

#ifndef LINE_IN_H
#define LINE_IN_H

#include "TYW_stdint.h"
#include "string.h"

/*所有硬线输入的索引*/
typedef enum
{
    /*指示灯相关*/
    LINE_IN_ABS = 0U,         /*A22  ABS*/
    LINE_IN_PARK_BRAKE,       /*A23  PARK BRAKE*/
    LINE_IN_HI_BEAM,          /*A25  HI BEAM*/
    LINE_IN_BRAKE_AIR_EBS,    /*A28  BRAKE AIR/EBS*/
    LINE_IN_SEAT_BELT,        /*A30  SEAT BELT*/
    LINE_IN_MIL,              /*A31  MIL*/
    LINE_IN_ENG_OIL,          /*A32  ENG OIL*/
    LINE_IN_CHARGE,           /*A34  CHARGE*/
    LINE_IN_TRAILER_ABS_INFO, /*B03  TRAILER ABS INFO*/
    LINE_IN_Rr_FOG_LAMP,      /*B14  Rr FOG LAMP*/
    LINE_IN_ACC_AIR,          /*B15  ACC AIR*/
    LINE_IN_AIR_SUS,          /*B30  AIR SUS*/
    LINE_IN_TRAILER_BRAKE,    /*B31  TRAILER BRAKE*/
    LINE_IN_TRAILER_ABS,      /*B33  TRAILER ABS*/
    LINE_IN_RR_DIFF_LOCK,     /*B36  RR DIFF LOCK*/
    LINE_IN_WEAR_IND,         /*B38  WEAR IND*/

    /*非指示灯相关*/
    LINE_IN_ILLUMINATION,    /*A06  ILLUMINATION*/
    LINE_IN_RET_BLENDING,    /*A10  RET_BLENDING*/
    LINE_IN_BRAKE,           /*A21  BRAKE*/
    LINE_IN_TURN_R,          /*A26  TURN_R*/
    LINE_IN_TURN_L,          /*A27  TURN_L*/
    LINE_IN_ABS_DETECT,      /*A33  ABS_DETECT*/
    LINE_IN_PTO,             /*B01  PTO*/
    LINE_IN_GLOW,            /*B05  GLOW*/
    LINE_IN_TRAILER_CONNECT, /*B06  TRAILER_CONNECT*/
    LINE_IN_LOW_COOLANT,     /*B32  LOW_COOLANT*/
    LINE_IN_ACC,             /*B39  ACC*/
    LINE_IN_WEAR2,           /*B40  WEAR2*/
    LINE_IN_A19,             /*A19  */
    LINE_IN_A03,             /*A03  */
    LINE_IN_A20,             /*A20  */

    LINE_IN_MAX,
} Line_In_Channel_en_t;

/*获取实时硬线电平函数指针*/
typedef LINE_IN_TriggerLevel_en_t (*LineIn_Read_Level)(void);

typedef struct
{
    LINE_IN_TriggerLevel_en_t enValidLevel; /*有效电平*/
    uint16_t u16ValidTime;                  /*从无效到有效的消抖时间 ms*/
    uint16_t u16InvalidTime;                /*从有效到无效的消抖时间*/
    LINE_IN_WorkSt_en_t enPowerStatus;      /*硬线工作的电源状态*/
    LineIn_Read_Level pfnLineIn_Read_Cbk;   /*获取实时电平的回调函数*/
} Line_In_Attribute_st_t;

/*属性表与硬线索引号Line_In_Channel_en_t一一对应*/
extern const Line_In_Attribute_st_t g_stLineInAttribute[LINE_IN_MAX];
extern void Line_In_SetPowerSt(LINE_IN_WorkSt_en_t u8PowerSt);
/*10ms调用*/
extern void Line_In_Debounce_Service(void);

extern LineIn_LogicLevel_en_t Line_In_Get_Status(uint8_t Channel);

extern void Line_In_KL30_Init(void);
extern void Line_In_KL15_ON_Init(void);
extern void Line_In_KL15_OFF_Init(void);

#endif
