#include "Services_Interval.h"
#include "Services_Mileage.h"
#include "Common_Interface.h"

#include "Services_UTC.h"
#include "RTE_TIME.h"
#include "Service_OFF_Time.h"
#include "EOL_Para.h"

_DataInputInterVal Data_Input_InterVal;
#pragma ghs section sbss=".mysbss"
_DataInterVal Data_Interval_Para;
_MYTIME_STRUCT TimerRecord;
uint32_t ServiceTimer;
uint32_t Servicekm;
#pragma ghs section sbss=default

uint32_t Services_KM_Back;
uint32_t Services_Timer_Back;

void Data_Service_Interval_Save_Call(_DataInterVal *m_Para4, uint8_t ForceSave)
{
}


void Data_interval_Geely_ReConfig(void)
{
    uint8_t ServicesType = 0u; /*not used0, 中文1, 真人语言1010, 为国内5000 .  其他为国外10000*/

    /*  Services_KM_Back = 0xffffffffu;
      Services_Timer_Back = 0xffffffffu;*/

   // ServicesType = Val_EOL_F101_Language();
    if ((ServicesType == 0u) || (ServicesType == 1u) || (ServicesType == 0x0Au))
    {
        Data_Service_Interval_OverWriteDIM(1u);
    }
    else
    {
        Data_Service_Interval_OverWriteDIM(0u);
    }
}


void Data_interval_Geely_Reset(void)
{
    _DataInterVal m_para0;
    _DataInputInterVal m_para1;
    uint8_t ServicesType = 0u; /*not used0, 中文1, 真人语言1010, 为国内5000 .  其他为国外10000*/

    m_para0.Sig.First_Flag = Services_FirstFlag;/*默认首保*/
    //ServicesType = Val_EOL_F101_Language();
    if ((ServicesType == 0u) || (ServicesType == 1u) || (ServicesType == 0x0Au))
    {
        m_para0.Sig.First_Interval = 50000ul;/*默认5000km*/
        m_para0.Sig.Second_Interval = 50000ul; /*默认10000km*/

    }
    else
    {
        m_para0.Sig.First_Interval = 100000ul;/*默认5000km*/
        m_para0.Sig.Second_Interval = 100000ul; /*默认10000km*/
    }


    m_para0.Sig.Servicekm = Data_ODO_Read();
    m_para0.Sig.ServiceTimer = 0ul;/*默认0*/
    m_para0.Sig.Timer_Interval = 155520000ul;
    m_para1.PowerSts = Common_Get_IG_Sts();
    Services_KM_Back = 0u;
    Services_Timer_Back = 0u;
    Data_Service_Interval_Reset(&m_para0, Data_ODO_Read());
}

void Data_interval_Geely_Write(uint32_t data)
{
    _DataInterVal m_para0;
    _DataInputInterVal m_para1;

    m_para0.Sig.First_Flag = Services_SecondFlag;/*第二次保养*/
    m_para0.Sig.First_Interval = 50000ul;/*默认5000km*/
    m_para0.Sig.Second_Interval = data; /*写入保养里程*/
    m_para0.Sig.Servicekm = Data_ODO_Read();
    m_para0.Sig.ServiceTimer = 0ul;/*默认0*/
    m_para0.Sig.Timer_Interval = 155520000ul;
    m_para1.PowerSts = Common_Get_IG_Sts();
    Services_KM_Back = 0u;
    Services_Timer_Back = 0u;
    Data_Service_Interval_Reset(&m_para0, Data_ODO_Read());
}

void Data_Interval_KL30_InitShell(void)
{

}
uint8_t Get_SERVICE_WARNING(void)
{
    uint8_t Res;
    uint32_t m_Condition_1;
    uint32_t m_Condition_2;

    m_Condition_1 = Get_IntervalKM();
    m_Condition_2 = Get_IntervalTime();
    /*87607-7*/                         /*87607-8*/ /*87607-9*/
    if ((m_Condition_1 <= 5000u) || (m_Condition_2 <= 25920000u))
    {
        Res = 1u;/*87606-4*/
    }
    else
    {
        Res = 0u;/*87606-5*/
    }
    return Res;
}
uint8_t Get_SERVICE_WARNING_ForCan(void)
{
    uint8_t Res;
    uint32_t m_Condition_1;
    uint32_t m_Condition_2;

    m_Condition_1 = Get_IntervalKM();
    m_Condition_2 = Get_IntervalTime();
    /*87607-7*/                         /*87607-8*/ /*87607-9*/
    if ((m_Condition_1 <= 0u) || (m_Condition_2 <= 0u))
    {
        Res = 1u;/*87606-4*/
    }
    else
    {
        Res = 0u;/*87606-5*/
    }
    return Res;
}
void Data_Interval_100MS_Cbk(void)
{
    Data_Interval_KMSet(Data_ODO_Read(), Common_Get_IG_Sts());
    Data_Service_Interval_Processing();
}


/* 系统进入休眠之前调用,用于存储系统工作状态下最后的时间,或者首次上电同步 */
void Data_Timer_Record_BeforeSleep(void)
{
    TimerRecord.nYear  = Get_RTC_YEAR();
    TimerRecord.nMonth = Get_RTC_MONTH();
    TimerRecord.nDay   = Get_RTC_DATE();
    TimerRecord.nHour  = Get_RTC_HOUR();
    TimerRecord.nMin   = Get_RTC_MINUTE();
    TimerRecord.nSec   = Get_RTC_SECOND();
}
/*每次唤醒之后,进入主循环之前调用,如果涉及到下电计时,这里可能还要往前提*/
void Data_Timer_Record_Calc(void)
{
    unsigned long int    time1 = 0u;/*其实就是uint32*/
    unsigned long int    time2 = 0u;
    unsigned long int TotalOFFSecond = 0u;
    _MYTIME_STRUCT my_time;

    my_time.nYear  = TimerRecord.nYear;
    my_time.nMonth = TimerRecord.nMonth;
    my_time.nDay   = TimerRecord.nDay;
    my_time.nHour  = TimerRecord.nHour;
    my_time.nMin   = TimerRecord.nMin;
    my_time.nSec   = TimerRecord.nSec;

    time1 = mytime_2_utc_sec(&my_time);

    my_time.nYear  = Get_RTC_YEAR();
    my_time.nMonth = Get_RTC_MONTH();
    my_time.nDay   = Get_RTC_DATE();
    my_time.nHour  = Get_RTC_HOUR();
    my_time.nMin   = Get_RTC_MINUTE();
    my_time.nSec   = Get_RTC_SECOND();

    time2 = mytime_2_utc_sec(&my_time);

    if (time2 >= time1)
    {
        TotalOFFSecond = time2 - time1;
        TotalOFFSecond *= 10u;
        Data_Interval_TimerSleepFix(TotalOFFSecond);
        Service_OFF_Timing_WakeupInit(TotalOFFSecond);
    }

}

