#include "SEG_DISPLAY.h"
#include "Seg_Ref.h"
#include "Common_Interface.h"
#include "Data_Fuel_User.h"
#include "Data_AirPressure.h"
#include "Data_CoolantTemperature.h"
#include "Data_EngineSpeed.h"
#include "Data_VehicleSpeed.h"
#include "GaugesInterface.h"

#define PRI_SEG_NUM_MAX 17U
#define SEC_SEG_NUM_MAX 17U
#define COOLANT_SEG_NUM_MAX 12U
#define FUEL_SEG_NUM_MAX 12U
#define TACHO_SEG_NUM_MAX 27U
#define VEH_SEG_NUM_MAX 30U

static  uint8_t GaugesTimer;

static void Seg_General_Digit_Display(uint32_t Digit, uint8_t Len, uint8_t Blank, uint8_t *DigitBuf, uint8_t *Reg);
static void Seg_Digit_1_Disp(uint8_t Digit);
static void Seg_Digit_2_Disp(uint8_t Digit);
static void Seg_Digit_3_Disp(uint8_t Digit);
static void SEG_PRI_Display(uint8_t Value, uint8_t Valid, uint8_t seg_status);
static void SEG_SEC_Display(uint8_t Value, uint8_t Valid, uint8_t seg_status);
static void SEG_Coolant_Display(uint8_t Value, uint8_t Valid, uint8_t seg_status);
static void SEG_Fuel_Display(uint8_t Value, uint8_t Valid, uint8_t seg_status);
static void SEG_Tacho_Display(uint8_t Value, uint8_t Valid, uint8_t seg_status);
static void SEG_VehicleSpeed_Display(uint8_t Value, uint8_t Valid, uint8_t seg_status);
static void SEG_VehicleSpeed_Num(uint16_t Value, uint8_t Valid);

/*****************************************************************************
某某灯(红)//_1_差速器锁
******************************************************************************/
void SEG_LED_INTER_DIFF_LOCK_T(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_36, seg_status);
}

/*****************************************************************************
某某灯(红)//_2_智能四驱故障
******************************************************************************/
void SEG_LED_FOUR_MUL_FOUR_T(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_35, seg_status);
}
/*****************************************************************************
某某灯(红)//_3_再生指示灯
******************************************************************************/
void SEG_LED_EXH_BRAKE_T(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_33, seg_status);
}
/*****************************************************************************
//_4_预热指示灯
******************************************************************************/
void SEG_LED_QOS_GLOW_T(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_32, seg_status);
}
/*****************************************************************************
//_5_远光灯开启提示
******************************************************************************/
void SEG_LED_HI_BEAM_T(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_31, seg_status);
}
/*****************************************************************************
//_6_后雾灯开启提示
******************************************************************************/
void SEG_LED_Rr_FOG_LAMP_T(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_161, seg_status);
}
/*****************************************************************************
//_7_发动机故障灯
******************************************************************************/
void SEG_LED_MIL_T(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_160, seg_status);
}
/*****************************************************************************
//_8_维修保养指示灯
******************************************************************************/
void SEG_LED_SVS_T(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_159, seg_status);
}
/*****************************************************************************
//_9_上坡起步辅助系统
******************************************************************************/
void SEG_LED_H_S_A_T(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_158, seg_status);
}
/*****************************************************************************
//_10_减速器指示灯
******************************************************************************/
void SEG_LED_RETARDER_T(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_157, seg_status);
}
/*****************************************************************************
//_11_自动调灯
******************************************************************************/
void SEG_LED_AUTO_LEVELING_T(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_156, seg_status);
}
/*****************************************************************************
//_12_行侧报警灯
******************************************************************************/
void SEG_LED_ROWS_L(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_126, seg_status);
}
/*****************************************************************************
//_13_后视镜bsm警报信号灯
******************************************************************************/
void SEG_LED_BSM_OFF_L(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_127, seg_status);
}
/*****************************************************************************
//_14_紧急刹车辅助系统
******************************************************************************/
void SEG_LED_AEBS_OFF_L(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_128, seg_status);
}
/*****************************************************************************
//_15_LDW系统状态提示故障报警
******************************************************************************/
void SEG_LED_LDWS_L(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_129, seg_status);
}
/*****************************************************************************
//_16_安全气囊
******************************************************************************/
void SEG_LED_SRS_L(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_122, seg_status);
}
/*****************************************************************************
//_17_机油压力异常报警
******************************************************************************/
void SEG_LED_ENG_OIL_L(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_123, seg_status);
}
/*****************************************************************************
//_18_蓄电池充电状态提示
******************************************************************************/
void SEG_LED_CHARG_L(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_124, seg_status);
}
/*****************************************************************************
//_19_安全带
******************************************************************************/
void SEG_LED_SEAT_BELT_L(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_125, seg_status);
}
/*****************************************************************************
//_20_智能四驱故障
******************************************************************************/
void SEG_LED_RR_DIFF_LOCK_L(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_118, seg_status);
}
/*****************************************************************************
//TPMS系统故障报警
******************************************************************************/
void SEG_LED_TPMS_L(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_119, seg_status);
}
/*****************************************************************************
//_22_ASR/EVSC/ESC系统关闭提示
******************************************************************************/
void SEG_LED_ASR_or_EVSC_OFF_L(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_120, seg_status);
}
/*****************************************************************************
//_23_EVSC/ESP/ESC/TCS系统介入提示//故障报警
******************************************************************************/
void SEG_LED_EVSC_L(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_121, seg_status);
}
/*****************************************************************************
//_24_怠速启停系统状态提示-停机
******************************************************************************/
void SEG_LED_eco_stop_OFF_L(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_76, seg_status);
}
/*****************************************************************************
//_25_自动变速箱系统故障报警
******************************************************************************/
void SEG_LED_AMT_L(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_77, seg_status);
}
/*****************************************************************************
//_26_制动刹车片磨损指示灯
******************************************************************************/
void SEG_LED_WEAR_IND_L(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_78, seg_status);
}
/*****************************************************************************
//_27_挂车制动阀指示灯
******************************************************************************/
void SEG_LED_TRAILER_BRAKE_R(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_107, seg_status);
}
/*****************************************************************************
//_28_制动液不足报警-制动系统故障报警 （下黄）
******************************************************************************/
void SEG_LED_BRAKE_AIR_or_EBS_YELLOW_R(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_108, seg_status);
}
/*****************************************************************************
//_29_气动避震指示灯
******************************************************************************/
void SEG_LED_ACC_AIR_R(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_109, seg_status);
}
/*****************************************************************************
//_30_ABS系统故障报警
******************************************************************************/
void SEG_LED_ABS_R(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_110, seg_status);
}
/*****************************************************************************
//_31_驻车制动器/EPB系统处于制动状态提示/AUTO HOLD驻车提示
******************************************************************************/
void SEG_LED_PARK_BRAKE_R(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_31, seg_status);
}
/*****************************************************************************
//_32_制动液不足报警/制动系统故障报警 （上红）
******************************************************************************/
void SEG_LED_BRAKE_AIR_or_EBS_RED_R(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_32, seg_status);
}
/*****************************************************************************
//_34_制动器锁
******************************************************************************/
void SEG_LED_BRAKE_LOCK_R(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_33, seg_status);
}
/*****************************************************************************
//_35_空气悬架指示灯----FULL
******************************************************************************/
void SEG_LED_AIR_SUS_R(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_34, seg_status);
}
/*****************************************************************************
//_36_拖车ABS系统故障报警
******************************************************************************/
void SEG_LED_TRAILER_ABS_U(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_138, seg_status);
}
/*****************************************************************************
//_37_工作灯
******************************************************************************/
void SEG_LED_WORKING_LAMP_U(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_55, seg_status);
}
/*****************************************************************************
//_38_拖车ABS信息
******************************************************************************/
void SEG_LED_TRAILER_ABS_INFO_U(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_137, seg_status);
}
/*****************************************************************************
//_39_右转向灯
******************************************************************************/
void SEG_LED_TURN_RIGHT(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_155, seg_status);
}
/*****************************************************************************
//_40_左转向灯
******************************************************************************/
void SEG_LED_TURN_LEFT(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_37, seg_status);
}
/*:ZH*/

/*****************************************************************************
常显示
******************************************************************************/
//左侧弧线
void SEG_A25_Disp(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_56, seg_status);
}
//右侧弧线
void SEG_C25_Disp(uint8_t seg_status)
{
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_136, seg_status);
}

/******************************************************************************
段码对应表
******************************************************************************/
#define NUM_1A(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_45, x);
#define NUM_1B(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_44, x);
#define NUM_1C(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_41, x);
#define NUM_1D(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_39, x);
#define NUM_1E(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_38, x);
#define NUM_1F(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_35, x);
#define NUM_1G(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_40, x);
#define NUM_1H(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_36, x);
#define NUM_1J(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_37, x);
#define NUM_1K(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_42, x);
#define NUM_1L(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_43, x);

#define NUM_2A(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_56, x);
#define NUM_2B(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_55, x);
#define NUM_2C(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_52, x);
#define NUM_2D(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_50, x);
#define NUM_2E(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_49, x);
#define NUM_2F(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_46, x);
#define NUM_2G(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_51, x);
#define NUM_2H(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_47, x);
#define NUM_2J(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_48, x);
#define NUM_2K(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_53, x);
#define NUM_2L(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_54, x);

#define NUM_3A(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_67, x);
#define NUM_3B(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_66, x);
#define NUM_3C(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_63, x);
#define NUM_3D(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_61, x);
#define NUM_3E(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_60, x);
#define NUM_3F(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_57, x);
#define NUM_3G(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_62, x);
#define NUM_3H(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_58, x);
#define NUM_3J(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_59, x);
#define NUM_3K(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_64, x);
#define NUM_3L(x) SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_65, x);
//      L K J //H G F E D C B A
// 0     1 1 1 //1 0 1 1 1 1 1 1  // 0x07Bf
// 1     1 1 0 //0 0 0 0 0 1 1 0  // 0x0606
// 2     0 1 1 //0 1 0 1 1 0 1 1  // 0x035b
// 3     1 1 0 //0 1 0 0 1 1 1 1  // 0x064f
// 4     1 1 1 //0 1 1 0 0 1 1 0  // 0x0766
// 5     0 1 1 //0 1 1 0 1 1 0 1  // 0x036d
// 6     0 1 1 //1 1 1 1 1 1 0 1  // 0x03fd
// 7     1 1 0 //0 0 0 0 0 1 1 1  // 0x0607
// 8     0 1 1 //0 1 1 1 1 1 1 1  // 0x037f
// 9     1 1 1 //0 1 1 0 1 1 1 1  // 0x076f
//      0 0 0   0 0 0 0 0 0 0 0  // 0x0000
//'-'   0 0 0   0 1 0 0 0 0 0 0  // 0x0040
static const uint16_t Seg_Digit_Nomal[] =
{
    /**0**  | **1**   |**2**    | **3**  |  **4**   | **5**  | **6**    | **7**   | **8**   |  **9** | **10 black** | **11 --** | **all light --**/
    0x07Bf,
    0x0606,
    0x035b,
    0x064f,
    0x0766,
    0x036d,
    0x03fd,
    0x0607,
    0x037f,
    0x076f,
    0x0000,
    0x0040,
    0xffff,
};

static void Seg_Digit_1_Disp(uint8_t Digit)
{
    uint8_t MUN_A;
    uint8_t MUN_B;
    uint8_t MUN_C;
    uint8_t MUN_D;
    uint8_t MUN_E;
    uint8_t MUN_F;
    uint8_t MUN_G;
    uint8_t MUN_H;
    uint8_t MUN_J;
    uint8_t MUN_K;
    uint8_t MUN_L;

    MUN_A = (((1 << 0) & Seg_Digit_Nomal[Digit]) >> 0) ? 7 : 0;
    MUN_B = (((1 << 1) & Seg_Digit_Nomal[Digit]) >> 1) ? 7 : 0;
    MUN_C = (((1 << 2) & Seg_Digit_Nomal[Digit]) >> 2) ? 7 : 0;
    MUN_D = (((1 << 3) & Seg_Digit_Nomal[Digit]) >> 3) ? 7 : 0;
    MUN_E = (((1 << 4) & Seg_Digit_Nomal[Digit]) >> 4) ? 7 : 0;
    MUN_F = (((1 << 5) & Seg_Digit_Nomal[Digit]) >> 5) ? 7 : 0;
    MUN_G = (((1 << 6) & Seg_Digit_Nomal[Digit]) >> 6) ? 7 : 0;
    MUN_H = (((1 << 7) & Seg_Digit_Nomal[Digit]) >> 7) ? 7 : 0;
    MUN_J = (((1 << 8) & Seg_Digit_Nomal[Digit]) >> 8) ? 7 : 0;
    MUN_K = (((1 << 9) & Seg_Digit_Nomal[Digit]) >> 9) ? 7 : 0;
    MUN_L = (((1 << 10) & Seg_Digit_Nomal[Digit]) >> 10) ? 7 : 0;

    NUM_1A(MUN_A);
    NUM_1B(MUN_B);
    NUM_1C(MUN_C);
    NUM_1D(MUN_D);
    NUM_1E(MUN_E);
    NUM_1F(MUN_F);
    NUM_1G(MUN_G);
    NUM_1H(MUN_H);
    NUM_1J(MUN_J);
    NUM_1K(MUN_K);
    NUM_1L(MUN_L);
}
static void Seg_Digit_2_Disp(uint8_t Digit)
{
    uint8_t MUN_A;
    uint8_t MUN_B;
    uint8_t MUN_C;
    uint8_t MUN_D;
    uint8_t MUN_E;
    uint8_t MUN_F;
    uint8_t MUN_G;
    uint8_t MUN_H;
    uint8_t MUN_J;
    uint8_t MUN_K;
    uint8_t MUN_L;

    MUN_A = (((1 << 0) & Seg_Digit_Nomal[Digit]) >> 0) ? 7 : 0;
    MUN_B = (((1 << 1) & Seg_Digit_Nomal[Digit]) >> 1) ? 7 : 0;
    MUN_C = (((1 << 2) & Seg_Digit_Nomal[Digit]) >> 2) ? 7 : 0;
    MUN_D = (((1 << 3) & Seg_Digit_Nomal[Digit]) >> 3) ? 7 : 0;
    MUN_E = (((1 << 4) & Seg_Digit_Nomal[Digit]) >> 4) ? 7 : 0;
    MUN_F = (((1 << 5) & Seg_Digit_Nomal[Digit]) >> 5) ? 7 : 0;
    MUN_G = (((1 << 6) & Seg_Digit_Nomal[Digit]) >> 6) ? 7 : 0;
    MUN_H = (((1 << 7) & Seg_Digit_Nomal[Digit]) >> 7) ? 7 : 0;
    MUN_J = (((1 << 8) & Seg_Digit_Nomal[Digit]) >> 8) ? 7 : 0;
    MUN_K = (((1 << 9) & Seg_Digit_Nomal[Digit]) >> 9) ? 7 : 0;
    MUN_L = (((1 << 10) & Seg_Digit_Nomal[Digit]) >> 10) ? 7 : 0;

    NUM_2A(MUN_A);
    NUM_2B(MUN_B);
    NUM_2C(MUN_C);
    NUM_2D(MUN_D);
    NUM_2E(MUN_E);
    NUM_2F(MUN_F);
    NUM_2G(MUN_G);
    NUM_2H(MUN_H);
    NUM_2J(MUN_J);
    NUM_2K(MUN_K);
    NUM_2L(MUN_L);
}

static void Seg_Digit_3_Disp(uint8_t Digit)
{
    uint8_t MUN_A;
    uint8_t MUN_B;
    uint8_t MUN_C;
    uint8_t MUN_D;
    uint8_t MUN_E;
    uint8_t MUN_F;
    uint8_t MUN_G;
    uint8_t MUN_H;
    uint8_t MUN_J;
    uint8_t MUN_K;
    uint8_t MUN_L;

    MUN_A = (((1 << 0) & Seg_Digit_Nomal[Digit]) >> 0) ? 7 : 0;
    MUN_B = (((1 << 1) & Seg_Digit_Nomal[Digit]) >> 1) ? 7 : 0;
    MUN_C = (((1 << 2) & Seg_Digit_Nomal[Digit]) >> 2) ? 7 : 0;
    MUN_D = (((1 << 3) & Seg_Digit_Nomal[Digit]) >> 3) ? 7 : 0;
    MUN_E = (((1 << 4) & Seg_Digit_Nomal[Digit]) >> 4) ? 7 : 0;
    MUN_F = (((1 << 5) & Seg_Digit_Nomal[Digit]) >> 5) ? 7 : 0;
    MUN_G = (((1 << 6) & Seg_Digit_Nomal[Digit]) >> 6) ? 7 : 0;
    MUN_H = (((1 << 7) & Seg_Digit_Nomal[Digit]) >> 7) ? 7 : 0;
    MUN_J = (((1 << 8) & Seg_Digit_Nomal[Digit]) >> 8) ? 7 : 0;
    MUN_K = (((1 << 9) & Seg_Digit_Nomal[Digit]) >> 9) ? 7 : 0;
    MUN_L = (((1 << 10) & Seg_Digit_Nomal[Digit]) >> 10) ? 7 : 0;

    NUM_3A(MUN_A);
    NUM_3B(MUN_B);
    NUM_3C(MUN_C);
    NUM_3D(MUN_D);
    NUM_3E(MUN_E);
    NUM_3F(MUN_F);
    NUM_3G(MUN_G);
    NUM_3H(MUN_H);
    NUM_3J(MUN_J);
    NUM_3K(MUN_K);
    NUM_3L(MUN_L);
}

static void SEG_VehicleSpeed_Num(uint16_t Value, uint8_t Valid)
{

    uint32_t VSPEED_FLAG;
    uint8_t Dig[3u];
    uint8_t Seg_Trip_Display_Reg = 0u;

    if (Valid == GUI_DISP_MODE_BLANK)
    {
        Seg_Digit_1_Disp(10u);
        Seg_Digit_2_Disp(10u);
        Seg_Digit_3_Disp(10u);
    }
    else
    {
        VSPEED_FLAG = Value;
        VSPEED_FLAG = VSPEED_FLAG / 10u;

        if (VSPEED_FLAG > 225u)
            VSPEED_FLAG = 225u;

        Seg_General_Digit_Display((uint32_t)VSPEED_FLAG, 3u, 2u, Dig, &Seg_Trip_Display_Reg);
        switch (Seg_Trip_Display_Reg)
        {
        case 0x02: //二位数
            Dig[2u] = 10u;
            break;
        case 0x03: //一位数
            Dig[2u] = 10u;
            Dig[1u] = 10u;
            break;
        default:
            break;
        }

        if (Valid == GUI_DISP_MODE_NORMAL)
        {
            Seg_Digit_1_Disp(Dig[2u]);
            Seg_Digit_2_Disp(Dig[1u]);
            Seg_Digit_3_Disp(Dig[0u]);
        }
        else
        {
            Seg_Digit_1_Disp(11u); //--
            Seg_Digit_2_Disp(11u); //--
            Seg_Digit_3_Disp(11u); //--
        }
    }
}
//主气压
static void SEG_PRI_Display(uint8_t Value, uint8_t Valid, uint8_t seg_status)
{
    uint8_t i;
    static OldValue = 0xff;
    static uint8_t mSEG[PRI_SEG_NUM_MAX] = {0};
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_95, seg_status);  // A63
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_96, seg_status);  // A64
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_114, seg_status); // A82
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_115, seg_status); // A83
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_116, seg_status); // A84
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_117, seg_status); // A85

    if (Valid == GUI_DISP_MODE_BLANK)
    {
        for (i = 0; i < PRI_SEG_NUM_MAX; i++)
        {
            mSEG[i] = 0;
        }
        OldValue = 0xff;
    }
    else if (Valid == GUI_DISP_MODE_INVALID)
    {
        SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_114, 0); // A82
        SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_115, 0); // A83
        SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_116, 0); // A84
        SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_117, 0); // A85

        for (i = 0; i < PRI_SEG_NUM_MAX; i++)
        {
            mSEG[i] = 0;
        }
        OldValue = 0xff;
    }
    else
    {
        if (Valid == GUI_DISP_MODE_NORMAL)
        {
            // eg: 5 -> 100000-> 11111
            // mSEG[0] = ((((1 << Value) - 1) & ( 1 << 0)) >> 0) ? seg_status : 0;
            if (OldValue != Value)
            {
                OldValue = Value;

                for (i = 0; i < PRI_SEG_NUM_MAX; i++)
                {
                    mSEG[i] = ((((1 << Value) - 1) & (1 << i)) >> i);
                    if (mSEG[i])
                    {
                        mSEG[i] = seg_status;
                    }
                    else
                    {
                        mSEG[i] = 0;
                    }
                }
            }
        }
    }

    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_97, mSEG[0]);   // A65
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_98, mSEG[1]);   // A66
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_99, mSEG[2]);   // A67
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_100, mSEG[3]);  // A68
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_101, mSEG[4]);  // A69
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_102, mSEG[5]);  // A70
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_103, mSEG[6]);  // A71
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_104, mSEG[7]);  // A72
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_105, mSEG[8]);  // A73
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_106, mSEG[9]);  // A74
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_107, mSEG[10]); // A75
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_108, mSEG[11]); // A76
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_109, mSEG[12]); // A77
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_110, mSEG[13]); // A78
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_111, mSEG[14]); // A79
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_112, mSEG[15]); // A80
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_113, mSEG[16]); // A81
}
//副气压
static void SEG_SEC_Display(uint8_t Value, uint8_t Valid, uint8_t seg_status)
{
    uint8_t i;
    static OldValue = 0xff;
    static uint8_t mSEG[SEC_SEG_NUM_MAX] = {0};
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_68, seg_status); // B5
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_69, seg_status); // B6
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_70, seg_status); // B7
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_71, seg_status); // B8
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_72, seg_status); // B9
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_90, seg_status); // B27

    if (Valid == GUI_DISP_MODE_BLANK)
    {
        for (i = 0; i < SEC_SEG_NUM_MAX; i++)
        {
            mSEG[i] = 0;
        }
        OldValue = 0xff;
    }
    else if (Valid == GUI_DISP_MODE_INVALID)
    {
        SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_70, 0); // B7
        SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_71, 0); // B8
        SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_72, 0); // B9
        SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_90, 0); // B27
        for (i = 0; i < SEC_SEG_NUM_MAX; i++)
        {
            mSEG[i] = 0;
        }
        OldValue = 0xff;
    }
    else
    {
        if (Valid == GUI_DISP_MODE_NORMAL)
        {
            // eg: 5 -> 100000-> 11111
            if (OldValue != Value)
            {
                for (i = 0; i < SEC_SEG_NUM_MAX; i++)
                {
                    mSEG[i] = ((((1 << Value) - 1) & (1 << i)) >> i);
                    if (mSEG[i])
                    {
                        mSEG[i] = seg_status;
                    }
                    else
                    {
                        mSEG[i] = 0;
                    }
                }
            }
        }
    }

    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_73, mSEG[0]);  // B10
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_74, mSEG[1]);  // B11
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_75, mSEG[2]);  // B12
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_76, mSEG[3]);  // B13
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_77, mSEG[4]);  // B14
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_78, mSEG[5]);  // B15
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_79, mSEG[6]);  // B16
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_80, mSEG[7]);  // B17
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_81, mSEG[8]);  // B18
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_82, mSEG[9]);  // B19
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_83, mSEG[10]); // B20
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_84, mSEG[11]); // B21
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_85, mSEG[12]); // B22
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_86, mSEG[13]); // B23
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_87, mSEG[14]); // B24
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_88, mSEG[15]); // B25
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_89, mSEG[16]); // B26
}
//水温
static void SEG_Coolant_Display(uint8_t Value, uint8_t Valid, uint8_t seg_status)
{
    uint8_t i;
    static uint8_t OldValue = 0;
    static uint8_t mSEG[COOLANT_SEG_NUM_MAX] = {0};
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_79, seg_status); // A47
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_92, seg_status); // A60
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_93, seg_status); // A61
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_94, seg_status); // A62

    if (Valid == GUI_DISP_MODE_BLANK)
    {
        for (i = 0; i < COOLANT_SEG_NUM_MAX; i++)
        {
            mSEG[i] = 0;
        }
        OldValue = 0;
    }
    else if (Valid == GUI_DISP_MODE_INVALID)
    {
        SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_92, 0u); // A60
        SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_93, 0u); // A61
        SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_94, 0u); // A62
        for (i = 0; i < COOLANT_SEG_NUM_MAX; i++)
        {
            mSEG[i] = 0;
        }
        OldValue = 0;
    }
    else
    {
        if (Valid == GUI_DISP_MODE_NORMAL)
        {
            // eg: 5 -> 100000-> 11111
            if (OldValue != Value)
            {
                OldValue = Value;
                for (i = 0; i < COOLANT_SEG_NUM_MAX; i++)
                {
                    mSEG[i] = ((((1 << Value) - 1) & (1 << i)) >> i);
                    if (mSEG[i])
                    {
                        mSEG[i] = seg_status;
                    }
                    else
                    {
                        mSEG[i] = 0;
                    }
                }
            }
        }
    }

    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_80, mSEG[0]);  // A48
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_81, mSEG[1]);  // A49
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_82, mSEG[2]);  // A50
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_83, mSEG[3]);  // A51
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_84, mSEG[4]);  // A52
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_85, mSEG[5]);  // A53
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_86, mSEG[6]);  // A54
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_87, mSEG[7]);  // A55
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_88, mSEG[8]);  // A56
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_89, mSEG[9]);  // A57
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_90, mSEG[10]); // A58
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_91, mSEG[11]); // A59
}
//燃油
static void SEG_Fuel_Display(uint8_t Value, uint8_t Valid, uint8_t seg_status)
{
    uint8_t i;
    uint8_t mSEG[FUEL_SEG_NUM_MAX] = {0};
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_91, seg_status);  // B28
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_92, seg_status);  // B29
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_93, seg_status);  // B30
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_106, seg_status); // B43

    if (Valid == GUI_DISP_MODE_BLANK)
    {
        for (i = 0; i < FUEL_SEG_NUM_MAX; i++)
        {
            mSEG[i] = 0;
        }
    }
    else
    {
        if (Valid == GUI_DISP_MODE_NORMAL)
        {
            // eg: 5 -> 100000-> 11111
            for (i = 0; i < FUEL_SEG_NUM_MAX; i++)
            {
                mSEG[i] = ((((1 << Value) - 1) & (1 << i)) >> i);
                if (mSEG[i])
                {
                    mSEG[i] = seg_status;
                }
                else
                {
                    mSEG[i] = 0;
                }
            }
        }
    }

    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_94, mSEG[0]);   // B31
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_95, mSEG[1]);   // B32
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_96, mSEG[2]);   // B33
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_97, mSEG[3]);   // B34
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_98, mSEG[4]);   // B35
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_99, mSEG[5]);   // B36
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_100, mSEG[6]);  // B37
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_101, mSEG[7]);  // B38
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_102, mSEG[8]);  // B39
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_103, mSEG[9]);  // B40
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_104, mSEG[10]); // B41
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_105, mSEG[11]); // B42
}
//转速
static void SEG_Tacho_Display(uint8_t Value, uint8_t Valid, uint8_t seg_status)
{
    uint8_t i;
    uint8_t mSEG[TACHO_SEG_NUM_MAX] = {0};
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_38, seg_status); // A8
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_59, seg_status); // A27
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_65, seg_status); // A33
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_71, seg_status); // A39
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_40, seg_status); // A10
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_46, seg_status); // A16
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_51, seg_status); // A21

    if (Valid == GUI_DISP_MODE_BLANK)
    {
        for (i = 0; i < TACHO_SEG_NUM_MAX; i++)
        {
            mSEG[i] = 0;
        }
    }
    else
    {
        if (Valid == GUI_DISP_MODE_NORMAL)
        {
            // eg: 5 -> 100000-> 11111
            for (i = 0; i < TACHO_SEG_NUM_MAX; i++)
            {
                mSEG[i] = ((((1 << Value) - 1) & (1 << i)) >> i);
                if (mSEG[i])
                {
                    mSEG[i] = seg_status;
                }
                else
                {
                    mSEG[i] = 1;
                }
            }
        }
    }

    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_58, mSEG[0]);  // A26
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_60, mSEG[1]);  // A28
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_61, mSEG[2]);  // A29
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_62, mSEG[3]);  // A30
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_63, mSEG[4]);  // A31
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_64, mSEG[5]);  // A32
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_66, mSEG[6]);  // A34
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_67, mSEG[7]);  // A35
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_68, mSEG[8]);  // A36
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_69, mSEG[9]);  // A37
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_70, mSEG[10]); // A38
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_72, mSEG[11]); // A40
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_73, mSEG[12]); // A41
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_74, mSEG[13]); // A42
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_75, mSEG[14]); // A43
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_39, mSEG[15]); // A9
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_41, mSEG[16]); // A11
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_42, mSEG[17]); // A12
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_43, mSEG[18]); // A13
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_44, mSEG[19]); // A14
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_45, mSEG[20]); // A15
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_47, mSEG[21]); // A17
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_48, mSEG[22]); // A18
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_49, mSEG[23]); // A19
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_53, mSEG[24]); // A23
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_52, mSEG[25]); // A22
    SEG_BUFF_Set(BU98_CHIP1, SEG_REDEFINE_50, mSEG[26]); // A20
}
//车速
static void SEG_VehicleSpeed_Display(uint8_t Value, uint8_t Valid, uint8_t seg_status)
{
    uint8_t i;
    uint8_t mSEG[VEH_SEG_NUM_MAX] = {0};

    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_154, seg_status); // C42
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_133, seg_status); // C23
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_128, seg_status); // C18
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_123, seg_status); // C13
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_118, seg_status); // C8
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_113, seg_status); // C3
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_151, seg_status); // C39
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_146, seg_status); // C34
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_141, seg_status); // C29

    if (Value > VEH_SEG_NUM_MAX)
    {
        Value = VEH_SEG_NUM_MAX;
    }

    if (Valid == GUI_DISP_MODE_BLANK)
    {
        for (i = 0; i < VEH_SEG_NUM_MAX; i++)
        {
            mSEG[i] = 0;
        }
    }
    else
    {
        if (Valid == GUI_DISP_MODE_NORMAL)
        {
            // eg: 5 -> 100000-> 11111
            for (i = 0; i < VEH_SEG_NUM_MAX; i++)
            {
                mSEG[i] = ((((1 << Value) - 1) & (1 << i)) >> i);
                if (mSEG[i])
                {
                    mSEG[i] = seg_status;
                }
                else
                {
                    mSEG[i] = 1;
                }
            }
        }
    }

    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_134, mSEG[0]);  // C24
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_132, mSEG[1]);  // C22
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_131, mSEG[2]);  // C21
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_130, mSEG[3]);  // C20
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_129, mSEG[4]);  // C19
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_127, mSEG[5]);  // C17
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_126, mSEG[6]);  // C16
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_125, mSEG[7]);  // C15
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_124, mSEG[8]);  // C14
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_122, mSEG[9]);  // C12
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_121, mSEG[10]); // C11
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_120, mSEG[11]); // C10
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_119, mSEG[12]); // C9
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_117, mSEG[13]); // C7
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_116, mSEG[14]); // C6
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_115, mSEG[15]); // C5
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_114, mSEG[16]); // C4
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_112, mSEG[17]); // C2
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_111, mSEG[18]); // C1
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_153, mSEG[19]); // C41
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_152, mSEG[20]); // C40
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_150, mSEG[21]); // C38
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_149, mSEG[22]); // C37
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_148, mSEG[23]); // C36
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_147, mSEG[24]); // C35
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_145, mSEG[25]); // C33
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_144, mSEG[26]); // C32
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_143, mSEG[27]); // C31
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_142, mSEG[28]); // C30
    SEG_BUFF_Set(BU98_CHIP0, SEG_REDEFINE_140, mSEG[29]); // C28
}
/******************************************************************************
函数名：Seg_General_Digit_Display
功  能：通用段数字显示程序
参  数：Digit：要显示的数字

        Len  : 需要显示的数字长度
        Blank：首位数字为零消隐位数,从最高位起算
        Reg : 寄存器变量
返回值：无
******************************************************************************/
static void Seg_General_Digit_Display(uint32_t Digit, uint8_t Len, uint8_t Blank, uint8_t *DigitBuf, uint8_t *Reg)
{
    uint8_t i;
    uint8_t ActLen;
    ActLen = 0;
    i = 0;

    //以10进制形式拆分数字并计算实际数字长度
    while (Digit)
    {
        DigitBuf[ActLen] = Digit % 10;
        Digit /= 10;
        ActLen++;
    }

    //数字为0时的特殊处理
    if (ActLen == 0)
    {
        ActLen = 1;
        DigitBuf[0] = 0;
    }

    //对未计算到的数字位作0填充
    for (i = ActLen; i < Len; i++)
        DigitBuf[i] = 0;

    //数字首部按消隐位数做零消隐
    i = (Len - 1);
    while ((DigitBuf[i] == 0) && (i >= (Len - Blank)))
    {
        DigitBuf[i] = 0xFF;
        i--;

        (*Reg) |= (1 << i);
    }
}

static uint8_t wbyTestSeg = 0;
static uint16_t wbyTestNum;
static uint8_t WBY_SET = 0;
/******************************************************************************
Seg_Display_Service   在 20MS任务中
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
void Seg_Display_Service(void)
{
    uint32_t Ign_Time;
    Ign_Time = Common_GetIgnOnTime();
    if (Common_Get_IG_Sts() == COMMON_POWER_ON)
    {
        if (WBY_SET == 1)/*测试用点亮全部断码*/
        {
            Seg_Display_ON();
        }
        else
        {
            SEG_A25_Disp(7u); //左侧弧线
            SEG_C25_Disp(7u); //右侧弧线

            if (Ign_Time < 3100)
            {
                SEG_PRI_Display         (GetGaugesCurrentPos(PRIGasGauges), GUI_DISP_MODE_NORMAL, 7u);        // PRI气压格
                SEG_SEC_Display         (GetGaugesCurrentPos(SECGasGauges), GUI_DISP_MODE_NORMAL, 7u);        // SEC气压格
                SEG_Coolant_Display     (GetGaugesCurrentPos(TempGauges),   GUI_DISP_MODE_NORMAL, 7u);        // 水温格
                SEG_Fuel_Display        (GetGaugesCurrentPos(TempGauges),   GUI_DISP_MODE_NORMAL, 7u);        // 燃油格
                SEG_Tacho_Display       (GetGaugesCurrentPos(RevGauges),    GUI_DISP_MODE_NORMAL, 7u);        // 转速格
                SEG_VehicleSpeed_Display(GetGaugesCurrentPos(VehGauges),    GUI_DISP_MODE_NORMAL, 7u);        // 车速格

                /*车速数字 暂时没有变化，只是全部点亮*/
                Seg_Digit_1_Disp(12);
                Seg_Digit_2_Disp(12);
                Seg_Digit_3_Disp(12);

                GaugesTimer = 15u;
            }
            else if (GaugesTimer == 0u)
            {
                GaugesTimer = 15u;

                if (Common_Get_Air1_Valid())
                {
                    SEG_PRI_Display(GetGaugesCurrentPos(PRIGasGauges), GUI_DISP_MODE_NORMAL, 7u); // PRI气压格
                }
                else
                {
                    SEG_PRI_Display(GetGaugesCurrentPos(PRIGasGauges), GUI_DISP_MODE_INVALID, 7u); // PRI气压格
                }
                if (Common_Get_Air2_Valid())
                {
                    SEG_SEC_Display(GetGaugesCurrentPos(SECGasGauges), GUI_DISP_MODE_NORMAL, 7u); // SEC气压格
                }
                else
                {
                    SEG_SEC_Display(GetGaugesCurrentPos(SECGasGauges), GUI_DISP_MODE_INVALID, 7u); // SEC气压格
                }

                if (Coolant_Get_Valid())
                {
                    SEG_Coolant_Display(Coolant_Get_CurSeg(), GUI_DISP_MODE_NORMAL, 7u); //水温格
                }
                else
                {
                    SEG_Coolant_Display(Coolant_Get_CurSeg(), GUI_DISP_MODE_INVALID, 7u); //水温格
                }

                SEG_Fuel_Display(Fuel_Get_CurSeg(), GUI_DISP_MODE_NORMAL, 7u);          //燃油格

                SEG_Tacho_Display(Tacho_Get_CurSeg(), GUI_DISP_MODE_NORMAL, 7u);        //转速格

                SEG_VehicleSpeed_Display(Speed_Get_CurSeg(), GUI_DISP_MODE_NORMAL, 7u); //车速格
                wbyTestNum = Common_Get_Disp_V_Speed();
                // Speed_Get_Display_Value()
                SEG_VehicleSpeed_Num(wbyTestNum, GUI_DISP_MODE_NORMAL); //车速值

                // SEG_PRI_Display(wbyTestSeg,GUI_DISP_MODE_NORMAL,7u) ;//PRI气压格
                // SEG_SEC_Display(wbyTestSeg,GUI_DISP_MODE_NORMAL,7u) ;//SEC气压格
                // SEG_Coolant_Display(wbyTestSeg,GUI_DISP_MODE_NORMAL,7u) ;//水温格
                // SEG_Fuel_Display(wbyTestSeg, GUI_DISP_MODE_NORMAL,7u);//燃油格
                // SEG_Tacho_Display(wbyTestSeg,GUI_DISP_MODE_NORMAL,7u);//转速格
                // SEG_VehicleSpeed_Display(wbyTestSeg,GUI_DISP_MODE_NORMAL,7u);//车速格
                // SEG_VehicleSpeed_Num(wbyTestNum,GUI_DISP_MODE_NORMAL);//车速值
            }
            else
            {
                GaugesTimer--;

                /*此处为测试水温走格速度用*/
                if (Coolant_Get_Valid())
                {
                    SEG_Coolant_Display(Coolant_Get_CurSeg(), GUI_DISP_MODE_NORMAL, 7u); //水温格
                }
                else
                {
                    SEG_Coolant_Display(Coolant_Get_CurSeg(), GUI_DISP_MODE_INVALID, 7u); //水温格
                }
            }
        }
    }
    else
    {
        SEG_A25_Disp(0u);                                                      //左侧弧线
        SEG_C25_Disp(0u);                                                      //右侧弧线
        SEG_PRI_Display(GetGaugesCurrentPos(PRIGasGauges), GUI_DISP_MODE_BLANK, 0u);   // PRI气压格
        SEG_SEC_Display(GetGaugesCurrentPos(SECGasGauges), GUI_DISP_MODE_BLANK, 0u);   // SEC气压格
        SEG_Coolant_Display(Coolant_Get_CurSeg(), GUI_DISP_MODE_BLANK, 0u);    //水温格
        SEG_Fuel_Display(Fuel_Get_CurSeg(), GUI_DISP_MODE_BLANK, 0u);          //燃油格
        SEG_Tacho_Display(Tacho_Get_CurSeg(), GUI_DISP_MODE_BLANK, 0u);        //转速格
        SEG_VehicleSpeed_Display(Speed_Get_CurSeg(), GUI_DISP_MODE_BLANK, 0u); //车速格
        SEG_VehicleSpeed_Num(0u, GUI_DISP_MODE_BLANK);                         //车速值
    }
}

void Seg_Display_ON(void)
{
    BU98_CHIP_NUM_t chip_num;
    BU98_SEG_NUM_t seg_num;

    for (chip_num = BU98_CHIP0; chip_num < BU98_CHIP_MAX; chip_num++)
    {
        for (seg_num = SEG_REDEFINE_1; seg_num < BU98R10_SEG_MAX; seg_num++)
        {
            SEG_BUFF_Set(chip_num, seg_num, 7);
        }
    }
}
void Seg_Display_OFF(void)
{
    BU98_CHIP_NUM_t chip_num;
    BU98_SEG_NUM_t seg_num;

    for (chip_num = BU98_CHIP0; chip_num < BU98_CHIP_MAX; chip_num++)
    {
        for (seg_num = SEG_REDEFINE_1; seg_num < BU98R10_SEG_MAX; seg_num++)
        {
            SEG_BUFF_Set(chip_num, seg_num, 0);
        }
    }
}
