/************************************************ ******************************
文 件 名：Flash_synchronizer.h
功能描述：闪烁同步信号发生器库文件
作    者：张暄
版    本：V1.0
日    期：2017.04.02
******************************************************************************/

#include "Flash_synchronizer.h"

volatile uint8_t FlashSync1Hz;
volatile uint8_t FlashSync2Hz;
volatile uint8_t FlashSync5Hz;
volatile uint8_t FlashSync05Hz;
volatile uint8_t FlashSync_2_5_Hz;

volatile uint8_t FlashSync3Hz;



const uint8_t FlashSync1HzTable[] = {0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u,
                                     1u, 1u, 1u, 1u, 1u, 1u, 1u, 1u, 1u, 1u,
									 
                                    };
const uint8_t FlashSync2HzTable[] = {0u, 0u, 0u, 0u, 0u, 1u, 1u, 1u, 1u, 1u,
                                     0u, 0u, 0u, 0u, 0u, 1u, 1u, 1u, 1u, 1u,
                                    };
const uint8_t FlashSync5HzTable[] = {0u, 0u, 1u, 1u, 0u, 0u, 1u, 1u, 0u, 0u,
                                     1u, 1u, 0u, 0u, 1u, 1u, 0u, 0u, 1u, 1u,
                                    };
const uint8_t FlashSync05HzTable[] = {0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u,
                                      1u, 1u, 1u, 1u, 1u, 1u, 1u, 1u, 1u, 1u,
                                      1u, 1u, 1u, 1u, 1u, 1u, 1u, 1u, 1u, 1u,
                                      0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u,
                                     };
const uint8_t FlashSync_2_5_HzTable[] = {0u, 0u, 0u, 0u, 1u, 1u, 1u, 1u, 0u, 0u,
                                         0u, 0u, 1u, 1u, 1u, 1u, 0u, 0u, 0u, 0u,
                                         1u, 1u, 1u, 1u, 0u, 0u, 0u, 0u, 1u, 1u,
                                         1u, 1u, 0u, 0u, 0u, 0u, 1u, 1u, 1u, 1u,
                                        }; /* 2.5Hz */

const uint8_t FlashSync3HzTable[] = {0u, 1u};/* 3Hz */

uint8_t count_10 = 0u;//此变量在0~9循环，一周期50ms
uint8_t count_33 = 0u;//此变量在0~32循环，一周期165ms
uint8_t FlashTimer = 0u;//数组下标，数组元素总数为20
uint8_t FlashTimer40 = 0u;//数组下标，数组元素总数为40

uint8_t FlashTimer2 = 0u;//数组下标，数组元素总数为2


/******************************************************************************
函数名：Flash_Sync_Signal_Generation_Service
功  能：闪烁同步信号发生服务
参  数：无
返回值：无
*******************************************************************************
注  意：该服务函数必须每5ms被调用一次
******************************************************************************/
void Flash_Sync_Signal_Generation_Service ( void )
{
    count_10++;//每5ms加1
    count_33++;//每5ms加1

    if (count_10 >= 10u)
    {
        count_10 = 0u;

        {
            FlashTimer++;       /*50ms一次 加  1*/
            if ( FlashTimer >= 20u )
            {
                FlashTimer = 0u;
            }

            FlashTimer40++;       /*50ms一次 加  1*/
            if ( FlashTimer40 >= 40u )
            {
                FlashTimer40 = 0u;
            }
        }
    }


    if (count_33 >= 33u)
    {
        count_33 = 0u;
        
        FlashTimer2++;        /*165ms一次 加 1*/
        if (FlashTimer2 >= 2)
        {
            FlashTimer2 = 0u;
        }
    }

    FLASH_SYNC_1Hz = FlashSync1HzTable[FlashTimer]; /*500ms*/
    FLASH_SYNC_2Hz = FlashSync2HzTable[FlashTimer]; /*250ms*/
    FLASH_SYNC_5Hz = FlashSync5HzTable[FlashTimer]; /*100ms*/
    FLASH_SYNC_05Hz = FlashSync05HzTable[FlashTimer40]; /*1000ms*/
    FLASH_SYNC_2_5_Hz = FlashSync_2_5_HzTable[FlashTimer40]; /*200ms*/

    FLASH_SYNC_3Hz = FlashSync3HzTable[FlashTimer2];/*165ms*/
}