/**************************************************************************//**
  * \file     Sound_Track_Playback.c
  * \brief    Sound track play driver file
  * \details
  * \author   Zhang Xuan
  * \version  V1.0.0
  * \date     11-Oct-2018
  * \par      History:
  *           V1.0.0 Initial release
  * \par      Copyright:
  *           (c) Heilongjiang TYW Electronics co., LTD
******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "Sound_Track_Playback.h"
//#include "IIS_MAX98357.h"


/**************************************************************************//**
  * \brief      Initializes the sound playback function
  * \retval     None
******************************************************************************/
void Sound_Track_Playback_Init ( void )
{

}

/**************************************************************************//**
  * \brief      PCM audio track playback
  * \param      TrackID : PCM track ID defined in "PCM_Sound_Tracks.h"
  * \param      Channel : Channel number(0 - 4). There are 5 PCM audio playback
  *                       channels that can play different PCM audio at the
  *                       same time
  * \retval     None
******************************************************************************/
void Snd_PCM_Track_Play ( uint8_t TrackID, uint8_t Channel )
{
#if SND_SYS_PCM_CHANNEL_ENABLE
    if ( ( TrackID >= PCM_TRACK_TOTAL_NUM ) || ( Channel > 4 ) )
        return;
//I2S_MAX98357_InternalFlash_CH0_Player(PCMTrackAttrTable[TrackID].pPCMData, PCMTrackAttrTable[TrackID].Size , 1U);
    //Sound_System_Play_PCM ( PCMTrackAttrTable[TrackID].pPCMData, PCMTrackAttrTable[TrackID].Size, Channel, PCMTrackAttrTable[TrackID].Gain );
#endif
}

/**************************************************************************//**
  * \brief      PCM audio track playback repeatedly
  * \param      TrackID : PCM track ID defined in "PCM_Sound_Tracks.h"
  * \param      Channel : Channel number(0 - 4). There are 5 PCM audio playback
  *                       channels that can play different PCM audio at the
  *                       same time
  * \retval     None
******************************************************************************/
void Snd_PCM_Track_Repeat_Play ( uint8_t TrackID, uint8_t Channel )
{
#if SND_SYS_PCM_CHANNEL_ENABLE
    if ( ( TrackID >= PCM_TRACK_TOTAL_NUM ) || ( Channel > 4 ) )
        return;
 //I2S_MAX98357_InternalFlash_CH0_Player(PCMTrackAttrTable[TrackID].pPCMData, PCMTrackAttrTable[TrackID].Size , 0xFFFFU);
    //Sound_System_Repeat_Play_PCM ( PCMTrackAttrTable[TrackID].pPCMData, PCMTrackAttrTable[TrackID].Size, Channel, PCMTrackAttrTable[TrackID].Gain );
#endif
}

/**************************************************************************//**
  * \brief      Stop PCM track playback
  * \param      Channel : Specified channel number(0 - 4) to stop
  * \retval     None
******************************************************************************/
void Snd_PCM_Track_Stop_Play ( uint8_t Channel )
{
#if SND_SYS_PCM_CHANNEL_ENABLE
   // Sound_System_Stop_Play_PCM ( Channel );
 //  I2S_MAX98357_Stop( Channel);
#endif
}

/**************************************************************************//**
  * \brief      Generated sound track playback
  * \param      TrackID : Generated sound track ID defined in
                          "Gen_Sound_Tracks.h"
  * \param      Channel : Channel number(0 - 4). There are 5 sound generate
  *                       channels that can generate different sound at the
  *                       same time
  * \retval     None
******************************************************************************/
void Snd_Gen_Track_Play ( uint8_t TrackID, uint8_t Channel )
{

}

/**************************************************************************//**
  * \brief      Generated sound track playback repeatedly
  * \param      TrackID : Generated sound track ID defined in
                          "Gen_Sound_Tracks.h"
  * \param      Channel : Channel number(0 - 4). There are 5 sound generate
  *                       channels that can generate different sound at the
  *                       same time
  * \retval     None
******************************************************************************/
void Snd_Gen_Track_Repeat_Play ( uint8_t TrackID, uint8_t Channel )
{

}

/**************************************************************************//**
  * \brief      Stop generated sound track playback
  * \param      Channel : Specified channel number(0 - 4) to stop
  * \retval     None
******************************************************************************/
void Snd_Gen_Track_Stop_Play ( uint8_t Channel )
{

}

/**************************************************************************//**
  * \brief      Sound track playback control service
  * \attention  Call this function every 10ms
  * \retval     None
******************************************************************************/
void Sound_Track_Playback_Service ( void )
{

}
