#include "GenDelay.h"
#include "GPIO.h"
#include "ADC.h"
#include "System_Monitor.h"
#include "Analog_Signals.h"

#define u16Base_Vol           0u        // 0
#define u16ENTER_LOW_N_RANGE   6500U    // 1
#define u16EXIT_LOW_N_RANGE    7000U    // 2
#define u16ENTER_LOW_Y_RANGE  19500U    // 3
#define u16EXIT_LOW_Y_RANGE   20000U    // 4
#define u16EXIT_HIGH_Y_RANGE  32000U    // 5
#define u16ENTER_HIGH_Y_RANGE 32500U    // 6
#define u16EXIT_HIGH_N_RANGE  33000U    // 7
#define u16ENTER_HIGH_N_RANGE 33500U    // 8
#define u16Top_Vol            0xffffu

#pragma alignvar(8)
static const monitorlib_uint16_t SysFun_Range [ 26u ] = {
    u16Base_Vol,

    u16ENTER_LOW_N_RANGE,
    u16EXIT_LOW_N_RANGE,

    u16ENTER_LOW_Y_RANGE,
    u16EXIT_LOW_Y_RANGE,

    u16EXIT_HIGH_Y_RANGE,
    u16ENTER_HIGH_Y_RANGE,

    u16EXIT_HIGH_N_RANGE,
    u16ENTER_HIGH_N_RANGE,

    u16Top_Vol,
    30000u,   /**进入保护的时间*/
    10u,
    u16Base_Vol,

    u16ENTER_LOW_N_RANGE,
    u16EXIT_LOW_N_RANGE,

    u16ENTER_LOW_Y_RANGE,
    u16EXIT_LOW_Y_RANGE,

    u16EXIT_HIGH_Y_RANGE,
    u16ENTER_HIGH_Y_RANGE,

    u16EXIT_HIGH_N_RANGE,
    u16ENTER_HIGH_N_RANGE,

    u16Top_Vol,
    10000u,
    10u,
    10u, /**退出保护的时间*/
    10u, /**退出保护的时间*/
};

monitorlib_uint16_t Sys_Read_KL30_Voltage_F(void)
{
    monitorlib_uint16_t u16Voltage;
    u16Voltage = ADC_Conv_Single_Channel(ADC_CH_KL30_VOLTAGE);
    return u16Voltage;
}

monitorlib_uint16_t Sys_Read_KL15_Voltage_F(void)
{
    monitorlib_uint16_t u16Voltage;
    u16Voltage = ADC_Conv_Single_Channel(ADC_CH_KL30_VOLTAGE);
    return u16Voltage;
}

monitorlib_uint16_t Sys_Read_KL30_Voltage(void)
{
    monitorlib_uint16_t u16Voltage;
    u16Voltage = ADC_Read_Signal(ADC_CH_KL30_VOLTAGE);
    return u16Voltage;
}

monitorlib_uint16_t Sys_Read_KL15_Voltage(void)
{
    monitorlib_uint16_t u16Voltage;
    u16Voltage = ADC_Read_Signal(ADC_CH_KL30_VOLTAGE);
    return u16Voltage;
}

monitorlib_uint8_t Sys_Read_KL30_Valid(void)
{
    monitorlib_uint8_t u8Valid;
    u8Valid = ADC_Read_Signal_Valid(ADC_CH_KL30_VOLTAGE);
    return u8Valid;
}

monitorlib_uint8_t Sys_Read_KL15_Valid(void)
{
    monitorlib_uint8_t u8Valid;
    u8Valid = ADC_Read_Signal_Valid(ADC_CH_KL30_VOLTAGE);
    return u8Valid;
}

monitorlib_uint8_t System_LINE_KL15(void)
{
    monitorlib_uint8_t u8KL15;

    if ( ADC_KL15_IN == 1u )
    {
        u8KL15 = 1u;
    }
    else
    {
        u8KL15 = 0u;
    }

    return u8KL15;
}

void Common_BlockDelay(monitorlib_uint32_t u32Ms)
{
    Gen_TimeDelay(u32Ms * 1000u, 50u);
}
void Sys_LogicProcess(void)
{
}

void Sys_KL30_Init(void)
{
    MonitorExt_st m_st;
    m_st.COM_Delay               = Common_BlockDelay;
    m_st.SysGet_KL15Line         = System_LINE_KL15;
    m_st.SysGet_KL15_Valid       = Sys_Read_KL15_Valid;
    m_st.SysGet_KL30_Valid       = Sys_Read_KL30_Valid;
    m_st.SysGet_KL15_value       = Sys_Read_KL15_Voltage;
    m_st.SysGet_KL30_value       = Sys_Read_KL30_Voltage;
    m_st.SysGet_KL15_value_Force = Sys_Read_KL15_Voltage_F;
    m_st.SysGet_KL30_value_Force = Sys_Read_KL30_Voltage_F;
    m_st.SysMonitorLogic         = Sys_LogicProcess;
    Sys_Set_Pata(SysFun_Range, &m_st);
    System_Monitor_KL30Init( );
}

void Sys_WakeUp_Init(void)
{
    MonitorExt_st m_st;
    m_st.COM_Delay               = Common_BlockDelay;
    m_st.SysGet_KL15Line         = System_LINE_KL15;
    m_st.SysGet_KL15_Valid       = Sys_Read_KL15_Valid;
    m_st.SysGet_KL30_Valid       = Sys_Read_KL30_Valid;
    m_st.SysGet_KL15_value       = Sys_Read_KL15_Voltage;
    m_st.SysGet_KL30_value       = Sys_Read_KL30_Voltage;
    m_st.SysGet_KL15_value_Force = Sys_Read_KL15_Voltage_F;
    m_st.SysGet_KL30_value_Force = Sys_Read_KL30_Voltage_F;
    m_st.SysMonitorLogic         = Sys_LogicProcess;
    Sys_Set_Pata(SysFun_Range, &m_st);
    System_Monitor_WakeupInit( );
}
