#include "Data_AdBule.h"
#include "Gauges.h"
#include "GaugesInterface.h"
#include "CAN_Communication_Matrix.h"
//-------------------------------------------
//尿素 数据处理 wangboyu
//-------------------------------------------
//区域1显示逻辑
//-------------------------------------------
//342 - 4.3.DS油位显示器
//-------------------------------------------

static struct
{
	uint8_t	Number ;
	en_ADBULE_Sta	DisplaySta ;
}AdBuleVariable ;

/*-------------------------------------------------------------------------
 * Function Name  : AdBule_KL30_Init
 * Description    : 
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void AdBule_KL30_Init(void)
{
    AdBuleVariable.Number = 0u;
    AdBuleVariable.DisplaySta = ADBULE_LED_OFF;
}
void AdBule_KL15_ON_Init(void)
{
	AdBuleVariable.Number = 0u;
    AdBuleVariable.DisplaySta = ADBULE_LED_OFF;
}
void AdBule_KL15_OFF_Init(void)
{
	AdBuleVariable.Number = 0u;
    AdBuleVariable.DisplaySta = ADBULE_LED_OFF;
}
void AdBule_Wakeup_Init(void)
{
	AdBuleVariable.Number = 0u;
    AdBuleVariable.DisplaySta = ADBULE_LED_OFF;
}
void AdBule_Sleep_Init(void)
{
	AdBuleVariable.Number = 0u;
    AdBuleVariable.DisplaySta = ADBULE_LED_OFF;
}
/*-------------------------------------------------------------------------
 * Function Name  : AdBule_Processing_Service
 * Description    : 
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void AdBule_Processing_Service(void)
{
	uint8_t Msg_Tank_Level = 0 ;
	uint8_t Msg_Level_blinking = 0 ; 
	uint8_t u8Number = 0 ;
	en_ADBULE_Sta u8DisplaySta = ADBULE_LED_OFF ;
	
	Msg_Tank_Level = Get_ID_18FF2300_Sig_Tank_Level();
	Msg_Level_blinking = Get_ID_18FF2300_Sig_Level_blinking();
	
	//if(Get_CanFirstRecv_Event(ID_CanMsg18FF2300_Msg_Count) == 0)
	//{
	//	u8Number = 0u;
	//	u8DisplaySta = ADBULE_LED_OFF;
	//}	
	//else if (CAN_MSG_Status(ID_CanMsg18FF2300_Msg_Count) == CAN_SIG_LOST)
	if (CAN_MSG_Status(ID_CanMsg18FF2300_Msg_Count) == CAN_SIG_LOST)
	{
		u8Number = 0u;
		u8DisplaySta = ADBULE_LED_OFF;
	}
	else
	{
		if(Msg_Tank_Level == 0x3C)
		{
			u8Number = 5u;
		}
		else if(Msg_Tank_Level == 0x1C)
		{
			u8Number = 4u;
		}
		else if(Msg_Tank_Level == 0x0C)
		{
			u8Number = 3u;
		}
		else if(Msg_Tank_Level == 0x04)
		{
			u8Number = 2u;
		}
		else if(Msg_Tank_Level == 0x02)
		{
			u8Number = 1u;
		}
		else
		{
			u8Number = 0u;
		}
		
		if(Msg_Level_blinking == 0x03)
		{
			u8DisplaySta = ADBULE_LED_3HZ_FLASH ;			
		}
		else if(Msg_Level_blinking == 0x01)
		{
			u8DisplaySta = ADBULE_LED_1HZ_FLASH ;
		}
		else
		{
			u8DisplaySta = ADBULE_LED_ON ;
		}	
	}
	
	AdBuleVariable.Number = u8Number ;
	AdBuleVariable.DisplaySta =	u8DisplaySta ;
}

/*-------------------------------------------------------------------------
 * Function Name  : AdBule_Get_Number
 * Description    : 返回尿素当前格数
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint8_t AdBule_Get_Number(void)
{
    uint8_t u8Result = 0u;
    u8Result = AdBuleVariable.Number;
    return u8Result;
}
/*-------------------------------------------------------------------------
 * Function Name  : AdBule_Get_Display_Sta
 * Description    : 返回尿素当前显示模式(最后一格的显示模式)
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
en_ADBULE_Sta AdBule_Get_Display_Sta(void)
{
    en_ADBULE_Sta u8Result = ADBULE_LED_OFF;
    u8Result = AdBuleVariable.DisplaySta;
    return u8Result;
}


