#include "Data_Fuel_User.h"
#include "FuelConfig.h"
#include "Common_Interface.h"
#include "RTE_ADC.h"
#include "GPIO.h"
#include "Services_ODO_User.h"
//-------------------------------------------
//燃油 数据处理 wangboyu 2021-8-31 15:19:14
//-------------------------------------------
//342 - 4.2.燃油表
//-------------------------------------------

/*----------------------------------------------------------------------------------------------------------------------
格			 0		1		2		3		4		5		6		7		8		9		10		11		12

阻值(Up)	 - 		144.5	126.5	108.1	90.9	75.7	60.6	47.3	38.2	29.1	21		15.5	9.9

step				13      23		33		43		52		61		68		73		79		83		86		90

阻值(Down)	 150	137.3	119.1	100.9	84.8	69.7	54.5	43.6	34.5	25.4	18.8	13.2	-

step		0		17		27		38		47		55		64		70		76		81		84		88



*-----------------------------------------------------------------------------------------------------------------------*/
static const UP_TABLE[13U]   = {10U , 13U , 23U , 33U , 43U , 52U , 61U , 68U , 73U , 79U , 83U , 86U , 90U};
static const DOWN_TABLE[13U] = {10U , 17U , 27U , 38U , 47U , 55U , 64U , 70U , 76U , 81U , 84U , 88U , 90U};

static uint8_t Fuel_CurSeg = 0 ;

static uint8_t CalFuel_CurSeg(uint8_t Step);

#define   BASEFUELVAL                       3500    //3.0L底油
/*-------------------------------------------------------------------------
 * Function Name  : Fuel_User_KL30_Init
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Fuel_User_KL30_Init(void)
{
    FuelStruct FuelInitPara ;
    AFC_INIT   AFCInit ;
    uint32_t ODO_Value = 0u;

    ODO_Value = Data_ODO_Read();

    FuelInitPara.FuelShortCircuitR       = FUEL_R_MIN_VAL;
    FuelInitPara.FuelOpenCircuitR        = FUEL_R_MAX_VAL;

    FuelInitPara.DisplayZoneBoundary[0]  =  DISPLAY_BOUNDARY_ES  ; //1500
    FuelInitPara.DisplayZoneBoundary[1]  =  DISPLAY_BOUNDARY_1   ; //1500
    FuelInitPara.DisplayZoneBoundary[2]  =  DISPLAY_BOUNDARY_2   ; //1373
    FuelInitPara.DisplayZoneBoundary[3]  =  DISPLAY_BOUNDARY_3   ; //1191
    FuelInitPara.DisplayZoneBoundary[4]  =  DISPLAY_BOUNDARY_4   ; //1009
    FuelInitPara.DisplayZoneBoundary[5]  =  DISPLAY_BOUNDARY_5   ; // 848
    FuelInitPara.DisplayZoneBoundary[6]  =  DISPLAY_BOUNDARY_6   ; // 697
    FuelInitPara.DisplayZoneBoundary[7]  =  DISPLAY_BOUNDARY_7   ; // 545
    FuelInitPara.DisplayZoneBoundary[8]  =  DISPLAY_BOUNDARY_8   ; // 436
    FuelInitPara.DisplayZoneBoundary[9]  =  DISPLAY_BOUNDARY_9   ; // 345
    FuelInitPara.DisplayZoneBoundary[10] =  DISPLAY_BOUNDARY_10  ; // 254
    FuelInitPara.DisplayZoneBoundary[11] =  DISPLAY_BOUNDARY_11  ; // 188
    FuelInitPara.DisplayZoneBoundary[12] =  DISPLAY_BOUNDARY_12  ; // 132
    FuelInitPara.DisplayZoneBoundary[13] =  DISPLAY_BOUNDARY_13  ; //  40
    FuelInitPara.DisplayZoneBoundary[14] =  DISPLAY_BOUNDARY_FS  ; //  30

    AFCInit.CalcAFCMaxNum   = 100;						/*50公里或者100公里已更新*/
    AFCInit.AFCMin          = 30;						/*油耗最小值十倍*/
    AFCInit.AFCMax          = 300;						/*油耗最大值*/
    AFCInit.AFCPreinstall   = 80;						/*油耗初始值*/
    AFCInit.CurODO          = ODO_Value * 100;			/*总共里数100倍*/
    AFCInit.MaxDRMileage    = 69900;					/*续航里程最大值*/

    InitFuelParamter(&FuelInitPara);
    InitAFC(&AFCInit);

    //----hyq--20190603--燃油上涨为下降的0.6
    SetIgnOffRefuelThreshold(6);

    SetPowerDnStep(0);

    SetFuelSensorRecoverGroupCnt(10);
    SetFuelSensorOpenCircuitGroupCnt(120);
    SetFuelSensorShortCircuitGroupCnt(120);
}
void Fuel_User_KL15_ON_Init(void)
{

}

void Fuel_User_KL15_OFF_Init(void)
{

}
void Fuel_User_Wakeup_Init(void)
{

}
void Fuel_User_Sleep_Init(void)
{

}
/*-------------------------------------------------------------------------
 * Function Name  : Fuel_User_KL15_ON_Processing_Service
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 10Ms调用
 --------------------------------------------------------------------------*/
static uint16_t wbyTestR = 0 ;
static uint8_t  wbyTestStep = 0 ;
void Fuel_User_KL15_ON_Processing_Service(void)
{
    AFC_PARA AFCPara ;
    uint8_t  FuelR_Valid = 0 ;
    uint16_t FuelR = 0 ;
    uint8_t  Vspeed_Valid = 0 ;
    uint16_t Vspeed = 0 ;
    uint8_t  Espeed_Valid = 0 ;
    uint16_t Espeed = 0 ;

    uint8_t FuelMode = 0 ;
    uint8_t Step = 0 ;

    uint32_t ODO_Value = 0u;

// In ---> Lib
    FuelR_Valid = RTE_Read_FUEL_R_Valid();
    Vspeed_Valid = Common_Get_Act_V_Speed_Valid();
    Espeed_Valid = Common_Get_Act_E_Speed_Valid();

    if (Common_Get_IG_Sts_Valid() == COMMON_Valid)
    {
        if (Common_Get_IG_Sts() == COMMON_POWER_ON)
        {
            if (FuelR_Valid)
            {
                FuelR = RTE_Read_FUEL_R();
                //FuelR = wbyTestR ;
            }
            else
            {
                FuelR = 0 ;
            }

            if (Vspeed_Valid)
            {
                Vspeed = Common_Get_Act_V_Speed();
            }
            else
            {
                Vspeed = 0 ;
            }

            if (Espeed_Valid)
            {
                Espeed = Common_Get_Act_E_Speed();
            }
            else
            {
                Espeed = 0 ;
            }

            SetPowerSt(1);
            AFCTimerCall();

            ODO_Value = Data_ODO_Read();

            AFCPara.CurODO = ODO_Value * 100; // m
            AFCPara.FuleConsume = 0 ;
            AFCPara.RPM = Espeed; 			// 1
            AFCPara.Speed = (Vspeed * 10);// 0.1

            SetAFCPara(&AFCPara);
            FuelFSM(FuelR);
        }
    }
    // Lib ---> Out
    FuelMode = GetFuelSensorState(); /*燃油状态获取*/

    Step = GetFuelStep();
    wbyTestStep = GetFuelStep();

    if (FuelMode == FuelSensorNormal)
    {
        Fuel_CurSeg = CalFuel_CurSeg(Step) ;
    }
    else
    {
        Fuel_CurSeg = 0 ;
    }
}
/*-------------------------------------------------------------------------
 * Function Name  : Fuel_User_KL15_OFF_Processing_Service
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 嵌入到100Ms中断中
 --------------------------------------------------------------------------*/
void Fuel_User_KL15_OFF_Processing_Service(void)
{
    uint8_t i;
    uint8_t  FuelR_Valid = 0 ;
    uint16_t FuelR = 0 ;

    FuelR_Valid = RTE_Read_FUEL_R_Valid();
    FuelR = RTE_Read_FUEL_R();

    if (Common_Get_IG_Sts_Valid() == COMMON_Valid)
    {
        if (Common_Get_IG_Sts() == COMMON_POWER_OFF)
        {
            SetPowerSt(0);
            for (i = 0; i < 10; i++)
            {
                AFCTimerCall();
            }
            FuelFSM(FuelR);
        }
    }


}
/*-------------------------------------------------------------------------
 * Function Name  : Fuel_Display
 * Description    : Step - 步数
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
static uint8_t CalFuel_CurSeg(uint8_t Step)
{
    static uint8_t Seg = 0 ;

    switch (Seg)
    {
    case 0 :
        if (Step >= UP_TABLE[1])
        {
            Seg = 1 ;
        }
        break ;
    case 1 :
        if (Step >= UP_TABLE[2])
        {
            Seg = 2 ;
        }
        else if (Step < DOWN_TABLE[0])
        {
            Seg = 0 ;
        }
        break ;
    case 2 :
        if (Step >= UP_TABLE[3])
        {
            Seg = 3 ;
        }
        else if (Step < DOWN_TABLE[1])
        {
            Seg = 1 ;
        }
        break ;
    case 3 :
        if (Step >= UP_TABLE[4])
        {
            Seg = 4 ;
        }
        else if (Step < DOWN_TABLE[2])
        {
            Seg = 2 ;
        }
        break ;
    case 4 :
        if (Step >= UP_TABLE[5])
        {
            Seg = 5 ;
        }
        else if (Step < DOWN_TABLE[3])
        {
            Seg = 3 ;
        }
        break ;
    case 5 :
        if (Step >= UP_TABLE[6])
        {
            Seg = 6 ;
        }
        else if (Step < DOWN_TABLE[4])
        {
            Seg = 4 ;
        }
        break ;
    case 6 :
        if (Step >= UP_TABLE[7])
        {
            Seg = 7 ;
        }
        else if (Step < DOWN_TABLE[5])
        {
            Seg = 5 ;
        }
        break ;
    case 7 :
        if (Step >= UP_TABLE[8])
        {
            Seg = 8 ;
        }
        else if (Step < DOWN_TABLE[6])
        {
            Seg = 6 ;
        }
        break ;
    case 8 :
        if (Step >= UP_TABLE[9])
        {
            Seg = 9 ;
        }
        else if (Step < DOWN_TABLE[7])
        {
            Seg = 7 ;
        }
        break ;
    case 9 :
        if (Step >= UP_TABLE[10])
        {
            Seg = 10 ;
        }
        else if (Step < DOWN_TABLE[8])
        {
            Seg = 8 ;
        }
        break ;
    case 10 :
        if (Step >= UP_TABLE[11])
        {
            Seg = 11 ;
        }
        else if (Step < DOWN_TABLE[9])
        {
            Seg = 9 ;
        }
        break ;
    case 11 :
        if (Step >= UP_TABLE[12])
        {
            Seg = 12 ;
        }
        else if (Step < DOWN_TABLE[10])
        {
            Seg = 10 ;
        }
        break ;
    case 12 :
        if (Step < DOWN_TABLE[11])
        {
            Seg = 11 ;
        }
        break ;
    default :
        Seg = 0 ;
        break ;
    }

    return Seg ;
}
/*-------------------------------------------------------------------------
 * Function Name  : Fuel_Get_CurSeg
 * Description    : 燃油当前格
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
uint8_t Fuel_Get_CurSeg(void)
{
    return Fuel_CurSeg ;
}
/*-------------------------------------------------------------------------
 * Function Name  : Fuel_Get_Percent
 * Description    : 燃油百分比
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 应用于外发报文
 --------------------------------------------------------------------------*/
uint8_t Fuel_Get_Percent(void)
{
    uint16_t Percent = 0 ;
    uint8_t Step = 0 ;

    Step = GetFuelStep();
    if (Step <= 10)
    {
        Percent = 0 ;
    }
    else if (Step >= 90)
    {
        Percent = 100 ;
    }
    else
    {
        Step -= 10 ;
        Percent = Step ;
        Percent *= 100 ; //放大100倍
        Percent /= 80 ;  // 90 - 10

    }
    return Percent ;
}

uint16_t Fuel_Get_Res(void)
{
    return GetFuelResistance();
}
uint16_t Fuel_Get_Step(void)
{
    return GetFuelStep();
}

uint8_t Fuel_Get_LowAlarm(void)
{
    uint8_t u8Result = 0 ;
    uint8_t FuelMode = 0 ;
    uint8_t Step = 0 ;
    uint8_t  FuelR_Valid = 0 ;
    uint16_t FuelR = 0 ;
    FuelR_Valid = RTE_Read_FUEL_R_Valid();

    FuelMode = GetFuelSensorState();
    Step = GetFuelStep();

    if (FuelR_Valid)
    {
        FuelR = RTE_Read_FUEL_R();
    }

    if (FuelMode == FuelSensorNormal)
    {
        if (FuelR > 30 && FuelR < 3000 )
        {
            if (Step < 20)
            {
                u8Result = 1 ;
            }
            else
            {
                u8Result = 0 ;
            }
        }
        else
        {
            u8Result = 0 ;
        }
    }
    else
    {
        u8Result = 0 ;
    }

    return u8Result ;
}



