#include "Data_FuelConsump.h"
#include "r_typedefs.h"
#include "CAN_Communication_Matrix.h"
#include "Services_Mileage.h"
#include "Common_Interface.h"
#include "CAN_Lib.h"
#pragma ghs section sbss=".mysbss"
uint32_t OldTotalFuel_Trip = 0u;
uint32_t OldTotalFuel_ThisTime = 0u;
uint32_t OldTotalFuel_Comprehensive = 0u;
uint32_t OldTotalRunTime_Comprehensive = 0u;
uint32_t OldOdo_ThisTime = 0u;
uint8_t EngineType = 0u;

uint32_t TotalFuleLitre = 0U;

/*综合油耗信息*/
uint16_t FuelCounsComprehensiveRestFlag = 0u;
uint32_t FuelCounsComprehensiveODO = 0U;
uint32_t FuelCounsComprehensiveTotalFuleLitre = 0U;
uint16_t FuelCounsComprehensiveVale = 0U;
/*小计油耗信息*/
uint16_t FuelCounsumpTripRestFlag = 0u;
uint32_t FuelCounsumpTripODO = 0U;
uint32_t FuelCounsumpTripTotalFuleLitre = 0U;
uint16_t FuelCounsumpTripVale = 0U;
uint32_t TripTotalFuleLitre =0u;
/*本次油耗信息*/
uint16_t FuelCounsumpThisTimeRestFlag = 0u;
uint32_t FuelCounsumpThisTimeODO = 0U;
uint32_t FuelCounsumpThisTimeTotalFuleLitre = 0U;
uint16_t FuelCounsumpThisTimeVale = 0U;
uint32_t ThisTimeTotalFuleLitre =0u;
/*加油后油耗信息*/
uint32_t AVFTotalFuleLitre = 0U;
uint32_t AVFODO = 0U;
uint16_t AVFVale = 0U;
uint16_t RefuelingRestFlag = 0U;
uint32_t RefuelingTotalFuleLitre = 0U;
uint32_t RefuelingTrip = 0U;
#pragma ghs section sbss=default




/******************************************************************************
  Function：Data_FuelCounsComprehensive
  Description：综合油耗行车信息
  Input:
  Output:
 ******************************************************************************/
void Data_FuelCounsComprehensive(void)
{
    uint32_t TmpTotalFuleLitre = 0u;
    uint32_t CurOdo = 0u;
    uint16_t TmpFuelCounsComprehensive = 0u;
    CAN_MSG_Status_t TmpCanStatus;

    //TmpCanStatus = CAN_MSG_Status(ID_Fcosm_0x18FEE900x_Msg_Count);
    if (TmpCanStatus == CAN_SIG_NORMAL)
    {
        //TotalFuleLitre = Get_ID_18FEE900_Sig_EngineTotalFuelUsed();
    }
    else
    {
        ;
    }
    if (Common_GetIgnOnTime() > 2000u)
    {
        if ((FuelCounsComprehensiveRestFlag == 0xaabbu))
        {
            if (TmpCanStatus == CAN_SIG_NORMAL)
            {
                FuelCounsComprehensiveTotalFuleLitre = TotalFuleLitre;
                FuelCounsComprehensiveTotalFuleLitre = FuelCounsComprehensiveTotalFuleLitre * 50u;
                FuelCounsComprehensiveODO = Data_ODO_Read();
                FuelCounsComprehensiveRestFlag = 0xbbaau;
            }
            else
            {

            }
        }
        else
        {
            ;
        }
        TmpTotalFuleLitre = TotalFuleLitre;
        TmpTotalFuleLitre = TmpTotalFuleLitre * 50u;
        CurOdo = Data_ODO_Read();
        if (TmpTotalFuleLitre > FuelCounsComprehensiveTotalFuleLitre)
        {

            if (CurOdo >FuelCounsComprehensiveODO)
            {

                if ((CurOdo - FuelCounsComprehensiveODO) >= 20u)
                {
                    TmpFuelCounsComprehensive = ((TmpTotalFuleLitre - FuelCounsComprehensiveTotalFuleLitre) * 100u) / (CurOdo - FuelCounsComprehensiveODO) ;
                }
                else
                {
                    TmpFuelCounsComprehensive = 0xffffu;
                }
            }
            else
            {
                TmpFuelCounsComprehensive = 0xffffu;
            }
        }
        else
        {
            TmpFuelCounsComprehensive = 0xffffu;
        }

    }
    else
    {
        ;
    }

    FuelCounsComprehensiveVale = TmpFuelCounsComprehensive;
}
/******************************************************************************
  Function：Rest_Refueling_Data
  Description：复位综合油耗行车信息
  Input:
  Output:
 ******************************************************************************/
void  Rest_FuelCounsComprehensive_Data(void)
{
    FuelCounsComprehensiveRestFlag = 0xaabbu;

}
/******************************************************************************
  Function：Get_FuelCounsComprehensive_ODO
  Description：得到综合油耗燃油消耗
  Input:
  Output:
 ******************************************************************************/
uint32_t  Get_FuelCounsComprehensive_ToalFuelLitre(void)
{
    uint32_t  TmpTotalFuleLitre;
    if (FuelCounsComprehensiveRestFlag == 0xbbaau)
    {
        //TmpTotalFuleLitre = Get_ID_18FEE900_Sig_EngineTotalFuelUsed();
        TmpTotalFuleLitre = TmpTotalFuleLitre / 2u;
    }
    else
    {
        TmpTotalFuleLitre = 0xffffffffu;
    }
    return TmpTotalFuleLitre;
}
/******************************************************************************
  Function：Get_FuelCounsComprehensive_ODO
  Description：得到综合油耗行驶里程
  Input:
  Output:
 ******************************************************************************/
uint32_t  Get_FuelCounsComprehensive_ODO(void)
{
    uint32_t  TmpFuelCounsComprehensiveODO;
    TmpFuelCounsComprehensiveODO = Data_ODO_Read();
    return TmpFuelCounsComprehensiveODO / 10u;
}
/******************************************************************************
  Function：Get_FuelCounsComprehensive_Value
  Description：得到综合油耗
  Input:
  Output:
 ******************************************************************************/
uint16_t  Get_FuelCounsComprehensive_Value(void)
{

    return FuelCounsComprehensiveVale;
}

/******************************************************************************
  Function：Get_Refueling_ToalFuelLitre
  Description：得到综合油耗行驶时间
  Input:
  Output:
 ******************************************************************************/
uint32_t  Get_FuelCounsComprehensive_RunTime(void)
{
    uint32_t  TmpFuelCounsComprehensiveRunTime;
    //TmpFuelCounsComprehensiveRunTime = Get_ID_18FEE500_Sig_Total_engine_hours ();
    return TmpFuelCounsComprehensiveRunTime / 2u;
}

/******************************************************************************
  Function：Data_FuelCounsumpTrip
  Description：小计油耗
  Input:
  Output:
 ******************************************************************************/
void Data_FuelCounsumpTrip(void)
{
    uint32_t TmpTotalFuleLitre = 0u;
    uint16_t TmpFuelCounsumpTrip = 0u;
    CAN_MSG_Status_t TmpCanStatus;

    //TmpCanStatus = CAN_MSG_Status(ID_Fcosm_0x18FEE900x_Msg_Count);

    if (Common_GetIgnOnTime() > 2000u)
    {
        if ((FuelCounsumpTripRestFlag == 0xaabbu))
        {
            if (TmpCanStatus == CAN_SIG_NORMAL)
            {
                FuelCounsumpTripTotalFuleLitre = TotalFuleLitre;
                FuelCounsumpTripTotalFuleLitre = FuelCounsumpTripTotalFuleLitre * 50u;
                TripTotalFuleLitre=0u;
                FuelCounsumpTripRestFlag = 0xbbaau;
            }
            else
            {

            }
        }
        else
        {
            ;
        }
        TmpTotalFuleLitre = TotalFuleLitre;
        TmpTotalFuleLitre = TmpTotalFuleLitre * 50u;
        FuelCounsumpTripODO = Data_Read_Trip(EM_TRIP_B);
        if (TmpTotalFuleLitre > FuelCounsumpTripTotalFuleLitre)
        {
            TripTotalFuleLitre = TmpTotalFuleLitre - FuelCounsumpTripTotalFuleLitre;
            

                if (FuelCounsumpTripODO >= 20u)
                {
                    TmpFuelCounsumpTrip = (TripTotalFuleLitre* 100u) / FuelCounsumpTripODO;
                }
                else
                {
                    TmpFuelCounsumpTrip = 0xffffu;
                }
            
        }
        else
        {
            TmpFuelCounsumpTrip = 0xffffu;
        }

    }
    else
    {
        ;
    }

    FuelCounsumpTripVale = TmpFuelCounsumpTrip;
}
/******************************************************************************
  Function：Rest_Refueling_Data
  Description：复位小计油耗行车信息
  Input:
  Output:
 ******************************************************************************/
void  Rest_FuelCounsumpTrip_Data(void)
{
    FuelCounsumpTripRestFlag = 0xaabbu;

    Data_Clear_Trip ( EM_TRIP_B);

}
/******************************************************************************
  Function：Get_FuelCounsComprehensive_ODO
  Description：得到小计燃油消耗
  Input:
  Output:
 ******************************************************************************/
uint32_t  Get_FuelCounsumpTrip_ToalFuelLitre(void)
{
    uint32_t  TmpTotalFuleLitre;
    if (FuelCounsumpTripRestFlag == 0xbbaau)
    {
        TmpTotalFuleLitre = TripTotalFuleLitre;
        TmpTotalFuleLitre = TmpTotalFuleLitre / 100u;
    }
    else
    {
        TmpTotalFuleLitre = 0xffffffffu;
    }
    return TmpTotalFuleLitre;
}
/******************************************************************************
  Function：Get_FuelCounsComprehensive_ODO
  Description：得到小计油耗行驶里程
  Input:
  Output:
 ******************************************************************************/
uint32_t  Get_FuelCounsumpTrip_ODO(void)
{
    uint32_t  TmpFuelCounsumpTripODO;
    TmpFuelCounsumpTripODO = Data_Read_Trip(EM_TRIP_A);
    return TmpFuelCounsumpTripODO /10u;
}
/******************************************************************************
  Function：Get_FuelCounsComprehensive_Value
  Description：得到小计油耗
  Input:
  Output:
 ******************************************************************************/
uint16_t  Get_FuelCounsumpTrip_Value(void)
{

    return FuelCounsumpTripVale;
}

/*****/
/******************************************************************************
  Function：Data_FuelCounsumpTrip
  Description：本次油耗
  Input:
  Output:
 ******************************************************************************/
void Data_FuelCounsumpThisTime(void)
{
    uint32_t TmpTotalFuleLitre = 0u;
    uint16_t TmpFuelCounsumpThisTime = 0u;
    CAN_MSG_Status_t TmpCanStatus;

    //TmpCanStatus = CAN_MSG_Status(ID_Fcosm_0x18FEE900x_Msg_Count);

    if (Common_GetIgnOnTime() > 3000u)
    {
        if ((FuelCounsumpThisTimeRestFlag == 0xaabbu))
        {
            if (TmpCanStatus == CAN_SIG_NORMAL)
            {
                FuelCounsumpThisTimeTotalFuleLitre = TotalFuleLitre;
                FuelCounsumpThisTimeTotalFuleLitre = FuelCounsumpThisTimeTotalFuleLitre * 50u;
                ThisTimeTotalFuleLitre=0u;
                FuelCounsumpThisTimeRestFlag = 0xbbaau;
            }
            else
            {

            }
        }
        else
        {
            ;
        }
        TmpTotalFuleLitre = TotalFuleLitre;
        TmpTotalFuleLitre = TmpTotalFuleLitre * 50u;
        FuelCounsumpThisTimeODO = Data_Read_Trip(EM_TRIP_C);
        if (TmpTotalFuleLitre > FuelCounsumpThisTimeTotalFuleLitre)
        {
           ThisTimeTotalFuleLitre = TmpTotalFuleLitre - FuelCounsumpThisTimeTotalFuleLitre;
            

                if (FuelCounsumpThisTimeODO >= 50u)
                {
                    TmpFuelCounsumpThisTime = (ThisTimeTotalFuleLitre* 100u) / FuelCounsumpThisTimeODO;
                }
                else
                {
                    TmpFuelCounsumpThisTime = 0xffffu;
                }
            
        }
        else
        {
            TmpFuelCounsumpThisTime= 0xffffu;
        }

    }
    else
    {
        ;
    }

    FuelCounsumpThisTimeVale = TmpFuelCounsumpThisTime;
}
/******************************************************************************
  Function：Rest_FuelCounsumpThisTime_Data
  Description：复位本次油耗行车信息
  Input:
  Output:
 ******************************************************************************/
void  Rest_FuelCounsumpThisTime_Data(void)
{
    FuelCounsumpThisTimeRestFlag = 0xaabbu;
    Data_Clear_Trip ( EM_TRIP_C);

}
/******************************************************************************
  Function：Get_FuelCounsumpThisTime_ToalFuelLitre
  Description：得到本次燃油消耗
  Input:
  Output:
 ******************************************************************************/
uint32_t  Get_FuelCounsumpThisTime_ToalFuelLitre(void)
{
    uint32_t  TmpTotalFuleLitre;
    if (FuelCounsumpThisTimeRestFlag == 0xbbaau)
    {
        TmpTotalFuleLitre = ThisTimeTotalFuleLitre;
        TmpTotalFuleLitre = TmpTotalFuleLitre / 100u;
    }
    else
    {
        TmpTotalFuleLitre = 0xffffffffu;
    }
    return TmpTotalFuleLitre;
}
/******************************************************************************
  Function：Get_FuelCounsumpThisTime_ODO
  Description：得到本次油耗行驶里程
  Input:
  Output:
 ******************************************************************************/
uint32_t  Get_FuelCounsumpThisTime_ODO(void)
{
    uint32_t  TmpFuelCounsumpThisTimeODO;
    TmpFuelCounsumpThisTimeODO = Data_Read_Trip(EM_TRIP_C);
    return TmpFuelCounsumpThisTimeODO / 10u;
}
/******************************************************************************
  Function：Get_FuelCounsumpThisTime_Value
  Description：得到本次油耗
  Input:
  Output:
 ******************************************************************************/
uint16_t  Get_FuelCounsumpThisTime_Value(void)
{

    return FuelCounsumpThisTimeVale;
}
/*****/
/******************************************************************************
  Function：Get_Info_Last_Refueling
  Description：上次加油后的行车信息
  Input:
  Output:
 ******************************************************************************/
void Data_Info_Last_Refueling(void)
{
    uint32_t TmpTotalFuleLitre = 0u;
    uint32_t CurOdo = 0u;
    uint16_t TmpAVF = 0u;
    CAN_MSG_Status_t TmpCanStatus;

    //TmpCanStatus = CAN_MSG_Status(ID_Fcosm_0x18FEE900x_Msg_Count);
    if (Common_GetIgnOnTime() > 2000u)
    {
        if ((RefuelingRestFlag == 0xaabbu))
        {
            if (TmpCanStatus == CAN_SIG_NORMAL)
            {
                AVFTotalFuleLitre = TotalFuleLitre;
                AVFTotalFuleLitre = AVFTotalFuleLitre * 50u;
                AVFODO = Data_ODO_Read();
                RefuelingTotalFuleLitre = 0u;
                RefuelingTrip = 0u;
                RefuelingRestFlag = 0xbbaau;
            }
            else
            {

            }
        }
        else
        {
            ;
        }
        TmpTotalFuleLitre = TotalFuleLitre;
        TmpTotalFuleLitre = TmpTotalFuleLitre * 50u;
        CurOdo = Data_ODO_Read();
        if (TmpTotalFuleLitre > AVFTotalFuleLitre)
        {
            RefuelingTotalFuleLitre = TmpTotalFuleLitre - AVFTotalFuleLitre;
            if (CurOdo > AVFODO)
            {
                RefuelingTrip = CurOdo - AVFODO;
                if ((CurOdo - AVFODO) >= 50u)
                {
                    TmpAVF = RefuelingTotalFuleLitre * 100u / RefuelingTrip;
                }
                else
                {
                    TmpAVF = 0xffffu;
                }
            }
            else
            {
                TmpAVF = 0xffffu;
            }
        }
        else
        {
            TmpAVF = 0xffffu;
        }

    }
    else
    {
        ;
    }

    AVFVale = TmpAVF;
}

/******************************************************************************
  Function：Rest_Refueling_Data
  Description：复位加油后行车信息
  Input:
  Output:
 ******************************************************************************/
void  Rest_Refueling_Data(void)
{
    RefuelingRestFlag = 0xaabbu;

}

/******************************************************************************
  Function：Get_Refueling_AVF
  Description：得到平均油耗
  Input:
  Output:
 ******************************************************************************/
uint16_t  Get_Refueling_AVF(void)
{

    return AVFVale;
}
/******************************************************************************
  Function：Get_Refueling_Trip
  Description：得到加油后行驶里程
  Input:
  Output:
 ******************************************************************************/
uint32_t  Get_Refueling_Trip(void)
{

    return RefuelingTrip/10u;
}
/******************************************************************************
  Function：Get_Refueling_ToalFuelLitre
  Description：得到加油后总油耗
  Input:
  Output:
 ******************************************************************************/
uint32_t  Get_Refueling_ToalFuelLitre(void)
{
    uint32_t  TmpTotalFuleLitre;
    if (RefuelingRestFlag == 0xbbaau)
    {
        TmpTotalFuleLitre = RefuelingTotalFuleLitre;
        TmpTotalFuleLitre = TmpTotalFuleLitre / 100u;
    }
    else
    {
        TmpTotalFuleLitre = 0xffffffffu;
    }
    return TmpTotalFuleLitre;

}

/******************************************************************************
  Function：Fuel_Consump_K30_Init
  Description：所有油耗燃油初始化
  Input:
  Output:
 ******************************************************************************/
void  Fuel_Consump_K30_Init(void)
{
    Rest_FuelCounsComprehensive_Data();
    Rest_Refueling_Data();
    Rest_FuelCounsumpTrip_Data();
    Rest_FuelCounsumpThisTime_Data();
}
/******************************************************************************
  Function：Fuel_Consump_K15_Init
  Description：所有油耗燃油初始化
  Input:
  Output:
 ******************************************************************************/
void Fuel_Consump_K15_Init(void)
{
    Rest_FuelCounsumpThisTime_Data();
}

