//ZH修改2021年8月27日16:58:42

#include "GPIO.h"
#include "Telltales.h"
#include "Telltales_user.h"
#include "CAN_Communication_Matrix.h"
#include "Flash_synchronizer.h"
#include "EOL_Para.h"
#include "Sound_Scheduler.h"
#include "SEG_DISPLAY.h"
#include "Maintenance.h"
#include "Line_in.h"
#include "IS31FL3236.h"




TelltaleLRCtrlStruct TelltaleLRCtrl;

const LED_Attribute_st LED_Attribute[LED_Max] =
{
    /*  指示灯索引                             是否自检         外部信号自检       工作电源状态       自检开始时间    自检持续时间       指示灯点亮条件                           指示灯执行函数               */
    {   em_LED_INTER_DIFF_LOCK_T          , NoSelfCheck ,     ExterNalCheck ,  LED_IGN_ON_OFF ,       0u,         3000ul,     LED_INTER_DIFF_LOCK_T_Judgement          , LED_INTER_DIFF_LOCK_T_Execution            },
    {   em_LED_FOUR_MUL_FOUR_T            , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,       0u,         3000ul,     LED_FOUR_MUL_FOUR_T_Judgement            , LED_FOUR_MUL_FOUR_T_Execution              },
    {   em_LED_EXH_BRAKE_T                , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,       0u,         3000ul,     LED_EXH_BRAKE_T_Judgement                , LED_EXH_BRAKE_T_Execution                  },
    {   em_LED_QOS_GLOW_T                 ,   SelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,       0u,         3000ul,     LED_QOS_GLOW_T_Judgement                 , LED_QOS_GLOW_T_Execution                   },
    {   em_LED_HI_BEAM_T                  , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,       0u,         3000ul,     LED_HI_BEAM_T_Judgement                  , LED_HI_BEAM_T_Execution                    },
    {   em_LED_Rr_FOG_LAMP_T              , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,       0u,         3000ul,     LED_Rr_FOG_LAMP_T_Judgement              , LED_Rr_FOG_LAMP_T_Execution                },
    {   em_LED_MIL_T                      ,   SelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,       0u,         3000ul,     LED_MIL_T_Judgement                      , LED_MIL_T_Execution                        },
    {   em_LED_SVS_T                      ,   SelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,       0u,         3000ul,     LED_SVS_T_Judgement                      , LED_SVS_T_Execution                        },
    {   em_LED_H_S_A__T                   , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,       0u,         3000ul,     LED_H_S_A_T_Judgement                    , LED_H_S_A_T_Execution                     },
    {   em_LED_RETARDER_T                 ,   SelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,       0u,         3000ul,     LED_RETARDER_T_Judgement                 , LED_RETARDER_T_Execution                   },
    {   em_LED_AUTO_LEVELING_T            , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,       0u,         3000ul,     LED_AUTO_LEVELING_T_Judgement            , LED_AUTO_LEVELING_T_Execution              },
    {   em_LED_ROWS_L                     , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,       0u,         3000ul,     LED_ROWS_L_Judgement                     , LED_ROWS_L_Execution                       },
    {   em_LED_BSM_OFF_L                  , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,       0u,         3000ul,     LED_BSM_OFF_L_Judgement                  , LED_BSM_OFF_L_Execution                    },
    {   em_LED_AEBS_OFF_L                 , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,       0u,         3000ul,     LED_AEBS_OFF_L_Judgement                 , LED_AEBS_OFF_L_Execution                   },
    {   em_LED_LDWS_L                     , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,       0u,         3000ul,     LED_LDWS_L_Judgement                     , LED_LDWS_L_Execution                       },
    {   em_LED_SRS_L                      , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,       0u,         3000ul,     LED_SRS_L_Judgement                      , LED_SRS_L_Execution                        },
    {   em_LED_ENG_OIL_L                  ,   SelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,       0u,         3000ul,     LED_ENG_OIL_L_Judgement                  , LED_ENG_OIL_L_Execution                    },
    {   em_LED_CHARG_L                    ,   SelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,       0u,         3000ul,     LED_CHARG_L_Judgement                    , LED_CHARG_L_Execution                      },
    {   em_LED_SEAT_BELT_L                ,   SelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,       0u,         3000ul,     LED_SEAT_BELT_L_Judgement                , LED_SEAT_BELT_L_Execution                  },
    {   em_LED_RR_DIFF_LOCK_L             ,   SelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,       0u,         3000ul,     LED_RR_DIFF_LOCK_L_Judgement             , LED_RR_DIFF_LOCK_L_Execution               },
    {   em_LED_TPMS_L                     , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,       0u,         3000ul,     LED_TPMS_L_Judgement                     , LED_TPMS_L_Execution                       },
    {   em_LED_ASR_or_EVSC_OFF_L          , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,       0u,         3000ul,     LED_ASR_or_EVSC_OFF_L_Judgement          , LED_ASR_or_EVSC_OFF_L_Execution            },
    {   em_LED_EVSC_L                     , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,       0u,         3000ul,     LED_EVSC_L_Judgement                     , LED_EVSC_L_Execution                       },
    {   em_LED_eco_stop_OFF_L             , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,       0u,         3000ul,     LED_eco_stop_OFF_L_Judgement             , LED_eco_stop_OFF_L_Execution               },
    {   em_LED_AMT_L                      , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,       0u,         3000ul,     LED_AMT_L_Judgement                      , LED_AMT_L_Execution                        },
    {   em_LED_WEAR_IND_L                 , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,       0u,         3000ul,     LED_WEAR_IND_L_Judgement                 , LED_WEAR_IND_L_Execution                   },
    {   em_LED_TRAILER_BRAKE_R            ,   SelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,       0u,         3000ul,     LED_TRAILER_BRAKE_R_Judgement            , LED_TRAILER_BRAKE_R_Execution              },
    {   em_LED_BRAKE_AIR_or_EBS_YELLOW_R  , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,       0u,         3000ul,     LED_BRAKE_AIR_or_EBS_YELLOW_R_Judgement  , LED_BRAKE_AIR_or_EBS_YELLOW_R_Execution    },
    {   em_LED_ACC_AIR_R                  , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,       0u,         3000ul,     LED_ACC_AIR_R_Judgement                  , LED_ACC_AIR_R_Execution                    },
    {   em_LED_ABS_R                      , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,       0u,         3000ul,     LED_ABS_R_Judgement                      , LED_ABS_R_Execution                        },
    {   em_LED_PARK_BRAKE_R               ,   SelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,       0u,         3000ul,     LED_PARK_BRAKE_R_Judgement               , LED_PARK_BRAKE_R_Execution                 },
    {   em_LED_BRAKE_AIR_or_EBS_RED_R     , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,       0u,         3000ul,     LED_BRAKE_AIR_or_EBS_RED_R_Judgement     , LED_BRAKE_AIR_or_EBS_RED_R_Execution       },
    {   em_LED_BRAKE_LOCK_R               , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,       0u,         3000ul,     LED_BRAKE_LOCK_R_Judgement               , LED_BRAKE_LOCK_R_Execution                 },
    {   em_LED_AIR_SUS_R                  ,   SelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,       0u,         3000ul,     LED_AIR_SUS_R_Judgement                  , LED_AIR_SUS_R_Execution                    },
    {   em_LED_TRAILER_ABS_U              ,   SelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,       0u,         3000ul,     LED_TRAILER_ABS_U_Judgement              , LED_TRAILER_ABS_U_Execution                },
    {   em_LED_WORKING_LAMP_U             , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,       0u,         3000ul,     LED_WORKING_LAMP_U_Judgement             , LED_WORKING_LAMP_U_Execution               },
    {   em_LED_TRAILER_ABS_INFO_U         , NoSelfCheck ,   NoExterNalCheck ,  LED_IGN_ON     ,       0u,         3000ul,     LED_TRAILER_ABS_INFO_U_Judgement         , LED_TRAILER_ABS_INFO_U_Execution           },


};

/*must put into 10ms task*/

void Telltales_Left_Right_KL30_Init(void);

void Telltales_Left_Right_KL30_Init(void)
{
    TelltaleLRCtrl.LastRight = 0u;
    TelltaleLRCtrl.LastLeft = 0u;
    TelltaleLRCtrl.Delay = 0u;
}
/*
uint8_t LED_LEFT_F = 0x00u;
uint8_t LED_RIGHT_F = 0x00u;
uint8_t LED_HI_BEAM_F = 0x00u;
uint8_t LED_PowerLimit_F = 0x00u;
uint8_t LED_MotorInvertorOverTempFault_F = 0x00u;
uint8_t LED_BrakeLightFault_F = 0x00u;
uint8_t LED_BATTERY_CHARGE_F = 0x00u;
uint8_t LED_RearFogLight_F = 0x00u;
uint8_t LED_BattMAINTENANCE_F = 0x00u;
uint8_t LED_AUTOHOLD_F = 0x00u;
uint8_t LED_HDC_F = 0x00u;
uint8_t LED_HAC_F = 0x00u;
uint8_t LED_MAINTENANCE_F = 0x00u;
uint8_t LED_SEATBELT_F = 0x00u;
*/
/******************************************************************************
  T3 L1 L2 L3 R1 R2 R3 U1 U4 U5无灯   左右转向单独 水温  燃油 气压1 气压2 在显示处做逻辑
 ******************************************************************************/

/******************************************************************************
  T0 左转向   T13 右转向
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
void Telltales_Left_Right_Management_Service(void) /*10ms*/
{
    uint8_t Edge;
    uint8_t RIGHT_ST = 0x00u;
    uint8_t LEFT_ST = 0x00u;

    RIGHT_ST = Line_In_Get_Status(LINE_IN_TURN_R);
    LEFT_ST = Line_In_Get_Status(LINE_IN_TURN_L);

    Edge = 0xffu ;

    if (LEFT_ST == 1u)//左转向
    {
        SEG_LED_TURN_LEFT(7);//左转向断码屏开
        IS31_CHIP0_CHANNEL36 = 0x3Fu;
    }
    else
    {
        SEG_LED_TURN_LEFT(0);
        IS31_CHIP0_CHANNEL36 = 0x00u;
    }
    if (TelltaleLRCtrl.LastLeft != LEFT_ST)
    {
        TelltaleLRCtrl.LastLeft = LEFT_ST;
        Edge = LEFT_ST;
    }

    if (RIGHT_ST == 1u)//右转向
    {
        SEG_LED_TURN_RIGHT(7);//右转向断码屏开
        IS31_CHIP0_CHANNEL24 = 0x3Fu;
    }
    else
    {
        SEG_LED_TURN_RIGHT(0);
        IS31_CHIP0_CHANNEL24 = 0x00u;
    }

    if (TelltaleLRCtrl.LastRight != RIGHT_ST)
    {
        TelltaleLRCtrl.LastRight = RIGHT_ST;
        Edge = RIGHT_ST;
    }

    if (TelltaleLRCtrl.Delay > 0u)
    {
        TelltaleLRCtrl.Delay--;
    }
    else
    {
        if (Edge != 0xFFu)
        {
            if (Edge)
            {
                Sound_Request(SND_TICK, 1u);
            }
            else
            {
                Sound_Request(SND_TOCK, 1u);
            }

            TelltaleLRCtrl.Delay = 10u; /*200ms内不允许重复播放声音*/
        }
        else
        {
            Sound_Delete(SND_TICK);
            Sound_Delete(SND_TOCK);
        }
    }
}

#if 0
/*************************************

测试用

**************************************/
void Test_LED_AllLight(void)
{
    LED_INTER_DIFF_LOCK_T_Execution(LED_ON_State);
    LED_FOUR_MUL_FOUR_T_Execution(LED_ON_State);
    LED_EXH_BRAKE_T_Execution(LED_ON_State);
    LED_QOS_GLOW_T_Execution(LED_ON_State);
    LED_HI_BEAM_T_Execution(LED_ON_State);
    LED_Rr_FOG_LAMP_T_Execution(LED_ON_State);
    LED_MIL_T_Execution(LED_ON_State);
    LED_SVS_T_Execution(LED_ON_State);
    LED_H_S_A__T_Execution(LED_ON_State);
    LED_RETARDER_T_Execution(LED_ON_State);
    LED_AUTO_LEVELING_T_Execution(LED_ON_State);
    LED_ROWS_L_Execution(LED_ON_State);
    LED_BSM_OFF_L_Execution(LED_ON_State);
    LED_AEBS_OFF_L_Execution(LED_ON_State);
    LED_LDWS_L_Execution(LED_ON_State);
    LED_SRS_L_Execution(LED_ON_State);
    LED_ENG_OIL_L_Execution(LED_ON_State);
    LED_CHARG_L_Execution(LED_ON_State);
    LED_SEAT_BELT_L_Execution(LED_ON_State);
    LED_RR_DIFF_LOCK_L_Execution(LED_ON_State);
    LED_TPMS_L_Execution(LED_ON_State);
    LED_ASR_or_EVSC_OFF_L_Execution(LED_ON_State);
    LED_EVSC_L_Execution(LED_ON_State);
    LED_eco_stop_OFF_L_Execution(LED_ON_State);
    LED_AMT_L_Execution(LED_ON_State);
    LED_WEAR_IND_L_Execution(LED_ON_State);
    LED_TRAILER_BRAKE_R_Execution(LED_ON_State);
    LED_BRAKE_AIR_or_EBS_YELLOW_R_Execution(LED_ON_State);
    LED_ACC_AIR_R_Execution(LED_ON_State);
    LED_ABS_R_Execution(LED_ON_State);
    LED_PARK_BRAKE_R_Execution(LED_ON_State);
    LED_BRAKE_AIR_or_EBS_RED_R_Execution(LED_ON_State);
    LED_BRAKE_LOCK_R_Execution(LED_ON_State);
    LED_AIR_SUS_R_Execution(LED_ON_State);
    LED_TRAILER_ABS_U_Execution(LED_ON_State);
    LED_WORKING_LAMP_U_Execution(LED_ON_State);
    LED_TRAILER_ABS_INFO_U_Execution(LED_ON_State);
}

#endif


/*ZH:*/

#define XXXX  0u
#define LED_BRIGHTNESS 0xff

uint8_t HYQ = 0U;

/******************************************************************************
  T1  INTER DIFF LOCK
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_INTER_DIFF_LOCK_T_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    m_Condition1 = (uint8_t)XXXX;

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}

void LED_INTER_DIFF_LOCK_T_Execution(uint8_t led_status)
{
    RR_DIFF_LOCK_MCU = led_status;

    if (led_status == 1)
    {
        SEG_LED_INTER_DIFF_LOCK_T(7);
    }
    else
    {
        SEG_LED_INTER_DIFF_LOCK_T(0);
    }
}

/******************************************************************************
  T2       指示灯不受控
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_FOUR_MUL_FOUR_T_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    m_Condition1 = (uint8_t)XXXX;

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_FOUR_MUL_FOUR_T_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL35 = LED_BRIGHTNESS;
    }
    else
    {
        IS31_CHIP0_CHANNEL35 = 0x00;
    }

    if (led_status == 1)
    {
        SEG_LED_FOUR_MUL_FOUR_T(7);
    }
    else
    {
        SEG_LED_FOUR_MUL_FOUR_T(0);
    }
}

/******************************************************************************
  T4 EXH BRAKE
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_EXH_BRAKE_T_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    m_Condition1 = (uint8_t)Get_ID_18FF2300_Sig_Exh_Lamp();

    if (m_Condition1 == 0u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_EXH_BRAKE_T_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL34 = LED_BRIGHTNESS;
    }
    else
    {
        IS31_CHIP0_CHANNEL34 = 0x00;
    }

    if (led_status == 1)
    {
        SEG_LED_EXH_BRAKE_T(7);
    }
    else
    {
        SEG_LED_EXH_BRAKE_T(0);
    }
}

/******************************************************************************
  T5 QOS(GLOW)
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_QOS_GLOW_T_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    m_Condition1 = (uint8_t)Get_ID_18FF2300_Sig_Glow_Lamp();

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_QOS_GLOW_T_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL33 = LED_BRIGHTNESS;
    }
    else
    {
        IS31_CHIP0_CHANNEL33 = 0x00;
    }

    if (led_status == 1)
    {
        SEG_LED_QOS_GLOW_T(7);
    }
    else
    {
        SEG_LED_QOS_GLOW_T(0);
    }
}
/******************************************************************************
  T6 HI BEAM
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_HI_BEAM_T_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    m_Condition1 = (uint8_t)Line_In_Get_Status(LINE_IN_HI_BEAM);

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_HI_BEAM_T_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL32 = LED_BRIGHTNESS;
    }
    else
    {
        IS31_CHIP0_CHANNEL32 = 0x00;
    }

    if (led_status == 1)
    {
        SEG_LED_HI_BEAM_T(7);
    }
    else
    {
        SEG_LED_HI_BEAM_T(0);
    }
}

/******************************************************************************
  T7 Rr FOG LAMP
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_Rr_FOG_LAMP_T_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    m_Condition1 = (uint8_t)Line_In_Get_Status(LINE_IN_Rr_FOG_LAMP);

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_Rr_FOG_LAMP_T_Execution(uint8_t led_status)
{
    T7_LED_OUT = led_status;

    if (led_status == 1)
    {
        SEG_LED_Rr_FOG_LAMP_T(7);
    }
    else
    {
        SEG_LED_Rr_FOG_LAMP_T(0);
    }
}

/******************************************************************************
  T8 MIL
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_MIL_T_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    m_Condition1 = (uint8_t)Line_In_Get_Status(LINE_IN_MIL);

    if (m_Condition1 == 1u)
    {
        u8Result = 0u;
    }
    else
    {
        u8Result = 1u;
    }

    return u8Result;
}
void LED_MIL_T_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL31 = LED_BRIGHTNESS;
    }
    else
    {
        IS31_CHIP0_CHANNEL31 = 0x00;
    }

    if (led_status == 1)
    {
        SEG_LED_MIL_T(7);
    }
    else
    {
        SEG_LED_MIL_T(0);
    }
}

/******************************************************************************
  T9 SVS
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_SVS_T_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    m_Condition1 = (uint8_t)Get_ID_18FED900_Sig_SVS_Lamp_Status();

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_SVS_T_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL30 = LED_BRIGHTNESS;
    }
    else
    {
        IS31_CHIP0_CHANNEL30 = 0x00;
    }

    if (led_status == 1)
    {
        SEG_LED_SVS_T(7);
    }
    else
    {
        SEG_LED_SVS_T(0);
    }
}

/******************************************************************************
  T10 H.S.A
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_H_S_A_T_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    m_Condition1 = (uint8_t)XXXX;

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_H_S_A_T_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL28 = LED_BRIGHTNESS; // 绿灯 亮
        IS31_CHIP0_CHANNEL29 = 0x00; // 黄灯 灭
    }
    else if (led_status == 2)
    {
        IS31_CHIP0_CHANNEL28 = 0x00; // 绿灯 灭
        IS31_CHIP0_CHANNEL29 = LED_BRIGHTNESS; // 黄灯 亮
    }
    else
    {
        IS31_CHIP0_CHANNEL28 = 0x00; // 绿灯 灭
        IS31_CHIP0_CHANNEL29 = 0x00; // 黄灯 灭
    }

    if ((led_status == 1) || (led_status == 2))
    {
        SEG_LED_H_S_A_T(7);
    }
    else
    {
        SEG_LED_H_S_A_T(0);
    }
}

/******************************************************************************
  T11 RETARDER
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_RETARDER_T_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;

    m_Condition1 = (uint8_t)Get_ID_18FF5510_Sig_Intarder_Pilot_Lamp_State();

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else if (m_Condition1 == 2u)
    {
        if (FLASH_SYNC_1Hz == 1u)
        {
            u8Result = 2u;
        }
        else
        {
            u8Result = 0u;
        }
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_RETARDER_T_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL27 = LED_BRIGHTNESS; // 绿灯 亮
        IS31_CHIP0_CHANNEL26 = 0x00; // 黄灯 灭
    }
    else if (led_status == 2)
    {
        IS31_CHIP0_CHANNEL27 = 0x00; // 绿灯 灭
        IS31_CHIP0_CHANNEL26 = LED_BRIGHTNESS; // 黄灯 亮
    }
    else
    {
        IS31_CHIP0_CHANNEL27 = 0x00; // 绿灯 灭
        IS31_CHIP0_CHANNEL26 = 0x00; // 黄灯 灭
    }

    if ((led_status == 1) || (led_status == 2))
    {
        SEG_LED_RETARDER_T(7);
    }
    else
    {
        SEG_LED_RETARDER_T(0);
    }
}

/******************************************************************************
  T12 AUTO LEVELING
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_AUTO_LEVELING_T_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    m_Condition1 = (uint8_t)XXXX;

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}

void LED_AUTO_LEVELING_T_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL25 = LED_BRIGHTNESS;
    }
    else
    {
        IS31_CHIP0_CHANNEL25 = 0x00;
    }

    if (led_status == 1)
    {
        SEG_LED_AUTO_LEVELING_T(7);
    }
    else
    {
        SEG_LED_AUTO_LEVELING_T(0);
    }
}

/******************************************************************************
  L4 ROWS
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_ROWS_L_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    m_Condition1 = (uint8_t)XXXX;

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_ROWS_L_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL01 = LED_BRIGHTNESS;
    }
    else
    {
        IS31_CHIP0_CHANNEL01 = 0x00;
    }

    if (led_status == 1)
    {
        SEG_LED_ROWS_L(7);
    }
    else
    {
        SEG_LED_ROWS_L(0);
    }
}

/******************************************************************************
  L5 BSM OFF
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_BSM_OFF_L_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    m_Condition1 = (uint8_t)XXXX;

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_BSM_OFF_L_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL02 = LED_BRIGHTNESS;
    }
    else
    {
        IS31_CHIP0_CHANNEL02 = 0x00;
    }

    if (led_status == 1)
    {
        SEG_LED_BSM_OFF_L(7);
    }
    else
    {
        SEG_LED_BSM_OFF_L(0);
    }
}

/******************************************************************************
  L6 AEBS OFF
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_AEBS_OFF_L_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    uint8_t m_Condition2 = 0u;
    uint8_t m_Condition3 = 0u;

    m_Condition1 = (uint8_t)Get_ID_CF02F2A_Sig_Advanced_Emerg_Braking_Sys_Sta();
    m_Condition2 = (uint8_t)Get_ID_CF02FA1_Sig_Advanced_Emerg_Braking_Sys_Sta();
    m_Condition3 = (uint8_t)Get_ID_CF02FA0_Sig_Advanced_Emerg_Braking_Sys_Sta();

    if ((m_Condition1 == 2u) || (m_Condition2 == 2u) || (m_Condition3 == 2u))
    {
        u8Result = 1u;
    }
    else if ((m_Condition1 == 14u) || (m_Condition2 == 14u) || (m_Condition3 == 14u))
    {
        u8Result = FLASH_SYNC_1Hz;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_AEBS_OFF_L_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL03 = LED_BRIGHTNESS;
    }
    else
    {
        IS31_CHIP0_CHANNEL03 = 0x00;
    }

    if (led_status == 1)
    {
        SEG_LED_AEBS_OFF_L(7);
    }
    else
    {
        SEG_LED_AEBS_OFF_L(0);
    }
}

/******************************************************************************
  L7 LDWS
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_LDWS_L_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    uint8_t m_Condition2 = 0u;

    m_Condition1 = (uint8_t)Get_ID_18FE5BE8_Sig_Lane_Departure_Warning_Sys_Sta();
    m_Condition2 = (uint8_t)Get_ID_18FECAE8_Sig_Amber_Warning_Lamp_Status();

    if ((m_Condition1 == 2u) || (m_Condition2 == 1u))
    {
        u8Result = 1u;
    }
    else if ((m_Condition1 == 5u) || (m_Condition1 == 14u) || (m_Condition1 == 0u))
    {
        u8Result = FLASH_SYNC_1Hz;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_LDWS_L_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL04 = LED_BRIGHTNESS;
    }
    else
    {
        IS31_CHIP0_CHANNEL04 = 0x00;
    }

    if (led_status == 1)
    {
        SEG_LED_LDWS_L(7);
    }
    else
    {
        SEG_LED_LDWS_L(0);
    }
}

/******************************************************************************
  L8 SRS
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_SRS_L_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    m_Condition1 = (uint8_t)XXXX;

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_SRS_L_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL20 = LED_BRIGHTNESS;
    }
    else
    {
        IS31_CHIP0_CHANNEL20 = 0x00;
    }

    if (led_status == 1)
    {
        SEG_LED_SRS_L(7);
    }
    else
    {
        SEG_LED_SRS_L(0);
    }
}

/******************************************************************************
  L9 ENG OIL
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_ENG_OIL_L_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    m_Condition1 = (uint8_t)Line_In_Get_Status(LINE_IN_ENG_OIL);

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_ENG_OIL_L_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL21 = LED_BRIGHTNESS;
    }
    else
    {
        IS31_CHIP0_CHANNEL21 = 0x00;
    }

    if (led_status == 1)
    {
        SEG_LED_ENG_OIL_L(7);
    }
    else
    {
        SEG_LED_ENG_OIL_L(0);
    }
}
/******************************************************************************
  L10 CHARG
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_CHARG_L_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    m_Condition1 = (uint8_t)Line_In_Get_Status(LINE_IN_CHARGE);

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_CHARG_L_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL22 = LED_BRIGHTNESS;
    }
    else
    {
        IS31_CHIP0_CHANNEL22 = 0x00;
    }

    if (led_status == 1)
    {
        SEG_LED_CHARG_L(7);
    }
    else
    {
        SEG_LED_CHARG_L(0);
    }
}

/******************************************************************************
  L11 SEAT BELT
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_SEAT_BELT_L_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    m_Condition1 = (uint8_t)Line_In_Get_Status(LINE_IN_SEAT_BELT);

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_SEAT_BELT_L_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL23 = LED_BRIGHTNESS;
    }
    else
    {
        IS31_CHIP0_CHANNEL23 = 0x00;
    }

    if (led_status == 1)
    {
        SEG_LED_SEAT_BELT_L(7);
    }
    else
    {
        SEG_LED_SEAT_BELT_L(0);
    }
}
/******************************************************************************
  L12 RR DIFF LOCK
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_RR_DIFF_LOCK_L_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    m_Condition1 = (uint8_t)Line_In_Get_Status(LINE_IN_RR_DIFF_LOCK);

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_RR_DIFF_LOCK_L_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL16 = LED_BRIGHTNESS;
    }
    else
    {
        IS31_CHIP0_CHANNEL16 = 0x00;
    }

    if (led_status == 1)
    {
        SEG_LED_RR_DIFF_LOCK_L(7);
    }
    else
    {
        SEG_LED_RR_DIFF_LOCK_L(0);
    }
}

/******************************************************************************
  L13 TPMS
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_TPMS_L_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    uint8_t m_Condition2 = 0u;
    uint8_t m_Condition3 = 0u;
    uint8_t m_Condition4 = 0u;
    uint8_t m_Condition5 = 0u;

    m_Condition1 = (uint8_t)Get_ID_18011733_Sig_Low_Presure_Alarm();
    m_Condition2 = (uint8_t)Get_ID_18011733_Sig_High_Presure_Alarm();
    m_Condition3 = (uint8_t)Get_ID_18011733_Sig_High_Temperature_Alarm();
    m_Condition4 = (uint8_t)Get_ID_18011733_Sig_No_signal_Alarm();
    m_Condition5 = (uint8_t)Get_ID_18011733_Sig_Sensor_fault_information();

    if ((m_Condition1 == 1u) || (m_Condition2 == 1u) || (m_Condition3 == 1u))
    {
        u8Result = 1u;
    }
    else if ((m_Condition4 == 1u) || (m_Condition5 == 7u) || (m_Condition5 == 8u) || (m_Condition5 == 9u))
    {
        u8Result = FLASH_SYNC_1Hz;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_TPMS_L_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL17 = LED_BRIGHTNESS;
    }
    else
    {
        IS31_CHIP0_CHANNEL17 = 0x00;
    }

    if (led_status == 1)
    {
        SEG_LED_TPMS_L(7);
    }
    else
    {
        SEG_LED_TPMS_L(0);
    }
}
/******************************************************************************
  L14 ASR/EVSC OFF
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_ASR_or_EVSC_OFF_L_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    m_Condition1 = (uint8_t)Get_ID_18F0010B_Sig_ASR_Offroad_Switch();

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_ASR_or_EVSC_OFF_L_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL18 = LED_BRIGHTNESS;
    }
    else
    {
        IS31_CHIP0_CHANNEL18 = 0x00;
    }

    if (led_status == 1)
    {
        SEG_LED_ASR_or_EVSC_OFF_L(7);
    }
    else
    {
        SEG_LED_ASR_or_EVSC_OFF_L(0);
    }
}

/******************************************************************************
  L15 EVSC
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_EVSC_L_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    uint8_t m_Condition2 = 0u;
    uint8_t m_Condition3 = 0u;
    uint8_t m_Condition4 = 0u;
    uint8_t m_Condition5 = 0u;
    uint8_t m_Condition6 = 0u;
    uint8_t m_Condition7 = 0u;

    m_Condition1 = (uint8_t)Line_In_Get_Status(LINE_IN_BRAKE_AIR_EBS);
    m_Condition2 = (uint8_t)Get_ID_18F0010B_Sig_EBS_Red_Warning_Lamp_State();
    m_Condition3 = (uint8_t)Get_ID_18F0010B_Sig_ATC_or_ASR_Lamp_State();
    m_Condition4 = (uint8_t)Get_ID_18FE4F0B_Sig_VDC_Lamp_State();
    m_Condition5 = (uint8_t)Get_ID_18FE4F0B_Sig_VDC_Fully_operational();
    //m_Condition6 = (uint8_t)Get_ID_18FE4F0B_Sig_VDC_Lamp_State();
    //m_Condition7 = (uint8_t)Get_ID_18F0010B_Sig_ASR_Offroad_Switch();

    if ((m_Condition1 == 1u) || (m_Condition2 == 1u))
    {
        u8Result = 1u;
    }
    else if (m_Condition3 == 1u)
    {
        u8Result = FLASH_SYNC_5Hz;
    }
    else if (m_Condition4 == 1u)
    {
        u8Result = FLASH_SYNC_2Hz;
    }
    else if (m_Condition5 == 1u)
    {
        u8Result = FLASH_SYNC_1Hz;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_EVSC_L_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL19 = LED_BRIGHTNESS;
    }
    else
    {
        IS31_CHIP0_CHANNEL19 = 0x00;
    }

    if (led_status == 1)
    {
        SEG_LED_EVSC_L(7);
    }
    else
    {
        SEG_LED_EVSC_L(0);
    }
}

/******************************************************************************
  L16 ECO STOP OFF
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_eco_stop_OFF_L_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    m_Condition1 = (uint8_t)XXXX;

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_eco_stop_OFF_L_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL12 = LED_BRIGHTNESS; // 绿灯 亮
        IS31_CHIP0_CHANNEL13 = 0x00; // 黄灯 灭
    }
    else if (led_status == 2)
    {
        IS31_CHIP0_CHANNEL12 = 0x00; // 绿灯 灭
        IS31_CHIP0_CHANNEL13 = LED_BRIGHTNESS; // 黄灯 亮
    }
    else
    {
        IS31_CHIP0_CHANNEL12 = 0x00; // 绿灯 灭
        IS31_CHIP0_CHANNEL13 = 0x00; // 黄灯 灭
    }


    if ((led_status == 1) || (led_status == 2))
    {
        SEG_LED_eco_stop_OFF_L(7);
    }
    else
    {
        SEG_LED_eco_stop_OFF_L(0);
    }
}

/******************************************************************************
  L17 AMT
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_AMT_L_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    uint8_t m_Condition2 = 0u;
    uint8_t m_Condition3 = 0u;
    uint8_t m_Condition4 = 0u;
    uint8_t m_Condition5 = 0u;
    uint8_t m_Condition6 = 0u;

    m_Condition1 = (uint8_t)Get_ID_18FECA03_Sig_Amber_Warning_Lamp_Status();
    m_Condition2 = (uint8_t)Get_ID_18FECA03_Sig_Malfunction_indicator_Lamp();
    m_Condition3 = (uint8_t)Get_ID_18EBFF03_Sig_Amber_Warning_Lamp_Status();
    m_Condition4 = (uint8_t)Get_ID_18EBFF03_Sig_Malfunction_indicator_Lamp();
    m_Condition5 = (uint8_t)Get_ID_18ECFF03_Sig_Amber_Warning_Lamp_Status();
    m_Condition6 = (uint8_t)Get_ID_18ECFF03_Sig_Malfunction_indicator_Lamp();

    if ((m_Condition1 == 1u) || (m_Condition2 == 1u) || (m_Condition3 == 1u) ||
            (m_Condition4 == 1u) || (m_Condition5 == 1u) || (m_Condition6 == 1u))
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_AMT_L_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL14 = LED_BRIGHTNESS;
    }
    else
    {
        IS31_CHIP0_CHANNEL14 = 0x00;
    }

    if (led_status == 1)
    {
        SEG_LED_AMT_L(7);
    }
    else
    {
        SEG_LED_AMT_L(0);
    }
}

/******************************************************************************
  L18 WEAR IND
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_WEAR_IND_L_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    m_Condition1 = (uint8_t)Line_In_Get_Status(LINE_IN_WEAR_IND);

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_WEAR_IND_L_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL15 = LED_BRIGHTNESS;
    }
    else
    {
        IS31_CHIP0_CHANNEL15 = 0x00;
    }

    if (led_status == 1)
    {
        SEG_LED_WEAR_IND_L(7);
    }
    else
    {
        SEG_LED_WEAR_IND_L(0);
    }
}

/******************************************************************************
  R4 TRAILER BRAKE
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_TRAILER_BRAKE_R_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    m_Condition1 = (uint8_t)Line_In_Get_Status(LINE_IN_TRAILER_BRAKE);

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_TRAILER_BRAKE_R_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL10 = LED_BRIGHTNESS;
    }
    else
    {
        IS31_CHIP0_CHANNEL10 = 0x00;
    }

    if (led_status == 1)
    {
        SEG_LED_TRAILER_BRAKE_R(7);
    }
    else
    {
        SEG_LED_TRAILER_BRAKE_R(0);
    }
}

/******************************************************************************
  R5 BRAKE AIR/EBS
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_BRAKE_AIR_or_EBS_YELLOW_R_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    m_Condition1 = (uint8_t)Get_ID_18F0010B_Sig_ABSorEBS_AmberWarnSt_power_veh();

    if (m_Condition1 == 1u)
    {
        u8Result = 0u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_BRAKE_AIR_or_EBS_YELLOW_R_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL09 = LED_BRIGHTNESS;
    }
    else
    {
        IS31_CHIP0_CHANNEL09 = 0x00;
    }

    if (led_status == 1)
    {
        SEG_LED_BRAKE_AIR_or_EBS_YELLOW_R(7);
    }
    else
    {
        SEG_LED_BRAKE_AIR_or_EBS_YELLOW_R(0);
    }
}

/******************************************************************************
  R6  ACC AIR
  信号接口：
  信号定义：
  输出信号： R6_LED_OUT
 ******************************************************************************/
uint8_t LED_ACC_AIR_R_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    m_Condition1 = (uint8_t)Line_In_Get_Status(LINE_IN_ACC_AIR);

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}

void LED_ACC_AIR_R_Execution(uint8_t led_status)
{
    R6_LED_OUT = led_status;

    if (led_status == 1)
    {
        SEG_LED_ACC_AIR_R(7);
    }
    else
    {
        SEG_LED_ACC_AIR_R(0);
    }
}
/******************************************************************************
  R7 ABS
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_ABS_R_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    uint8_t m_Condition2 = 0u;

    m_Condition1 = (uint8_t)Line_In_Get_Status(LINE_IN_ABS);
    m_Condition2 = (uint8_t)Get_ID_18F0010B_Sig_ABSorEBS_AmberWarnSt_power_veh();

    if ((m_Condition1 == 1u) || (m_Condition2 == 1u))
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_ABS_R_Execution(uint8_t led_status)
{
    ABS_LED_MCU_OUT = led_status;

    if (led_status == 1)
    {
        SEG_LED_ABS_R(7);
    }
    else
    {
        SEG_LED_ABS_R(0);
    }
}

/******************************************************************************
 R8 PARK BRAKE
 信号接口：
 信号定义：
 输出信号：
******************************************************************************/
uint8_t LED_PARK_BRAKE_R_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    m_Condition1 = (uint8_t)Line_In_Get_Status(LINE_IN_PARK_BRAKE);

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_PARK_BRAKE_R_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL08 = LED_BRIGHTNESS;
    }
    else
    {
        IS31_CHIP0_CHANNEL08 = 0x00;
    }

    if (led_status == 1)
    {
        SEG_LED_PARK_BRAKE_R(7);
    }
    else
    {
        SEG_LED_PARK_BRAKE_R(0);
    }
}

/******************************************************************************
  R9 BRAKE AIR/EBS
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_BRAKE_AIR_or_EBS_RED_R_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    uint8_t m_Condition2 = 0u;
    uint8_t m_Condition3 = 0u;

    m_Condition1 = (uint8_t)Line_In_Get_Status(LINE_IN_BRAKE_AIR_EBS);
    m_Condition2 = (uint8_t)Get_ID_18F0010B_Sig_ABS_Fully_Operational();
    m_Condition3 = (uint8_t)Get_ID_18F0010B_Sig_EBS_Red_Warning_Lamp_State();

    if ((m_Condition1 == 1u) || (m_Condition2 == 0u) || (m_Condition3 == 1u))
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_BRAKE_AIR_or_EBS_RED_R_Execution(uint8_t led_status)
{
    BRAKE_AIR_EBS_LED_MCU = led_status;

    if (led_status == 1)
    {
        SEG_LED_BRAKE_AIR_or_EBS_RED_R(7);
    }
    else
    {
        SEG_LED_BRAKE_AIR_or_EBS_RED_R(0);
    }
}

/******************************************************************************
  R10 BRAKE LOCK
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_BRAKE_LOCK_R_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    m_Condition1 = (uint8_t)XXXX;

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_BRAKE_LOCK_R_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL07 = LED_BRIGHTNESS;
    }
    else
    {
        IS31_CHIP0_CHANNEL07 = 0x00;
    }

    if (led_status == 1)
    {
        SEG_LED_BRAKE_LOCK_R(7);
    }
    else
    {
        SEG_LED_BRAKE_LOCK_R(0);
    }
}

/******************************************************************************
  R11 AIR SUS
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_AIR_SUS_R_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    m_Condition1 = (uint8_t)Line_In_Get_Status(LINE_IN_AIR_SUS);

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_AIR_SUS_R_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL06 = LED_BRIGHTNESS;
    }
    else
    {
        IS31_CHIP0_CHANNEL06 = 0x00;
    }

    if (led_status == 1)
    {
        SEG_LED_AIR_SUS_R(7);
    }
    else
    {
        SEG_LED_AIR_SUS_R(0);
    }
}

/******************************************************************************
U2 TRAILER ABS
  信号接口：
  信号定义：
  输出信号：U2_LED_OUT
 ******************************************************************************/
uint8_t LED_TRAILER_ABS_U_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    m_Condition1 = (uint8_t)Line_In_Get_Status(LINE_IN_TRAILER_ABS);

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}

void LED_TRAILER_ABS_U_Execution(uint8_t led_status)
{
    //U2_LED_OUT = led_status;

    if (led_status == 1)
    {
        SEG_LED_TRAILER_ABS_U(7);
    }
    else
    {
        SEG_LED_TRAILER_ABS_U(0);
    }
}

/******************************************************************************
U3 WORKING LAMP
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_WORKING_LAMP_U_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    m_Condition1 = (uint8_t)XXXX;

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_WORKING_LAMP_U_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL11 = LED_BRIGHTNESS;
    }
    else
    {
        IS31_CHIP0_CHANNEL11 = 0x00;
    }

    if (led_status == 1)
    {
        SEG_LED_WORKING_LAMP_U(7);
    }
    else
    {
        SEG_LED_WORKING_LAMP_U(0);
    }
}

/******************************************************************************
U6 TRAILE ABS INFO
  信号接口：
  信号定义：
  输出信号：
 ******************************************************************************/
uint8_t LED_TRAILER_ABS_INFO_U_Judgement(void)
{
    uint8_t u8Result = 0u;
    uint8_t m_Condition1 = 0u;
    m_Condition1 = (uint8_t)Line_In_Get_Status(LINE_IN_TRAILER_ABS_INFO);

    if (m_Condition1 == 1u)
    {
        u8Result = 1u;
    }
    else
    {
        u8Result = 0u;
    }

    return u8Result;
}
void LED_TRAILER_ABS_INFO_U_Execution(uint8_t led_status)
{
    if (led_status == 1)
    {
        IS31_CHIP0_CHANNEL05 = LED_BRIGHTNESS;
    }
    else
    {
        IS31_CHIP0_CHANNEL05 = 0x00;
    }

    if (led_status == 1)
    {
        SEG_LED_TRAILER_ABS_INFO_U(7);
    }
    else
    {
        SEG_LED_TRAILER_ABS_INFO_U(0);
    }
}