#ifndef GUI_VC66_INCLUDE_H
#define GUI_VC66_INCLUDE_H
/*-----------------------------------------------------------------------------
说明：	2021年7月9日11:06:07 wangboyu

		包含VC66项目所有刷图功能.包含所有刷图组件头文件,上层仅调用本文件

		按组件区分,每个组件完成相关刷图逻辑，逻辑来源为 APP中 Data_XXXXXX.h

		每个组件不关注外部调用，默认被调用.需要的通用信息以接口形式处理,不用考虑上掉电这些问题，外部调用会处理.

		GUI_VC66_General.h 为通用文件,被各组件调用
		
非固定通用信息接口说明：
			  ①上电时间
			  ②下电时间
			  ③闪烁标志
			  ④菜单信息
			  ⑤多国语言接口
			  ⑥

固定通用信息接口：
			  ①.使能
			  ②.
			  ③.

接口要求：不可以传入地址，传入立即数.

每个.h文件 应该只暴露一个函数被上层使用.命名格式：Gui_Display_含义			  
			  
接口顺序及命名要求：
			  -----------------------------------------------------------------
			  首位必须为使能位 1 - 正常应用  0 - 不应用,保持上次状态
			  -----------------------------------------------------------------
			  多国语言在GUI_VC66_General.h定义,不能更改. 
			  -----------------------------------------------------------------
			  
==============================================================================*/

//=======================================================================
//================常显信息===============================================
//=======================================================================

//---------------------------------------
//尿素
#include "GUI_VC66_AC_AdBule.h"
//=======================================

//---------------------------------------
//室外温度
#include "GUI_VC66_AC_TEMP.h"
//=======================================

//---------------------------------------
//WET空气计
#include "GUI_VC66_AC_WET.h"
//=======================================

//---------------------------------------
//ADAS
#include "GUI_VC66_ADAS.h"
//=======================================

//---------------------------------------
//日期
#include "GUI_VC66_Date.h"
//=======================================

//---------------------------------------
//驾驶支持
#include "GUI_VC66_DrivingSupport.h"
//=======================================

//---------------------------------------
//大计里程
#include "GUI_VC66_ODO.h"
//=======================================

//---------------------------------------
//TRIPA
#include "GUI_VC66_TRIPA.h"
//=======================================

//---------------------------------------
//时间
#include "GUI_VC66_Time.h"
//=======================================

//---------------------------------------
//档位
#include "GUI_VC66_Gear.h"
//=======================================

//=======================================



//=======================================================================
//================通常显示转换===========================================
//=======================================================================

#include "GUI_VC66_Usually.h"


//=======================================================================
//================弹出信息===============================================
//=======================================================================

#include "GUI_VC66_Popup.h"

//=======================================================================
//================菜单===================================================
//=======================================================================

//---------------------------------------
//用户模式
#include "GUI_VC66_Menu_User.h"
//=======================================

//---------------------------------------
//经销商模式
#include "GUI_VC66_Menu_DLR.h"
//=======================================

//---------------------------------------
//工厂模式
#include "GUI_VC66_Menu_Fty.h"
//=======================================

//---------------------------------------

//=======================================

//---------------------------------------

//=======================================

//---------------------------------------

//=======================================

//---------------------------------------

//=======================================






#endif
