
#include "Menu.h"

#include "GUI.h"

#include "Services_Mileage.h"
#include "Data_FuelConsump.h"
#include "CAN_Communication_Matrix.h"

#include "Common_Interface.h"
/*-------------------------------------------------------*/

uint8_t u8MenuItemVariateData[MENU_ITEM_MAX];
uint8_t u8MenuItemVariateNum[MENU_ITEM_MAX];

/*---------------------------------------------------------------------------------------*/

#define MENU_TOTAL_NORMAL 49U
#define MENU_TOTAL_CONFIG 101U

const Menu_Item_Attribute_st_t stMenuItemAttribute[MENU_ITEM_MAX] =
{
/*------------------------------------------------------------------------------------------------(分枝)-----------------------------所在界面----------------------------------------上级菜单项---------------------------------------------序号-总数-行数-序号---(总数)-------------(方向)-----------------------(支持的按键)----确认按键跳转(界面)-----------------------------------(确认跳转后光标位置)------------返回按键跳转(界面)-----------------------------(返回跳转后光标位置)--------超时跳转(界面)-----------------------------------(超时跳转后光标位置)-----回调--------------------*/
//*******************************************************************************************
//                                 通常显示（行车信息）
//*******************************************************************************************
        /*MENU_ITEM_DRIVE_INFOR_TRIPA-------------------一一一TRIPA 平均油耗/平均车速显示画面  */ {MENU_BRANCH_NORMAL_DISPLAY      , MENU_INTF_DRIVE_INFOR                         , MENU_ITEM_MAX                                         , 0U , 7U , 7U , 0U  , 7U               , MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTERFACE_MAX                            , MENU_JUMP_FIRST           , MENU_INTERFACE_MAX                              , MENU_JUMP_FIRST           , 0U     },
        /*MENU_ITEM_DRIVE_INFOR_TRIPB-------------------一一一TRIPB 平均油耗/平均车速显示画面  */ {MENU_BRANCH_NORMAL_DISPLAY      , MENU_INTF_DRIVE_INFOR                         , MENU_ITEM_MAX                                         , 1U , 7U , 7U , 1U  , 7U               , MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTERFACE_MAX                            , MENU_JUMP_FIRST           , MENU_INTERFACE_MAX                              , MENU_JUMP_FIRST           , 0U     },
        /*MENU_ITEM_DRIVE_INFOR_VOLTMETER----------------------一一一一一一一一电压计显示画面  */ {MENU_BRANCH_NORMAL_DISPLAY      , MENU_INTF_DRIVE_INFOR                         , MENU_ITEM_MAX                                         , 2U , 7U , 7U , 2U  , 7U               , MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTERFACE_MAX                            , MENU_JUMP_FIRST           , MENU_INTERFACE_MAX                              , MENU_JUMP_FIRST           , 0U     },
        /*MENU_ITEM_DRIVE_INFOR_CALENDAR----------------------一一一一一一一日期/时钟显示画面  */ {MENU_BRANCH_NORMAL_DISPLAY      , MENU_INTF_DRIVE_INFOR                         , MENU_ITEM_MAX                                         , 3U , 7U , 7U , 3U  , 7U               , MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTERFACE_MAX                            , MENU_JUMP_FIRST           , MENU_INTERFACE_MAX                              , MENU_JUMP_FIRST           , 0U     },
        /*MENU_ITEM_DRIVE_INFOR_TIME_TABLE--------------------一一一一一计时表/油温计显示画面  */ {MENU_BRANCH_NORMAL_DISPLAY      , MENU_INTF_DRIVE_INFOR                         , MENU_ITEM_MAX                                         , 4U , 7U , 7U , 4U  , 7U               , MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTERFACE_MAX                            , MENU_JUMP_FIRST           , MENU_INTERFACE_MAX                              , MENU_JUMP_FIRST           , 0U     },
        /*MENU_ITEM_DRIVE_INFOR_DPD_ACCUMULATION------------一一一一一一一一DPD堆积量显示画面  */ {MENU_BRANCH_NORMAL_DISPLAY      , MENU_INTF_DRIVE_INFOR                         , MENU_ITEM_MAX                                         , 5U , 7U , 7U , 5U  , 7U               , MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTERFACE_MAX                            , MENU_JUMP_FIRST           , MENU_INTERFACE_MAX                              , MENU_JUMP_FIRST           , 0U     },
        /*MENU_ITEM_DRIVE_INFOR_DPD_REGENERATION------------一一一一一一一DPD再生进度显示画面  */ {MENU_BRANCH_NORMAL_DISPLAY      , MENU_INTF_DRIVE_INFOR                         , MENU_ITEM_MAX                                         , 6U , 7U , 7U , 6U  , 7U               , MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTERFACE_MAX                            , MENU_JUMP_FIRST           , MENU_INTERFACE_MAX                              , MENU_JUMP_FIRST           , 0U     },
//*******************************************************************************************
//                                   用户模式
//*******************************************************************************************
//一级菜单
        /*MENU_ITEM_LEVEL_1_DTC--------------------------------一一一一一一一一一一一故障代码  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_LEVEL_1_MENU                      , MENU_ITEM_MAX                                         , 0U , 6U , 6U , 0U  , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTERFACE_MAX                            , MENU_JUMP_FIRST           , MENU_INTERFACE_MAX                              , MENU_JUMP_FIRST           , 0U     },
        /*MENU_ITEM_LEVEL_1_MAINTENANCE_NOTICE-----------------一一一一一一一一一一一维修通知  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_LEVEL_1_MENU                      , MENU_ITEM_MAX                                         , 1U , 6U , 6U , 1U  , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTF_U_MAINTENANCE_NOTICE                     , MENU_JUMP_FIRST           , MENU_INTERFACE_MAX                            , MENU_JUMP_FIRST           , MENU_INTERFACE_MAX                              , MENU_JUMP_FIRST           , 0U     },
        /*MENU_ITEM_LEVEL_1_MAINTENANCE_NOTICE_SET-------------一一一一一一一一维修通知的设定  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_LEVEL_1_MENU                      , MENU_ITEM_MAX                                         , 2U , 6U , 6U , 2U  , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTF_U_MAINTENANCE_NOTICE_SET                 , MENU_JUMP_FIRST           , MENU_INTERFACE_MAX                            , MENU_JUMP_FIRST           , MENU_INTERFACE_MAX                              , MENU_JUMP_FIRST           , 0U     },
        /*MENU_ITEM_LEVEL_1_USER_SET---------------------------一一一一一一一一一一一用户设定  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_LEVEL_1_MENU                      , MENU_ITEM_MAX                                         , 3U , 6U , 6U , 3U  , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTF_U_USER_SET                               , MENU_JUMP_FIRST           , MENU_INTERFACE_MAX                            , MENU_JUMP_FIRST           , MENU_INTERFACE_MAX                              , MENU_JUMP_FIRST           , 0U     },
        /*MENU_ITEM_LEVEL_1_SYS_DISPLAY_MODE-------------------一一一一一一一一一系统演示模式  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_LEVEL_1_MENU                      , MENU_ITEM_MAX                                         , 4U , 6U , 6U , 4U  , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTF_U_SYS_DISPLAY_MODE                       , MENU_JUMP_FIRST           , MENU_INTERFACE_MAX                            , MENU_JUMP_FIRST           , MENU_INTERFACE_MAX                              , MENU_JUMP_FIRST           , 0U     },
        /*MENU_ITEM_LEVEL_1_TIRE_STATUS_DISPLAY----------------一一一一一一一一一轮胎状态显示  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_LEVEL_1_MENU                      , MENU_ITEM_MAX                                         , 5U , 6U , 6U , 5U  , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTF_U_TIRE_STATUS_DISPLAY                    , MENU_JUMP_FIRST           , MENU_INTERFACE_MAX                            , MENU_JUMP_FIRST           , MENU_INTERFACE_MAX                              , MENU_JUMP_FIRST           , 0U     },
         
//二级菜单---维修通知(保养通知) 
        /*MENU_ITEM_LEVEL_2_ENGINE_OIL_AND_FILTER--------------一一一一一一发动机机油和滤清器  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_MAINTENANCE_NOTICE                , MENU_ITEM_LEVEL_1_MAINTENANCE_NOTICE                  , 0U , 8U , 8U , 6U  , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTF_U_LEVEL_1_MENU                      , MENU_JUMP_LAST_POSITION   , MENU_INTF_U_LEVEL_1_MENU                        , MENU_JUMP_LAST_POSITION   , 0U     },
        /*MENU_ITEM_LEVEL_2_FUEL_FILTER------------------------一一一一一一一一一一燃油滤清器  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_MAINTENANCE_NOTICE                , MENU_ITEM_LEVEL_1_MAINTENANCE_NOTICE                  , 1U , 8U , 8U , 7U  , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTF_U_LEVEL_1_MENU                      , MENU_JUMP_LAST_POSITION   , MENU_INTF_U_LEVEL_1_MENU                        , MENU_JUMP_LAST_POSITION   , 0U     },
        /*MENU_ITEM_LEVEL_2_TRANSMISSION_OIL-------------------一一一一一一一一一一一变速箱油  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_MAINTENANCE_NOTICE                , MENU_ITEM_LEVEL_1_MAINTENANCE_NOTICE                  , 2U , 8U , 8U , 8U  , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTF_U_LEVEL_1_MENU                      , MENU_JUMP_LAST_POSITION   , MENU_INTF_U_LEVEL_1_MENU                        , MENU_JUMP_LAST_POSITION   , 0U     },
        /*MENU_ITEM_LEVEL_2_DIFFERENTIAL_OIL-------------------一一一一一一一一一一一差速器油  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_MAINTENANCE_NOTICE                , MENU_ITEM_LEVEL_1_MAINTENANCE_NOTICE                  , 3U , 8U , 8U , 9U  , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTF_U_LEVEL_1_MENU                      , MENU_JUMP_LAST_POSITION   , MENU_INTF_U_LEVEL_1_MENU                        , MENU_JUMP_LAST_POSITION   , 0U     },
        /*MENU_ITEM_LEVEL_2_AIR_DRYER_DESICCANT----------------一一一一一一一空气干燥器干燥剂  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_MAINTENANCE_NOTICE                , MENU_ITEM_LEVEL_1_MAINTENANCE_NOTICE                  , 4U , 8U , 8U , 10U , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTF_U_LEVEL_1_MENU                      , MENU_JUMP_LAST_POSITION   , MENU_INTF_U_LEVEL_1_MENU                        , MENU_JUMP_LAST_POSITION   , 0U     },
        /*MENU_ITEM_LEVEL_2_POWER_STEERING_FLUID---------------一一一一一一一一一一动力转向液  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_MAINTENANCE_NOTICE                , MENU_ITEM_LEVEL_1_MAINTENANCE_NOTICE                  , 5U , 8U , 8U , 11U , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTF_U_LEVEL_1_MENU                      , MENU_JUMP_LAST_POSITION   , MENU_INTF_U_LEVEL_1_MENU                        , MENU_JUMP_LAST_POSITION   , 0U     },
        /*MENU_ITEM_LEVEL_2_TIRE-------------------------------一一一一一一一一一一一一一轮胎  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_MAINTENANCE_NOTICE                , MENU_ITEM_LEVEL_1_MAINTENANCE_NOTICE                  , 6U , 8U , 8U , 12U , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTF_U_LEVEL_1_MENU                      , MENU_JUMP_LAST_POSITION   , MENU_INTF_U_LEVEL_1_MENU                        , MENU_JUMP_LAST_POSITION   , 0U     },
        /*MENU_ITEM_LEVEL_2_STARTER----------------------------一一一一一一一一一一一一起动机  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_MAINTENANCE_NOTICE                , MENU_ITEM_LEVEL_1_MAINTENANCE_NOTICE                  , 7U , 8U , 8U , 13U , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTF_U_LEVEL_1_MENU                      , MENU_JUMP_LAST_POSITION   , MENU_INTF_U_LEVEL_1_MENU                        , MENU_JUMP_LAST_POSITION   , 0U     },

//二级菜单---维修通知的设定(保养通知的设定)
        /*MENU_ITEM_LEVEL_2_REPLACE_ENGINE_OIL_AND_FILTER------一一一一更换发动机机油和滤清器  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_MAINTENANCE_NOTICE_SET            , MENU_ITEM_LEVEL_1_MAINTENANCE_NOTICE_SET              , 0U , 8U , 8U , 14U , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTF_U_LEVEL_1_MENU                      , MENU_JUMP_LAST_POSITION   , MENU_INTF_U_LEVEL_1_MENU                        , MENU_JUMP_LAST_POSITION   , 0U     },
        /*MENU_ITEM_LEVEL_2_REPLACE_FUEL_FILTER_REPLACE--------一一一一一一一一更换燃油滤清器  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_MAINTENANCE_NOTICE_SET            , MENU_ITEM_LEVEL_1_MAINTENANCE_NOTICE_SET              , 1U , 8U , 8U , 15U , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTF_U_LEVEL_1_MENU                      , MENU_JUMP_LAST_POSITION   , MENU_INTF_U_LEVEL_1_MENU                        , MENU_JUMP_LAST_POSITION   , 0U     },
        /*MENU_ITEM_LEVEL_2_REPLACE_TRANSMISSION_OIL-----------一一一一一一一一一更换变速箱油  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_MAINTENANCE_NOTICE_SET            , MENU_ITEM_LEVEL_1_MAINTENANCE_NOTICE_SET              , 2U , 8U , 8U , 16U , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTF_U_LEVEL_1_MENU                      , MENU_JUMP_LAST_POSITION   , MENU_INTF_U_LEVEL_1_MENU                        , MENU_JUMP_LAST_POSITION   , 0U     },
        /*MENU_ITEM_LEVEL_2_REPLACE_DIFFERENTIAL_OIL-----------一一一一一一一一一更换差速器油  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_MAINTENANCE_NOTICE_SET            , MENU_ITEM_LEVEL_1_MAINTENANCE_NOTICE_SET              , 3U , 8U , 8U , 17U , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTF_U_LEVEL_1_MENU                      , MENU_JUMP_LAST_POSITION   , MENU_INTF_U_LEVEL_1_MENU                        , MENU_JUMP_LAST_POSITION   , 0U     },
        /*MENU_ITEM_LEVEL_2_SMOOTHER_CLUTCH_OIL--------一一一一一一一一一一一SMOOTHER离合器油  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_MAINTENANCE_NOTICE_SET            , MENU_ITEM_LEVEL_1_MAINTENANCE_NOTICE_SET              , 4U , 8U , 8U , 18U , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTF_U_LEVEL_1_MENU                      , MENU_JUMP_LAST_POSITION   , MENU_INTF_U_LEVEL_1_MENU                        , MENU_JUMP_LAST_POSITION   , 0U     },
        /*MENU_ITEM_LEVEL_2_REPLACE_POWER_STEERING_FLUID-------一一一一一一一一更换动力转向液  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_MAINTENANCE_NOTICE_SET            , MENU_ITEM_LEVEL_1_MAINTENANCE_NOTICE_SET              , 5U , 8U , 8U , 19U , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTF_U_LEVEL_1_MENU                      , MENU_JUMP_LAST_POSITION   , MENU_INTF_U_LEVEL_1_MENU                        , MENU_JUMP_LAST_POSITION   , 0U     },
        /*MENU_ITEM_LEVEL_2_REPLACE_TIRE-----------------------一一一一一一一一一一一更换轮胎  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_MAINTENANCE_NOTICE_SET            , MENU_ITEM_LEVEL_1_MAINTENANCE_NOTICE_SET              , 6U , 8U , 8U , 20U , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTF_U_LEVEL_1_MENU                      , MENU_JUMP_LAST_POSITION   , MENU_INTF_U_LEVEL_1_MENU                        , MENU_JUMP_LAST_POSITION   , 0U     },
        /*MENU_ITEM_LEVEL_2_REPLACE_STARTER--------------------一一一一一一一一一一更换起动机  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_MAINTENANCE_NOTICE_SET            , MENU_ITEM_LEVEL_1_MAINTENANCE_NOTICE_SET              , 7U , 8U , 8U , 21U , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTF_U_LEVEL_1_MENU                      , MENU_JUMP_LAST_POSITION   , MENU_INTF_U_LEVEL_1_MENU                        , MENU_JUMP_LAST_POSITION   , 0U     },

//二级菜单---用户设定
        /*MENU_ITEM_LEVEL_2_SET_DATE---------------------------一一一一一一一一一一一设定日期  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_USER_SET                          , MENU_ITEM_LEVEL_1_USER_SET                            , 0U , 6U , 6U , 22U , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTF_U_SET_DATE_YEAR                          , MENU_JUMP_FIRST           , MENU_INTF_U_LEVEL_1_MENU                      , MENU_JUMP_LAST_POSITION   , MENU_INTF_U_LEVEL_1_MENU                        , MENU_JUMP_LAST_POSITION   , 0U     },
        /*MENU_ITEM_LEVEL_2_SET_TIME---------------------------一一一一一一一一一一一设定时间  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_USER_SET                          , MENU_ITEM_LEVEL_1_USER_SET                            , 1U , 6U , 6U , 23U , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTF_U_SET_TIME_HOUR                          , MENU_JUMP_FIRST           , MENU_INTF_U_LEVEL_1_MENU                      , MENU_JUMP_LAST_POSITION   , MENU_INTF_U_LEVEL_1_MENU                        , MENU_JUMP_LAST_POSITION   , 0U     },
        /*MENU_ITEM_LEVEL_2_SET_DISPLAY------------------------一一一一一一一一一一一设定显示  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_USER_SET                          , MENU_ITEM_LEVEL_1_USER_SET                            , 2U , 6U , 6U , 24U , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTF_U_SET_DISPLAY                            , MENU_JUMP_FIRST           , MENU_INTF_U_LEVEL_1_MENU                      , MENU_JUMP_LAST_POSITION   , MENU_INTF_U_LEVEL_1_MENU                        , MENU_JUMP_LAST_POSITION   , 0U     },
        /*MENU_ITEM_LEVEL_2_SET_SAVE_FUEL_DRIVE_SUGGESTION-----一一一一一一一设定节油驾驶建议  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_USER_SET                          , MENU_ITEM_LEVEL_1_USER_SET                            , 3U , 6U , 6U , 25U , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTF_U_SET_SAVE_FUEL_DRIVE_SUGGESTION         , MENU_JUMP_FIRST           , MENU_INTF_U_LEVEL_1_MENU                      , MENU_JUMP_LAST_POSITION   , MENU_INTF_U_LEVEL_1_MENU                        , MENU_JUMP_LAST_POSITION   , 0U     },
        /*MENU_ITEM_LEVEL_2_SET_VEHICLE_SPACING_ALARM_VOLUME---一一一一一一设定车间距报警音量  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_USER_SET                          , MENU_ITEM_LEVEL_1_USER_SET                            , 4U , 6U , 6U , 26U , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTF_U_SET_VEHICLE_SPACING_ALARM_VOLUME       , MENU_JUMP_FIRST           , MENU_INTF_U_LEVEL_1_MENU                      , MENU_JUMP_LAST_POSITION   , MENU_INTF_U_LEVEL_1_MENU                        , MENU_JUMP_LAST_POSITION   , 0U     },
        /*MENU_ITEM_LEVEL_2_METER_SET--------------------------一一一一一一一一一一一仪表设定  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_USER_SET                          , MENU_ITEM_LEVEL_1_USER_SET                            , 5U , 6U , 6U , 27U , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTF_U_LEVEL_1_MENU                      , MENU_JUMP_LAST_POSITION   , MENU_INTF_U_LEVEL_1_MENU                        , MENU_JUMP_LAST_POSITION   , 0U     },

//二级菜单---系统演示模式
        /*MENU_ITEM_LEVEL_2_LDWS_ALERT_DEMO---------------一一一一一一一一一一一LDWS 警报演示  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_SYS_DISPLAY_MODE                  , MENU_ITEM_LEVEL_1_SYS_DISPLAY_MODE                    , 0U , 4U , 4U , 28U , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTF_U_LEVEL_1_MENU                      , MENU_JUMP_LAST_POSITION   , MENU_INTF_U_LEVEL_1_MENU                        , MENU_JUMP_LAST_POSITION   , 0U     },
        /*MENU_ITEM_LEVEL_2_AEBS_FIRST_ALERT_DEMO---------一一一一一一一一一一AEBS第1警报演示  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_SYS_DISPLAY_MODE                  , MENU_ITEM_LEVEL_1_SYS_DISPLAY_MODE                    , 1U , 4U , 4U , 29U , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTF_U_LEVEL_1_MENU                      , MENU_JUMP_LAST_POSITION   , MENU_INTF_U_LEVEL_1_MENU                        , MENU_JUMP_LAST_POSITION   , 0U     },
        /*MENU_ITEM_LEVEL_2_AEBS_SECOND_ALERT_DEMO--------一一一一一一一一一一AEBS第2警报演示  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_SYS_DISPLAY_MODE                  , MENU_ITEM_LEVEL_1_SYS_DISPLAY_MODE                    , 2U , 4U , 4U , 30U , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTF_U_LEVEL_1_MENU                      , MENU_JUMP_LAST_POSITION   , MENU_INTF_U_LEVEL_1_MENU                        , MENU_JUMP_LAST_POSITION   , 0U     },
        /*MENU_ITEM_LEVEL_2_AEBS_FULL_BRAKING_ALERT_DEMO---一一一一一一一AEBS全力制动警报演示  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_SYS_DISPLAY_MODE                  , MENU_ITEM_LEVEL_1_SYS_DISPLAY_MODE                    , 3U , 4U , 4U , 31U , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTF_U_LEVEL_1_MENU                      , MENU_JUMP_LAST_POSITION   , MENU_INTF_U_LEVEL_1_MENU                        , MENU_JUMP_LAST_POSITION   , 0U     },

//二级菜单---轮胎状态显示
        /*MENU_ITEM_LEVEL_2_TIRE_PRESSURE----------------------一一一一一一一一一一一轮胎气压  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_TIRE_STATUS_DISPLAY               , MENU_ITEM_LEVEL_1_TIRE_STATUS_DISPLAY                 , 0U , 2U , 2U , 32U , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTF_U_LEVEL_1_MENU                      , MENU_JUMP_LAST_POSITION   , MENU_INTF_U_LEVEL_1_MENU                        , MENU_JUMP_LAST_POSITION   , 0U     },
        /*MENU_ITEM_LEVEL_2_TIRE_TEMP--------------------------一一一一一一一一一一一轮胎温度  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_TIRE_STATUS_DISPLAY               , MENU_ITEM_LEVEL_1_TIRE_STATUS_DISPLAY                 , 1U , 2U , 2U , 33U , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTF_U_LEVEL_1_MENU                      , MENU_JUMP_LAST_POSITION   , MENU_INTF_U_LEVEL_1_MENU                        , MENU_JUMP_LAST_POSITION   , 0U     },

//三级菜单---设定日期（年）
        /*MENU_ITEM_LEVEL_3_SET_DATE_YEAR----------------------一一一一一一一一一一一一设定年  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_SET_DATE_YEAR                     , MENU_ITEM_LEVEL_2_SET_DATE                            , 0U , 1U , 1U , 34U , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTF_U_SET_DATE_MONTH                         , MENU_JUMP_FIRST           , MENU_INTF_U_USER_SET                          , MENU_JUMP_FIRST           , MENU_INTF_U_USER_SET                            , MENU_JUMP_FIRST           , 0U     },

//四级菜单---设定日期（月）
        /*MENU_ITEM_LEVEL_4_SET_DATE_MONTH---------------------一一一一一一一一一一一一设定月  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_SET_DATE_MONTH                    , MENU_ITEM_LEVEL_3_SET_DATE_YEAR                       , 0U , 1U , 1U , 35U , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTF_U_SET_DATE_DATE                          , MENU_JUMP_FIRST           , MENU_INTF_U_SET_DATE_YEAR                     , MENU_JUMP_FIRST           , MENU_INTF_U_SET_DATE_YEAR                       , MENU_JUMP_FIRST           , 0U     },

//五级菜单---设定日期（日）
        /*MENU_ITEM_LEVEL_5_SET_DATE_DATE----------------------一一一一一一一一一一一一设定日  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_SET_DATE_DATE                     , MENU_ITEM_LEVEL_4_SET_DATE_MONTH                      , 0U , 1U , 1U , 36U , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTF_U_USER_SET                               , MENU_JUMP_FIRST           , MENU_INTF_U_SET_DATE_MONTH                    , MENU_JUMP_FIRST           , MENU_INTF_U_SET_DATE_MONTH                      , MENU_JUMP_FIRST           , 0U     },

//三级菜单---设定时间（小时）
        /*MENU_ITEM_LEVEL_3_SET_TIME_HOUR----------------------一一一一一一一一一一一设定小时  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_SET_TIME_HOUR                     , MENU_ITEM_LEVEL_2_SET_TIME                            , 0U , 1U , 1U , 37U , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTF_U_SET_TIME_MINUTE                        , MENU_JUMP_FIRST           , MENU_INTF_U_USER_SET                          , MENU_JUMP_LAST_POSITION   , MENU_INTF_U_USER_SET                            , MENU_JUMP_LAST_POSITION   , 0U     },

//四级菜单---设定时间（分钟）
        /*MENU_ITEM_LEVEL_4_SET_TIME_MINUTE--------------------一一一一一一一一一一一设定分钟  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_SET_TIME_MINUTE                   , MENU_ITEM_LEVEL_3_SET_TIME_HOUR                       , 0U , 1U , 1U , 38U , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTF_U_USER_SET                               , MENU_JUMP_LAST_POSITION   , MENU_INTF_U_SET_TIME_HOUR                     , MENU_JUMP_FIRST           , MENU_INTF_U_SET_TIME_HOUR                       , MENU_JUMP_FIRST           , 0U     },

//三级菜单---设定显示
        /*MENU_ITEM_LEVEL_3_TIME-------------------------------一一一一一一一一一一一一一时间  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_SET_DISPLAY                       , MENU_ITEM_LEVEL_2_SET_DISPLAY                         , 0U , 2U , 2U , 39U , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTF_U_USER_SET                          , MENU_JUMP_LAST_POSITION   , MENU_INTF_U_USER_SET                            , MENU_JUMP_LAST_POSITION   , 0U     },
        /*MENU_ITEM_LEVEL_3_DATE-------------------------------一一一一一一一一一一一一一日期  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_SET_DISPLAY                       , MENU_ITEM_LEVEL_2_SET_DISPLAY                         , 1U , 2U , 2U , 40U , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTF_U_USER_SET                          , MENU_JUMP_LAST_POSITION   , MENU_INTF_U_USER_SET                            , MENU_JUMP_LAST_POSITION   , 0U     },

//三级菜单---设定节油驾驶建议
        /*MENU_ITEM_LEVEL_3_SPEED_SETTING_HIGH_SPEED_ROAD------一一一一一一一速度设定－高速路  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_SET_SAVE_FUEL_DRIVE_SUGGESTION    , MENU_ITEM_LEVEL_2_SET_SAVE_FUEL_DRIVE_SUGGESTION      , 0U , 7U , 7U , 41U , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTF_U_USER_SET                          , MENU_JUMP_LAST_POSITION   , MENU_INTF_U_USER_SET                            , MENU_JUMP_LAST_POSITION   , 0U     },
        /*MENU_ITEM_LEVEL_3_SPEED_SETTING_GENERAL_ROAD---------一一一一一一一速度设定－一般路  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_SET_SAVE_FUEL_DRIVE_SUGGESTION    , MENU_ITEM_LEVEL_2_SET_SAVE_FUEL_DRIVE_SUGGESTION      , 1U , 7U , 7U , 42U , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTF_U_USER_SET                          , MENU_JUMP_LAST_POSITION   , MENU_INTF_U_USER_SET                            , MENU_JUMP_LAST_POSITION   , 0U     },
        /*MENU_ITEM_LEVEL_3_ENGINE_SPEED_SETTING---------------一一一一一一一一发动机转速设定  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_SET_SAVE_FUEL_DRIVE_SUGGESTION    , MENU_ITEM_LEVEL_2_SET_SAVE_FUEL_DRIVE_SUGGESTION      , 2U , 7U , 7U , 43U , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTF_U_USER_SET                          , MENU_JUMP_LAST_POSITION   , MENU_INTF_U_USER_SET                            , MENU_JUMP_LAST_POSITION   , 0U     },
        /*MENU_ITEM_LEVEL_3_RAPID_ACCELERATION_SETTING---------一一一一一一一一一一急加速设定  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_SET_SAVE_FUEL_DRIVE_SUGGESTION    , MENU_ITEM_LEVEL_2_SET_SAVE_FUEL_DRIVE_SUGGESTION      , 3U , 7U , 7U , 44U , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTF_U_USER_SET                          , MENU_JUMP_LAST_POSITION   , MENU_INTF_U_USER_SET                            , MENU_JUMP_LAST_POSITION   , 0U     },
        /*MENU_ITEM_LEVEL_3_RAPID_DECELERATION_SETTING---------一一一一一一一一一一急减速设定  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_SET_SAVE_FUEL_DRIVE_SUGGESTION    , MENU_ITEM_LEVEL_2_SET_SAVE_FUEL_DRIVE_SUGGESTION      , 4U , 7U , 7U , 45U , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTF_U_USER_SET                          , MENU_JUMP_LAST_POSITION   , MENU_INTF_U_USER_SET                            , MENU_JUMP_LAST_POSITION   , 0U     },
        /*MENU_ITEM_LEVEL_3_LONG_IDLE_SETTING------------------一一一一一一一一长时间怠速设定  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_SET_SAVE_FUEL_DRIVE_SUGGESTION    , MENU_ITEM_LEVEL_2_SET_SAVE_FUEL_DRIVE_SUGGESTION      , 5U , 7U , 7U , 46U , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTF_U_USER_SET                          , MENU_JUMP_LAST_POSITION   , MENU_INTF_U_USER_SET                            , MENU_JUMP_LAST_POSITION   , 0U     },
        /*MENU_ITEM_LEVEL_3_AUXILIARY_PARKING_RELEASE_SETTING--一一一一一一一辅助驻车解除设定  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_SET_SAVE_FUEL_DRIVE_SUGGESTION    , MENU_ITEM_LEVEL_2_SET_SAVE_FUEL_DRIVE_SUGGESTION      , 6U , 7U , 7U , 47U , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTF_U_USER_SET                          , MENU_JUMP_LAST_POSITION   , MENU_INTF_U_USER_SET                            , MENU_JUMP_LAST_POSITION   , 0U     },

//三级菜单---设定车间距报警音量
        /*MENU_ITEM_LEVEL_3_SET_VEHICLE_SPACING_ALARM_VOLUME---设定车间距报警音量（图形界面）  */ {MENU_BRANCH_USER_MODE_MENU      , MENU_INTF_U_SET_VEHICLE_SPACING_ALARM_VOLUME  , MENU_ITEM_LEVEL_2_SET_VEHICLE_SPACING_ALARM_VOLUME    , 0U , 1U , 1U , 48U , MENU_TOTAL_NORMAL, MENU_DIRECTION_LONGITUDINAL, 0XFFU       , MENU_INTERFACE_MAX                                 , MENU_JUMP_FIRST           , MENU_INTF_U_USER_SET                          , MENU_JUMP_LAST_POSITION   , MENU_INTF_U_USER_SET                            , MENU_JUMP_LAST_POSITION   , 0U     },


};


