#include "Data_CoolantTemperature.h"
#include "CAN_Communication_Matrix.h"
#include "GaugesInterface.h"
#include "GPIO.h"
//-------------------------------------------
//水温数据处理 wangboyu
//-------------------------------------------
//断码显示
//-------------------------------------------
//344 - 3.1.1.  水温计显示
//-------------------------------------------
static struct
{
    uint8_t Value ;
    uint8_t Valid ;
    uint8_t CurSeg ;
} CoolantVariable ;

static uint8_t CalCoolant_CurSeg(uint8_t Valid, uint8_t Temp);
static uint8_t CalCoolant_TarSeg(uint16_t CanMsg);
/*-------------------------------------------------------------------------
 * Function Name  : Coolant_KL30_Init
 * Description    : 水温KL30初始化
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Coolant_KL30_Init(void)
{
    CoolantVariable.Valid = 0 ;
    CoolantVariable.Value = 0 ;
    CoolantVariable.CurSeg = 0 ;

}
void Coolant_KL15_ON_Init(void)
{
    CoolantVariable.Valid = 0 ;
    CoolantVariable.Value = 0 ;
    CoolantVariable.CurSeg = 0 ;
}
void Coolant_KL15_OFF_Init(void)
{
    CoolantVariable.Valid = 0 ;
    CoolantVariable.Value = 0 ;
    CoolantVariable.CurSeg = 0 ;
}
void Coolant_Wakeup_Init(void)
{
    CoolantVariable.Valid = 0 ;
    CoolantVariable.Value = 0 ;
    CoolantVariable.CurSeg = 0 ;
}
void Coolant_Sleep_Init(void)
{
    CoolantVariable.Valid = 0 ;
    CoolantVariable.Value = 0 ;
    CoolantVariable.CurSeg = 0 ;
}
/*-------------------------------------------------------------------------
 * Function Name  : Coolant_Processing_Service
 * Description    : 水温
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
static uint8_t wbyTestSeg = 0 ;
void Coolant_Processing_Service(void)
{
    static uint8_t Timer2s = 0 ;

    uint8_t TargetSeg = 0 ;

    uint8_t Msg_CoolTemp = 0 ;

    if (CAN_MSG_Status(ID_CanMsg18FEEE00_Msg_Count) == 0x55u)
    {
        //timeout
        CoolantVariable.Valid = 0 ;
        Timer2s = 0 ;
    }
    else
    {
        Msg_CoolTemp = Get_ID_18FEEE00_Sig_Engine_Coolant_Temperature();

        if (Msg_CoolTemp > 0xFAu)
        {
            CoolantVariable.Valid = 0u ;
            TargetSeg = 0u;
        }
        else
        {
            Timer2s = 0 ;
            CoolantVariable.Valid = 1 ;
            CoolantVariable.Value = Msg_CoolTemp ;

            TargetSeg = CalCoolant_TarSeg(Msg_CoolTemp);
        }
    }

    if (Msg_CoolTemp < 40)
    {
        Msg_CoolTemp = 0 ;
    }
    else
    {
        Msg_CoolTemp -= 40 ;
    }
    //CoolantVariable.CurSeg = CalCoolant_CurSeg(CoolantVariable.Valid,Msg_CoolTemp);
    //TargetSeg - 目标段
    //CoolantVariable.Valid - 有效值
    //CoolantVariable.CurSeg - 当前段
    CoolantVariable.CurSeg = Coolant_Temp_Filter(TargetSeg, CoolantVariable.Valid);

}
/*-------------------------------------------------------------------------
 * Function Name  : CalCoolant_TarSeg
 * Description    : 根据有效报文 得到 目标格
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
static uint8_t CalCoolant_TarSeg(uint16_t CanMsg)
{
    uint8_t TargetSeg = 0 ;
    if (CanMsg >= 0x00 && CanMsg <= 0x59)
    {
        TargetSeg = 0 ;
    }
    if (CanMsg >= 0x5A && CanMsg <= 0x5E)
    {
        TargetSeg = 1 ;
    }
    if (CanMsg >= 0x5F && CanMsg <= 0x64)
    {
        TargetSeg = 2 ;
    }
    if (CanMsg >= 0x65 && CanMsg <= 0x69)
    {
        TargetSeg = 3 ;
    }
    if (CanMsg >= 0x6A && CanMsg <= 0x6F)
    {
        TargetSeg = 4 ;
    }
    if (CanMsg >= 0x70 && CanMsg <= 0x74)
    {
        TargetSeg = 5 ;
    }
    if (CanMsg >= 0x75 && CanMsg <= 0x8D)
    {
        TargetSeg = 6 ;
    }
    if (CanMsg >= 0x8E && CanMsg <= 0x8F)
    {
        TargetSeg = 7 ;
    }
    if (CanMsg >= 0x90 && CanMsg <= 0x91)
    {
        TargetSeg = 8 ;
    }
    if (CanMsg >= 0x92 && CanMsg <= 0x93)
    {
        TargetSeg = 9 ;
    }
    if (CanMsg >= 0x94 && CanMsg <= 0x95)
    {
        TargetSeg = 10 ;
    }
    if (CanMsg == 0x96)
    {
        TargetSeg = 11 ;
    }
    if (CanMsg >= 0x97)
    {
        TargetSeg = 12 ;
    }

    return TargetSeg ;
}
/*-------------------------------------------------------------------------
 * Function Name  : CalCoolant_CurSeg
 * Description    : 计算当前段
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
static uint8_t CalCoolant_CurSeg(uint8_t Valid, uint8_t Temp)
{
    uint8_t u8Result = 0u;

    if (Valid)
    {
        SetGaugesPara(TempGauges, Temp);
        u8Result = GetGaugesCurrentPos(TempGauges) ;
    }
    else
    {
        //范围外/CAN中断
        u8Result = 0 ;
    }

    return u8Result ;
}
/*-------------------------------------------------------------------------
 * Function Name  : Coolant_Get_ActualValue
 * Description    : 水温值.结果带偏移 - 40
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint8_t Coolant_Get_ActualValue(void)
{
    uint8_t u8Result = 0u;
    u8Result = CoolantVariable.Value ;
    return u8Result;
}
/*-------------------------------------------------------------------------
 * Function Name  : Coolant_Get_Valid
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint8_t Coolant_Get_Valid(void)
{
    uint8_t u8Result = 0u;
    u8Result = CoolantVariable.Valid ;
    return u8Result;
}
/*-------------------------------------------------------------------------
 * Function Name  : Coolant_Get_CurSeg
 * Description    : 水温当前段
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint8_t Coolant_Get_CurSeg(void)
{
    uint8_t u8Result = 0u;
    u8Result = CoolantVariable.CurSeg ;
    return u8Result;
}