#include "Common_Interface.h"
#include "CAN_Communication_Matrix.h"
#include "CAN_Lib.h"
#include "Data_VehicleSpeed.h"
#include "Data_EngineSpeed.h"
#include "System_Monitor.h"
#include "GaugesInterface.h"
#include "Gauges.h"
#include "dr7f701441.dvf.h"
#include "GPIO.h"

#include "Line_in.h"

#include "Maintenance.h"
#include "Menu.h"

#include "Emulated_EEPROM.h"
#include "Watchdog.h"

/*修饰变量static*/

/*ig on off时间线*/
static uint32_t PowerIgnOnTimeLine;
static uint32_t PowerIgnOffTimeLine;

static COMMON_PowerStatus_t PowerSts; /*1 ON ;  0 OFF*/
static uint16_t Act_V_Speed;          /*实际值,十倍的*/
static uint16_t Act_E_Speed;          /*实际值*/
static uint16_t Disp_V_Speed;         /*显示值,十倍的*/
static uint16_t Disp_E_Speed;         /*显示值*/

/*数据有效 1 ;数据无效 0 /0xff */
static DataValid_t PowerSts_Valid;
static DataValid_t Act_V_Speed_Valid;
static DataValid_t Act_E_Speed_Valid;
static DataValid_t Disp_V_Speed_Valid;
static DataValid_t Disp_E_Speed_Valid;

static void Common_Set_Act_V_Speed(uint16_t Val);
static void Common_Set_Act_E_Speed(uint16_t Val);
static void Common_Set_Disp_V_Speed(uint16_t Val);
static void Common_Set_Disp_E_Speed(uint16_t Val);

static void Common_Set_Act_V_Speed_Valid(DataValid_t Val);
static void Common_Set_Act_E_Speed_Valid(DataValid_t Val);
static void Common_Set_Disp_V_Speed_Valid(DataValid_t Val);
static void Common_Set_Disp_E_Speed_Valid(DataValid_t Val);

static uint16_t SysRollingCounter;
// wangboyu - begin
static uint8_t CanFirstEvent[ID_TOTAL_MAX];
static void Individual_ECU_Communication(void);
// wangboyu - end

/*菜单设置项存储EEP结构*/
//_Menu_Configure_Value Menu_Con_EEP_Value;
extern uint8_t u8MenuItemVariateNum[MENU_ITEM_MAX];
extern uint8_t u8MenuItemVariateData[MENU_ITEM_MAX];

/*每次唤醒调用*/
void Common_DataInit(void)
{
    PowerSts = COMMON_POWER_UNKNOW;
    Act_V_Speed = 0xffffu;
    Act_E_Speed = 0xffffu;
    Disp_V_Speed = 0xffffu;
    Disp_E_Speed = 0xffffu;

    PowerSts_Valid = COMMON_Valid_UNKNOW;
    Act_V_Speed_Valid = COMMON_Valid_UNKNOW;
    Act_E_Speed_Valid = COMMON_Valid_UNKNOW;
    Disp_V_Speed_Valid = COMMON_Valid_UNKNOW;
    Disp_E_Speed_Valid = COMMON_Valid_UNKNOW;
    PowerIgnOnTimeLine = 0x0ul;
    PowerIgnOffTimeLine = 0x0ul;
}

/*以下由各个处理模块按需调用*/
/*使用数据之前,需要先判断数据是否有效,如果无效,则不可以使用*/

COMMON_PowerStatus_t Common_Get_IG_Sts(void)
{
    return PowerSts;
}

uint16_t Common_Get_Act_V_Speed(void)
{
    return Act_V_Speed;
}
uint16_t Common_Get_Act_E_Speed(void)
{
    return Act_E_Speed;
}
uint16_t Common_Get_Disp_V_Speed(void)
{
    return Disp_V_Speed;
}
uint16_t Common_Get_Disp_E_Speed(void)
{
    return Disp_E_Speed;
}

/*获取超速报警状态*/
uint8_t Common_Get_OverSpeed_Status(void)
{
    uint8_t OverSpeedStatus = 0u;
    uint16_t DispVSpeed = 0u;
    DispVSpeed = Common_Get_Disp_V_Speed();

    if (DispVSpeed >= 1000u)
    {
        OverSpeedStatus = 1u;
    }
    else if (DispVSpeed <= 960u)
    {
        OverSpeedStatus = 0u;
    }

    return OverSpeedStatus;
}

static void Common_Set_IG_Sts(COMMON_PowerStatus_t Val)
{
    PowerSts = Val;
}
static void Common_Set_Act_V_Speed(uint16_t Val)
{
    Act_V_Speed = Val;
}
static void Common_Set_Act_E_Speed(uint16_t Val)
{
    Act_E_Speed = Val;
}
static void Common_Set_Disp_V_Speed(uint16_t Val)
{
    Disp_V_Speed = Val;
}
static void Common_Set_Disp_E_Speed(uint16_t Val)
{
    Disp_E_Speed = Val;
}

DataValid_t Common_Get_IG_Sts_Valid(void)
{
    return PowerSts_Valid;
}
DataValid_t Common_Get_Act_V_Speed_Valid(void)
{
    return Act_V_Speed_Valid;
}
DataValid_t Common_Get_Act_E_Speed_Valid(void)
{
    return Act_E_Speed_Valid;
}
DataValid_t Common_Get_Disp_V_Speed_Valid(void)
{
    return Disp_V_Speed_Valid;
}
DataValid_t Common_Get_Disp_E_Speed_Valid(void)
{
    return Disp_E_Speed_Valid;
}

static void Common_Set_IG_Sts_Valid(DataValid_t Val)
{
    PowerSts_Valid = Val;
}
static void Common_Set_Act_V_Speed_Valid(DataValid_t Val)
{
    Act_V_Speed_Valid = Val;
}
static void Common_Set_Act_E_Speed_Valid(DataValid_t Val)
{
    Act_E_Speed_Valid = Val;
}
static void Common_Set_Disp_V_Speed_Valid(DataValid_t Val)
{
    Disp_V_Speed_Valid = Val;
}
static void Common_Set_Disp_E_Speed_Valid(DataValid_t Val)
{
    Disp_E_Speed_Valid = Val;
}

uint16_t Common_Get_DispSpeed(void)
{
    uint16_t m_Res;
    if (Disp_V_Speed_Valid)
    {
        m_Res = (((Disp_V_Speed / 10u) * 16u) / 9u);
    }
    else
    {
        m_Res = 0x1fffu;
    }
    return m_Res;
}

/*2MS任务*/
static uint16_t wbyTest = 0;
void Common_Input_Para(void)
{
    /*    if (SYS_OPR_STAT_IGN_ON)
        {*/
    uint32_t V_Speed_Convert = 0ul;
    uint32_t u32IG_ON_Timer = 0u;
    uint16_t OilValue = 0u; /*机油压力数值*/
    uint32_t EBC2_Speed_Value = 0u;
    uint8_t LineStatus1 = 0u;
    uint8_t LineStatus2 = 0u;

    u32IG_ON_Timer = Common_GetIgnOnTime();

    if (SYS_OPR_STAT_IGN_ON)
    {
        Common_Set_IG_Sts(COMMON_POWER_ON);
        Common_Set_IG_Sts_Valid(COMMON_Valid);

        OilValue = Common_Get_Disp_E_Speed();

        //车速
        wbyTest = Speed_Get_Display_Value();
        Common_Set_Disp_V_Speed(wbyTest);
        Common_Set_Act_V_Speed(Speed_Get_ActualValue());

        if (Speed_Get_Valid())
        {
            Common_Set_Act_V_Speed_Valid(COMMON_Valid);
            Common_Set_Disp_V_Speed_Valid(COMMON_Valid);
        }
        else
        {
            Common_Set_Act_V_Speed_Valid(COMMON_InValid);
            Common_Set_Disp_V_Speed_Valid(COMMON_InValid);
        }

        Common_Set_Act_E_Speed(RevSpeedManage(Tacho_Get_ActualValue()));

        PowerIgnOffTimeLine = 0ul;
        if (PowerIgnOnTimeLine < 0x7ffffffful)
        {
            PowerIgnOnTimeLine += 2u;
        }
    }
    else
    {
        PowerIgnOnTimeLine = 0ul;
        if (PowerIgnOffTimeLine < 0x7ffffffful)
        {
            PowerIgnOffTimeLine += 2u;
        }

        Common_Set_IG_Sts(COMMON_POWER_OFF);
        Common_Set_IG_Sts_Valid(COMMON_Valid);

        /*车转真实值OFF为0*/
        Common_Set_Act_V_Speed(0u);
        Common_Set_Act_E_Speed(0u);
        Common_Set_Disp_V_Speed(0u);
        Common_Set_Disp_E_Speed(0u);
    }
}

void Set_Can18FF5510_FirstRecv_Event(void)
{
    CanFirstEvent[ID_CanMsg18FF5510_Msg_Count] = 1;
}

void Set_Can18FF2300_FirstRecv_Event(void)
{
    CanFirstEvent[ID_CanMsg18FF2300_Msg_Count] = 1;
}

uint8_t Get_CanFirstRecv_Event(uint8_t ID)
{
    return CanFirstEvent[ID];
}

void Common_RollingCounterAdd(void)
{
    SysRollingCounter++;
}

void Common_RollingCounterClear(void)
{
    SysRollingCounter = 0u;
}

uint16_t Common_ReadRollingCounter(void)
{
    return SysRollingCounter;
}

void Common_BlockDelay(uint16_t m_MS)
{
    uint16_t RocBackup;
    uint16_t Counter;
    uint16_t DIMCounter;

    DIMCounter = m_MS * 20u;
    Common_RollingCounterClear();
    RocBackup = Common_ReadRollingCounter();
    do
    {
        Counter = Common_ReadRollingCounter();

        if (Counter >= RocBackup)
        {
            Counter -= RocBackup;
        }
        else
        {
            Counter = 65535u - RocBackup + Counter + 1u;
        }

    } while (Counter < DIMCounter);
}

uint32_t Common_GetIgnOnTime(void)
{
    return PowerIgnOnTimeLine;
}

uint32_t Common_GetIgnOffTime(void)
{
    return PowerIgnOffTimeLine;
}

#pragma diag_suppress = Pm064
int32_t SEGGER_RTT_printf(uint16_t BufferIndex, const char *sFormat, ...);
int32_t SEGGER_RTT_printf(uint16_t BufferIndex, const char *sFormat, ...)
{
    return 0;
}
