#include "PowerManagement.h"
#include "System_Monitor.h"
#include "Common_Interface.h"
#include "Data_CoolantTemperature.h"
#include "Data_VehicleSpeed.h"
#include "Data_EngineSpeed.h"
#include "Service_TPMS.h"
#include "Services_Mileage.h"
#include "Data_Gear.h"
#include "Data_Time.h"
#include "AC_TEMP.h"
#include "Service_OFF_Time.h"
#include "RTE_CAN_NM.h"
#include "Telltales.h"
#include "DisplaySch.h"
#include "Line_in.h"
#include "Seg_Ref.h"
#include "Seatbelt.h"
#include "Door.h"
#include "Data_ADAS.h"
#include "Data_AdBule.h"
#include "Data_AirPressure.h"
#include "Key.h"
#include "Menu.h"
#include "Services_ODO_User.h"
#include "AvgSpeed.h"
#include "Maintenance.h"
#include "GaugesInterface.h"
#include "Popup_Scheduler.h"
#include "GPIO.h"
#include "dr7f701441.dvf.h"
#include "Sound_Scheduler.h"
#include "Sound_Player.h"
#include "RTE_PWM_OUT.h"
#include "BackLight_APP.h"
#include "Clock.h"
#include "TimerB.h"

#include "CD4051.h"
#include "GaugesInterface.h"
#include "DisplaySch_user.h"
#include "Data_FuelConsump.h"
#include "IS31FL3236.h"

#include "GUI.h"
#include "Individual_ECU_Comm.h"
#include "Data_Fuel_User.h"

#define POWER_NM_SLEEP  0U
#define POWER_NM_WAKEUP 1U



static uint8_t PowerGetNMStatus(void);


Power_Status_t Power_KL30_Init ( void )
{
    Power_Status_t u8PowerSts;
    Menu_Init_st_t pstMenuInit;

    /*电源 指示灯 硬线 通用信息部分  赵建智 维护开始*/
    ClearNoInitArea();
    Common_DataInit();
    Sys_KL30_Init();
    Line_In_KL30_Init();
    Telltales_Left_Right_KL30_Init();
    Telltales_KL30_Init();
    SEG_BUFF_Init();
    DispSch_TotalInit();
    /*电源 指示灯 硬线 通用信息部分  赵建智 维护结束*/

    /*车速 转速 水温表头 初始化 田雨 维护开始*/
    UserGaugeK30Init();
    /*车速 转速 水温表头 初始化 田雨 维护开始*/

    /*里程 大小计部分 刘明月 胡志松 辛雨 维护开始*/
    Service_OFF_Timing_KL30Init();
    Data_User_Mileage_KL30Init();
    Data_AvgSpeed_KL30_Init();
    Data_Maintenance_Service_KL30_Init();
    /*里程 大小计部分 刘明月 胡志松 辛雨 维护结束*/

    /*室外温度 胎压部分  档位 清大计 报警 对时 胡迎秋 维护开始*/
    Data_AC_Temp_KL30_Init();
    Data_TPMS_KL30_Init();
    Data_Gear_KL30_Init();
    Data_ODO_Clear_KL30Init();
    /*室外温度 胎压部分  档位 清大计 报警 对时 胡迎秋 维护结束*/

    /*安全带 车门部分  李茂军维护开始*/
    SeatbeltInit();
    Door_WakeUpInit();
    /*安全带 车门部分  李茂军维护结束*/

    /*按键部分 杨真东维护开始*/
    Key_Init();

    pstMenuInit.enMenuItemLen =  MENU_ITEM_MAX ;
    pstMenuInit.enMenuInterfaceLen =  MENU_INTERFACE_MAX ;
    pstMenuInit.enMenuBranchLen = MENU_BRANCH_MAX  ;
    pstMenuInit.u32MenuConfig = 0u ;

    Menu_Init(u8MenuRamData, stMenuItemAttribute, &pstMenuInit);

    VCC12V0_OUT_EN = 1U;        /*12V 电源使能*/
    VCC05V0_OUT_EN = 1U;        /*外设5V 电源使能*/
    D1530_EN_MCU_OUT = 1U;      /*1530 使能*/
    BL_ACC_EN = 1U;       /*8867 使能*/
    Fuel_VCC05V_OUT_EN = 1U ;   /*燃油电源 使能*/
    AIR_5V_OUT_EN = 1u;         /*气压 5V*/
    ACC5V_LED_PWM_MCU = 1u;

    IS31_Init();
    Sound_Scheduler_Init();
    Sound_Player_Init();
    RTE_PWM_Init();
    /*按键部分 杨真东维护结束*/

    ADAS_KL30_Init();
    AirPressure_KL30_Init();
    AdBule_KL30_Init();
    Individual_ECU_Comm_KL30_Init();
    /*报警调度初始化*/
    Popup_Scheduler_Init();
    /*报警调度初始化*/

    /*5s不按按键计时清零*/
    //LongTimeNoKey_Operation_TimeRest();
    BL_Init();

    /*****油耗类****/
    Fuel_Consump_K30_Init();
    Fuel_User_KL30_Init();
    u8PowerSts = m_IGN_OFF_Init;
    return  u8PowerSts;
}


void Power_Sleep_Init(void)
{
    //TimerB_PWM_Channel_Sleep(TIMERB_2_CH10);
    //TimerB_PWM_Channel_Sleep(TIMERB_1_CH10);

    VCC12V0_OUT_EN = 1U;        /*12V 电源使能*/
    VCC05V0_OUT_EN = 1U;        /*外设5V 电源使能*/
    D1530_EN_MCU_OUT = 1U;      /*1530 使能*/
    BL_ACC_EN = 1U;       /*8867 使能*/
    Fuel_VCC05V_OUT_EN = 1U ;   /*燃油电源 使能*/
    AIR_5V_OUT_EN = 1u;         /*气压 5V*/
    ACC5V_LED_PWM_MCU = 1u;

    IS31_Shutdown();

    Speed_Sleep_Init();
    Tacho_Sleep_Init();
    Coolant_Sleep_Init();

    GPIO_Init(GPIO_SLEEP_MODE );
}


Power_Status_t Power_Wakeup_Init ( void )
{
    Power_Status_t u8PowerSts;
    Menu_Init_st_t pstMenuInit;

    pstMenuInit.enMenuItemLen =  MENU_ITEM_MAX ;
    pstMenuInit.enMenuInterfaceLen =  MENU_INTERFACE_MAX ;
    pstMenuInit.enMenuBranchLen = MENU_BRANCH_MAX  ;
    pstMenuInit.u32MenuConfig = 0u ;

    Menu_Wake_Up_Init(u8MenuRamData, stMenuItemAttribute, &pstMenuInit);

    /*电源 指示灯 硬线 通用信息部分  赵建智 维护开始*/
    Common_DataInit();
    Sys_WakeUp_Init();
    Line_In_KL30_Init();
    Telltales_Left_Right_KL30_Init();
    Telltales_KL30_Init();
    SEG_BUFF_Init();
    DispSch_TotalInit();
    /*电源 指示灯 硬线 通用信息部分  赵建智 维护结束*/
    Telltales_Wakeup_Init();
    Data_Time_WakeUp_Init();
    /*车速 转速 水温表头 初始化 田雨 维护开始*/
    UserGaugeK30Init();
    /*车速 转速 水温表头 初始化 田雨 维护开始*/
    ADAS_Wakeup_Init();
    Data_User_Mileage_KL15Init();
    Maintenance_WakeUp_Init();
    /*安全带 车门部分  李茂军维护开始*/
    SeatbeltInit();
    Door_WakeUpInit();
    /*安全带 车门部分  李茂军维护结束*/
    RTE_PWM_Init();

    VCC12V0_OUT_EN = 1U;        /*12V 电源使能*/
    VCC05V0_OUT_EN = 1U;        /*外设5V 电源使能*/
    D1530_EN_MCU_OUT = 1U;      /*1530 使能*/
    BL_ACC_EN = 1U;       /*8867 使能*/
    Fuel_VCC05V_OUT_EN = 1U ;   /*燃油电源 使能*/
    AIR_5V_OUT_EN = 1u;         /*气压 5V*/
    ACC5V_LED_PWM_MCU = 1u;

    IS31_Init();
    /*报警调度初始化*/
    Popup_Scheduler_Init();
    /*报警调度初始化*/
    Sound_Scheduler_Init();
    Sound_Player_Init();
    u8PowerSts = m_IGN_OFF_Init;
    return  u8PowerSts;
}




void Power_IG_OFF_Init(void)
{
    Line_In_KL15_OFF_Init();
    Speed_KL15_OFF_Init();
    Tacho_KL15_OFF_Init();
    Coolant_KL15_OFF_Init();
    //Maintenance_KL15_OFF_Init();
    /*表头参数初始OFF下调用 added by yutian*/
    GaugesK15Init_OFF() ;/*仪表IGOFF调用*/
    /*end*/
    /*报警调度*/
    Popup_Scheduler_OFF();
    //Menu_Init_IG(0u);
    GUI_Display_KL15_OFF_Init();

}
void Power_IG_ON_Init(void)
{
    Data_ODO_Clear_KL15Init();
    Telltales_KL15_Init();
    Line_In_KL15_ON_Init();
    Coolant_KL15_ON_Init();
    Data_Time_KL15_Init();
    Data_AC_Temp_KL15_Init();
    Data_TPMS_KL15_ON_Init();
    Service_OFF_Timing_KL15Init();
    Tacho_KL15_ON_Init();
    Speed_KL15_ON_Init();
    Data_Gear_KL15_Init();
    /*表头数据处理 added by yutian*/
    UserGaugeK15Init() ;/*仪表IGON调用*/
    /*end*/


    /*5s不按按键计时清零*/
    //LongTimeNoKey_Operation_TimeRest();
    CD4051B_KL15Init();

    Fuel_Consump_K15_Init();

    GUI_Display_KL15_ON_Init();
}
Power_Status_t Power_Stay_ON(void)
{
    Power_Status_t u8PowerSts;
    uint8_t u8Condition1;
    uint8_t u8Condition2;
    uint8_t u8Condition3;
    u8Condition1 = Common_Get_IG_Sts() ;
    u8Condition2 = Common_Get_IG_Sts_Valid();
    u8Condition3 = System_FUN_KL30_Status_Get();
    if ((u8Condition1 == COMMON_POWER_ON ) && ( u8Condition2 == COMMON_Valid))
    {
        u8PowerSts = m_IGN_ON;
    }
    else
    {
        if ((u8Condition1 == COMMON_POWER_OFF ) && (u8Condition2 == COMMON_Valid))
        {
            u8PowerSts = m_IGN_OFF_Init;
        }
        else
        {
            u8PowerSts = m_IGN_ON;
        }
    }
    if (((u8Condition3 == 1u) || (u8Condition3 >= 7u)))
    {
        u8PowerSts = m_IGN_LIMIT;
    }
    return  u8PowerSts;
}

Power_Status_t Power_Stay_OFF(void)
{
    Power_Status_t u8PowerSts;
    uint8_t u8Condition1;
    uint8_t u8Condition2;
    u8Condition1 = Common_Get_IG_Sts() ;
    u8Condition2 = Common_Get_IG_Sts_Valid();

    if ((u8Condition1 == COMMON_POWER_ON ) && (u8Condition2 == COMMON_Valid))
    {
        u8PowerSts = m_IGN_ON_Init;
    }
    else
    {
        if ((u8Condition1 == COMMON_POWER_OFF ) && (u8Condition2 == COMMON_Valid))
        {
            if (PowerGetNMStatus() == POWER_NM_SLEEP)
            {
                u8PowerSts = m_IGN_Sleep_Init;
            }
            else
            {
                u8PowerSts = m_IGN_OFF;
            }
        }
        else
        {
            u8PowerSts = m_IGN_OFF;
        }
    }
    return  u8PowerSts;
}



Power_Status_t  Power_Stay_Protect(void)
{
    Power_Status_t u8PowerSts;
    u8PowerSts = m_IGN_OFF_Init;
    return  u8PowerSts;
}



Power_Status_t Power_Stay_Sleep ( void )
{
    Power_Status_t u8PowerSts;

    Sys_Enter_Sleep_Mode();




    u8PowerSts = m_IGN_OFF_Init;
    return  u8PowerSts;
}


static uint8_t PowerGetNMStatus(void)
{
    uint8_t u8NMStatus = 0U;
    NM_Mode_t m_condition;
    m_condition = RTE_CAN_NM_GetStatus();

    if (m_condition == NM_Mode_Sleep)
    {
        u8NMStatus = POWER_NM_SLEEP;
    }
    else
    {
        u8NMStatus = POWER_NM_WAKEUP;
    }




    return u8NMStatus;
}




void ClearNoInitArea(void)
{
    uint32_t  *pRam;
    uint32_t  p;
    pRam = (unsigned int*)0x3FCE4000ul;
    for (p = 0ul; p < 4096ul; p ++)
    {
        pRam[ p ] = 0ul;
    }
}
