
#include "Key.h"
#include "Menu.h"
#include "GUI.h"
#include "CD4051.h"
#include "Services_ODO_User.h"

#include "DisplaySch_user.h"
#include "DispSch.h"
#include "Sound_Scheduler.h"
#include "System_Monitor.h"
#include "RTE_ADC.h"

#include "kwp2000_service.h"
#include "CAN_Communication_Matrix.h"

#include "UDS_Common.h"
#include "SEG_DISPLAY.h"

/*----------按键具体功能执行的回调函数-----------------------*/
#pragma ghs section bss=".myNonInitArea"
Key_uint8_t u8KeyRamData[KEY_RAM_DATA_LEN];
#pragma ghs section bss=default

void Key_Operation_Enter(Key_Event_en_t enKeyEvent);
void Key_Operation_Return(Key_Event_en_t enKeyEvent);
void Key_Operation_Up(Key_Event_en_t enKeyEvent);
void Key_Operation_Down(Key_Event_en_t enKeyEvent);
void Key_Operation_Menu(Key_Event_en_t enKeyEvent);
void Key_Operation_ODOTrip(Key_Event_en_t enKeyEvent);

/*******************************UP***********************************************
  Function： Key_Operation_Up
  Description：
  Input:
  Output:
 *******************************UP***********************************************/
void Key_Operation_Up(Key_Event_en_t enKeyEvent)
{
    uint8_t CanStatus1 = 0u;
    uint16_t DispVSpeed = 0u;
    UElib_uint16_t HMI_MENU_Sta = 0u;

    HMI_Set_KEY_UP(enKeyEvent);

    HMI_MENU_Sta = Get_Cur_HMI();

    DispVSpeed = Common_Get_Disp_V_Speed();
    CanStatus1 = CAN_MSG_Status(ID_CanMsg0CF00400_Msg_Count);

    if (DispVSpeed <= DISPSPEEDNULLMAX)
    {
        /*----无车速，无报警----*/
        if (HMI_MENU_Sta != Display_Alarm)
        {
            if (enKeyEvent == KEY_EVENT_SHORT_PRESS_1)
            {
                /*主界面 一级菜单 二级菜单*/
                if (((bCurMenuIDX >= _MN_DSP_LEVEL1MENU_1) && (bCurMenuIDX <= _MN_DSP_LEVEL2_6_MENU_2)) ||
                        ((bCurMenuIDX >= _MN_DSP_LEVEL3_4_MENU_41) && (bCurMenuIDX <= _MN_DSP_LEVEL3_4_MENU_47)))
                {
                    /*系统演示模式*/
                    if ((bCurMenuIDX == _MN_DSP_LEVEL2MENU_6) && (K_Line_Set.K_Line_LID27 != 0x01u) && (K_Line_Set.K_Line_LID28 != 0x01u))
                    {
                        NextMenu(_MN_DSP_LEVEL2MENU_4);
                    }
                    /*TPMS轮胎设定*/
                    else if ((bCurMenuIDX == _MN_DSP_LEVEL2_4_MENU_6) && (K_Line_Set.K_Line_LID3E != 0x01u))
                    {
                        NextMenu(_MN_DSP_LEVEL2_4_MENU_4);
                    }
                    else
                    {
                        NextMenu(MenuOptTab[bCurMenuIDX].VK_IDX_UP);
                    }
                }
                /*系统演示模式子菜单*/
                else if ((bCurMenuIDX >= _MN_DSP_LEVEL2_5_MENU_1) && (bCurMenuIDX <= _MN_DSP_LEVEL2_5_MENU_4))
                {
                    if ((K_Line_Set.K_Line_LID27 != 0x01u) && (bCurMenuIDX == _MN_DSP_LEVEL2_5_MENU_2))
                    {
                        ; /*Do Nothing!*/
                    }
                    else
                    {
                        NextMenu(MenuOptTab[bCurMenuIDX].VK_IDX_UP);
                    }
                }
                /*背光调节*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL3_7_MENU_1)
                {
                    if (User_set_Num.User_Light1 < 16u)
                    {
                        User_set_Num.User_Light1++;
                    }
                }
                else if (bCurMenuIDX == _MN_DSP_LEVEL3_7_MENU_2)
                {
                    if (User_set_Num.User_Light2 < 16u)
                    {
                        User_set_Num.User_Light2++;
                    }
                }
                /*保养通知设定 更换机油&机油滤清器*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL3_3_MENU_1)
                {
                    if (User_set_Num.User_FDJYLQQ == (uint32_t)K_Line_Set.K_Line_LID4F * 1000u)
                    {
                        User_set_Num.User_FDJYLQQ = 0u;
                    }
                }
                /*保养通知设定 更换燃油滤清器*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL3_3_MENU_2)
                {
                    if (User_set_Num.User_RYLQQ == (uint32_t)K_Line_User_RYLQQ * 1000u)
                    {
                        User_set_Num.User_RYLQQ = 0u;
                    }
                }
                /*保养通知设定 更换变速箱油*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL3_3_MENU_3)
                {
                    if (User_set_Num.User_BSXY == (uint32_t)K_Line_Set.K_Line_LID4A * 1000u)
                    {
                        User_set_Num.User_BSXY = 0u;
                    }
                }
                /*保养通知设定 更换差速器右*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL3_3_MENU_4)
                {
                    if (User_set_Num.User_CSQY == (uint32_t)K_Line_Set.K_Line_LID4B * 1000u)
                    {
                        User_set_Num.User_CSQY = 0u;
                    }
                }
                /*保养通知设定 更换动力转向油*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL3_3_MENU_6)
                {
                    if (User_set_Num.User_DLZXY == (uint32_t)K_Line_Set.K_Line_LID4D * 1000u)
                    {
                        User_set_Num.User_DLZXY = 0u;
                    }
                }
                /*保养通知设定 轮胎换位.更换*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL3_3_MENU_7)
                {
                    if (User_set_Num.User_LT == (uint32_t)K_Line_Set.K_Line_LID4E * 1000u)
                    {
                        User_set_Num.User_LT = 0u;
                    }
                }
                /*设置日期-年*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_11)
                {
                    User_set_Num.Year++;

                    if (User_set_Num.Year > 99u)
                    {
                        User_set_Num.Year = 0u;
                    }
                }
                /*设置日期-月*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_12)
                {
                    User_set_Num.Month++;

                    if (User_set_Num.Month > 12u)
                    {
                        User_set_Num.Month = 1u;
                    }
                }
                /*设置日期-日*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_13)
                {
                    User_set_Num.Date++;

                    switch (User_set_Num.Month)
                    {
                    case 1:
                    case 3:
                    case 5:
                    case 7:
                    case 8:
                    case 10:
                    case 12:
                        if (User_set_Num.Date > 31u)
                        {
                            User_set_Num.Date = 1u;
                        }
                        break;
                    case 4:
                    case 6:
                    case 9:
                    case 11:
                        if (User_set_Num.Date > 30u)
                        {
                            User_set_Num.Date = 1u;
                        }
                        break;
                    case 2:
                        if (((User_set_Num.Year % 4u == 0u) && (User_set_Num.Year % 100 != 0u)) || (User_set_Num.Year % 400u == 0u))
                        {
                            User_set_Num.LeapYear = 1u;
                        }
                        else
                        {
                            User_set_Num.LeapYear = 0u;
                        }

                        if (User_set_Num.LeapYear)
                        {
                            if (User_set_Num.Date > 29u)
                            {
                                User_set_Num.Date = 1u;
                            }
                        }
                        else
                        {
                            if (User_set_Num.Date > 28u)
                            {
                                User_set_Num.Date = 1u;
                            }
                        }
                        break;
                    default:
                        break;
                    }
                }
                /*设置时间-时*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_21)
                {
                    User_set_Num.Hour++;

                    if (User_set_Num.Hour > 23u)
                    {
                        User_set_Num.Hour = 0u;
                    }
                }
                /*设置时间-分*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_22)
                {
                    User_set_Num.Minute++;

                    if (User_set_Num.Minute > 59u)
                    {
                        User_set_Num.Minute = 0u;
                    }
                }
                /*语言设置 ----反*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_3)
                {
                    //if (User_set_Num.User_Language > 0u)
                    //{
                    //    User_set_Num.User_Language--;
                    //}
                }
                /*胎压匹配界面*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_5)
                {
                    if (User_set_Num.User_TpmsStatus == 0)
                    {
                        User_set_Num.User_TpmsStatus = 1;
                    }
                    if ((User_set_Num.User_TpmsStatus == 1) && (User_set_Num.User_Tpms < 12))
                    {
                        User_set_Num.User_Tpms++;
                    }
                }
                /*高速路*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL4_4_MENU_1)
                {
                    if (User_set_Num.User_Gsl < 110)
                    {
                        User_set_Num.User_Gsl++;
                    }
                    else if (User_set_Num.User_Gsl == 0xFF)
                    {
                        User_set_Num.User_Gsl = 20;
                    }
                }
                /*一般路*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL4_4_MENU_2)
                {
                    if (User_set_Num.User_Ybl < 110)
                    {
                        User_set_Num.User_Ybl++;
                    }
                    else if (User_set_Num.User_Ybl == 0xFF)
                    {
                        User_set_Num.User_Ybl = 20;
                    }
                }
                /*发动机转速*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL4_4_MENU_3)
                {
                    if (User_set_Num.User_Speed < 99)
                    {
                        User_set_Num.User_Speed++;
                    }
                    else if (User_set_Num.User_Speed == 0xFF)
                    {
                        User_set_Num.User_Speed = 0;
                    }
                }
                /*急加速*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL4_4_MENU_4)
                {
                    if (User_set_Num.User_JADD < 99)
                    {
                        User_set_Num.User_JADD++;
                    }
                    else if (User_set_Num.User_JADD == 0xFF)
                    {
                        User_set_Num.User_JADD = 5;
                    }
                }
                /*急减速*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL4_4_MENU_5)
                {
                    if (User_set_Num.User_JSUB < 99)
                    {
                        User_set_Num.User_JSUB++;
                    }
                    else if (User_set_Num.User_JSUB == 0xFF)
                    {
                        User_set_Num.User_JSUB = 5;
                    }
                }
                /*长时间怠速设定*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL4_4_MENU_6)
                {
                    if (User_set_Num.User_IDLING == 0xFFu)
                    {
                        User_set_Num.User_IDLING = 0u;
                    }
                }
                /*辅助驻车解除设定*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL4_4_MENU_7)
                {
                    if (User_set_Num.User_Parking == 0xFFu)
                    {
                        User_set_Num.User_Parking = 0u;
                    }
                }
                /*工厂模式*/ /*经销商模式*/
                else if (((bCurMenuIDX >= _FAC_DSP_LEVEL1MENU_1) && (bCurMenuIDX <= _FAC_DSP_LEVEL1_3MENU_2)) ||
                         ((bCurMenuIDX >= _DEA_DSP_LEVEL1MENU_1) && (bCurMenuIDX <= _DEA_DSP_LEVEL1_3MENU_2)))
                {
                    NextMenu(MenuOptTab[bCurMenuIDX].VK_IDX_UP);
                }
                else
                {
                    ;/*Do Nothing!*/
                }
            }
            else if (enKeyEvent == KEY_EVENT_LONG_PRESS_1)
            {
                MenuFlag.Menu_Key_Time++;
                if (MenuFlag.Menu_Key_Time > 10)
                {
                    MenuFlag.Menu_Key_Time = 0;
                    /*设置日期-年*/
                    if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_11)
                    {
                        User_set_Num.Year++;

                        if (User_set_Num.Year > 99u)
                        {
                            User_set_Num.Year = 0u;
                        }
                    }
                    /*设置日期-月*/
                    else if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_12)
                    {
                        User_set_Num.Month++;

                        if (User_set_Num.Month > 12u)
                        {
                            User_set_Num.Month = 1u;
                        }
                    }
                    /*设置日期-日*/
                    else if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_13)
                    {
                        User_set_Num.Date++;

                        switch (User_set_Num.Month)
                        {
                        case 1:
                        case 3:
                        case 5:
                        case 7:
                        case 8:
                        case 10:
                        case 12:
                            if (User_set_Num.Date > 31u)
                            {
                                User_set_Num.Date = 1u;
                            }
                            break;
                        case 4:
                        case 6:
                        case 9:
                        case 11:
                            if (User_set_Num.Date > 30u)
                            {
                                User_set_Num.Date = 1u;
                            }
                            break;
                        case 2:
                            if (((User_set_Num.Year % 4u == 0u) && (User_set_Num.Year % 100 != 0u)) || (User_set_Num.Year % 400u == 0u))
                            {
                                User_set_Num.LeapYear = 1u;
                            }
                            else
                            {
                                User_set_Num.LeapYear = 0u;
                            }

                            if (User_set_Num.LeapYear)
                            {
                                if (User_set_Num.Date > 29u)
                                {
                                    User_set_Num.Date = 1u;
                                }
                            }
                            else
                            {
                                if (User_set_Num.Date > 28u)
                                {
                                    User_set_Num.Date = 1u;
                                }
                            }
                            break;
                        default:
                            break;
                        }
                    }
                    /*设置时间-时*/
                    else if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_21)
                    {
                        User_set_Num.Hour++;

                        if (User_set_Num.Hour > 23u)
                        {
                            User_set_Num.Hour = 0u;
                        }
                    }
                    /*设置时间-分*/
                    else if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_22)
                    {
                        User_set_Num.Minute++;

                        if (User_set_Num.Minute > 59u)
                        {
                            User_set_Num.Minute = 0u;
                        }
                    }
                }
            }
        }
        /*----无车速，有报警----*/
        else
        {
            if (enKeyEvent == KEY_EVENT_SHORT_PRESS_1)
            {
                ; /*D0 Nothing!*/
            }
            else if (enKeyEvent == KEY_EVENT_LONG_PRESS_1)
            {
                ; /*D0 Nothing!*/
            }
        }
    }
    else
    {
        /*----有车速，无报警----*/
        if (HMI_MENU_Sta != Display_Alarm)
        {
            if (enKeyEvent == KEY_EVENT_SHORT_PRESS_1)
            {
                /*工厂模式*/ /*经销商模式*/
                if (((bCurMenuIDX >= _FAC_DSP_LEVEL1MENU_1) && (bCurMenuIDX <= _FAC_DSP_LEVEL1_3MENU_2)) ||
                        ((bCurMenuIDX >= _DEA_DSP_LEVEL1MENU_1) && (bCurMenuIDX <= _DEA_DSP_LEVEL1_3MENU_2)))
                {
                    NextMenu(MenuOptTab[bCurMenuIDX].VK_IDX_UP);
                }
                /*主界面 一级菜单 二级菜单那*/
                else if (((bCurMenuIDX >= _MN_DSP_LEVEL1MENU_1) && (bCurMenuIDX <= _MN_DSP_LEVEL1MENU_6)) ||
                         ((bCurMenuIDX >= _MN_DSP_LEVEL3_4_MENU_41) && (bCurMenuIDX <= _MN_DSP_LEVEL3_4_MENU_47)))
                {
                    /*系统演示模式*/
                    if ((bCurMenuIDX == _MN_DSP_LEVEL2MENU_6) && (K_Line_Set.K_Line_LID27 != 0x01u) && (K_Line_Set.K_Line_LID28 != 0x01u))
                    {
                        NextMenu(_MN_DSP_LEVEL2MENU_4);
                    }
                    else
                    {
                        NextMenu(MenuOptTab[bCurMenuIDX].VK_IDX_UP);
                    }
                }
                else
                {
                    ;/*Do Nothing!*/
                }
            }
            else if (enKeyEvent == KEY_EVENT_LONG_PRESS_1)
            {
                ; /*D0 Nothing!*/
            }
        }
        /*----有车速，有报警----*/
        else
        {
            if (enKeyEvent == KEY_EVENT_SHORT_PRESS_1)
            {
                ; /*D0 Nothing!*/
            }
            else if (enKeyEvent == KEY_EVENT_LONG_PRESS_1)
            {
                ; /*D0 Nothing!*/
            }
        }
    }
}

/*******************************DOWN***********************************************
  Function： Key_Operation_Down
  Description：
  Input:
  Output:
 *******************************DOWN***********************************************/
void Key_Operation_Down(Key_Event_en_t enKeyEvent)
{
    uint16_t DispVSpeed = 0u;
    UElib_uint16_t HMI_MENU_Sta = 0u;

    HMI_Set_KEY_DOWN(enKeyEvent);

    HMI_MENU_Sta = Get_Cur_HMI();
    DispVSpeed = Common_Get_Disp_V_Speed();

    if (DispVSpeed <= DISPSPEEDNULLMAX)
    {
        /*----无车速，无报警----*/
        if (HMI_MENU_Sta != Display_Alarm)
        {
            if (enKeyEvent == KEY_EVENT_SHORT_PRESS_1)
            {
                /*主界面 一级菜单 二级菜单*/
                if (((bCurMenuIDX >= _MN_DSP_LEVEL1MENU_1) && (bCurMenuIDX <= _MN_DSP_LEVEL2_6_MENU_2)) ||
                        ((bCurMenuIDX >= _MN_DSP_LEVEL3_4_MENU_41) && (bCurMenuIDX <= _MN_DSP_LEVEL3_4_MENU_47)))
                {
                    /*系统演示模式*/
                    if ((bCurMenuIDX == _MN_DSP_LEVEL2MENU_4) && (K_Line_Set.K_Line_LID27 != 0x01u) && (K_Line_Set.K_Line_LID28 != 0x01u))
                    {
                        if (K_Line_Set.K_Line_LID3E == 0x01u)
                        {
                            NextMenu(_MN_DSP_LEVEL2MENU_6);
                        }
                        else
                        {
                            ;/*Do Notingh!*/
                        }
                    }
                    /*轮胎状态显示*/
                    else if ((bCurMenuIDX == _MN_DSP_LEVEL2MENU_5) && (K_Line_Set.K_Line_LID3E != 0x01u))
                    {
                        ;/*Do Notingh!*/
                    }
                    /*TPMS轮胎设定*/
                    else if ((bCurMenuIDX == _MN_DSP_LEVEL2_4_MENU_4) && (K_Line_Set.K_Line_LID3E != 0x01u))
                    {
                        NextMenu(_MN_DSP_LEVEL2_4_MENU_6);
                    }
                    else
                    {
                        NextMenu(MenuOptTab[bCurMenuIDX].VK_IDX_DOWN);
                    }
                }
                /*系统演示模式子菜单*/
                else if ((bCurMenuIDX >= _MN_DSP_LEVEL2_5_MENU_1) && (bCurMenuIDX <= _MN_DSP_LEVEL2_5_MENU_4))
                {
                    if ((K_Line_Set.K_Line_LID28 != 0x01u) && (bCurMenuIDX == _MN_DSP_LEVEL2_5_MENU_1))
                    {
                        ; /*Do Nothing!*/
                    }
                    else
                    {
                        NextMenu(MenuOptTab[bCurMenuIDX].VK_IDX_DOWN);
                    }
                }
                /*背光调节*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL3_7_MENU_1)
                {
                    if (User_set_Num.User_Light1 > 1u)
                    {
                        User_set_Num.User_Light1--;
                    }
                }
                else if (bCurMenuIDX == _MN_DSP_LEVEL3_7_MENU_2)
                {
                    if (User_set_Num.User_Light2 > 1u)
                    {
                        User_set_Num.User_Light2--;
                    }
                }
                /*保养通知设定 更换机油&机油滤清器*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL3_3_MENU_1)
                {
                    if (User_set_Num.User_FDJYLQQ == 0u)
                    {
                        User_set_Num.User_FDJYLQQ = (uint32_t)K_Line_Set.K_Line_LID4F * 1000u;
                    }
                }
                /*保养通知设定 更换燃油滤清器*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL3_3_MENU_2)
                {
                    if (User_set_Num.User_RYLQQ == 0u)
                    {
                        User_set_Num.User_RYLQQ = (uint32_t)K_Line_User_RYLQQ * 1000u;
                    }
                }
                /*保养通知设定 更换变速箱油*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL3_3_MENU_3)
                {
                    if (User_set_Num.User_BSXY == 0u)
                    {
                        User_set_Num.User_BSXY = (uint32_t)K_Line_Set.K_Line_LID4A * 1000u;
                    }
                }
                /*保养通知设定 更换差速器油*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL3_3_MENU_4)
                {
                    if (User_set_Num.User_CSQY == 0u)
                    {
                        User_set_Num.User_CSQY = (uint32_t)K_Line_Set.K_Line_LID4B * 1000u;
                    }
                }
                /*保养通知设定 更换动力转向液*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL3_3_MENU_6)
                {
                    if (User_set_Num.User_DLZXY == 0u)
                    {
                        User_set_Num.User_DLZXY = (uint32_t)K_Line_Set.K_Line_LID4D * 1000u;
                    }
                }
                /*保养通知设定 轮胎换位.更换*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL3_3_MENU_7)
                {
                    if (User_set_Num.User_LT == 0u)
                    {
                        User_set_Num.User_LT = (uint32_t)K_Line_Set.K_Line_LID4E * 1000u;
                    }
                }
                /*设置日期-年*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_11)
                {
                    if (User_set_Num.Year > 0u)
                    {
                        User_set_Num.Year--;
                    }
                    else
                    {
                        User_set_Num.Year = 99u;
                    }
                }
                /*设置日期-月*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_12)
                {
                    if (User_set_Num.Month > 1u)
                    {
                        User_set_Num.Month--;
                    }
                    else
                    {
                        User_set_Num.Month = 12u;
                    }
                }
                /*设置日期-日*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_13)
                {
                    User_set_Num.Date--;
                    switch (User_set_Num.Month)
                    {
                    case 1:
                    case 3:
                    case 5:
                    case 7:
                    case 8:
                    case 10:
                    case 12:
                        if (User_set_Num.Date < 1u)
                        {
                            User_set_Num.Date = 31u;
                        }
                        break;
                    case 4:
                    case 6:
                    case 9:
                    case 11:
                        if (User_set_Num.Date < 1u)
                        {
                            User_set_Num.Date = 30u;
                        }
                        break;
                    case 2:
                        if (((User_set_Num.Year % 4u == 0u) && (User_set_Num.Year % 100u != 0u)) || (User_set_Num.Year % 400u == 0u))
                        {
                            User_set_Num.LeapYear = 1u;
                        }
                        else
                        {
                            User_set_Num.LeapYear = 0u;
                        }

                        if (User_set_Num.LeapYear)
                        {
                            if (User_set_Num.Date < 1u)
                            {
                                User_set_Num.Date = 29u;
                            }
                        }
                        else
                        {
                            if (User_set_Num.Date < 1u)
                            {
                                User_set_Num.Date = 28u;
                            }
                        }
                        break;
                    default:
                        break;
                    }
                }
                /*设置时间-时*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_21)
                {
                    if (User_set_Num.Hour > 0u)
                    {
                        User_set_Num.Hour--;
                    }
                    else
                    {
                        User_set_Num.Hour = 23u;
                    }
                }
                /*设置时间-分*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_22)
                {
                    if (User_set_Num.Minute > 0u)
                    {
                        User_set_Num.Minute--;
                    }
                    else
                    {
                        User_set_Num.Minute = 59u;
                    }
                }
                /*语言设置 ----反*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_3)
                {
                    //if (User_set_Num.User_Language < 1)
                    //    User_set_Num.User_Language++;
                }
                /*胎压匹配界面*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_5)
                {
                    /*if(User_set_Num.User_TpmsStatus == 0)
                    {
                      if(User_set_Num.User_Par_Temp == 0)
                        User_set_Num.User_Par_Temp = 1;
                      else
                        User_set_Num.User_Par_Temp = 0;
                    }
                    else */
                    if ((User_set_Num.User_TpmsStatus == 1) && (User_set_Num.User_Tpms > 1))
                        User_set_Num.User_Tpms--;
                }
                /*高速路*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL4_4_MENU_1)
                {
                    if ((User_set_Num.User_Gsl > 20) && (User_set_Num.User_Gsl <= 110))
                    {
                        User_set_Num.User_Gsl--;
                    }
                    else
                    {
                        User_set_Num.User_Gsl = 0xFF;
                    }
                }
                /*一般路*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL4_4_MENU_2)
                {
                    if ((User_set_Num.User_Ybl > 20) && (User_set_Num.User_Ybl <= 110))
                    {
                        User_set_Num.User_Ybl--;
                    }
                    else
                    {
                        User_set_Num.User_Ybl = 0xFF;
                    }
                }
                /*发动机转速*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL4_4_MENU_3)
                {
                    if ((User_set_Num.User_Speed >= 0) && (User_set_Num.User_Speed <= 99))
                    {
                        User_set_Num.User_Speed--;
                    }
                }
                /*急加速*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL4_4_MENU_4)
                {
                    if ((User_set_Num.User_JADD > 5) && (User_set_Num.User_JADD <= 99))
                    {
                        User_set_Num.User_JADD--;
                    }
                    else
                    {
                        User_set_Num.User_JADD = 0xFF;
                    }
                }
                /*急减速*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL4_4_MENU_5)
                {
                    if ((User_set_Num.User_JSUB > 5) && (User_set_Num.User_JSUB <= 99))
                    {
                        User_set_Num.User_JSUB--;
                    }
                    else
                    {
                        User_set_Num.User_JSUB = 0xFF;
                    }
                }
                /*长时间怠速*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL4_4_MENU_6)
                {
                    if (User_set_Num.User_IDLING == 0u)
                    {
                        User_set_Num.User_IDLING = 0xFFu;
                    }
                }
                /*辅助驻车解除*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL4_4_MENU_7)
                {
                    if (User_set_Num.User_Parking == 0u)
                    {
                        User_set_Num.User_Parking = 0xFFu;
                    }
                }
                /*工厂模式*/ /*经销商模式*/
                else if (((bCurMenuIDX >= _FAC_DSP_LEVEL1MENU_1) && (bCurMenuIDX <= _FAC_DSP_LEVEL1_3MENU_2)) ||
                         ((bCurMenuIDX >= _DEA_DSP_LEVEL1MENU_1) && (bCurMenuIDX <= _DEA_DSP_LEVEL1_3MENU_2)))
                {
                    NextMenu(MenuOptTab[bCurMenuIDX].VK_IDX_DOWN);
                }
                else
                {
                    ;/*Do Nothing!*/
                }
            }
            else if (enKeyEvent == KEY_EVENT_LONG_PRESS_1)
            {
                MenuFlag.Menu_Key_Time++;
                if (MenuFlag.Menu_Key_Time > 10)
                {
                    MenuFlag.Menu_Key_Time = 0;
                    /*设置日期-年*/
                    if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_11)
                    {
                        if (User_set_Num.Year > 0u)
                        {
                            User_set_Num.Year--;
                        }
                        else
                        {
                            User_set_Num.Year = 99u;
                        }
                    }
                    /*设置日期-月*/
                    else if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_12)
                    {
                        if (User_set_Num.Month > 1u)
                        {
                            User_set_Num.Month--;
                        }
                        else
                        {
                            User_set_Num.Month = 12u;
                        }
                    }
                    /*设置日期-日*/
                    else if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_13)
                    {
                        User_set_Num.Date--;
                        switch (User_set_Num.Month)
                        {
                        case 1:
                        case 3:
                        case 5:
                        case 7:
                        case 8:
                        case 10:
                        case 12:
                            if (User_set_Num.Date < 1u)
                            {
                                User_set_Num.Date = 31u;
                            }
                            break;
                        case 4:
                        case 6:
                        case 9:
                        case 11:
                            if (User_set_Num.Date < 1u)
                            {
                                User_set_Num.Date = 30u;
                            }
                            break;
                        case 2:
                            if (((User_set_Num.Year % 4u == 0u) && (User_set_Num.Year % 100u != 0u)) || (User_set_Num.Year % 400u == 0u))
                            {
                                User_set_Num.LeapYear = 1u;
                            }
                            else
                            {
                                User_set_Num.LeapYear = 0u;
                            }

                            if (User_set_Num.LeapYear)
                            {
                                if (User_set_Num.Date < 1u)
                                {
                                    User_set_Num.Date = 29u;
                                }
                            }
                            else
                            {
                                if (User_set_Num.Date < 1u)
                                {
                                    User_set_Num.Date = 28u;
                                }
                            }
                            break;
                        default:
                            break;
                        }
                    }
                    /*设置时间-时*/
                    else if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_21)
                    {
                        if (User_set_Num.Hour > 0u)
                        {
                            User_set_Num.Hour--;
                        }
                        else
                        {
                            User_set_Num.Hour = 23u;
                        }
                    }
                    /*设置时间-分*/
                    else if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_22)
                    {
                        if (User_set_Num.Minute > 0u)
                        {
                            User_set_Num.Minute--;
                        }
                        else
                        {
                            User_set_Num.Minute = 59u;
                        }
                    }
                }
            }
        }
        else
        {
            /*----无车速，有报警----*/
            if (enKeyEvent == KEY_EVENT_SHORT_PRESS_1)
            {
                ; /*D0 Nothing!*/
            }
            else if (enKeyEvent == KEY_EVENT_LONG_PRESS_1)
            {
                ; /*D0 Nothing!*/
            }
        }
    }
    else
    {
        /*----有车速，无报警----*/
        if (HMI_MENU_Sta != Display_Alarm)
        {
            if (enKeyEvent == KEY_EVENT_SHORT_PRESS_1)
            {
                /*工厂模式*/ /*经销商模式*/
                if (((bCurMenuIDX >= _FAC_DSP_LEVEL1MENU_1) && (bCurMenuIDX <= _FAC_DSP_LEVEL1_3MENU_2)) ||
                        ((bCurMenuIDX >= _DEA_DSP_LEVEL1MENU_1) && (bCurMenuIDX <= _DEA_DSP_LEVEL1_3MENU_2)))
                {
                    NextMenu(MenuOptTab[bCurMenuIDX].VK_IDX_DOWN);
                }
                /*主界面 一级菜单 二级菜单*/
                else if (((bCurMenuIDX >= _MN_DSP_LEVEL1MENU_1) && (bCurMenuIDX <= _MN_DSP_LEVEL1MENU_6)) ||
                         ((bCurMenuIDX >= _MN_DSP_LEVEL3_4_MENU_41) && (bCurMenuIDX <= _MN_DSP_LEVEL3_4_MENU_47)))
                {
                    /*系统演示模式*/
                    if ((bCurMenuIDX == _MN_DSP_LEVEL2MENU_4) && (K_Line_Set.K_Line_LID27 != 0x01u) && (K_Line_Set.K_Line_LID28 != 0x01u))
                    {
                        NextMenu(_MN_DSP_LEVEL2MENU_6);
                    }
                    else
                    {
                        NextMenu(MenuOptTab[bCurMenuIDX].VK_IDX_DOWN);
                    }
                }
                else
                {
                    ;/*Do Nothing!*/
                }
            }
            else if (enKeyEvent == KEY_EVENT_LONG_PRESS_1)
            {
                ; /*D0 Nothing!*/
            }
        }
        /*----有车速，有报警----*/
        else
        {
            if (enKeyEvent == KEY_EVENT_SHORT_PRESS_1)
            {
                ; /*D0 Nothing!*/
            }
            else if (enKeyEvent == KEY_EVENT_LONG_PRESS_1)
            {
                ; /*D0 Nothing!*/
            }
        }
    }
}
/*******************************ENTER***********************************************
  Function： Key_Operation_Enter
  Description：
  Input:
  Output:
 *******************************ENTER***********************************************/
void Key_Operation_Enter(Key_Event_en_t enKeyEvent)
{
    uint16_t DispVSpeed = 0u;
    UElib_uint16_t HMI_MENU_Sta = 0u;

    HMI_Set_KEY_CONFIRM(enKeyEvent);

    HMI_MENU_Sta = Get_Cur_HMI();
    DispVSpeed = Common_Get_Disp_V_Speed();

    if (DispVSpeed <= DISPSPEEDNULLMAX)
    {
        /*----无车速，无报警----*/
        if (HMI_MENU_Sta != Display_Alarm)
        {
            if (enKeyEvent == KEY_EVENT_SHORT_PRESS_1)
            {
                if (((bCurMenuIDX >= _MN_DSP_LEVEL2MENU_1) && (bCurMenuIDX <= _MN_DSP_LEVEL2_5_MENU_4)) ||
                        ((bCurMenuIDX >= _MN_DSP_LEVEL3_4_MENU_41) && (bCurMenuIDX <= _MN_DSP_LEVEL3_4_MENU_47)))
                {
                    /*系统演示模式*/
                    if (bCurMenuIDX == _MN_DSP_LEVEL2MENU_5)
                    {
                        if (K_Line_Set.K_Line_LID27 == 0x01u)
                        {
                            NextMenu(MenuOptTab[bCurMenuIDX].VK_IDX_ENTER);
                        }
                        else
                        {
                            NextMenu(_MN_DSP_LEVEL2_5_MENU_2);
                        }
                    }
                    else
                    {
                        NextMenu(MenuOptTab[bCurMenuIDX].VK_IDX_ENTER);
                    }
                }
                else if (((bCurMenuIDX >= _MN_DSP_LEVEL3_3_MENU_1) && (bCurMenuIDX <= _MN_DSP_LEVEL3_4_MENU_3)) ||
                         ((bCurMenuIDX >= _MN_DSP_LEVEL4_4_MENU_1) && (bCurMenuIDX <= _MN_DSP_LEVEL4_4_MENU_7)))
                {
                    MenuFlag.Menu_Return = 1u;
                    NextMenu(MenuOptTab[bCurMenuIDX].VK_IDX_ENTER);
                }
                /*背光调节*/
                else if ((bCurMenuIDX == _MN_DSP_LEVEL3_7_MENU_1) || (bCurMenuIDX == _MN_DSP_LEVEL3_7_MENU_2))
                {
                    MenuFlag.Menu_Return = 1u;
                    NextMenu(MenuOptTab[bCurMenuIDX].VK_IDX_ENTER);
                }
                /*轮胎匹配界面*/
                else if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_5)
                {
                    if (User_set_Num.User_TpmsStatus == 1)
                    {
                        User_set_Num.User_TpmsStatus = 2;  /*匹配轮胎*/
                        User_set_Num.User_TpmsSend = 3;    /*报文外发状态*/
                        User_set_Num.User_Temp_Return = 0; /*清空取消标记位*/
                    }
                }
                /*Go Return*/
                else if (bCurMenuIDX == _MN_DSP_ENTER_MENU)
                {
                    MenuFlag.Menu_Return = 1;
                    NextMenu(_MN_DSP_RETURN_MENU);
                }
                /*工厂模式 经销商模式*/
                else if ((bCurMenuIDX >= _FAC_DSP_LEVEL0MENU_1) && (bCurMenuIDX <= _MN_DSP_MENU_MAX))
                {
                    if ((bCurMenuIDX == _FAC_DSP_LEVEL2_5MENU_1) || (bCurMenuIDX == _DEA_DSP_LEVEL2_5MENU_1))
                    {
                        K_Line_Set.K_Line_LID51 = 1u;
                    }
                    /*工厂模式*/
                    else if (bCurMenuIDX == _FAC_DSP_LEVEL1MENU_4)
                    {
                        K_Line_Set.K_Line_LID51 = 0x01u;
                        MenuFlag.Menu_StaFlag = 0x00u;
                    }
                    /*经销商模式*/
                    else if (bCurMenuIDX == _DEA_DSP_LEVEL1MENU_4)
                    {
                        K_Line_Set.K_Line_LID51 = 0x01u;
                        MenuFlag.Menu_StaFlag = 0x02u;
                    }
                    else
                    {
                        NextMenu(MenuOptTab[bCurMenuIDX].VK_IDX_ENTER);
                    }
                }
                else
                {
                    ;/*Do Nothing!*/
                }
            }
            else if (enKeyEvent == KEY_EVENT_LONG_PRESS_1)
            {
                /*Go Enter*/
                if ((bCurMenuIDX >= _MN_DSP_LEVEL3_2_MENU_1) && (bCurMenuIDX <= _MN_DSP_LEVEL3_2_MENU_8))
                {
                    MenuFlag.Menu_Enter_Return = bCurMenuIDX;
                    NextMenu(_MN_DSP_ENTER_MENU);
                }
            }
        }
        else
        {
            /*----无车速，有报警----*/
            if (enKeyEvent == KEY_EVENT_SHORT_PRESS_1)
            {
                ; /*D0 Nothing!*/
            }
            else if (enKeyEvent == KEY_EVENT_LONG_PRESS_1)
            {
                ; /*D0 Nothing!*/
            }
        }
    }
    else
    {
        /*----有车速，无报警----*/
        if (HMI_MENU_Sta != Display_Alarm)
        {
            if (enKeyEvent == KEY_EVENT_SHORT_PRESS_1)
            {
                /*工厂模式 经销商模式*/
                if ((bCurMenuIDX >= _FAC_DSP_LEVEL0MENU_1) && (bCurMenuIDX <= _MN_DSP_MENU_MAX))
                {
                    if ((bCurMenuIDX == _FAC_DSP_LEVEL2_5MENU_1) || (bCurMenuIDX == _DEA_DSP_LEVEL2_5MENU_1))
                    {
                        K_Line_Set.K_Line_LID51 = 1u;
                    }
                    /*工厂模式*/
                    else if (bCurMenuIDX == _FAC_DSP_LEVEL1MENU_4)
                    {
                        K_Line_Set.K_Line_LID51 = 0x01u;
                        MenuFlag.Menu_StaFlag = 0x00u;
                    }
                    /*经销商模式*/
                    else if (bCurMenuIDX == _DEA_DSP_LEVEL1MENU_4)
                    {
                        K_Line_Set.K_Line_LID51 = 0x01u;
                        MenuFlag.Menu_StaFlag = 0x02u;
                    }
                    else
                    {
                        NextMenu(MenuOptTab[bCurMenuIDX].VK_IDX_ENTER);
                    }
                }
                else
                {
                    ;/*Do Nothing!*/
                }
            }
            else if (enKeyEvent == KEY_EVENT_LONG_PRESS_1)
            {
                ; /*D0 Nothing!*/
            }
        }
        /*----有车速，有报警----*/
        else
        {
            if (enKeyEvent == KEY_EVENT_SHORT_PRESS_1)
            {
                ; /*D0 Nothing!*/
            }
            else if (enKeyEvent == KEY_EVENT_LONG_PRESS_1)
            {
                ; /*D0 Nothing!*/
            }
        }
    }
}

/*******************************RETURN***********************************************
  Function： Key_Operation_Return
  Description：
  Input:
  Output:
 *******************************RETURN***********************************************/
void Key_Operation_Return(Key_Event_en_t enKeyEvent)
{
    uint16_t DispVSpeed = 0u;
    UElib_uint16_t HMI_MENU_Sta = 0u;

    HMI_Set_KEY_CANCEL(enKeyEvent);

    HMI_MENU_Sta = Get_Cur_HMI();
    DispVSpeed = Common_Get_Disp_V_Speed();

    if (DispVSpeed <= DISPSPEEDNULLMAX)
    {
        /*----无车速，无报警----*/
        if (HMI_MENU_Sta != Display_Alarm)
        {
            if (enKeyEvent == KEY_EVENT_SHORT_PRESS_1)
            {
                if ((bCurMenuIDX >= _MN_DSP_LEVEL2_1_MENU_1) && (bCurMenuIDX < _MN_DSP_ENTER_MENU))
                {
                    if (
                        (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_3) ||                                              /*语言设定*/
                        (bCurMenuIDX == _MN_DSP_LEVEL3_7_MENU_1) || (bCurMenuIDX == _MN_DSP_LEVEL3_7_MENU_2) ||  /*亮度调节*/
                        ((bCurMenuIDX >= _MN_DSP_LEVEL3_4_MENU_41) && (bCurMenuIDX <= _MN_DSP_LEVEL3_4_MENU_47)) /*省油设定子菜单*/
                    )
                    {
                        MenuFlag.Menu_Return = 0u;
                        NextMenu(MenuOptTab[bCurMenuIDX].VK_IDX_EXIT);
                    }
                    else if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_5) /*胎压设置界面返回操作*/
                    {
                        if (User_set_Num.User_TpmsStatus != 2u) /*不是正在匹配状态*/
                        {
                            NextMenu(MenuOptTab[bCurMenuIDX].VK_IDX_EXIT);
                        }
                        else
                        {
                            User_set_Num.User_TpmsStatus = 1u; /*退出匹配界面*/
                            if (User_set_Num.User_Temp_Return == 0u)
                            {
                                User_set_Num.User_Temp_Return = 1u; /*取消配对标记*/
                                User_set_Num.User_TpmsSend = 3u;    /*报文外发状态*/
                            }
                            else
                            {
                                ; /* do nonthing*/
                            }
                        }
                    }
                    else
                    {
                        NextMenu(MenuOptTab[bCurMenuIDX].VK_IDX_EXIT);
                    }
                }
                /*系统演示模式*/
                else if ((bCurMenuIDX >= _MN_DSP_LEVEL3_5_MENU_1) && (bCurMenuIDX <= _MN_DSP_LEVEL3_5_MENU_4))
                {
                    MenuFlag.Menu_Return = 0;
                    NextMenu(MenuOptTab[bCurMenuIDX].VK_IDX_EXIT);
                }
                /*Enter Go*/
                else if (bCurMenuIDX == _MN_DSP_ENTER_MENU)
                {
                    MenuFlag.Menu_Return = 0;
                    NextMenu(MenuFlag.Menu_Enter_Return);
                }
                /*工厂模式 经销商模式*/
                else if ((bCurMenuIDX >= _FAC_DSP_LEVEL0MENU_1) && (bCurMenuIDX <= _MN_DSP_MENU_MAX))
                {
                    NextMenu(MenuOptTab[bCurMenuIDX].VK_IDX_EXIT);
                }
                else
                {
                    ; /*do nothing*/
                }
            }
            else if (enKeyEvent == KEY_EVENT_LONG_PRESS_1)
            {
                ; /*D0 Nothing!*/
            }
        }
        else
        {
            /*----无车速，有报警----*/
            if (enKeyEvent == KEY_EVENT_SHORT_PRESS_1)
            {
                ; /*Do Nothing!*/
            }
            else if (enKeyEvent == KEY_EVENT_LONG_PRESS_1)
            {
                MenuFlag.Key_Menu_Popup_time = 6000u;
            }
        }
    }
    else
    {
        if (HMI_MENU_Sta != Display_Alarm)
        {
            /*----有车速，无报警----*/
            if (enKeyEvent == KEY_EVENT_SHORT_PRESS_1)
            {
                /*工厂模式 经销商模式*/
                if ((bCurMenuIDX >= _FAC_DSP_LEVEL0MENU_1) && (bCurMenuIDX <= _MN_DSP_MENU_MAX))
                {
                    NextMenu(MenuOptTab[bCurMenuIDX].VK_IDX_EXIT);
                }
                else
                {
                    ; /*do nothing*/
                }
            }
            else if (enKeyEvent == KEY_EVENT_LONG_PRESS_1)
            {
                ; /*Do Nothing!*/
            }
        }
        else
        {
            /*----有车速，无报警----*/
            if (enKeyEvent == KEY_EVENT_SHORT_PRESS_1)
            {
                ; /*Do Nothing!*/
            }
            else if (enKeyEvent == KEY_EVENT_LONG_PRESS_1)
            {
                MenuFlag.Key_Menu_Popup_time = 6000u;
            }
        }
    }
}

/*******************************Menu***********************************************
  Function： Key_Operation_Menu
  Description：
  Input:
  Output:
 *******************************Menu***********************************************/
void Key_Operation_Menu(Key_Event_en_t enKeyEvent)
{
    uint8_t CanStatus1 = 0u;
    uint16_t DispVSpeed = 0u;
    UElib_uint16_t HMI_MENU_Sta = 0u;

    HMI_Set_KEY_MENU(enKeyEvent);

    HMI_MENU_Sta = Get_Cur_HMI();
    DispVSpeed = Common_Get_Disp_V_Speed();

    CanStatus1 = CAN_MSG_Status(ID_CanMsg0CF00400_Msg_Count);

    if (DispVSpeed <= DISPSPEEDNULLMAX)
    {
        /*----无车速，无报警----*/
        if (HMI_MENU_Sta != Display_Alarm)
        {
            if (enKeyEvent == KEY_EVENT_SHORT_PRESS_1)
            {
                /*自检模式进入经销商模式*/
                if (bCurMenuIDX == _MN_DSP_Menu_Test)
                {
                    K_Line_Set.K_Line_LID51 = 0x02u;
                }
                /*工厂模式*/
                else if (MenuFlag.Menu_StaFlag == 0x00u)
                {
                    Common_Set_Menu_FacDea_Time_Sta(0x00u);

                    K_Line_Set.K_Line_LID51 = 0x00u;
                    MenuFlag.Menu_StaFlag = 0x01u;
                }
                /*经销商模式*/
                else if (MenuFlag.Menu_StaFlag == 0x02u)
                {
                    Common_Set_Menu_FacDea_Time_Sta(0x00u);

                    K_Line_Set.K_Line_LID51 = 0x02u;
                    MenuFlag.Menu_StaFlag = 0x01u;
                }
                /*记录进入menu菜单的位置*/
                else if ((bCurMenuIDX >= _MN_DSP_LEVEL1MENU_1) && (bCurMenuIDX <= _MN_DSP_LEVEL1MENU_6))
                {
                    MenuFlag.Menu_Flag = bCurMenuIDX;

                    NextMenu(MenuOptTab[bCurMenuIDX].VK_IDX_ENTER);
                }
                /*无论从哪里都能回去*/
                else if ((bCurMenuIDX >= _MN_DSP_LEVEL2MENU_1) && (bCurMenuIDX <= _MN_DSP_LEVEL3_5_MENU_4))
                {
                    NextMenu(MenuFlag.Menu_Flag);
                }
            }
            else if (enKeyEvent == KEY_EVENT_LONG_PRESS_1)
            {
                ; /*Do Nothing!*/
            }
            else if (enKeyEvent == KEY_EVENT_LONG_PRESS_2)
            {
                /*EOL USB 刷写功能----20220721*/
                if (bCurMenuIDX == _MN_DSP_Menu_Test)
                {
                    StartUSBUpgrade();
                }
            }
        }
        else
        {
            /*----无车速，有报警----*/
            if (enKeyEvent == KEY_EVENT_SHORT_PRESS_1)
            {
                /*自检模式进入经销商模式*/
                if (bCurMenuIDX == _MN_DSP_Menu_Test)
                {
                    K_Line_Set.K_Line_LID51 = 0x02;
                }
                /*工厂模式*/
                else if (MenuFlag.Menu_StaFlag == 0x00u)
                {
                    Common_Set_Menu_FacDea_Time_Sta(0x00u);

                    K_Line_Set.K_Line_LID51 = 0x00u;
                    MenuFlag.Menu_StaFlag = 0x01u;
                }
                /*经销商模式*/
                else if (MenuFlag.Menu_StaFlag == 0x02u)
                {
                    Common_Set_Menu_FacDea_Time_Sta(0x00u);

                    K_Line_Set.K_Line_LID51 = 0x02u;
                    MenuFlag.Menu_StaFlag = 0x01u;
                }
            }
            else if (enKeyEvent == KEY_EVENT_LONG_PRESS_1)
            {
                ; /*Do Nothing!*/
            }
            else if (enKeyEvent == KEY_EVENT_LONG_PRESS_2)
            {
                /*EOL USB 刷写功能----20220721*/
                if (bCurMenuIDX == _MN_DSP_Menu_Test)
                {
                    StartUSBUpgrade();
                }
            }
        }
    }
    else
    {
        if (HMI_MENU_Sta != Display_Alarm)
        {
            /*----有车速，无报警----*/
            if (enKeyEvent == KEY_EVENT_SHORT_PRESS_1)
            {
                /*工厂模式*/
                if (MenuFlag.Menu_StaFlag == 0x00u)
                {
                    Common_Set_Menu_FacDea_Time_Sta(0x00u);

                    K_Line_Set.K_Line_LID51 = 0x00u;
                    MenuFlag.Menu_StaFlag = 0x01u;
                }
                /*经销商模式*/
                else if (MenuFlag.Menu_StaFlag == 0x02u)
                {
                    Common_Set_Menu_FacDea_Time_Sta(0x00u);

                    K_Line_Set.K_Line_LID51 = 0x02u;
                    MenuFlag.Menu_StaFlag = 0x01u;
                }
            }
            else if (enKeyEvent == KEY_EVENT_LONG_PRESS_1)
            {
                /*EOL USB 刷写功能----20220721*/
                if (bCurMenuIDX == _MN_DSP_Menu_Test)
                {
                    StartUSBUpgrade();
                }
            }
            else if (enKeyEvent == KEY_EVENT_LONG_PRESS_2)
            {
                Gui_Display_Test();
                /*TYW总计清零*/
                TYW_Data_ODO_Clear();
            }
        }
        else
        {
            /*----有车速，无报警----*/
            if (enKeyEvent == KEY_EVENT_SHORT_PRESS_1)
            {
                /*工厂模式*/
                if (MenuFlag.Menu_StaFlag == 0x00u)
                {
                    Common_Set_Menu_FacDea_Time_Sta(0x00u);

                    K_Line_Set.K_Line_LID51 = 0x00u;
                    MenuFlag.Menu_StaFlag = 0x01u;
                }
                /*经销商模式*/
                else if (MenuFlag.Menu_StaFlag == 0x02u)
                {
                    Common_Set_Menu_FacDea_Time_Sta(0x00u);

                    K_Line_Set.K_Line_LID51 = 0x02u;
                    MenuFlag.Menu_StaFlag = 0x01u;
                }
            }
            else if (enKeyEvent == KEY_EVENT_LONG_PRESS_1)
            {
                /*EOL USB 刷写功能----20220721*/
                if (bCurMenuIDX == _MN_DSP_Menu_Test)
                {
                    StartUSBUpgrade();
                }
            }
            else if (enKeyEvent == KEY_EVENT_LONG_PRESS_2)
            {
                Gui_Display_Test();
                /*TYW总计清零*/
                TYW_Data_ODO_Clear();
            }
        }
    }
}

/*******************************ODOTrip***********************************************
  Function： Key_Operation_ODOTrip
  Description：
  Input:
  Output:
 *******************************ODOTrip***********************************************/
void Key_Operation_ODOTrip(Key_Event_en_t enKeyEvent)
{
    uint16_t DispVSpeed = 0u;
    UElib_uint16_t HMI_MENU_Sta = 0u;
    uint8_t PowerStatus;

    HMI_Set_KEY_ODOTRIP(enKeyEvent);

    HMI_MENU_Sta = Get_Cur_HMI();
    DispVSpeed = Common_Get_Disp_V_Speed();
    PowerStatus = Common_Get_IG_Sts();

    if (enKeyEvent == KEY_EVENT_OFF_TO_ON)
    {
        MenuFlag.Key_MenuTest_Long = 1u;
    }
    else if (enKeyEvent == KEY_EVENT_SHORT_PRESS_1)
    {
        if (PowerStatus == COMMON_POWER_ON)
        {
            if (HMI_MENU_Sta == Display_StartAnimation)
            {
                if (MenuFlag.Key_MenuTest_ShortNum < 100u)
                {
                    MenuFlag.Key_MenuTest_ShortNum++;
                }
            }
            else if (bCurMenuIDX == _MN_DSP_Menu_Test)
            {

            }
            else if (User_set_Num.Trip_Type == TRAPA)
            {
                User_set_Num.Trip_Type = TRAPB;
            }
            else if (User_set_Num.Trip_Type == TRAPB)
            {
                User_set_Num.Trip_Type = TRAPA;
            }
            else
            {
                ;/*Do Nothing !*/
            }
        }
        else
        {
            State_Flag.Menu_Key_Static = 1u;
            Coom_Set_Menu_Off_MenuTime(0);
        }
    }
    else if (enKeyEvent == KEY_EVENT_LONG_PRESS_1)
    {
        if (PowerStatus == COMMON_POWER_ON)
        {
            if (User_set_Num.Trip_Type == TRAPA)
            {
                Data_Clear_Trip(EM_TRIP_A);
            }
            else
            {
                Data_Clear_Trip(EM_TRIP_B);
            }

            if (State_Flag.FState_ClearOilTx == 0u)
            {
                State_Flag.FState_ClearOilTx = 1u;
            }
        }
    }
#if 0
    if (DispVSpeed <= DISPSPEEDNULLMAX)
    {
        if (HMI_MENU_Sta != Display_Alarm)
        {
            /*----无车速，无报警----*/
            if (enKeyEvent == KEY_EVENT_SHORT_PRESS_1)
            {
                ;
            }
            else if (enKeyEvent == KEY_EVENT_LONG_PRESS_1)
            {
                ; /*Do Nothing!*/
            }
        }
        else
        {
            /*----无车速，有报警----*/
            if (enKeyEvent == KEY_EVENT_SHORT_PRESS_1)
            {
                ; /*Do Nothing!*/
            }
            else if (enKeyEvent == KEY_EVENT_LONG_PRESS_1)
            {
                ; /*Do Nothing!*/
            }
        }
    }
    else
    {
        if (HMI_MENU_Sta != Display_Alarm)
        {
            /*----有车速，无报警----*/
            if (enKeyEvent == KEY_EVENT_SHORT_PRESS_1)
            {
                ; /*Do Nothing!*/
            }
            else if (enKeyEvent == KEY_EVENT_LONG_PRESS_1)
            {
                ; /*Do Nothing!*/
            }
        }
        else
        {
            /*----有车速，无报警----*/
            if (enKeyEvent == KEY_EVENT_SHORT_PRESS_1)
            {
                ; /*Do Nothing!*/
            }
            else if (enKeyEvent == KEY_EVENT_LONG_PRESS_1)
            {
                ; /*Do Nothing!*/
            }
        }
    }
#endif
}

uint8_t Common_Get_RetMenu_Flag(void)
{
    return MenuFlag.Menu_Flag;
}
/*------------读按键实时状态的回调函数-------------------------------------------*/
Key_Status_en_t Key_Real_Status_Read_Enter(void);
Key_Status_en_t Key_Real_Status_Read_Return(void);
Key_Status_en_t Key_Real_Status_Read_Up(void);
Key_Status_en_t Key_Real_Status_Read_Down(void);
Key_Status_en_t Key_Real_Status_Read_Menu(void);
/*-------------------------------------------------*/

// Menu_R   = 24000*470 / (24000 + 470) =  460.97Ω
// Enter_R  = 24000*6800 / (24000 + 6800) =  5298.7Ω
// Return_R = 24000*15000 / (24000 + 15000) =  9230.77Ω
// Up_R     = 24000*1200 / (24000 + 1200) =  1142.86Ω
// Down_R   = 24000*3300 / (24000 + 3300) =  2901.1Ω

// Menu_R   = 16000*470 / (16000 + 470) =  456.59Ω
// Enter_R  = 16000*6800 / (16000 + 6800) =  4771.9Ω
// Return_R = 16000*15000 / (16000 + 15000) =  7741.94Ω
// Up_R     = 16000*1200 / (16000 + 1200) =  1116.28Ω
// Down_R   = 16000*3300 / (16000 + 3300) =  2736Ω

//实际按键测试
//无操作     21000~24000Ω
// Menu_R        640~680Ω
// Enter_R       5300~5700Ω
// Return_R      9000~9500Ω
// Up_R          1300~1400Ω
// Down_R        3000~3200Ω

/*上*/
Key_Status_en_t Key_Real_Status_Read_Up(void)
{
    Key_Status_en_t enKeyRealStatus = KEY_REALTIME_LOOSEN;
    uint16_t Key_R = 0;

    Key_R = (uint16_t)RTE_Read_KEY_R();

    if (RTE_Read_KEY_R_Valid() == 0)
    {
        enKeyRealStatus = KEY_REALTIME_LOOSEN;
    }
    else
    {
        if ((Key_R >= (1250 - 400)) && (Key_R <= (1250 + 400)))
        {
            enKeyRealStatus = KEY_REALTIME_PRESS;
        }
        else
        {
            enKeyRealStatus = KEY_REALTIME_LOOSEN;
        }
    }

    return enKeyRealStatus;
}

/*下*/
Key_Status_en_t Key_Real_Status_Read_Down(void)
{
    Key_Status_en_t enKeyRealStatus = KEY_REALTIME_LOOSEN;
    uint16_t Key_R = 0;

    Key_R = (uint16_t)RTE_Read_KEY_R();

    if (RTE_Read_KEY_R_Valid() == 0)
    {
        enKeyRealStatus = KEY_REALTIME_LOOSEN;
    }
    else
    {
        if ((Key_R >= (2900 - 400)) && (Key_R <= (2900 + 400)))
        {
            enKeyRealStatus = KEY_REALTIME_PRESS;
        }
        else
        {
            enKeyRealStatus = KEY_REALTIME_LOOSEN;
        }
    }

    return enKeyRealStatus;
}

/*Enter*/
Key_Status_en_t Key_Real_Status_Read_Enter(void)
{
    Key_Status_en_t enKeyRealStatus = KEY_REALTIME_LOOSEN;
    uint16_t Key_R = 0;

    Key_R = (uint16_t)RTE_Read_KEY_R();

    if (RTE_Read_KEY_R_Valid() == 0)
    {
        enKeyRealStatus = KEY_REALTIME_LOOSEN;
    }
    else
    {
        if ((Key_R >= (4800 - 400)) && (Key_R <= (5300 + 400)))
        {
            enKeyRealStatus = KEY_REALTIME_PRESS;
        }
        else
        {
            enKeyRealStatus = KEY_REALTIME_LOOSEN;
        }
    }
    return enKeyRealStatus;
}

/*Return*/
Key_Status_en_t Key_Real_Status_Read_Return(void)
{
    Key_Status_en_t enKeyRealStatus = KEY_REALTIME_LOOSEN;
    uint16_t Key_R = 0;

    Key_R = (uint16_t)RTE_Read_KEY_R();

    if (RTE_Read_KEY_R_Valid() == 0)
    {
        enKeyRealStatus = KEY_REALTIME_LOOSEN;
    }
    else
    {
        if ((Key_R >= (7800 - 400)) && (Key_R <= (8900 + 400)))
        {
            enKeyRealStatus = KEY_REALTIME_PRESS;
        }
        else
        {
            enKeyRealStatus = KEY_REALTIME_LOOSEN;
        }
    }

    return enKeyRealStatus;
}

/*Menu*/
Key_Status_en_t Key_Real_Status_Read_Menu(void)
{
    Key_Status_en_t enKeyRealStatus = KEY_REALTIME_LOOSEN;
    uint16_t Key_R = 0;

    Key_R = (uint16_t)RTE_Read_KEY_R();

    if (RTE_Read_KEY_R_Valid() == 0)
    {
        enKeyRealStatus = KEY_REALTIME_LOOSEN;
    }
    else
    {
        if ((Key_R >= (500 - 300)) && (Key_R <= (500 + 300)))
        {
            enKeyRealStatus = KEY_REALTIME_PRESS;
        }
        else
        {
            enKeyRealStatus = KEY_REALTIME_LOOSEN;
        }
    }

    return enKeyRealStatus;
}

/*TRIO-ODO*/
Key_Status_en_t Key_Real_Status_Read_ODOTrip(void)
{
    Key_Status_en_t enKeyRealStatus = KEY_REALTIME_LOOSEN;
    uint16_t Key_R = 0;

    Key_R = (uint16_t)CD4051_COM3_X5_IN;

    if (Key_R == 0u)
    {
        enKeyRealStatus = KEY_REALTIME_PRESS;
    }
    else
    {
        enKeyRealStatus = KEY_REALTIME_LOOSEN;
    }

    return enKeyRealStatus;
}
/*---------------------------------------------------------------------------------------*/
const Key_Attribute_st_t stKeyAttribute[KEY_NUM_MAX] =
{
    {KEY_NEED_DEBOUNCE_NORMAL, Key_Real_Status_Read_Up, Key_Operation_Up},
    {KEY_NEED_DEBOUNCE_NORMAL, Key_Real_Status_Read_Down, Key_Operation_Down},
    {KEY_NEED_DEBOUNCE_NORMAL, Key_Real_Status_Read_Enter, Key_Operation_Enter},
    {KEY_NEED_DEBOUNCE_NORMAL, Key_Real_Status_Read_Return, Key_Operation_Return},
    {KEY_NEED_DEBOUNCE_NORMAL, Key_Real_Status_Read_Menu, Key_Operation_Menu},
    {KEY_NEED_DEBOUNCE_NORMAL, Key_Real_Status_Read_ODOTrip, Key_Operation_ODOTrip},
};

void Key_KL30_Init_EXample(void)
{
    Key_Init_st_t stKeyInitTem;
    Key_uint16_t i;
    for (i = 0; i < KEY_RAM_DATA_LEN; i++)
    {
        u8KeyRamData[i] = 0;
    }

    stKeyInitTem.u8KeyNum = KEY_NUM_MAX;
    stKeyInitTem.enKeyIGNRealStatus = KEY_IG_OFF;
    Key_KL30_Init(&u8KeyRamData[0], stKeyAttribute, &stKeyInitTem);
}
void Key_Wakeup_Init_EXample(void)
{
    Key_Init_st_t stKeyInitTem;

    stKeyInitTem.u8KeyNum = KEY_NUM_MAX;
    stKeyInitTem.enKeyIGNRealStatus = KEY_IG_OFF; //

    Key_Wakeup_Init(&u8KeyRamData[0], stKeyAttribute, &stKeyInitTem);
}