#include "UDS_23Service_Filter.h"

/**
  *23服务是否支持功能寻址
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_23Service_NRC11(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}

/**
  *23服务会话是否支持验证
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_23Service_NRC7F(void)
{
    uint8_t NRC = positiveResponse;
    if(getSessionType() == DefaultSession)
    {
        if(DiagMSG.msgID == DIAG_ID_Rx_PHY)
        {
            NRC = serviceNotSupportedInActiveSession;
        }
    }
    return NRC;
}

/**
  *23服务解锁等级验证
  *@return 负反馈编号
  */
uint8_t UDS_23Service_NRC33(void)
{
    uint8_t NRC = positiveResponse;
    if(getSecurityLevel(1) == NormalKeyLock)
    {
        NRC = securityAccessDenied;
    }
    return NRC;
}

/**
  *23服务最小长度验证
  *@return 负反馈编号
  */
uint8_t UDS_23Service_NRC13_MinLengthCheck(void)
{
    uint8_t NRC = positiveResponse;
    if(DiagMSG.msgDLC < 9u)
    {
        NRC = incorrectMessageLength;
        UDS_Service_Response(0x23u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }
    else
    {
        NRC = positiveResponse;
    }
    return NRC;
}

/**
  *23服务超出请求范围验证
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_23Service_NRC31(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}

/**
  *23服务总长度长度验证
  *@return 负反馈编号
  */
uint8_t UDS_23Service_NRC13_TotalLengthCheck(void)
{
    uint8_t NRC = positiveResponse;
    if(DiagMSG.msgDLC != 9u)
    {
        NRC = incorrectMessageLength;
        UDS_Service_Response(0x23u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }
    else
    {
        NRC = positiveResponse;
    }
    return NRC;
}

/**
  *23服务条件验证
  *@return 负反馈编号
  */
uint8_t UDS_23Service_NRC22(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}
