#include "UDS_23Service_Main.h"

/**
  *23服务函数入口
  *@param A_TA_type 收到数据的地址
  *@param A_Length 收到数据的长度
  *@param A_Data 收到数据的数据
  */
void UDS_Service_23_Indication(uint32_t A_TA_type, uint16_t A_Length, uint8_t A_Data[])
{
    uint8_t NRC = positiveResponse;
    setDiagMSG(A_TA_type, A_Length, A_Data);
    if(NRC == positiveResponse)
    {
        NRC = UDS_23Service_NRC11();                                            /*23服务是否支持功能寻址*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_23Service_NRC7F();                                            /*23服务会话是否支持验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_23Service_NRC33();                                            /*23服务解锁等级验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_23Service_NRC13_MinLengthCheck();                             /*23服务最小长度验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_23Service_NRC31();                                            /*23服务超出请求范围验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_23Service_NRC13_TotalLengthCheck();                           /*23服务总长度长度验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_23Service_NRC22();                                            /*23服务条件验证*/
    }
    if(NRC == positiveResponse)
    {
        UDS_23Service();                                                        /*23服务功能*/
    }
    clearDiagMSG();                                                             /*清除诊断信息*/
}

/**
  *23服务功能
  */
void UDS_23Service(void)
{

}