#include "UDS_2EService_Filter.h"

uint16_t S2EDLC[] = {42u,      42u,    42u,     17u,     6u,      6u,      1u,      1u,      1u,      1u,      1u,      2u,      1u,      1u,      1u,      1u,      1u,      2u,      1u,      1u,      1u,      1u,	   1u,      1u,      3u,      1u,      2u,      2u,      1u,      2u,      1u,      1u,      1u,      1u,      1u};
uint16_t S2EDID[] = {0xF183u, 0xF184u, 0xF185u, 0xF190u, 0xF1F0u, 0xF1F1u, 0x605Cu, 0x605Du, 0x605Eu, 0x605Fu, 0x6060u, 0x6062u, 0x6063u, 0x6064u, 0x6068u, 0x606Du, 0x606Eu, 0x606Fu, 0x6070u, 0x6071u, 0x6072u, 0x6073u, 0x6074u, 0x6075u, 0x6076u, 0x60C9u, 0x60CAu, 0x60CBu, 0x60CCu, 0x60CDu, 0x60CEu, 0x60CFu, 0x60D0u, 0x60D1u, 0x60D2u};
//uint16_t S2EDID_Boolean[] = {0x605Cu, 0x605Du, 0x605Eu, 0x605Fu, 0x6060u, 0x606Du, 0x606Eu, 0x6070u, 0x6071u, 0x6072u, 0x6073u};

/**
  *2E服务是否支持功能寻址
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_2EService_NRC11(void)
{
    uint8_t NRC = positiveResponse;
    if(DiagMSG.msgID == DIAG_ID_Rx_FUN)
    {
        NRC = serviceNotSupported;
    }
    return NRC;
}

/**
  *2E服务会话是否支持验证
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_2EService_NRC7F(void)
{
    uint8_t NRC = positiveResponse;
    if(getSessionType() == DefaultSession)
    {
        NRC = serviceNotSupportedInActiveSession;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }
    else
    {
        NRC = positiveResponse;
    }
    return NRC;
}

/**
  *2E服务解锁等级验证
  *@return 负反馈编号
  */
uint8_t UDS_2EService_NRC33(void)
{
    uint8_t NRC = positiveResponse;
    if(getSecurityLevel(1) == NormalKeyUnlock)
    {
        NRC = positiveResponse;
    }
    else
    {
        NRC = securityAccessDenied;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }  
    return NRC;
}

/**
  *2E服务最小长度验证
  *@return 负反馈编号
  */
uint8_t UDS_2EService_NRC13_MinLengthCheck(void)
{
    uint8_t NRC = positiveResponse;
    if(DiagMSG.msgDLC < 2u)
    {
        NRC = incorrectMessageLength;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }
    else
    {
        NRC = positiveResponse;
    }
    return NRC;
}

/**
  *2E服务超出请求范围验证
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_2EService_NRC31(void)
{
    uint8_t i;
    uint8_t j;
    uint8_t NRC = requestOutOfRange;
    for(i = 0u; i < DIM(S2EDID); ++i)
    {
        if(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == S2EDID[i])
        {
            NRC = positiveResponse;
        }
    }
    if((NRC == requestOutOfRange) && (DiagMSG.msgID == DIAG_ID_Rx_PHY))
    {
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }/**/
    return NRC;
}

/**
  *2E服务总长度长度验证
  *@return 负反馈编号
  */
uint8_t UDS_2EService_NRC13_TotalLengthCheck(void)
{
    uint8_t i;
    uint8_t NRC = positiveResponse;
    for(i = 0u; i < DIM(S2EDID); ++i)
    {
        if(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == S2EDID[i])
        {
            if((DiagMSG.msgDLC - 2) != S2EDLC[i])
            {
                NRC = incorrectMessageLength;
                UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
            }
            else
            {
                NRC = positiveResponse;
            }
            break;
        }
    }/**/
    return NRC;
}

/**
  *2E服务子参数超出请求范围验证
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
/*uint8_t UDS_2EService_Sub_NRC31(void)
{
    uint8_t i;
    uint8_t j;
    uint8_t NRC = positiveResponse;
    for(i = 0u; i < DIM(S2EDID_Boolean); ++i)
    {
        if(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == S2EDID_Boolean[i])
        {
            
            for(j = 0; j < (DiagMSG.msgDLC - 2); ++j)
            {
                //if(isBoolean(DiagMSG.msgData.didDetail.Data[j]))
                {
                    
                }
               // else
                {
                    NRC = requestOutOfRange;      
                    break;                 
                }
            }
            break;
        }
    }
    if((NRC == requestOutOfRange) && (DiagMSG.msgID == DIAG_ID_Rx_PHY))
    {
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }
    return NRC;
}*/









/**
  *2E服务条件验证
  *@return 负反馈编号
  */
uint8_t UDS_2EService_NRC22(void)
{
    uint8_t NRC = positiveResponse;
    if(getSpeed() >= 3u)
    {
        NRC = conditionsNotCorrect;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }
    /*else if(getESpeed() > 400u)
    {
        NRC = conditionsNotCorrect;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }*/
    else
    {
        NRC = positiveResponse;
    }
    

    return NRC;
}
