#include "Data_AirPressure.h"
#include "Gauges.h"
#include "CAN_Communication_Matrix.h"
#include "RTE_ADC.h"

#include "Common_Interface.h"

DataStruct DataStrGas1;
DataStruct DataStrGas2;
DataStruct DataStrWET;

/*-------------------------------------------------------------------------
 * Function Name  : AirPressure_KL30_Init
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : Table固化 斜率同时固化
 --------------------------------------------------------------------------*/
void AirPressure_KL30_Init(void)
{}
void AirPressure_KL15_ON_Init(void)
{
    uint8_t i = 0u;
    /*气压1结构体初始化*/
    DataStrGas1.Count = 0u;
    for (i = 0; i < 15u; i++)
    {
        DataStrGas1.DataBuf[i] = 0u;
    }
    DataStrGas1.DataDisplay = 0u;
    DataStrGas1.Valid = 0u;
    DataStrGas1.LostTimer = 0u;
    DataStrGas1.Status = 0u;

    /*气压2结构体初始化*/
    DataStrGas2.Count = 0u;
    for (i = 0; i < 15u; i++)
    {
        DataStrGas2.DataBuf[i] = 0u;
    }
    DataStrGas2.DataDisplay = 0u;
    DataStrGas2.Valid = 0u;
    DataStrGas2.LostTimer = 0u;
    DataStrGas2.Status = 0u;

    /*wet 气压结构体初始化*/
    DataStrWET.Count = 0u;
    for (i = 0; i < 15u; i++)
    {
        DataStrWET.DataBuf[i] = 0u;
    }
    DataStrWET.DataDisplay = 0u;
    DataStrWET.Valid = 0u;
    DataStrWET.LostTimer = 0u;
}
void AirPressure_KL15_OFF_Init(void)
{

}
void AirPressure_Wakeup_Init(void)
{

}
void AirPressure_Sleep_Init(void)
{

}
/*-------------------------------------------------------------------------
 * Function Name  : AirPressure_Processing_Service
 * Description    : 主函数周期调用
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void AirPressure_Processing_Service(void)
{
    Data_Gas1_Processing_Service();
    Data_Gas2_Processing_Service();
    Data_WET_Processing_Service();

    SetGaugesPara(PRIGasGauges, DataStrGas1.DataDisplay);
    SetGaugesPara(SECGasGauges, DataStrGas2.DataDisplay);
    SetGaugesPara(WETGasGauges, DataStrWET.DataDisplay);
}

/*-------------------------------------------------------------------------
 * Function Name  : Data_Gas1_Processing_Service
 * Description    : 气压1
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Data_Gas1_Processing_Service(void)
{
    uint32_t Gas_Value = 0u;
    uint32_t data = 0u;

    if ((K_Line_Set.K_Line_LID42 == 0x00) || (K_Line_Set.K_Line_LID42 == 0x02))
    {
        Gas_Value = RTE_Read_PRIMARY_AIR_Voltage();
    }
    else if ((K_Line_Set.K_Line_LID42 == 0x01) || (K_Line_Set.K_Line_LID42 == 0x03))
    {
        Gas_Value = RTE_Read_SECONDARY_AIR_Voltage();
    }

    if ((Common_Get_IG_Sts_Valid() == 1u) && (Common_Get_IG_Sts() == COMMON_POWER_ON))
    {
        if ((Gas_Value < 250u) || (Gas_Value > 4250u))
        {
            if (DataStrGas1.LostTimer < 200u)
            {
                if (DataStrGas1.Valid == 1u)
                {
                    DataStrGas1.LostTimer++;
                }
                else
                {
                    DataStrGas1.Count = 0u;
                    DataStrGas1.DataDisplay = 0u;
                    DataStrGas1.LostTimer = 200u;
                }
            }
            else
            {
                DataStrGas1.Valid = 0u;
                DataStrGas1.Count = 0u;
                DataStrGas1.DataDisplay = 0u;
                DataStrGas1.Status = 1u;
            }
        }
        else
        {
            DataStrGas1.Status = 0u;
            DataStrGas1.LostTimer = 0u;
            if (DataStrGas1.Valid == 0u)
            {
                DataStrGas1.DataDisplay = Gas_Value;
                DataStrGas1.Valid = 1u;
            }
            else
            {
                if (DataStrGas1.Count >= 15)
                {
                    DataStrGas1.Count = 0u;
                    App_SortNByte(DataStrGas1.DataBuf, 5u);
                    App_SortNByte(DataStrGas1.DataBuf + 5u, 5u);
                    App_SortNByte(DataStrGas1.DataBuf + 10u, 5u);
                    data = (DataStrGas1.DataBuf[2u] + DataStrGas1.DataBuf[7u] + DataStrGas1.DataBuf[12u]);
                    data = data / 3u;
                    DataStrGas1.DataDisplay = (uint16_t)data;
                }
                else
                {
                    DataStrGas1.Count++;
                    DataStrGas1.DataBuf[DataStrGas1.Count - 1u] = Gas_Value;
                }
            }
        }
    }
    else
    {
        DataStrGas1.Count = 0u;
        DataStrGas1.DataDisplay = 0u;
        DataStrGas1.Valid = 0u;
        DataStrGas1.LostTimer = 0u;
        DataStrGas1.Status = 0u;
    }
}

/*-------------------------------------------------------------------------
 * Function Name  : Data_Gas2_Processing_Service
 * Description    : 气压2
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Data_Gas2_Processing_Service(void)
{
    uint32_t Gas_Value = 0u;
    uint32_t data = 0u;

    if ((K_Line_Set.K_Line_LID42 == 0x00) || (K_Line_Set.K_Line_LID42 == 0x02))
    {
        Gas_Value = RTE_Read_SECONDARY_AIR_Voltage();
    }
    else if ((K_Line_Set.K_Line_LID42 == 0x01) || (K_Line_Set.K_Line_LID42 == 0x03))
    {
        Gas_Value = RTE_Read_PRIMARY_AIR_Voltage();
    }

    if ((Common_Get_IG_Sts_Valid() == 1u) && (Common_Get_IG_Sts() == COMMON_POWER_ON))
    {
        if ((Gas_Value < 250u) || (Gas_Value > 4250u))
        {
            if (DataStrGas2.LostTimer < 200u)
            {
                if (DataStrGas2.Valid == 1u)
                {
                    DataStrGas2.LostTimer++;
                }
                else
                {
                    DataStrGas2.Count = 0u;
                    DataStrGas2.DataDisplay = 0u;
                    DataStrGas2.LostTimer = 200u;
                }
            }
            else
            {
                DataStrGas2.Valid = 0u;
                DataStrGas2.Count = 0u;
                DataStrGas2.DataDisplay = 0u;
                DataStrGas2.Status = 1u;
            }
        }
        else
        {
            DataStrGas2.Status = 0u;
            DataStrGas2.LostTimer = 0u;
            if (DataStrGas2.Valid == 0u)
            {
                DataStrGas2.DataDisplay = Gas_Value;
                DataStrGas2.Valid = 1u;
            }
            else
            {
                if (DataStrGas2.Count >= 15)
                {
                    DataStrGas2.Count = 0u;
                    App_SortNByte(DataStrGas2.DataBuf, 5u);
                    App_SortNByte(DataStrGas2.DataBuf + 5u, 5u);
                    App_SortNByte(DataStrGas2.DataBuf + 10u, 5u);
                    data = (DataStrGas2.DataBuf[2u] + DataStrGas2.DataBuf[7u] + DataStrGas2.DataBuf[12u]);
                    data = data / 3u;
                    DataStrGas2.DataDisplay = (uint16_t)data;
                }
                else
                {
                    DataStrGas2.Count++;
                    DataStrGas2.DataBuf[DataStrGas2.Count - 1u] = Gas_Value;
                }
            }
        }
    }
    else
    {
        DataStrGas2.Count = 0u;
        DataStrGas2.DataDisplay = 0u;
        DataStrGas2.Valid = 0u;
        DataStrGas2.LostTimer = 0u;
        DataStrGas2.Status = 0u;
    }
}

/*-------------------------------------------------------------------------
 * Function Name  : Data_WET_Processing_Service
 * Description    : WET 气压
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Data_WET_Processing_Service(void)
{
    uint32_t Gas_Value = 0u;
    uint32_t data = 0u;

    if ((K_Line_Set.K_Line_LID42 == 0x00) || (K_Line_Set.K_Line_LID42 == 0x02))
    {
        Gas_Value = RTE_Read_WET_AIR_Voltage();
    }
    else if ((K_Line_Set.K_Line_LID42 == 0x01) || (K_Line_Set.K_Line_LID42 == 0x03))
    {
        Gas_Value = RTE_Read_WET_AIR_Voltage();
    }

    if ((Common_Get_IG_Sts_Valid() == 1u) && (Common_Get_IG_Sts() == COMMON_POWER_ON))
    {
        if ((Gas_Value < 500u) || (Gas_Value > 4500u))
        {
            if (DataStrWET.LostTimer < 200u)
            {
                if (DataStrWET.Valid == 1u)
                {
                    DataStrWET.LostTimer++;
                }
                else
                {
                    DataStrWET.Count = 0u;
                    DataStrWET.DataDisplay = 0u;
                    DataStrWET.LostTimer = 200u;
                }
            }
            else
            {
                DataStrWET.Valid = 0u;
                DataStrWET.Count = 0u;
                DataStrWET.DataDisplay = 0u;
            }
        }
        else
        {
            DataStrWET.LostTimer = 0u;
            if (DataStrWET.Valid == 0u)
            {
                DataStrWET.DataDisplay = Gas_Value;
                DataStrWET.Valid = 1u;
            }
            else
            {
                if (DataStrWET.Count >= 15)
                {
                    DataStrWET.Count = 0u;
                    App_SortNByte(DataStrWET.DataBuf, 5u);
                    App_SortNByte(DataStrWET.DataBuf + 5u, 5u);
                    App_SortNByte(DataStrWET.DataBuf + 10u, 5u);
                    data = (DataStrWET.DataBuf[2u] + DataStrWET.DataBuf[7u] + DataStrWET.DataBuf[12u]);
                    data = data / 3u;
                    DataStrWET.DataDisplay = (uint16_t)data;
                }
                else
                {
                    DataStrWET.Count++;
                    DataStrWET.DataBuf[DataStrWET.Count - 1u] = Gas_Value;
                }
            }
        }
    }
    else
    {
        DataStrWET.Count = 0u;
        DataStrWET.DataDisplay = 0u;
        DataStrWET.Valid = 0u;
        DataStrWET.LostTimer = 0u;
    }
}

/*-------------------------------------------------------------------------
 * Function Name  : Common_Get_Air1_Valid
 * Description    : 获取气压 1 的有效性
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint8_t Common_Get_Air1_Valid(void)
{
    return DataStrGas1.Valid;
}

/*-------------------------------------------------------------------------
 * Function Name  : Common_Get_Air2_Valid
 * Description    : 获取气压 2 的有效性
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint8_t Common_Get_Air2_Valid(void)
{
    return DataStrGas2.Valid;
}

/*-------------------------------------------------------------------------
 * Function Name  : Common_Get_WET_Valid
 * Description    : 获取 WET 有效性
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint8_t Common_Get_WET_Valid(void)
{
    return DataStrWET.Valid;
}

/*-------------------------------------------------------------------------
 * Function Name  : Common_Get_Air1_Data
 * Description    : 获取
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint16_t Common_Get_Air1_Data(void)
{
    return DataStrGas1.DataDisplay;
}

/*-------------------------------------------------------------------------
 * Function Name  : Common_Get_Air2_Data
 * Description    : 获取
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint16_t Common_Get_Air2_Data(void)
{
    return DataStrGas2.DataDisplay;
}

/*-------------------------------------------------------------------------
 * Function Name  : Common_Get_WET_Data
 * Description    : 获取
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint16_t Common_Get_WET_Data(void)
{
    return DataStrWET.DataDisplay;
}

