//#include "r_typedefs.h"
#include "dr7f701441.dvf.h"
#include "UART.h"
//#include "rh850_macros.h"
#include "GPIO.h"
#include "r_dev_api.h"

#include "kwp2000_tp.h"

/*-----------------use for RH850_D1M1A --------------------*/
/*******************************************************************/

#define UART_BASE_ADDRESS 0xFFCE0000UL
#define UART_CKSCLK_ILIN 48000000UL
#define UART_TIME_OUT 10000UL

/*******************************************************************/

uint32_t UART_Init(UART_Channel_en_t enUARTCh, UART_Channel_Config_st_t *penUARTCfg);
void UART_Sleep_Init(UART_Channel_en_t enUARTCh);
/*******************************************************************/
/*******************************************************************/
/*******************************************************************/
#define UART_LSB_FIRST (0U << 1U)
#define UART_MSB_FIRST (1U << 1U)

#define UART_INT_AT_START (0U << 3U)
#define UART_INT_AT_FINISH (1U << 3U)
/*******************************************************/
typedef struct
{
    uint8_t u8UARTCount;      /*发送计数*/
    uint8_t u8UARTLEN;        /*发送数据总长*/
    uint8_t u8UARTTXBusyFlag; /*发送是否忙标志  0:idle  1:busy */
    uint8_t *pu8UARTDataBuf;  /*要发送数据的指针*/
} UART_Ctr_st_t;
/*******************************************************/

static UART_Ctr_st_t stUARTCtr0;
static UART_Ctr_st_t stUARTCtr1;
static UART_Ctr_st_t stUARTCtr2;
static UART_Ctr_st_t stUARTCtr3;

static UART_Channel_Config_st_t stUARTCh0Cfg;
static UART_Channel_Config_st_t stUARTCh1Cfg;
static UART_Channel_Config_st_t stUARTCh2Cfg;
static UART_Channel_Config_st_t stUARTCh3Cfg;

/*******************************************************/
static void UART_Variate_Init(UART_Channel_en_t enUARTCh)
{
    switch (enUARTCh)
    {
    case UART_RLIN30:
    {
        stUARTCtr0.u8UARTCount = 0U;
        stUARTCtr0.u8UARTLEN = 0U;
        stUARTCtr0.u8UARTTXBusyFlag = 0U;
        stUARTCtr0.pu8UARTDataBuf = 0U;

        stUARTCh0Cfg.u32UARTChEn = 0U;
        stUARTCh0Cfg.u32UARTbps = 0U;
        stUARTCh0Cfg.pfnUARTConfirmCallBack = 0U;
        stUARTCh0Cfg.pfnUARTReadMsgCallBack = 0U;
        break;
    }
    case UART_RLIN31:
    {
        stUARTCtr1.u8UARTCount = 0U;
        stUARTCtr1.u8UARTLEN = 0U;
        stUARTCtr1.u8UARTTXBusyFlag = 0U;
        stUARTCtr1.pu8UARTDataBuf = 0U;

        stUARTCh1Cfg.u32UARTChEn = 0U;
        stUARTCh1Cfg.u32UARTbps = 0U;
        stUARTCh1Cfg.pfnUARTConfirmCallBack = 0U;
        stUARTCh1Cfg.pfnUARTReadMsgCallBack = 0U;
        break;
    }
    case UART_RLIN32:
    {
        stUARTCtr2.u8UARTCount = 0U;
        stUARTCtr2.u8UARTLEN = 0U;
        stUARTCtr2.u8UARTTXBusyFlag = 0U;
        stUARTCtr2.pu8UARTDataBuf = 0U;

        stUARTCh2Cfg.u32UARTChEn = 0U;
        stUARTCh2Cfg.u32UARTbps = 0U;
        stUARTCh2Cfg.pfnUARTConfirmCallBack = 0U;
        stUARTCh2Cfg.pfnUARTReadMsgCallBack = 0U;

        break;
    }
    case UART_RLIN33:
    {
        stUARTCtr3.u8UARTCount = 0U;
        stUARTCtr3.u8UARTLEN = 0U;
        stUARTCtr3.u8UARTTXBusyFlag = 0U;
        stUARTCtr3.pu8UARTDataBuf = 0U;

        stUARTCh3Cfg.u32UARTChEn = 0U;
        stUARTCh3Cfg.u32UARTbps = 0U;
        stUARTCh3Cfg.pfnUARTConfirmCallBack = 0U;
        stUARTCh3Cfg.pfnUARTReadMsgCallBack = 0U;
        break;
    }

    default:
        break;
    }
}

/*
返回设置成功的波特率，返回0xFFFFFFFF表示设置失败。
*/
uint32_t UART_Init(UART_Channel_en_t enUARTCh, UART_Channel_Config_st_t *penUARTCfg)
{
    uint32_t u32UARTAddressBase = 0UL;
    uint32_t u32UARTAddress = 0UL;
    uint32_t u32UARTCalBuf = 0UL;
    uint32_t u32UARTCount = 0UL;

    if ((enUARTCh < UART_RLIN_MAX) && (penUARTCfg->u32UARTChEn) && (penUARTCfg->u32UARTbps))
    {
        u32UARTAddressBase = UART_BASE_ADDRESS + 0x1000UL * enUARTCh;

        u32UARTAddress = u32UARTAddressBase + 0x20U;
        (*((uint8_t *)(u32UARTAddress))) = 0X00U;
        //  RLN31LUOER = 0X00U;

        u32UARTAddress = u32UARTAddressBase + 0x08U;
        (*((uint8_t *)(u32UARTAddress))) = 0X00U;
        // RLN31LMD = 0X0U;
        /*****LIN reset mode*/
        u32UARTAddress = u32UARTAddressBase + 0x0EU;
        (*((uint8_t *)(u32UARTAddress))) = 0X00U;
        //  RLN31LCUC = 0X0U;
        u32UARTCount = 0UL;
        u32UARTAddress = u32UARTAddressBase + 0x11U;
        while (((*((uint8_t *)(u32UARTAddress))) != 0U) && (u32UARTCount < UART_TIME_OUT))
            //  while (RLN31LMST != 0U)
        {
            u32UARTCount++;
        }

        UART_Variate_Init(enUARTCh);

        /** baud rate**/
        u32UARTAddress = u32UARTAddressBase + 0x01U;
        (*((uint8_t *)(u32UARTAddress))) = 0X50U;
        /*6 samplings  Prescaler Clock Select1/1*/
        // RLN31LWBR = 0X50U;

        u32UARTCalBuf = UART_CKSCLK_ILIN / 6UL / penUARTCfg->u32UARTbps;
        if (u32UARTCalBuf <= 65536U)
        {
            u32UARTAddress = u32UARTAddressBase + 0x02U;
            (*((uint16_t *)(u32UARTAddress))) = u32UARTCalBuf - 1U;
            // RLN31LBRP01 = u32UARTCalBuf - 1U;
            penUARTCfg->u32UARTbps = UART_CKSCLK_ILIN / 6UL / u32UARTCalBuf;
        }
        else
        {
            penUARTCfg->u32UARTbps = 0xFFFFFFFFUL;
        }

        /**The noise filter is enabled**/
        u32UARTAddress = u32UARTAddressBase + 0x08U;
        (*((uint8_t *)(u32UARTAddress))) = 0X01U;
        //RLN31LMD = 0X01U;

        /**disable error detection.**/
        u32UARTAddress = u32UARTAddressBase + 0x0DU;
        (*((uint8_t *)(u32UARTAddress))) = 0X00U;
        //  RLN31LEDE = 0U;
        /*** data format   N81*/
        u32UARTAddress = u32UARTAddressBase + 0x09U;
        (*((uint8_t *)(u32UARTAddress))) = UART_MSB_FIRST;
        // RLN31LBFC = UART_MSB_FIRST;
        /*Transmission interrupt is generated at.*/
        u32UARTAddress = u32UARTAddressBase + 0x21U;
        (*((uint8_t *)(u32UARTAddress))) = UART_INT_AT_FINISH;
        // RLN31LUOR1 = UART_INT_AT_FINISH;
        /******Exits from LIN reset mode***/
        u32UARTAddress = u32UARTAddressBase + 0x0EU;
        (*((uint8_t *)(u32UARTAddress))) = 0X01U;
        // RLN31LCUC = 0X01U;

        u32UARTCount = 0UL;
        u32UARTAddress = u32UARTAddressBase + 0x11U;
        while (((*((uint8_t *)(u32UARTAddress))) != 0X01U) && (u32UARTCount < UART_TIME_OUT))
            //  while (RLN31LMST != 0X01U)
        {
            u32UARTCount++;
        }

        u32UARTAddress = u32UARTAddressBase + 0x13U;
        (*((uint8_t *)(u32UARTAddress))) = 0X0U;
        // RLN31LEST = 0X0U; /*clear Error Flag , it doesn't matter*/

        u32UARTAddress = u32UARTAddressBase + 0x20U;
        (*((uint8_t *)(u32UARTAddress))) = 0X03U;
        //  RLN31LUOER = 0X03U; /*TX RX EN*/

        /***************************/
        /**********NO USE*****************/

        /***************************/

        if (enUARTCh == UART_RLIN30)
        {
            stUARTCh0Cfg = *penUARTCfg;
            R_DEV_IntEnable(R_DEV_INT_RLIN30R, 1U);
            R_DEV_IntEnable(R_DEV_INT_RLIN30T, 1U);
        }
        else if (enUARTCh == UART_RLIN31)
        {
            stUARTCh1Cfg = *penUARTCfg;
            R_DEV_IntEnable(R_DEV_INT_RLIN31R, 1U);
            R_DEV_IntEnable(R_DEV_INT_RLIN31T, 1U);
        }
        else if (enUARTCh == UART_RLIN32)
        {
            stUARTCh2Cfg = *penUARTCfg;
            R_DEV_IntEnable(R_DEV_INT_RLIN32R, 1U);
            R_DEV_IntEnable(R_DEV_INT_RLIN32T, 1U);
        }
        else if (enUARTCh == UART_RLIN33)
        {
            stUARTCh3Cfg = *penUARTCfg;
            R_DEV_IntEnable(R_DEV_INT_RLIN33R, 1U);
            R_DEV_IntEnable(R_DEV_INT_RLIN33T, 1U);
        }

        /***************************/
    }
    return penUARTCfg->u32UARTbps;
}

void UART_Sleep_Init(UART_Channel_en_t enUARTCh)
{
    uint32_t u32UARTCount = 0UL;
    uint32_t u32UARTAddressBase = 0UL;
    uint32_t u32UARTAddress = 0UL;

    if ((enUARTCh < UART_RLIN_MAX))
    {
        u32UARTAddressBase = UART_BASE_ADDRESS + 0x1000UL * enUARTCh;

        u32UARTAddress = u32UARTAddressBase + 0x20U;
        (*((uint8_t *)(u32UARTAddress))) = 0X00U;
        //  RLN31LUOER = 0X00U;

        u32UARTAddress = u32UARTAddressBase + 0x08U;
        (*((uint8_t *)(u32UARTAddress))) = 0X00U;
        // RLN31LMD = 0X0U;
        /*****LIN reset mode*/
        u32UARTAddress = u32UARTAddressBase + 0x0EU;
        (*((uint8_t *)(u32UARTAddress))) = 0X00U;
        //  RLN31LCUC = 0X0U;
        u32UARTCount = 0UL;
        u32UARTAddress = u32UARTAddressBase + 0x11U;
        while (((*((uint8_t *)(u32UARTAddress))) != 0U) && (u32UARTCount < UART_TIME_OUT))
            //  while (RLN31LMST != 0U)
        {
            u32UARTCount++;
        }
    }
    UART_Variate_Init(enUARTCh);
}
/*
0：idle
1：busy
*/
uint8_t UART_Ch0_Get_TX_Busy_Flag(void)
{
    uint8_t u8Status = 0U;
    if ((RLN30LST & 0x10U) || (stUARTCtr0.u8UARTTXBusyFlag))
    {
        u8Status = 1U;
    }
    return u8Status;
}
uint8_t UART_Ch1_Get_TX_Busy_Flag(void)
{
    uint8_t u8Status = 0U;
    if ((RLN31LST & 0x10U) || (stUARTCtr1.u8UARTTXBusyFlag))
    {
        u8Status = 1U;
    }
    return u8Status;
}
uint8_t UART_Ch2_Get_TX_Busy_Flag(void)
{
    uint8_t u8Status = 0U;
    if ((RLN32LST & 0x10U) || (stUARTCtr2.u8UARTTXBusyFlag))
    {
        u8Status = 1U;
    }
    return u8Status;
}
uint8_t UART_Ch3_Get_TX_Busy_Flag(void)
{
    uint8_t u8Status = 0U;
    if ((RLN33LST & 0x10U) || (stUARTCtr3.u8UARTTXBusyFlag))
    {
        u8Status = 1U;
    }
    return u8Status;
}
/*
Data：要发送数据的指针，
请确认是全局变量的指针，且指向的数据在发送完成之前不会被改变。
*/
void UART_Ch0_Send_Multiple_Byte(uint8_t *Data, uint8_t Len)
{
    if (UART_Ch0_Get_TX_Busy_Flag() == 0U)
    {
        stUARTCtr0.u8UARTCount = 1U;
        stUARTCtr0.u8UARTLEN = Len;
        stUARTCtr0.u8UARTTXBusyFlag = 1U;
        stUARTCtr0.pu8UARTDataBuf = Data;
        RLN30LUTDR = stUARTCtr0.pu8UARTDataBuf[0U];
    }
}
void UART_Ch1_Send_Multiple_Byte(uint8_t *Data, uint8_t Len)
{
    if (UART_Ch1_Get_TX_Busy_Flag() == 0U)
    {
        stUARTCtr1.u8UARTCount = 1U;
        stUARTCtr1.u8UARTLEN = Len;
        stUARTCtr1.u8UARTTXBusyFlag = 1U;
        stUARTCtr1.pu8UARTDataBuf = Data;
        RLN31LUTDR = stUARTCtr1.pu8UARTDataBuf[0U];
    }
}
void UART_Ch2_Send_Multiple_Byte(uint8_t *Data, uint8_t Len)
{
    if (UART_Ch2_Get_TX_Busy_Flag() == 0U)
    {
        stUARTCtr2.u8UARTCount = 1U;
        stUARTCtr2.u8UARTLEN = Len;
        stUARTCtr2.u8UARTTXBusyFlag = 1U;
        stUARTCtr2.pu8UARTDataBuf = Data;
        RLN32LUTDR = stUARTCtr2.pu8UARTDataBuf[0U];
    }
}
void UART_Ch3_Send_Multiple_Byte(uint8_t *Data, uint8_t Len)
{
    if (UART_Ch3_Get_TX_Busy_Flag() == 0U)
    {
        stUARTCtr3.u8UARTCount = 1U;
        stUARTCtr3.u8UARTLEN = Len;
        stUARTCtr3.u8UARTTXBusyFlag = 1U;
        stUARTCtr3.pu8UARTDataBuf = Data;
        RLN33LUTDR = stUARTCtr3.pu8UARTDataBuf[0U];
    }
}

void UART_CH0_RX_ISR(void)
{
    /*If no error is detected*/
    if (stUARTCh0Cfg.pfnUARTReadMsgCallBack)
    {
        stUARTCh0Cfg.pfnUARTReadMsgCallBack(RLN30LURDR);
    }
}
void UART_CH1_RX_ISR(void)
{
    /*If no error is detected*/
    if (stUARTCh1Cfg.pfnUARTReadMsgCallBack)
    {
        stUARTCh1Cfg.pfnUARTReadMsgCallBack(RLN31LURDR);
    }
}
void UART_CH2_RX_ISR(void)
{
    /*If no error is detected*/
    if (stUARTCh2Cfg.pfnUARTReadMsgCallBack)
    {
        stUARTCh2Cfg.pfnUARTReadMsgCallBack(RLN32LURDR);
    }
}
void UART_CH3_RX_ISR(void)
{
    /*If no error is detected*/
    if (stUARTCh3Cfg.pfnUARTReadMsgCallBack)
    {
        stUARTCh3Cfg.pfnUARTReadMsgCallBack(RLN33LURDR);
    }
}

void UART_CH0_TX_ISR(void)
{
    if (stUARTCtr0.u8UARTCount < stUARTCtr0.u8UARTLEN)
    {
        RLN30LUTDR = stUARTCtr0.pu8UARTDataBuf[stUARTCtr0.u8UARTCount++];
    }
    else
    {
        stUARTCtr0.u8UARTTXBusyFlag = 0U;
        if (stUARTCh0Cfg.pfnUARTConfirmCallBack)
        {
            stUARTCh0Cfg.pfnUARTConfirmCallBack();
        }
    }
}
void UART_CH1_TX_ISR(void)
{
    if (stUARTCtr1.u8UARTCount < stUARTCtr1.u8UARTLEN)
    {
        RLN31LUTDR = stUARTCtr1.pu8UARTDataBuf[stUARTCtr1.u8UARTCount++];
    }
    else
    {
        stUARTCtr1.u8UARTTXBusyFlag = 0U;
        if (stUARTCh1Cfg.pfnUARTConfirmCallBack)
        {
            stUARTCh1Cfg.pfnUARTConfirmCallBack();
        }
    }
}
void UART_CH2_TX_ISR(void)
{
    if (stUARTCtr2.u8UARTCount < stUARTCtr2.u8UARTLEN)
    {
        RLN32LUTDR = stUARTCtr2.pu8UARTDataBuf[stUARTCtr2.u8UARTCount++];
    }
    else
    {
        stUARTCtr2.u8UARTTXBusyFlag = 0U;
        if (stUARTCh2Cfg.pfnUARTConfirmCallBack)
        {
            stUARTCh2Cfg.pfnUARTConfirmCallBack();
        }
    }
}
void UART_CH3_TX_ISR(void)
{
    if (stUARTCtr3.u8UARTCount < stUARTCtr3.u8UARTLEN)
    {
        RLN33LUTDR = stUARTCtr3.pu8UARTDataBuf[stUARTCtr3.u8UARTCount++];
    }
    else
    {
        stUARTCtr3.u8UARTTXBusyFlag = 0U;
        if (stUARTCh3Cfg.pfnUARTConfirmCallBack)
        {
            stUARTCh3Cfg.pfnUARTConfirmCallBack();
        }
    }
}
/***********************************************************************/
/***********************************************************************/
/***********************************************************************/
//#define UART_CH_SEL UART_RLIN30
#define UART_CH_SEL UART_RLIN32

/*****所有引脚相关根据实际引脚自行添加****/
/*****所有引脚相关根据实际引脚自行添加****/
/*****所有引脚相关根据实际引脚自行添加****/

/*-------------------------------------------------------------------------
* Function Name  : Uart_ConfigOperationMode
* Description    : 配置串口工作模式
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Uart_ConfigOperationMode(void)
{
    // SCI0SR2_AMAP = 1;
    // SCI0ACR1_RXEDGIE = 0; /* RXEDGIF interrupt requests disabled */
    // SCI0ACR1_BERRIE = 0;  /* BERRIF interrupt requests disabled */
    // SCI0ACR1_BKDIE = 0;   /* BKDIF interrupt requests disabled */

    // SCI0SR2_AMAP = 0;
    // SCI0CR1_M = 0;
    // SCI0CR1_WAKE = 0;
    // SCI0CR1_PE = 0;
}

/*-------------------------------------------------------------------------
* Function Name  : Uart_GetRxLevel
* Description    : 提取RX 管脚电平
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
unsigned char Uart_GetRxLevel(void)
{
    // return PTS_PTS0;
    return GPIO_OUT_PORT00_PIN03;
}

/*-------------------------------------------------------------------------
* Function Name  : Uart_ClearRxFullFlag
* Description    : 清除串口接收完成标志位
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Uart_ClearRxFullFlag(void)
{
    //SCI0SR1_RDRF = 1;

    switch (UART_CH_SEL)
    {
    case UART_RLIN30:
    {
        R_DEV_IntClearFlag(R_DEV_INT_RLIN30R);
        break;
    }
    case UART_RLIN31:
    {
        R_DEV_IntClearFlag(R_DEV_INT_RLIN31R);
        break;
    }
    case UART_RLIN32:
    {
        R_DEV_IntClearFlag(R_DEV_INT_RLIN32R);
        break;
    }
    case UART_RLIN33:
    {
        R_DEV_IntClearFlag(R_DEV_INT_RLIN33R);
        break;
    }
    default:
        break;
    }
}

/*-------------------------------------------------------------------------
* Function Name  : Uart_SetBaudrate
* Description    : 设置串口波特率
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void UART_Read_ISR(uint16_t u16UARTData)
{
    Kwp2000_AscRxInterrupt();//包含一下，然后打开即可
}

void Uart_SetBaudrate(unsigned long xBaudrate_u32)
{
    // unsigned long fModule_u32;
    // unsigned char IREN;

    // fModule_u32 = BOARD_TMBCLK_HZ;

    // SCI0SR2_AMAP = 0;

    // SCI0BDH_TNP = 3;
    // SCI0BDH_IREN = 0; /* IR disabled  */
    // /* set ASC registers for new baudrate */
    // IREN = SCI0BDH_IREN;
    // SCI0BD_SBR = fModule_u32 / ((IREN + 1) * 16) / xBaudrate_u32;

    UART_Channel_Config_st_t stUARTConfig;

    stUARTConfig.u32UARTChEn = 1U;
    stUARTConfig.u32UARTbps = xBaudrate_u32;
    stUARTConfig.pfnUARTConfirmCallBack = 0U;
    stUARTConfig.pfnUARTReadMsgCallBack = UART_Read_ISR;

    UART_Init(UART_CH_SEL, &stUARTConfig);
}

/*-------------------------------------------------------------------------
* Function Name  : Uart_SetRxGpio
* Description    : 设置接收的GPIO
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Uart_SetRxGpio(void)
{
    // DDRS_DDRS0 = 0;
}

/*-------------------------------------------------------------------------
* Function Name  : Uart_SetTxGpio
* Description    : 设置发送的GPIO
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Uart_SetTxGpio(void)
{
    //  DDRS_DDRS1 = 1;
}

/*-------------------------------------------------------------------------
* Function Name  : Uart_EnableRx
* Description    : 使能接收
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Uart_EnableRx(void)
{
    switch (UART_CH_SEL)
    {
    case UART_RLIN30:
    {
        RLN30LUOER |= 0X02U;
        break;
    }
    case UART_RLIN31:
    {
        RLN31LUOER |= 0X02U;
        break;
    }
    case UART_RLIN32:
    {
        RLN32LUOER |= 0X02U;
        break;
    }
    case UART_RLIN33:
    {
        RLN33LUOER |= 0X02U;
        break;
    }
    default:
        break;
    }
}

/*-------------------------------------------------------------------------
* Function Name  : Uart_DisableRx
* Description    : 禁止接收
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Uart_DisableRx(void)
{
    switch (UART_CH_SEL)
    {
    case UART_RLIN30:
    {
        RLN30LUOER &= 0XFDU;
        break;
    }
    case UART_RLIN31:
    {
        RLN31LUOER &= 0XFDU;
        break;
    }
    case UART_RLIN32:
    {
        RLN32LUOER &= 0XFDU;
        break;
    }
    case UART_RLIN33:
    {
        RLN33LUOER &= 0XFDU;
        break;
    }
    default:
        break;
    }
}

/*-------------------------------------------------------------------------
* Function Name  : TJA1021_Enable
* Description    : 使能收发器
* Input          :
* Output         : None
* Return         : None
* onther         : 1 使能 ; 0 关闭
--------------------------------------------------------------------------*/
void TJA1021_Enable(unsigned char state)
{

    // DDRR_DDRR3 = 1;
    // PTR_PTR3 = state;
    LIN_SLP_N_MCU = state;
}

/*-------------------------------------------------------------------------
* Function Name  : Uart_EnableTx
* Description    : 使能发
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Uart_EnableTx(void)
{
    switch (UART_CH_SEL)
    {
    case UART_RLIN30:
    {
        RLN30LUOER |= 0X01U;
        break;
    }
    case UART_RLIN31:
    {
        RLN31LUOER |= 0X01U;
        break;
    }
    case UART_RLIN32:
    {
        RLN32LUOER |= 0X01U;
        break;
    }
    case UART_RLIN33:
    {
        RLN33LUOER |= 0X01U;
        break;
    }
    default:
        break;
    }
}

/*-------------------------------------------------------------------------
* Function Name  : Uart_ClearAllErrorFlag
* Description    : 清除所有的错误标志位
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Uart_ClearAllErrorFlag(void)
{
    // unsigned long xTmp_u32;
    // xTmp_u32 = SCI0SR1;
    // xTmp_u32 = SCI0DRL;

    switch (UART_CH_SEL)
    {
    case UART_RLIN30:
    {
        RLN30LEST = 0X0U;
        break;
    }
    case UART_RLIN31:
    {
        RLN31LEST = 0X0U;
        break;
    }
    case UART_RLIN32:
    {
        RLN32LEST = 0X0U;
        break;
    }
    case UART_RLIN33:
    {
        RLN33LEST = 0X0U;
        break;
    }
    default:
        break;
    }
}

/*-------------------------------------------------------------------------
* Function Name  : Uart_SetData
* Description    : 写串口数据
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Uart_SetData(unsigned char xBuffer_pu8)
{

    switch (UART_CH_SEL)
    {
    case UART_RLIN30:
    {
        RLN30LUTDR = xBuffer_pu8;
        break;
    }
    case UART_RLIN31:
    {
        RLN31LUTDR = xBuffer_pu8;
        break;
    }
    case UART_RLIN32:
    {
        RLN32LUTDR = xBuffer_pu8;
        break;
    }
    case UART_RLIN33:
    {
        RLN33LUTDR = xBuffer_pu8;
        break;
    }
    default:
        break;
    }
}

/*-------------------------------------------------------------------------
* Function Name  : Uart_GetData
* Description    : 读取串口数据
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
unsigned short Uart_GetData(void)
{
    unsigned short wTemp_u08 = 0;

    switch (UART_CH_SEL)
    {
    case UART_RLIN30:
    {
        wTemp_u08 = RLN30LURDR;
        break;
    }
    case UART_RLIN31:
    {
        wTemp_u08 = RLN31LURDR;
        break;
    }
    case UART_RLIN32:
    {
        wTemp_u08 = RLN32LURDR;
        break;
    }
    case UART_RLIN33:
    {
        wTemp_u08 = RLN33LURDR;
        break;
    }
    default:
        break;
    }
    return wTemp_u08;
}

/*-------------------------------------------------------------------------
* Function Name  : Uart_DisableReceiveIsrReq
* Description    : 禁止接收中断
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Uart_DisableReceiveIsrReq(void)
{
    switch (UART_CH_SEL)
    {
    case UART_RLIN30:
    {
        R_DEV_IntEnable(R_DEV_INT_RLIN30R, 0U);
        break;
    }
    case UART_RLIN31:
    {
        R_DEV_IntEnable(R_DEV_INT_RLIN31R, 0U);
        break;
    }
    case UART_RLIN32:
    {
        R_DEV_IntEnable(R_DEV_INT_RLIN32R, 0U);
        break;
    }
    case UART_RLIN33:
    {
        R_DEV_IntEnable(R_DEV_INT_RLIN33R, 0U);
        break;
    }
    default:
        break;
    }
}

/*-------------------------------------------------------------------------
* Function Name  : Uart_EnableReceiveIsrReq
* Description    : 使能接收中断
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Uart_EnableReceiveIsrReq(void)
{
    switch (UART_CH_SEL)
    {
    case UART_RLIN30:
    {
        R_DEV_IntEnable(R_DEV_INT_RLIN30R, 1U);
        break;
    }
    case UART_RLIN31:
    {
        R_DEV_IntEnable(R_DEV_INT_RLIN31R, 1U);
        break;
    }
    case UART_RLIN32:
    {
        R_DEV_IntEnable(R_DEV_INT_RLIN32R, 1U);
        break;
    }
    case UART_RLIN33:
    {
        R_DEV_IntEnable(R_DEV_INT_RLIN33R, 1U);
        break;
    }
    default:
        break;
    }
}

/*-------------------------------------------------------------------------
* Function Name  : Uart_DisableTxInterrupt
* Description    : 禁止发送中断
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Uart_DisableTxInterrupt(void)
{

    switch (UART_CH_SEL)
    {
    case UART_RLIN30:
    {
        R_DEV_IntEnable(R_DEV_INT_RLIN30T, 0U);
        break;
    }
    case UART_RLIN31:
    {
        R_DEV_IntEnable(R_DEV_INT_RLIN31T, 0U);
        break;
    }
    case UART_RLIN32:
    {
        R_DEV_IntEnable(R_DEV_INT_RLIN32T, 0U);
        break;
    }
    case UART_RLIN33:
    {
        R_DEV_IntEnable(R_DEV_INT_RLIN33T, 0U);
        break;
    }
    default:
        break;
    }
}
