
/*#include "bt_pwm_driver.h"*/
#include "TimerB.h"

#include "BackgroundLight.h"
/*#include "DriverPWM.h"*/

#include "BGLInterface.h"
BL_STATE_PARA BLStatePara;
uint16_t CurLcdBackLightCycle;
/*Comfort 指针仪表
 类型 白天 傍晚 夜晚
 背光等级 不同仪表配置不同
*/

const uint16_t BackLightValue_TFT_Default[BL_TYPE_TOTAL][BL_LV_TOTAL] =
{
    /*0    1    2    3    4    5    6    7    8    9   10   11   12   13   14    15*/
    {50, 113, 177, 240, 303, 368, 430, 493, 557, 620, 683, 747, 810, 873, 937, 1000},
    { 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,    0},
    { 3,   8,  15,  23,  43,  68,  98, 130, 170, 212, 267, 323, 385, 450, 523,  600},

};

/*¡°BackLightValue_DIAL¡± corresponds to ¡°Pointer¡±*/
const uint16_t BackLightValue_DIAL_Default[BL_TYPE_TOTAL][BL_LV_TOTAL] =
{
    /*0    1    2    3    4    5    6    7    8    9   10   11   12   13   14    15*/
    {50, 113, 177, 240, 303, 368, 430, 493, 557, 620, 683, 747, 810, 873, 937, 1000},
    { 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,    0},
    { 3,   8,  15,  23,  43,  68,  98, 130, 170, 212, 267, 323, 385, 450, 523,  600},

};

/*Comfort 断码仪表
 主题 不同仪表配置不同
 类型 白天 傍晚 夜晚
 背光等级 不同仪表配置不同
*/
const uint16_t BackLightValue_R_Default[BL_THEME_TOTAL][BL_TYPE_TOTAL][BL_LV_TOTAL] =
{
    {
        {20, 70, 140, 210, 280, 350, 400, 470, 540, 610, 680, 680},
        { 0,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0},
        { 0,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}
    },
    {
        {10, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 100},
        { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   0,   0},
        { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   0,   0}
    },
    {
        {5, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 50},
        {0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
        {0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0}
    }
};

const uint8_t PwmChannel[BACKLIGHT_TOTAL] =
    /*  TFT             表盘           燃油          水温         水温背光*/
{TIMERB_2_CH1, TIMERB_0_CH15, TIMERB_1_CH15, TIMERB_1_CH10, TIMERB_2_CH7};
//{255, 255, 255, TIMERB_1_CH10, 255};

/**@brief Back Ground  Light Config function
 * @author TYW
 * @param[in] BGLType  背光类型
 * @param[in] DutyVal  占空比
 * @since 1.0.0.0
 */
void BGLPwm_Config(uint8_t BGLType, uint16_t DutyVal)
{
    /*Pwm_Config(2, CurLcdBackLightCycle, DutyVal);*/
    if (PwmChannel[BGLType] != 255u)
    {
        TimerB_PWM_Channel_Duty_Set(PwmChannel[BGLType], DutyVal);
    }
    else
    {
        ;
    }
}
/**@brief Back Ground  Light Stop function
 * @author TYW
 * @param[in] BGLType 背光类型
 * @since 1.0.0.0
 */

void BGLPwm_Stop(uint8_t BGLType)
{

    if (PwmChannel[BGLType] != 255u)
    {
        TimerB_PWM_Channel_Stop(PwmChannel[BGLType]);
    }
    else
    {
        ;
    }
}
/**@brief Back Ground  Light Start function
 * @author TYW
 * @param[in] BGLType 背光类型
 * @since 1.0.0.0
 */
void BGLPwm_Start(uint8_t BGLType)
{

    if (PwmChannel[BGLType] != 255u)
    {
        TimerB_PWM_Channel_Start(PwmChannel[BGLType]);
    }
    else
    {
        ;
    }
}
/**@brief Back Ground  Light Schedu function
 * @author TYW
 * @param[in] BGLTheme 背光主题
 * @param[in] BGLType  背光类型
 * @param[in] BGLLvl   背光等级
 * @since 1.0.0.0
 */
BL_USER_PARA BL_Tmp_PARA;
uint8_t testBL;
void BackLightSchedu(uint8_t BGLPowerSt, uint8_t WakeFlag)
{

    CurLcdBackLightCycle = BACKLIGHTCYCLE;
    BL_Tmp_PARA.BL_User_PowerSt = BGLPowerSt;
    BL_Tmp_PARA.BL_User_WakeFlag = WakeFlag;
    BLStatePara.BL_User_Lvl_Total = BL_LV_TOTAL;
    BLStatePara.BL_User_NTC_AD_MAX = NTC_AD_MAX;
    BLStatePara.BL_User_effect = testBL;
    if (BLStatePara.BL_User_Lvl < BL_LV_TOTAL)
    {
        BL_Tmp_PARA.BL_User_TFTDuty = BackLightValue_TFT_Default[BLStatePara.BL_User_Type][BLStatePara.BL_User_Lvl];
        BL_Tmp_PARA.BL_User_GaugesDuty = BackLightValue_DIAL_Default[BLStatePara.BL_User_Type][BLStatePara.BL_User_Lvl];
        // BL_Tmp_PARA.BL_User_RDuty = BackLightValue_R_Default[BLStatePara.BL_User_Theme][BLStatePara.BL_User_Type][BLStatePara.BL_User_Lvl];
        // BL_Tmp_PARA.BL_User_GDuty = BackLightValue_G_Default[BLStatePara.BL_User_Theme][BLStatePara.BL_User_Type][BLStatePara.BL_User_Lvl];
        // BL_Tmp_PARA.BL_User_BDuty = BackLightValue_B_Default[BLStatePara.BL_User_Theme][BLStatePara.BL_User_Type][BLStatePara.BL_User_Lvl];

        BL_Tmp_PARA.BL_User_TFTDuty_MIN = BackLightValue_TFT_Default[BLStatePara.BL_User_Type][BL_LV_MIN];
        BL_Tmp_PARA.BL_User_GaugesDuty_MIN = BackLightValue_DIAL_Default[BLStatePara.BL_User_Type][BL_LV_MIN];
        // BL_Tmp_PARA.BL_User_RDuty_MIN = BackLightValue_R_Default[BLStatePara.BL_User_Theme][BLStatePara.BL_User_Type][BL_LV_MIN];
        // BL_Tmp_PARA.BL_User_GDuty_MIN = BackLightValue_G_Default[BLStatePara.BL_User_Theme][BLStatePara.BL_User_Type][BL_LV_MIN];
        // BL_Tmp_PARA.BL_User_BDuty_MIN = BackLightValue_B_Default[BLStatePara.BL_User_Theme][BLStatePara.BL_User_Type][BL_LV_MIN];
    }
    else
    {
        ;
    }
#if COLOR_LED_DEBUG
    DebugBGLPara();
#endif
    BackLightDeal(BL_Tmp_PARA, BLStatePara);
}

/**@brief Get Ground  Light Theme function
 * @author TYW
 * @param[in] BGLTheme 背光主题
 * @since 1.0.0.0
 */
void GetBGLTheme(uint8_t BGLTheme)
{
    BLStatePara.BL_User_Theme = BGLTheme;
}

/**@brief Get Ground  Light Type function
 * @author TYW
 * @param[in] BGLType 背光类型 白天 傍晚 晚上
 * @since 1.0.0.0
 */
void GetBGLType(uint8_t BGLType)
{
    BLStatePara.BL_User_Type = BGLType;
}

/**@brief Get Ground  Light Level function
 * @author TYW
 * @param[in] BGLTheme 背光等级
 * @param[in] PositionLight 小灯触发 1是小灯触发 0是关闭
 * @since 1.0.0.0
 */
void GetBGLLvl(uint8_t BGLLvl, uint8_t FunPositionLight)
{
    uint8_t tmpLvl;
    tmpLvl = 0u;
    if (FunPositionLight)
    {
        tmpLvl = ProcessLittleLight(BGLLvl);
    }
    else
    {
        tmpLvl = BGLLvl;
    }
    BLStatePara.BL_User_Lvl = tmpLvl;
}
/**@brief Get Ground  Light Little Light function
 * @author TYW
 * @param[in] BGLTheme 背光等级
 * @since 1.0.0.0
 */
uint8_t ProcessLittleLight(uint8_t BGLLvl)
{
    uint16_t tmpLvl;
    tmpLvl = BGLLvl;
    tmpLvl = tmpLvl * POSITION_LIGHT_PERCENT / 100u;
    if ((uint8_t)tmpLvl < BL_LV_2)
    {
        tmpLvl = BL_LV_2;
    }
    else
    {
        ;
    }
    return (uint8_t)tmpLvl;
}
/**@brief Get Ground  Light NTCval function
 * @author TYW
 * @param[in] BGLNTCADVal 热敏电阻电压值
 * @since 1.0.0.0
 */
void GetBGLNTCVol(uint16_t BGLNTCVol)
{
    BLStatePara.BL_User_NTC_AD = BGLNTCVol;
}
/**@brief Debug Ground  Light function
 * @author TYW
 * @调试背光用传递占空比参数用于调整背后亮度和颜色
 * @since 1.0.0.0
 */
#if COLOR_LED_DEBUG
uint16_t DebugTFTDuty;
uint16_t DebugGaugesDuty;
uint16_t DebugRDuty;
uint16_t DebugGDuty;
uint16_t DebugBDuty;
void DebugBGLPara(void)
{

    BL_Tmp_PARA.BL_User_TFTDuty = DebugTFTDuty;
    BL_Tmp_PARA.BL_User_GaugesDuty = DebugGaugesDuty;
    BL_Tmp_PARA.BL_User_RDuty = DebugRDuty;
    BL_Tmp_PARA.BL_User_GDuty = DebugGDuty;
    BL_Tmp_PARA.BL_User_BDuty = DebugBDuty;
}
/**@brief Debug Ground  Light function
 * @author TYW
 * @param[in] TestTFTDuty TFT占空比
 * @since 1.0.0.0
 */
void SetTFTDebugPara(uint16_t TestTFTDuty)
{
    DebugTFTDuty = TestTFTDuty;
}
/**@brief Debug Ground  Light function
 * @author TYW
 * @param[in] TestGaugesDuty Gauges占空比
 * @since 1.0.0.0
 */
void SetGaugesDebugPara(uint16_t TestGaugesDuty)
{
    DebugGaugesDuty = TestGaugesDuty;
}
/**@brief Debug Ground  Light function
 * @author TYW
 * @param[in] TestRDuty RED占空比
 * @since 1.0.0.0
 */
void SetRDebugPara(uint16_t TestRDuty)
{
    DebugRDuty = TestRDuty;
}
/**@brief Debug Ground  Light function
 * @author TYW
 * @param[in] TestGDuty Green占空比
 * @since 1.0.0.0
 */
void SetGDebugPara(uint16_t TestGDuty)
{
    DebugGDuty = TestGDuty;
}
/**@brief Debug Ground  Light function
 * @author TYW
 * @param[in] TestBDuty Blue占空比
 * @since 1.0.0.0
 */
void SetGDebugPara(uint16_t TestBDuty)
{
    DebugBDuty = TestBDuty;
}
#endif