#include "Common_Interface.h"
#include "CAN_Communication_Matrix.h"
#include "CAN_Lib.h"
#include "Data_VehicleSpeed.h"
#include "Data_EngineSpeed.h"
#include "System_Monitor.h"
#include "GaugesInterface.h"
#include "Gauges.h"
#include "dr7f701441.dvf.h"
#include "GPIO.h"
#include "Data_Voltmeter.h"

#include "Line_in.h"

#include "Maintenance.h"
#include "Menu.h"
#include "GUI.h"

#include "Emulated_EEPROM.h"
#include "Watchdog.h"
#include "UDS_Common.h"
#include "kwp2000_service.h"

/*修饰变量static*/

/*ig on off时间线*/
static uint32_t PowerIgnOnTimeLine;
static uint32_t PowerIgnOffTimeLine;

static COMMON_PowerStatus_t PowerSts; /*1 ON ;  0 OFF*/
static uint16_t Act_V_Speed;          /*实际值,十倍的*/
static uint16_t Act_E_Speed;          /*实际值*/
static uint16_t Disp_V_Speed;         /*显示值,十倍的*/
static uint16_t Disp_E_Speed;         /*显示值*/

/*数据有效 1 ;数据无效 0 /0xff */
static DataValid_t PowerSts_Valid;
static DataValid_t Act_V_Speed_Valid;
static DataValid_t Act_E_Speed_Valid;
static DataValid_t Disp_V_Speed_Valid;
static DataValid_t Disp_E_Speed_Valid;

static DataValid_t Set_18EF1718_Msg_Sta;

static void Common_Set_Act_V_Speed(uint16_t Val);
static void Common_Set_Act_E_Speed(uint16_t Val);
static void Common_Set_Disp_V_Speed(uint16_t Val);
static void Common_Set_Disp_E_Speed(uint16_t Val);

static void Common_Set_Act_V_Speed_Valid(DataValid_t Val);
static void Common_Set_Act_E_Speed_Valid(DataValid_t Val);
static void Common_Set_Disp_V_Speed_Valid(DataValid_t Val);
static void Common_Set_Disp_E_Speed_Valid(DataValid_t Val);

static uint16_t SysRollingCounter;

static uint8_t CanFirstEvent[ID_TOTAL_MAX];
static void Individual_ECU_Communication(void);

extern _EOL_K_LINE_SET K_Line_Set;

/**/
static uint32_t User_FDJYLQQ_Time;
static uint32_t User_RYLQQ_Time;
static uint32_t User_BSXY_Time;
static uint32_t User_CSQY_Time;
static uint32_t User_LHQY_Time;
static uint32_t User_KQGZJ_Time;
static uint32_t User_DLZXY_Time;
static uint32_t User_LT_Time;

static uint32_t CRUISE_1_Time;
static uint32_t CRUISE_STUDY_Time;
static uint32_t CRUISE_SLD1_Time;
static uint32_t CRUISE_SLD2_Time;

static uint32_t VolWarning_Time;

static uint32_t LOW_VOLTAGE_TIME1;
static uint32_t LOW_VOLTAGE_TIME2;
static uint32_t HIGH_VOLTAGE_TIME1;
static uint32_t HIGH_VOLTAGE_TIME2;

static uint32_t HIGH_VOLTAGE;
static uint32_t LOW_VOLTAGE;

static uint32_t TPMS_TEST_OFF_TIME;
static uint32_t Menu_FacDea_Time;
static uint32_t OIL_PRESSURE_Time;

uint32_t UdsCanIDSta;

#pragma ghs section bss=".myNonInitArea"
static uint32_t Menu_Off_Time;
#pragma ghs section bss=default

/*每次唤醒调用*/
void Common_DataInit(void)
{
    PowerSts = COMMON_POWER_UNKNOW;
    Act_V_Speed = 0xffffu;
    Act_E_Speed = 0xffffu;
    Disp_V_Speed = 0xffffu;
    Disp_E_Speed = 0xffffu;

    PowerSts_Valid = COMMON_Valid_UNKNOW;
    Act_V_Speed_Valid = COMMON_Valid_UNKNOW;
    Act_E_Speed_Valid = COMMON_Valid_UNKNOW;
    Disp_V_Speed_Valid = COMMON_Valid_UNKNOW;
    Disp_E_Speed_Valid = COMMON_Valid_UNKNOW;
    PowerIgnOnTimeLine = 0x0ul;
    PowerIgnOffTimeLine = 0x0ul;

    /**/
    User_FDJYLQQ_Time = 0x00u;
    User_RYLQQ_Time = 0x00u;
    User_BSXY_Time = 0x00u;
    User_CSQY_Time = 0x00u;
    User_LHQY_Time = 0x00u;
    User_KQGZJ_Time = 0x00u;
    User_DLZXY_Time = 0x00u;
    User_LT_Time = 0x00u;

    CRUISE_1_Time = 0x00u;
    CRUISE_STUDY_Time = 0x00u;
    CRUISE_SLD1_Time = 0x00u;
    CRUISE_SLD2_Time = 0x00u;

    VolWarning_Time = 0x00u;
    LOW_VOLTAGE_TIME1 = 0x00u;
    LOW_VOLTAGE_TIME2 = 0x00u;
    HIGH_VOLTAGE_TIME1 = 0x00u;
    HIGH_VOLTAGE_TIME2 = 0x00u;
    HIGH_VOLTAGE = 0x0u;
    LOW_VOLTAGE = 0x0u;

    TPMS_TEST_OFF_TIME = 0x00u;
    Menu_FacDea_Time = 0x00u;
    OIL_PRESSURE_Time = 0x00u;
    Set_18EF1718_Msg_Sta = COMMON_InValid;
    //Menu_Off_Time = 0x00u;
    UdsCanIDSta = 0x00u;
}

/*以下由各个处理模块按需调用*/
/*使用数据之前,需要先判断数据是否有效,如果无效,则不可以使用*/

COMMON_PowerStatus_t Common_Get_IG_Sts(void)
{
    return PowerSts;
}

uint16_t Common_Get_Act_V_Speed(void)
{
    return Act_V_Speed;
}
uint16_t Common_Get_Act_E_Speed(void)
{
    return Act_E_Speed;
}
uint16_t Common_Get_Disp_V_Speed(void)
{
    return Disp_V_Speed;
}
uint16_t Common_Get_Disp_E_Speed(void)
{
    return Disp_E_Speed;
}

/*获取超速报警状态*/
uint8_t Common_Get_OverSpeed_Status(void)
{
    uint8_t OverSpeedStatus = 0u;
    uint16_t DispVSpeed = 0u;
    DispVSpeed = Common_Get_Disp_V_Speed();

    if (DispVSpeed >= 1000u)
    {
        OverSpeedStatus = 1u;
    }
    else if (DispVSpeed <= 960u)
    {
        OverSpeedStatus = 0u;
    }

    return OverSpeedStatus;
}

uint8_t Common_Get_OverSpeedLine_Status(void)
{
    uint8_t OverSpeedStatus = 0u;
    uint16_t DispVSpeed = 0u;
    uint16_t DataOverSpeedValue = 0u;

    DataOverSpeedValue = K_Line_Set.K_Line_LID44;
    DataOverSpeedValue *= 10u;

    DispVSpeed = Common_Get_Disp_V_Speed();

    if (K_Line_Set.K_Line_LID44 != 0xFF)
    {
        if (DispVSpeed >= (DataOverSpeedValue + 20))
        {
            OverSpeedStatus = 1u;
        }
        else if (DispVSpeed <= DataOverSpeedValue)
        {
            OverSpeedStatus = 0u;
        }
    }
    else
    {
        OverSpeedStatus = 0u;
    }

    return OverSpeedStatus;
}

static void Common_Set_IG_Sts(COMMON_PowerStatus_t Val)
{
    PowerSts = Val;
}
static void Common_Set_Act_V_Speed(uint16_t Val)
{
    Act_V_Speed = Val;
}
static void Common_Set_Act_E_Speed(uint16_t Val)
{
    Act_E_Speed = Val;
}
static void Common_Set_Disp_V_Speed(uint16_t Val)
{
    Disp_V_Speed = Val;
}
static void Common_Set_Disp_E_Speed(uint16_t Val)
{
    Disp_E_Speed = Val;
}

DataValid_t Common_Get_IG_Sts_Valid(void)
{
    return PowerSts_Valid;
}
DataValid_t Common_Get_Act_V_Speed_Valid(void)
{
    return Act_V_Speed_Valid;
}
DataValid_t Common_Get_Act_E_Speed_Valid(void)
{
    return Act_E_Speed_Valid;
}
DataValid_t Common_Get_Disp_V_Speed_Valid(void)
{
    return Disp_V_Speed_Valid;
}
DataValid_t Common_Get_Disp_E_Speed_Valid(void)
{
    return Disp_E_Speed_Valid;
}

static void Common_Set_IG_Sts_Valid(DataValid_t Val)
{
    PowerSts_Valid = Val;
}
static void Common_Set_Act_V_Speed_Valid(DataValid_t Val)
{
    Act_V_Speed_Valid = Val;
}
static void Common_Set_Act_E_Speed_Valid(DataValid_t Val)
{
    Act_E_Speed_Valid = Val;
}
static void Common_Set_Disp_V_Speed_Valid(DataValid_t Val)
{
    Disp_V_Speed_Valid = Val;
}
static void Common_Set_Disp_E_Speed_Valid(DataValid_t Val)
{
    Disp_E_Speed_Valid = Val;
}

/*2MS任务*/
static uint16_t wbyTest = 0;
void Common_Input_Para(void)
{
    /*    if (SYS_OPR_STAT_IGN_ON)
        {*/
    uint32_t V_Speed_Convert = 0ul;
    uint32_t u32IG_ON_Timer = 0u;
    uint16_t OilValue = 0u; /*机油压力数值*/
    uint32_t EBC2_Speed_Value = 0u;
    uint8_t LineStatus1 = 0u;
    uint8_t LineStatus2 = 0u;

    u32IG_ON_Timer = Common_GetIgnOnTime();

    if (SYS_OPR_STAT_IGN_ON)
    {
        Common_Set_IG_Sts(COMMON_POWER_ON);
        Common_Set_IG_Sts_Valid(COMMON_Valid);

        OilValue = Common_Get_Disp_E_Speed();

        //车速
        wbyTest = Speed_Get_Display_Value();
        Common_Set_Disp_V_Speed(wbyTest);
        Common_Set_Act_V_Speed(Speed_Get_ActualValue());

        if (Speed_Get_Valid())
        {
            Common_Set_Act_V_Speed_Valid(COMMON_Valid);
            Common_Set_Disp_V_Speed_Valid(COMMON_Valid);
        }
        else
        {
            Common_Set_Act_V_Speed_Valid(COMMON_InValid);
            Common_Set_Disp_V_Speed_Valid(COMMON_InValid);
        }

        Common_Set_Act_E_Speed(RevSpeedManage(Tacho_Get_ActualValue()));

        PowerIgnOffTimeLine = 0ul;
        if (PowerIgnOnTimeLine < 0x7ffffffful)
        {
            PowerIgnOnTimeLine += 2u;
        }

        /*电压计报警时间*/
        if (Gui_Get_Voltmeter_DisplayMode() <= 3u)
        {
            if (VolWarning_Time <= 5100)
            {
                VolWarning_Time++;
            }
        }
        else
        {
            VolWarning_Time = 0;
        }

        /**/
        if (RTE_Read_KL15_Voltage() <= (23500 - 800)) /*A2*/
        {
            if (LOW_VOLTAGE_TIME1 <= 3500)
                LOW_VOLTAGE_TIME1++;
            else
                LOW_VOLTAGE = 1;
        }
        else
        {
            LOW_VOLTAGE_TIME1 = 0;
        }

        if (RTE_Read_KL15_Voltage() >= (25000 - 800)) /*A2*/
        {
            if (LOW_VOLTAGE_TIME2 <= 5000)
                LOW_VOLTAGE_TIME2++;
            else
                LOW_VOLTAGE = 0;
        }
        else
        {
            LOW_VOLTAGE_TIME2 = 0;
        }
        //
        if (RTE_Read_KL15_Voltage() >= (30400 - 800)) /*A2*/
        {
            if (HIGH_VOLTAGE_TIME1 <= 3500)
                HIGH_VOLTAGE_TIME1++;
            else
                HIGH_VOLTAGE = 1;
        }
        else
        {
            HIGH_VOLTAGE_TIME1 = 0;
        }

        if (RTE_Read_KL15_Voltage() <= (29400 - 800)) /*A2*/
        {
            if (HIGH_VOLTAGE_TIME2 <= 5000)
                HIGH_VOLTAGE_TIME2++;
            else
                HIGH_VOLTAGE = 0;
        }
        else
        {
            HIGH_VOLTAGE_TIME2 = 0;
        }

        /*胎压匹配3分钟有效计时*/
        if ((TPMS_TEST_OFF_TIME <= 90000u) && (User_set_Num.User_TpmsStatus == 2u))
        {
            TPMS_TEST_OFF_TIME++;
        }
        else
        {
            TPMS_TEST_OFF_TIME = 0;
        }

        /**/
        if (
            ((bCurMenuIDX >= _FAC_DSP_LEVEL3_2MENU_1) && (bCurMenuIDX <= _FAC_DSP_LEVEL3_2MENU_6)) ||
            ((bCurMenuIDX >= _DEA_DSP_LEVEL3_2MENU_1) && (bCurMenuIDX <= _DEA_DSP_LEVEL3_2MENU_6)) ||
            (MenuFlag.Menu_StaFlag != 0x01u)
        )
        {
            if (Menu_FacDea_Time < 15000u)
            {
                Menu_FacDea_Time++;
            }
            else
            {
                ;/*Do Nothing!*/
            }
        }

        /**/
        if ((OilValue > 350u) && (Line_In_Get_Status(LINE_IN_ENG_OIL) == LINE_IN_LOGIC_VALID))
        {
            if (OIL_PRESSURE_Time < 5000u)
            {
                OIL_PRESSURE_Time++;
            }
        }
        else
        {
            OIL_PRESSURE_Time = 0u;
        }
        /**/
        if ((State_Flag.User_FDJYLQQ_FLAG == 1) || (State_Flag.User_FDJYLQQ_FLAG == 2))
        {
            if (User_FDJYLQQ_Time < 30001)
                User_FDJYLQQ_Time++;
        }
        else
        {
            User_FDJYLQQ_Time = 0;
        }

        if ((State_Flag.User_RYLQQ_FLAG == 1) || (State_Flag.User_RYLQQ_FLAG == 2))
        {
            if (User_RYLQQ_Time < 30001)
                User_RYLQQ_Time++;
        }
        else
        {
            User_RYLQQ_Time = 0;
        }

        if ((State_Flag.User_BSXY_FLAG == 1) || (State_Flag.User_BSXY_FLAG == 2))
        {
            if (User_BSXY_Time < 30001)
                User_BSXY_Time++;
        }
        else
        {
            User_BSXY_Time = 0;
        }

        if ((State_Flag.User_CSQY_FLAG == 1) || (State_Flag.User_CSQY_FLAG == 2))
        {
            if (User_CSQY_Time < 30001)
                User_CSQY_Time++;
        }
        else
        {
            User_CSQY_Time = 0;
        }

        if ((State_Flag.User_LHQY_FLAG == 1) || (State_Flag.User_LHQY_FLAG == 2))
        {
            if (User_LHQY_Time < 30001)
                User_LHQY_Time++;
        }
        else
        {
            User_LHQY_Time = 0;
        }

        if ((State_Flag.User_KQGZJ_FLAG == 1) || (State_Flag.User_KQGZJ_FLAG == 2))
        {
            if (User_KQGZJ_Time < 30001)
                User_KQGZJ_Time++;
        }
        else
        {
            User_KQGZJ_Time = 0;
        }

        if ((State_Flag.User_DLZXY_FLAG == 1) || (State_Flag.User_DLZXY_FLAG == 2))
        {
            if (User_DLZXY_Time < 30001)
                User_DLZXY_Time++;
        }
        else
        {
            User_DLZXY_Time = 0;
        }

        if ((State_Flag.User_LT_FLAG == 1) || (State_Flag.User_LT_FLAG == 2))
        {
            if (User_LT_Time < 30001)
                User_LT_Time++;
        }
        else
        {
            User_LT_Time = 0;
        }

        /**/
        if (Get_ID_18FF4100_Sig_Cruise_VariableSLD_Disp() == 1u)
        {
            if (CRUISE_1_Time < 1501u)
            {
                CRUISE_1_Time++;
            }
        }
        else
        {
            CRUISE_1_Time = 0;
        }
        if (Get_ID_18FF4100_Sig_Cruise_VariableSLD_Disp() == 2u)
        {
            if (CRUISE_STUDY_Time < 1501u)
            {
                CRUISE_STUDY_Time++;
            }
        }
        else
        {
            CRUISE_STUDY_Time = 0;
        }
        if (Get_ID_18FF4100_Sig_Cruise_VariableSLD_Disp() == 3u)
        {
            if (CRUISE_SLD1_Time < 1501u)
            {
                CRUISE_SLD1_Time++;
            }
        }
        else
        {
            CRUISE_SLD1_Time = 0;
        }

        Menu_Off_Time = 0u;
    }
    else
    {
        OIL_PRESSURE_Time = 0u;
        PowerIgnOnTimeLine = 0ul;
        if (PowerIgnOffTimeLine < 0x7ffffffful)
        {
            PowerIgnOffTimeLine += 2u;
        }

        if (Menu_Off_Time <= 300000u )
        {
            Menu_Off_Time ++;
        }
        Common_Set_IG_Sts(COMMON_POWER_OFF);
        Common_Set_IG_Sts_Valid(COMMON_Valid);

        /*车转真实值OFF为0*/
        Common_Set_Act_V_Speed(0u);
        Common_Set_Act_E_Speed(0u);
        Common_Set_Disp_V_Speed(0u);
        Common_Set_Disp_E_Speed(0u);

        /*----*/
        User_FDJYLQQ_Time = 0x00u;
        User_RYLQQ_Time = 0x00u;
        User_BSXY_Time = 0x00u;
        User_CSQY_Time = 0x00u;
        User_LHQY_Time = 0x00u;
        User_KQGZJ_Time = 0x00u;
        User_DLZXY_Time = 0x00u;
        User_LT_Time = 0x00u;

        CRUISE_1_Time = 0x00u;
        CRUISE_STUDY_Time = 0x00u;
        CRUISE_SLD1_Time = 0x00u;
        CRUISE_SLD2_Time = 0x00u;

        VolWarning_Time = 0x00u;
        LOW_VOLTAGE_TIME1 = 0x00u;
        LOW_VOLTAGE_TIME2 = 0x00u;
        HIGH_VOLTAGE_TIME1 = 0x00u;
        HIGH_VOLTAGE_TIME2 = 0x00u;
        HIGH_VOLTAGE = 0x0u;
        LOW_VOLTAGE = 0x0u;

        Menu_FacDea_Time = 0u;
    }
}

void Set_Can18FF5510_FirstRecv_Event(void)
{
    CanFirstEvent[ID_CanMsg18FF5510_Msg_Count] = 1;
}

void Set_Can18FF2300_FirstRecv_Event(void)
{
    CanFirstEvent[ID_CanMsg18FF2300_Msg_Count] = 1;
}

uint8_t Get_CanFirstRecv_Event(uint8_t ID)
{
    return CanFirstEvent[ID];
}

void Common_RollingCounterAdd(void)
{
    SysRollingCounter++;
}

void Common_RollingCounterClear(void)
{
    SysRollingCounter = 0u;
}

uint16_t Common_ReadRollingCounter(void)
{
    return SysRollingCounter;
}

void Common_BlockDelay(uint16_t m_MS)
{
    uint16_t RocBackup;
    uint16_t Counter;
    uint16_t DIMCounter;

    DIMCounter = m_MS * 20u;
    Common_RollingCounterClear();
    RocBackup = Common_ReadRollingCounter();
    do
    {
        Counter = Common_ReadRollingCounter();

        if (Counter >= RocBackup)
        {
            Counter -= RocBackup;
        }
        else
        {
            Counter = 65535u - RocBackup + Counter + 1u;
        }

    }
    while (Counter < DIMCounter);
}

uint32_t Common_GetIgnOnTime(void)
{
    return PowerIgnOnTimeLine;
}

uint32_t Common_GetIgnOffTime(void)
{
    return PowerIgnOffTimeLine;
}

#pragma diag_suppress = Pm064
int32_t SEGGER_RTT_printf(uint16_t BufferIndex, const char *sFormat, ...);
int32_t SEGGER_RTT_printf(uint16_t BufferIndex, const char *sFormat, ...)
{
    return 0;
}

uint8_t Common_Get_Cruise_TimeSta(void)
{
    uint8_t Time_Sta = 0u;

    if ((CRUISE_1_Time > 0u) && (CRUISE_1_Time < 1500u))
    {
        Time_Sta = 1u;
    }
    else
    {
        Time_Sta = 0u;
    }

    return Time_Sta;
}

uint8_t Common_Get_Cruise_SLD_TimeSta(void)
{
    uint8_t Time_Sta = 0u;

    if ((CRUISE_SLD1_Time > 0u) && (CRUISE_SLD1_Time < 1500u))
    {
        Time_Sta = 1u;
    }
    else
    {
        Time_Sta = 0u;
    }

    return Time_Sta;
}

uint8_t Common_Get_VolWarning_Sta(void)
{
    uint8_t DataHiCollantVolWarning = 0u;

    if (VolWarning_Time >= 5000u)
    {
        DataHiCollantVolWarning = 1u;
    }
    else
    {
        DataHiCollantVolWarning = 0u;
    }

    return DataHiCollantVolWarning;
}

uint8_t Common_Get_HIGH_VOLTAGE(void)
{
    return HIGH_VOLTAGE;
}

uint8_t Common_Get_LOW_VOLTAGE(void)
{
    return LOW_VOLTAGE;
}

uint8_t Common_Get_FDJYLQQ_Sta(void)
{
    uint8_t ValueSta = 0u;

    if (User_FDJYLQQ_Time < 30000u)
    {
        ValueSta = 1u;
    }
    else
    {
        ValueSta = 0u;
    }

    return ValueSta;
}

uint8_t Common_Get_RYLQQ_Sta(void)
{
    uint8_t ValueSta = 0u;

    if (User_RYLQQ_Time < 30000u)
    {
        ValueSta = 1u;
    }
    else
    {
        ValueSta = 0u;
    }

    return ValueSta;
}

uint8_t Common_Get_BSXY_Sta(void)
{
    uint8_t ValueSta = 0u;

    if (User_BSXY_Time < 30000u)
    {
        ValueSta = 1u;
    }
    else
    {
        ValueSta = 0u;
    }

    return ValueSta;
}

uint8_t Common_Get_CSQY_Sta(void)
{
    uint8_t ValueSta = 0u;

    if (User_CSQY_Time < 30000u)
    {
        ValueSta = 1u;
    }
    else
    {
        ValueSta = 0u;
    }

    return ValueSta;
}

uint8_t Common_Get_LHQY_Sta(void)
{
    uint8_t ValueSta = 0u;

    if (User_LHQY_Time < 30000u)
    {
        ValueSta = 1u;
    }
    else
    {
        ValueSta = 0u;
    }

    return ValueSta;
}

uint8_t Common_Get_KQGZJ_Sta(void)
{
    uint8_t ValueSta = 0u;

    if (User_KQGZJ_Time < 30000u)
    {
        ValueSta = 1u;
    }
    else
    {
        ValueSta = 0u;
    }

    return ValueSta;
}

uint8_t Common_Get_DLZXY_Sta(void)
{
    uint8_t ValueSta = 0u;

    if (User_DLZXY_Time < 30000u)
    {
        ValueSta = 1u;
    }
    else
    {
        ValueSta = 0u;
    }

    return ValueSta;
}

uint8_t Common_Get_LT_Sta(void)
{
    uint8_t ValueSta = 0u;

    if (User_LT_Time < 30000u)
    {
        ValueSta = 1u;
    }
    else
    {
        ValueSta = 0u;
    }

    return ValueSta;
}

uint8_t Common_Get_TPMS_TEST_OFF_Time_Sta(void)
{
    uint8_t ValueSta = 0u;

    if (TPMS_TEST_OFF_TIME >= 90000u)
    {
        ValueSta = 1u;
    }
    else
    {
        ValueSta = 0u;
    }

    return 0u;
}

void Common_Set_Menu_FacDea_Time_Sta(uint32_t Value)
{
    Menu_FacDea_Time = Value;
}
uint32_t Common_Get_Menu_FacDea_Time_Sta(void)
{
    return Menu_FacDea_Time;
}

uint32_t Coom_Get_Menu_Off_Time(void)
{
    return Menu_Off_Time;
}

void Common_Set_18EF1718_Msg_Sta(void)
{
    Set_18EF1718_Msg_Sta = COMMON_Valid;
}

DataValid_t Common_Get_18EF1718_Msg_Sta(void)
{
    return Set_18EF1718_Msg_Sta;
}

/*EOL诊断配置数据转换为仪表配置数据*/
void ReadDTCEOLValue_Meter_K_LINE(void)
{
    /*获取所有存储数据*/
    ReadDFlashData(EEPROM_BLOCK_EOL_K_LINE, (uint32_t *)&K_Line_Set.Flag, (sizeof(K_Line_Set) / 4u), K_LINE_EOL_InitVal);
}

void Common_Set_K_Line_Value(void)
{
    uint8_t K_Line_Set_Flag = 0u;
    EEPROM_RW_Result_en_t enResult = EEPROM_RW_FAIL;

    K_Line_Set_Flag = Common_Get_DTCstatusCHGFFK_Flag();

    if (K_Line_Set_Flag == 1u)
    {
        Common_Set_DTCstatusCHGFFK_Flag(0);
        /*存储*/
        //if (EEPROM_Get_Block_Status (EEPROM_BLOCK_EOL_K_LINE) != EEPROM_STAT_ERROR)
        //{
        while (EEPROM_Get_Status() == EEPROM_STAT_BUSY)
        {
            WDT_Clear();
        }
        enResult = EEPROM_Write_Data(EEPROM_BLOCK_EOL_K_LINE, &K_Line_Set, (sizeof(K_Line_Set) / 4u));
        //}
    }
}

void Common_Set_UdsCanIDSta(uint32_t Val)
{
    UdsCanIDSta = Val;
}

uint32_t Common_Get_UdsCanIDSta(void)
{
    return UdsCanIDSta;
}

uint32_t Common_Get_OIL_PRESSURE_Time(void)
{
    return OIL_PRESSURE_Time;
}