#include "Individual_ECU_Comm.h"
#include "CAN_Communication_Matrix.h"
//---------------------------------------------------------
//仪表→“守护神”ECU的通信式样 wangboyu 2021年8月3日09:48:26
//---------------------------------------------------------
//344 - 7
//---------------------------------------------------------

static const DefaultCommCode[COMM_CODE_MAX_NUM] = {0x01,0x40,0x41,0x81,0x40,0xD1,0x7F};

//typedef struct 
//{
//	ID18FEAE17_TYPE Data_Type[ ID18FEAE17_TYPE_MAX ] ;
//	uint32_t Data[ ID18FEAE17_TYPE_MAX ] ;
//}ReqDataStruct;


static struct
{
	en_CommSta CacheReqCode ;
	en_CommSta ReqCode ;
	en_CommSta OldReqCode ;
	en_CommSta RespCode ;
	uint8_t ErrCount ;
	uint8_t ErrSta	 ;
	uint8_t RevEvent ;
	//------------------
	ID18FEAE17_TYPE Type ;
	uint32_t Data[ID18FEAE17_TYPE_MAX] ;
	uint32_t ReqData[ID18FEAE17_TYPE_MAX] ;
}CommVariable ;

static void Set_ECU_ResponseCode(en_CommSta Code);
static void Set_ECU_Data(ID18FEAE17_TYPE Type,uint32_t Data);
/*-------------------------------------------------------------------------
 * Function Name  : Individual_ECU_Comm_KL30_Init
 * Description    : 
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Individual_ECU_Comm_KL30_Init(void)
{
	Set_Meter_RequestCode(METER_CODE_DATA_T_REQ,ID_TripA_AvrFuelCost,0) ;
	CommVariable.ErrCount = 1 ;
	CommVariable.ErrSta = 0 ;
	CommVariable.RevEvent = 0 ;
}
void Individual_ECU_Comm_KL15_ON_Init(void)
{

}
void Individual_ECU_Comm_KL15_OFF_Init(void)
{

}
void Individual_ECU_Comm_Wakeup_Init(void)
{

}
void Individual_ECU_Comm_Sleep_Init(void)
{

}
/*-------------------------------------------------------------------------
 * Function Name  : Individual_ECU_Comm_Processing_Service
 * Description    : 
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Individual_ECU_Comm_Processing_Service(void)
{
	if(CAN_MSG_Status(ID_CanMsg18EF1718_Msg_Count) == CAN_SIG_LOST)
	{
		CommVariable.RevEvent = 0 ;
		CommVariable.ErrCount = 0 ; 
		CommVariable.ErrSta = 1 ;
	}
	else
	{
		if(CommVariable.RevEvent)
		{
			CommVariable.RevEvent = 0 ;
			if(CommVariable.OldReqCode != CommVariable.ReqCode)
			{
				CommVariable.OldReqCode = CommVariable.ReqCode ;
				CommVariable.ErrCount = 0 ; 
			}
			switch(CommVariable.ReqCode)
			{
				case METER_CODE_DATA_T_REQ :
						if(CommVariable.RespCode == ECU_CODE_DATA_T_Y_RESPONSE)
						{
							CommVariable.ErrCount = 0 ; 
							CommVariable.ErrSta = 0 ;					
						}
						else
						{
							if(CommVariable.ErrCount < 10)
							{
								CommVariable.ErrCount ++ ;
								CommVariable.ErrSta = 1 ;
							}
							else
							{
								CommVariable.ErrSta = 2 ;
							}
						}
				break ;
				case METER_CODE_DATA_CLR_REQ :
						if(CommVariable.RespCode == ECU_CODE_DATA_CLR_Y_RESPONSE)
						{
							CommVariable.ErrCount = 0 ; 
							CommVariable.ErrSta = 0 ;					
						}
						else
						{
							if(CommVariable.ErrCount < 10)
							{
								CommVariable.ErrCount ++ ;
								CommVariable.ErrSta = 1 ;
							}
							else
							{
								CommVariable.ErrSta = 2 ;
							}
						}
				break ;
				case METER_CODE_DATA_W_REQ :
						if(CommVariable.RespCode == ECU_CODE_DATA_W_Y_RESPONSE)
						{
							CommVariable.ErrCount = 0 ; 
							CommVariable.ErrSta = 0 ;					
						}
						else
						{
							if(CommVariable.ErrCount < 10)
							{								
								CommVariable.ErrCount ++ ;
								CommVariable.ErrSta = 1 ;
							}
							else
							{
								CommVariable.ErrSta = 2 ;
							}
						}
				break ;
				default :
				break ;
			}
		}
	}
}
/*-------------------------------------------------------------------------
 * Function Name  : RevMsg_ID18EF1718_Cbk
 * Description    : 放在CAN接收中断中
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void RevMsg_ID18EF1718_Cbk(void)
{
	uint8_t i = 0 ;
	uint32_t Data = 0 ;
	ID18FEAE17_TYPE Type = 0 ;
 	CommVariable.RevEvent = 1 ;
	
	if(Get_ID_18EF1718_Sig_Response_Code() == DefaultCommCode[ECU_CODE_DATA_T_Y_RESPONSE])
	{
		Set_ECU_ResponseCode(ECU_CODE_DATA_T_Y_RESPONSE) ;
	}
	else if(Get_ID_18EF1718_Sig_Response_Code() == DefaultCommCode[ECU_CODE_DATA_CLR_Y_RESPONSE])
	{
		Set_ECU_ResponseCode(ECU_CODE_DATA_CLR_Y_RESPONSE) ;
	}
	else if(Get_ID_18EF1718_Sig_Response_Code() == DefaultCommCode[ECU_CODE_DATA_W_Y_RESPONSE])
	{
		Set_ECU_ResponseCode(ECU_CODE_DATA_W_Y_RESPONSE) ;
	}
	else
	{
		Set_ECU_ResponseCode(ECU_CODE_DATA_N_RESPONSE) ;
	}

	Type = Get_ID_18EF1718_Sig_Data_Type();
	Data = Get_ID_18EF1718_Sig_Date();
	for(i = 0 ;i < ID18FEAE17_TYPE_MAX;i ++)
	{
		if(Type == IDAE17_TYTE_DATA[i])
		{
			break ;
		}
	}
	
	Set_ECU_Data(i,Data);
}
/*-------------------------------------------------------------------------
 * Function Name  : Set_Meter_RequestCode
 * Description    : 应用发起- 清零或复位等事件
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Set_Meter_RequestCode(en_CommSta Code,ID18FEAE17_TYPE Type,uint32_t Data)
{
	CommVariable.CacheReqCode = Code ;
	if(Code != METER_CODE_DATA_T_REQ)
	{
		CommVariable.Type = Type ;
		CommVariable.ReqData[ Type ] = Data ;
	}
}
/*-------------------------------------------------------------------------
 * Function Name  : Meter_RequestCode_Update
 * Description    : 放在CAN发送中断的首行
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Meter_RequestCode_Update(void)
{
	if(CommVariable.CacheReqCode != CommVariable.ReqCode)
	{
		CommVariable.ReqCode = CommVariable.CacheReqCode ;
	}
}
/*-------------------------------------------------------------------------
 * Function Name  : Get_Meter_RequestID
 * Description    : 
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
en_CommSta Get_Meter_RequestID(void)
{
	return CommVariable.ReqCode ;
}
/*-------------------------------------------------------------------------
 * Function Name  : Get_Meter_RequestCode
 * Description    : 
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint8_t Get_Meter_RequestCode(void)
{
	return DefaultCommCode[ CommVariable.ReqCode ] ;
}
/*-------------------------------------------------------------------------
 * Function Name  : Get_Meter_RequestType
 * Description    : 
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
ID18FEAE17_TYPE Get_Meter_RequestType(void)
{
	return CommVariable.Type ;
}
/*-------------------------------------------------------------------------
 * Function Name  : Get_Meter_RequestData
 * Description    : 
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint32_t Get_Meter_RequestData(ID18FEAE17_TYPE Type)
{
	return CommVariable.ReqData[ Type ]  ;
}
/*-------------------------------------------------------------------------
 * Function Name  : Set_ECU_ResponseCode
 * Description    : 
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
static void Set_ECU_ResponseCode(en_CommSta Code)
{
	CommVariable.RespCode = Code ;
}
/*-------------------------------------------------------------------------
 * Function Name  : Get_ECU_ResponseCode
 * Description    : 
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
static uint8_t Get_ECU_ResponseCode(void)
{
	return DefaultCommCode[ CommVariable.RespCode ] ;
}
/*-------------------------------------------------------------------------
 * Function Name  : Set_ECU_Data
 * Description    : 
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
static void Set_ECU_Data(ID18FEAE17_TYPE Type,uint32_t Data)
{
	if(Type < ID18FEAE17_TYPE_MAX)
	{
		CommVariable.Data[Type] = Data ;
	}
	
}
/*-------------------------------------------------------------------------
 * Function Name  : Get_ECU_Data
 * Description    : 
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint32_t Get_ECU_Data(ID18FEAE17_TYPE Type)
{
	return CommVariable.Data[Type] ;
}
/*-------------------------------------------------------------------------
 * Function Name  : Get_ECU_RespErr
 * Description    : 错误计数器状态
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint8_t Get_ECU_RespErr(void)
{
	return CommVariable.ErrSta ;
}
/*-------------------------------------------------------------------------
 * Function Name  : Get_ECU_RespSure
 * Description    : 得到肯定应答
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint8_t Get_ECU_RespSure(void)
{
	uint8_t u8Result = 0 ;
	if(CommVariable.ErrSta == 0)
	{
		u8Result = 1 ;
	}
	
	return u8Result ;
}






