
#include "Key.h"
#include "Menu.h"                     /*菜单显示函数在此*/
#include "Services_ODO_User.h"        /*清空总计历程函数*/

#include "DisplaySch_user.h"
#include "Sound_Scheduler.h"
#include "System_Monitor.h"
#include "RTE_ADC.h"
/*-------------------------------------------------------*/

/*----------按键具体功能执行的回调函数-----------------------*/


void Key_Operation_Enter(Key_Event_en_t enKeyEvent);
void Key_Operation_Return(Key_Event_en_t enKeyEvent);
void Key_Operation_Up(Key_Event_en_t enKeyEvent);
void Key_Operation_Down(Key_Event_en_t enKeyEvent);
void Key_Operation_Menu(Key_Event_en_t enKeyEvent);

Key_IGN_en_t Key_Get_IGN_Status(void);

struct 
{
	/* data */
	uint8_t Up ;
	uint8_t Down ;
	uint8_t Enter ;
	uint8_t Menu ;
	uint8_t Return ;

}KeyTest;

/*******************************UP***********************************************
  Function： Key_Operation_Up
  Description：
  Input:
  Output:
 *******************************UP***********************************************/
void Key_Operation_Up(Key_Event_en_t enKeyEvent)
{
	KeyTest.Up ++ ;
	HMI_Set_KEY_UP(enKeyEvent);
}

/*******************************DOWN***********************************************
  Function： Key_Operation_Down
  Description：
  Input:
  Output:
 *******************************DOWN***********************************************/
void Key_Operation_Down(Key_Event_en_t enKeyEvent)
{
	KeyTest.Down ++ ;
	HMI_Set_KEY_DOWN(enKeyEvent);
}
/*******************************ENTER***********************************************
  Function： Key_Operation_Enter
  Description：
  Input:
  Output:
 *******************************ENTER***********************************************/
void Key_Operation_Enter(Key_Event_en_t enKeyEvent)
{
	KeyTest.Enter ++ ;
	HMI_Set_KEY_CONFIRM(enKeyEvent);
}

/*******************************RETURN***********************************************
  Function： Key_Operation_Return
  Description：
  Input:
  Output:
 *******************************RETURN***********************************************/
void Key_Operation_Return(Key_Event_en_t enKeyEvent)
{
	KeyTest.Return ++ ;
	HMI_Set_KEY_CANCEL(enKeyEvent);
}

/*******************************Menu***********************************************
  Function： Key_Operation_Menu
  Description：
  Input:
  Output:
 *******************************Menu***********************************************/
void Key_Operation_Menu(Key_Event_en_t enKeyEvent)
{
	KeyTest.Menu ++ ;
	HMI_Set_KEY_MENU(enKeyEvent);

}



/*------------读按键实时状态的回调函数-------------------------------------------*/
Key_Real_Status_en_t Key_Real_Status_Read_Enter(void);
Key_Real_Status_en_t Key_Real_Status_Read_Return(void);
Key_Real_Status_en_t Key_Real_Status_Read_Up(void);
Key_Real_Status_en_t Key_Real_Status_Read_Down(void);
Key_Real_Status_en_t Key_Real_Status_Read_Menu(void) ;
/*-------------------------------------------------*/

//Menu_R   = 24000*470 / (24000 + 470) =  460.97Ω
//Enter_R  = 24000*6800 / (24000 + 6800) =  5298.7Ω
//Return_R = 24000*15000 / (24000 + 15000) =  9230.77Ω
//Up_R 	   = 24000*1200 / (24000 + 1200) =  1142.86Ω
//Down_R   = 24000*3300 / (24000 + 3300) =  2901.1Ω

//Menu_R   = 16000*470 / (16000 + 470) =  456.59Ω
//Enter_R  = 16000*6800 / (16000 + 6800) =  4771.9Ω
//Return_R = 16000*15000 / (16000 + 15000) =  7741.94Ω
//Up_R 	   = 16000*1200 / (16000 + 1200) =  1116.28Ω
//Down_R   = 16000*3300 / (16000 + 3300) =  2736Ω

//实际按键测试
//无操作		21000~24000Ω
//Menu_R		640~680Ω
//Enter_R		5300~5700Ω		
//Return_R		9000~9500Ω
//Up_R			1300~1400Ω
//Down_R		3000~3200Ω

Key_Real_Status_en_t Key_Real_Status_Read_Menu(void)
{
    Key_Real_Status_en_t enKeyRealStatus = KEY_LINE_LOOSEN;
    uint16_t Key_R = 0;
	
	Key_R = (uint16_t)RTE_Read_KEY_R();

	if(RTE_Read_KEY_R_Valid() == 0)
	{
		enKeyRealStatus = KEY_LINE_LOOSEN;
	}
	else
	{
 
		if((Key_R >= (460 - 300))&&(Key_R <= (460 + 300)))
		{
			enKeyRealStatus = KEY_LINE_PRESS;
		}
		else
		{
			enKeyRealStatus = KEY_LINE_LOOSEN;
		}
	}

    return enKeyRealStatus;
}

Key_Real_Status_en_t Key_Real_Status_Read_Enter(void)
{
    Key_Real_Status_en_t enKeyRealStatus = KEY_LINE_LOOSEN;
    uint16_t Key_R = 0;
	
	Key_R = (uint16_t)RTE_Read_KEY_R();

	if(RTE_Read_KEY_R_Valid() == 0)
	{
		enKeyRealStatus = KEY_LINE_LOOSEN;
	}
	else
	{
		if((Key_R >= (5298 - 300))&&(Key_R <= (5298 + 300)))
		{
			enKeyRealStatus = KEY_LINE_PRESS;
		}
		else
		{
			enKeyRealStatus = KEY_LINE_LOOSEN;
		}
	}
    return enKeyRealStatus;
}

Key_Real_Status_en_t Key_Real_Status_Read_Return(void)
{
    Key_Real_Status_en_t enKeyRealStatus = KEY_LINE_LOOSEN;
    uint16_t Key_R = 0;
	
	Key_R = (uint16_t)RTE_Read_KEY_R();

	if(RTE_Read_KEY_R_Valid() == 0)
	{
		enKeyRealStatus = KEY_LINE_LOOSEN;
	}
	else
	{
		if((Key_R >= (9230 - 300))&&(Key_R <= (9230 + 300)))
		{
			enKeyRealStatus = KEY_LINE_PRESS;
		}
		else
		{
			enKeyRealStatus = KEY_LINE_LOOSEN;
		}
	}

    return enKeyRealStatus;
}

Key_Real_Status_en_t Key_Real_Status_Read_Up(void)
{
    Key_Real_Status_en_t enKeyRealStatus = KEY_LINE_LOOSEN;
    uint16_t Key_R = 0;
	
	Key_R = (uint16_t)RTE_Read_KEY_R();

	if(RTE_Read_KEY_R_Valid() == 0)
	{
		enKeyRealStatus = KEY_LINE_LOOSEN;
	}
	else
	{
		if((Key_R >= (1142 - 300))&&(Key_R <= (1142 + 300)))
		{
			enKeyRealStatus = KEY_LINE_PRESS;
		}
		else
		{
			enKeyRealStatus = KEY_LINE_LOOSEN;
		}
	}

    return enKeyRealStatus;
}

Key_Real_Status_en_t Key_Real_Status_Read_Down(void)
{
    Key_Real_Status_en_t enKeyRealStatus = KEY_LINE_LOOSEN;
    uint16_t Key_R = 0;
	
	Key_R = (uint16_t)RTE_Read_KEY_R();

	if(RTE_Read_KEY_R_Valid() == 0)
	{
		enKeyRealStatus = KEY_LINE_LOOSEN;
	}
	else
	{
		if((Key_R >= (2901 - 300))&&(Key_R <= (2901 + 300)))
		{
			enKeyRealStatus = KEY_LINE_PRESS;
		}
		else
		{
			enKeyRealStatus = KEY_LINE_LOOSEN;
		}
	}

    return enKeyRealStatus;
}


/*---------------------------------------------------------------------------------------*/
const Key_Attribute_st_t stKeyAttribute[KEY_NUM_MAX] =
{
    {KEY_NEED_DEBOUNCE_NORMAL, Key_Real_Status_Read_Up, Key_Operation_Up},
    {KEY_NEED_DEBOUNCE_NORMAL, Key_Real_Status_Read_Down, Key_Operation_Down},
    {KEY_NEED_DEBOUNCE_NORMAL, Key_Real_Status_Read_Enter, Key_Operation_Enter},
    {KEY_NEED_DEBOUNCE_NORMAL, Key_Real_Status_Read_Return, Key_Operation_Return},
    {KEY_NEED_DEBOUNCE_NORMAL, Key_Real_Status_Read_Menu, Key_Operation_Menu},
};

Key_IGN_en_t Key_Get_IGN_Status(void)
{
    Key_IGN_en_t ret = KEY_IG_INVALID;
    if (SYS_OPR_STAT_IGN_ON)
    {
        ret = KEY_IG_ON;
    }
    else
    {
        ret = KEY_IG_OFF;
    }
    return ret;
}
