#ifndef MEMU_H__
#define MEMU_H__

#include "TYW_stdint.h"

#ifdef GLOBALS_MEU_PROCESS
#define EXTERN_MEU_PROCESS
#else
#define EXTERN_MEU_PROCESS extern
#endif

#define _MN_IDX_NULL 0xff
#define _MN_IDX_NULL0 0x00
#define _MN_OPR_NULL (void *)0

typedef enum
{
    /*主界面*/
    _MN_DSP_LEVEL1MENU_1 = 0, // 0
    _MN_DSP_LEVEL1MENU_2,     // 1
    _MN_DSP_LEVEL1MENU_3,     // 2
    _MN_DSP_LEVEL1MENU_4,     // 3
    _MN_DSP_LEVEL1MENU_5,     // 4
    _MN_DSP_LEVEL1MENU_6,     // 5
    _MN_DSP_LEVEL1MENU_7,     // 6
    _MN_DSP_LEVEPOPUP,
    /*一级菜单*/
    _MN_DSP_LEVEL2MENU_1, // 6
    _MN_DSP_LEVEL2MENU_2, // 7
    _MN_DSP_LEVEL2MENU_3, // 8
    _MN_DSP_LEVEL2MENU_4, // 9
    _MN_DSP_LEVEL2MENU_7, // 10
    _MN_DSP_LEVEL2MENU_5, // 11
    _MN_DSP_LEVEL2MENU_6, // 12

    /*二级菜单*/
    _MN_DSP_LEVEL2_1_MENU_1, // 13

    _MN_DSP_LEVEL2_2_MENU_1, // 14
    _MN_DSP_LEVEL2_2_MENU_2, // 15
    _MN_DSP_LEVEL2_2_MENU_3, // 16
    _MN_DSP_LEVEL2_2_MENU_4, // 17
    //_MN_DSP_LEVEL2_2_MENU_5       ,            //21
    _MN_DSP_LEVEL2_2_MENU_6, // 18
    _MN_DSP_LEVEL2_2_MENU_7, // 19
    _MN_DSP_LEVEL2_2_MENU_8, // 20
    _MN_DSP_LEVEL2_2_MENU_9, // 21

    _MN_DSP_LEVEL2_3_MENU_1, // 22
    _MN_DSP_LEVEL2_3_MENU_2, // 23
    _MN_DSP_LEVEL2_3_MENU_3, // 24
    _MN_DSP_LEVEL2_3_MENU_4, // 25
    //_MN_DSP_LEVEL2_3_MENU_5       ,            //30
    _MN_DSP_LEVEL2_3_MENU_6, // 26
    _MN_DSP_LEVEL2_3_MENU_7, // 27

    _MN_DSP_LEVEL2_4_MENU_1, // 28
    _MN_DSP_LEVEL2_4_MENU_2, // 29
    _MN_DSP_LEVEL2_4_MENU_3, // 30
    _MN_DSP_LEVEL2_4_MENU_A, // 31   Ì¥Ñ¹ÉèÖÃ½çÃæ
    _MN_DSP_LEVEL2_4_MENU_4, // 32
    _MN_DSP_LEVEL2_4_MENU_5, // 33
    _MN_DSP_LEVEL2_4_MENU_6, // 34
    _MN_DSP_LEVEL2_4_MENU_7, // 35
    _MN_DSP_LEVEL2_4_MENU_8, // 36
    _MN_DSP_LEVEL2_4_MENU_9, // 37
    _MN_DSP_LEVEL2_7_MENU_1, // 38   Ì¥Ñ¹ÏÔÊ¾½çÃæ
    /*三级菜单*/
    //_MN_DSP_LEVEL3_1_MENU_1       ,            //42
    //_MN_DSP_LEVEL3_1_MENU_2       ,            //43
    //_MN_DSP_LEVEL3_1_MENU_3       ,            //44
    //_MN_DSP_LEVEL3_1_MENU_4       ,            //45
    //_MN_DSP_LEVEL3_1_MENU_5       ,

    _MN_DSP_LEVEL3_2_MENU_1, // 39
    _MN_DSP_LEVEL3_2_MENU_2, // 40
    _MN_DSP_LEVEL3_2_MENU_3, // 41
    _MN_DSP_LEVEL3_2_MENU_4, // 42
    //_MN_DSP_LEVEL3_2_MENU_5       ,            //50
    _MN_DSP_LEVEL3_2_MENU_6, // 43
    _MN_DSP_LEVEL3_2_MENU_7, // 44
    _MN_DSP_LEVEL3_2_MENU_8, // 45
    _MN_DSP_LEVEL3_2_MENU_9, // 46

    _MN_DSP_LEVEL3_3_MENU_1, // 47
    _MN_DSP_LEVEL3_3_MENU_2, // 48
    _MN_DSP_LEVEL3_3_MENU_3, // 49
    _MN_DSP_LEVEL3_3_MENU_4, // 50
    //_MN_DSP_LEVEL3_3_MENU_5       ,            //59
    _MN_DSP_LEVEL3_3_MENU_6, // 51
    _MN_DSP_LEVEL3_3_MENU_7, // 52

    _MN_DSP_LEVEL3_4_MENU_11, // 53
    _MN_DSP_LEVEL3_4_MENU_12, // 54
    _MN_DSP_LEVEL3_4_MENU_21, // 55
    _MN_DSP_LEVEL3_4_MENU_22, // 56
    _MN_DSP_LEVEL3_4_MENU_3,  // 57
    _MN_DSP_LEVEL3_4_MENU_41, // 58
    _MN_DSP_LEVEL3_4_MENU_42, // 59
    _MN_DSP_LEVEL3_4_MENU_43, // 60
    _MN_DSP_LEVEL3_4_MENU_44, // 61
    _MN_DSP_LEVEL3_4_MENU_45, // 62
    _MN_DSP_LEVEL3_4_MENU_51, // 63
    _MN_DSP_LEVEL3_4_MENU_52, // 64
    _MN_DSP_LEVEL3_4_MENU_6,  // 65
    _MN_DSP_LEVEL3_4_MENU_7,  // 66
    _MN_DSP_LEVEL3_4_MENU_8,  // 67
    _MN_DSP_LEVEL3_4_MENU_9,  // 68
    _MN_DSP_LEVEL3_4_MENU_A,  // 69

    /*四级菜单*/
    _MN_DSP_LEVEL4_1_MENU_1, // 70
    _MN_DSP_LEVEL4_1_MENU_2, // 71
    _MN_DSP_LEVEL4_2_MENU_1, // 72
    _MN_DSP_LEVEL4_2_MENU_2, // 73
    _MN_DSP_LEVEL4_4_MENU_1, // 74
    _MN_DSP_LEVEL4_4_MENU_2, // 75
    _MN_DSP_LEVEL4_4_MENU_3, // 76
    _MN_DSP_LEVEL4_4_MENU_4, // 77
    _MN_DSP_LEVEL4_4_MENU_5, // 78
    _MN_DSP_LEVEL4_5_MENU_1, // 79
    _MN_DSP_LEVEL4_5_MENU_2, // 80

    /*特殊界面*/
    _MN_DSP_HSAENTER_MENU, // 81
    _MN_DSP_ENTER_MENU,    // 82
    _MN_DSP_RETURN_MENU,   // 83
};

typedef uint8_t _MENU_IDX;
typedef struct
{
    _MENU_IDX VK_IDX_ENTER;
    _MENU_IDX VK_IDX_UP;
    _MENU_IDX VK_IDX_DOWN;
    _MENU_IDX VK_IDX_EXIT;

    void (*Enter)(void);
    void (*Do)(void);
    void (*Exit)(void);
} _MenuOptTab;

EXTERN_MEU_PROCESS uint8_t bMenuSwFlag;
EXTERN_MEU_PROCESS uint8_t g_ClearWin1;
EXTERN_MEU_PROCESS uint8_t bNextMenuIDX; // the next index of menu .
EXTERN_MEU_PROCESS uint8_t bCurMenuIDX;  // the current index of menu.
EXTERN_MEU_PROCESS uint8_t bMainMenuIDX; // the current index of menu.
EXTERN_MEU_PROCESS uint8_t bOldMenuIDX;  // the Old index of menu.

EXTERN_MEU_PROCESS const _MenuOptTab MenuOptTab[]; // add
EXTERN_MEU_PROCESS void NextMenu(_MENU_IDX idx);
EXTERN_MEU_PROCESS void MenuInit(void);
EXTERN_MEU_PROCESS void MenuManage(void);

EXTERN_MEU_PROCESS void Level1Menu_1Enter(void);
EXTERN_MEU_PROCESS void Level1Menu_1Do(void);
EXTERN_MEU_PROCESS void Level1Menu_1Exit(void);

EXTERN_MEU_PROCESS void Level1Menu_2Enter(void);
EXTERN_MEU_PROCESS void Level1Menu_2Do(void);
EXTERN_MEU_PROCESS void Level1Menu_2Exit(void);

EXTERN_MEU_PROCESS void Level1Menu_3Enter(void);
EXTERN_MEU_PROCESS void Level1Menu_3Do(void);
EXTERN_MEU_PROCESS void Level1Menu_3Exit(void);

EXTERN_MEU_PROCESS void Level1Menu_4Enter(void);
EXTERN_MEU_PROCESS void Level1Menu_4Do(void);
EXTERN_MEU_PROCESS void Level1Menu_4Exit(void);

EXTERN_MEU_PROCESS void Level1Menu_5Enter(void);
EXTERN_MEU_PROCESS void Level1Menu_5Do(void);
EXTERN_MEU_PROCESS void Level1Menu_5Exit(void);

EXTERN_MEU_PROCESS void Level1Menu_6Enter(void);
EXTERN_MEU_PROCESS void Level1Menu_6Do(void);
EXTERN_MEU_PROCESS void Level1Menu_6Exit(void);

EXTERN_MEU_PROCESS void Level1Menu_7Enter(void);
EXTERN_MEU_PROCESS void Level1Menu_7Do(void);
EXTERN_MEU_PROCESS void Level1Menu_7Exit(void);

EXTERN_MEU_PROCESS void LevelPopup_Enter(void);
EXTERN_MEU_PROCESS void LevelPopup_Do(void);
EXTERN_MEU_PROCESS void LevelPopup_Exit(void);

#endif
