
#ifndef _SOUND_LIST_H_
#define _SOUND_LIST_H_
#include "TYW_stdint.h"
#include "Sound_Source.h"

#define SND_TOTAL_NUMBER SND_INDEX_MAX

/******************************************************************************
声音报警列表
******************************************************************************/
typedef enum SoundName
{

    SND_TICK = 0x00,                                /*51转向            29              */
    SND_TOCK,                                       /*52转向            30              */

    SND_INDEX_MAX,

} SoundName_en_t;

/******************************************************************************
伪声音列表
******************************************************************************/
#define SND_NONE 0xFF
//#define   SND_RADAR                         SND_RADAR_2Hz
//#define   SND_FASTEN_SEATBELT               SND_FASTEN_SEATBELT_DR_Level_1

/******************************************************************************
声音属性结构
******************************************************************************/
typedef struct
{
    SND_SRC_Index_en_t Src; //音源
    uint8_t Type;           //类型
} SoundAttributeStruct;

#define SND_TYPE_NORMAL 0x00   //普通声音类型
#define SND_TYPE_MULTI 0x01    //可多次触发的声音
#define SND_TYPE_RADAR 0x02    //雷达声音
#define SND_TYPE_SEATBELT 0x03 //安全带声音

/******************************************************************************
声音属性列表
******************************************************************************/
static const SoundAttributeStruct SoundList[SND_INDEX_MAX] =
{
    /*=====================================================================================
             声音名称                 |              音源              |        模式
    -------------------------------------------------------------------------------------*/
    {    /*51 SND_TICK,                            */          SND_SRC_TICK,                    SND_TYPE_NORMAL,    },
    {    /*52 SND_TOCK,                            */          SND_SRC_TOCK,                    SND_TYPE_NORMAL,    },

    /*====================================================================================*/
};


#endif