/**********************************************************************************************************
* @file    loc_graphics.h
* @author  HZS
* @version V1.0.0
* @date    2020.12.24
* @brief   c header file
********************************************************************************************************/
#ifndef LOC_GRAPHICS_H_
#define LOC_GRAPHICS_H_

#include "r_typedefs.h"        /* Renesas basic types, e.g. uint32_t */

/******************************
WINDOW  SET
******************************/
#define GUI_BLENDMODE_CUSTOM        0
#define GUI_BLENDMODE_SRC_OVER      2

typedef struct
{
    uint32_t MemBase;
    uint32_t WrapBits;
    uint32_t WrapBase;
    uint32_t WrapSize;
    uint32_t Alignment;
} r_cdi_Wrap_t;

typedef enum
{
    WET_Sprite,         //区域1 - 量表显示    - WET
    AdBlue_Sprite,      //区域1 - 量表显示    - AdBlue
    TRIP_Sprite,        //区域2 - TRIP显示
    ODO_Sprite,         //区域2 - ODO显示
    WarningLight_Sprite,//区域3 - 警告灯显示
    ADAS_Sprite,        //区域4 - ADAS显示
    MultiPurpose_Sprite,//区域5 - 多目的性显示区域
    Cruise_Sprite,      //区域6 - 巡航显示
    Gear_Sprite,        //区域7 - 档位显示
    Temp_Sprite,        //区域8 - 温度显示
    Time_Sprite,        //区域8 - 时间显示
    Calendar_Sprite,    //区域8 - 日历显示
    Max_Sprite,
} SpriteName_t;

typedef enum
{
    TARGET_FLASH = 0u,
    TARGET_LRAM,
    TARGET_SDRAM,
    TARGET_VRAM,
    TARGET_VRAM_RGB888,
    TARGET_VRAM_ARGB6666,
    TARGET_VRAM_RGB666,
} SpriteTarge_t;


typedef struct
{
    uint16_t     u16ImageID;
    uint16_t     u16PosX;
    uint16_t     u16PosY;
    uint8_t      u8BlendEn;
    uint8_t      u8RotateEn;
    int32_t      i32Angle;
    float        fModulus;
    uint8_t      u8Dir;
    uint8_t      u8AlphaEn;
    int32_t      i32Alpha;
    uint8_t      u8ScaleEn;
    float        fFactor;
    uint8_t      u8UnicodeEn;
    uint32_t     u32UnicodeColor;
    uint8_t      UnicodeLen;
    uint16_t     *pUnicode;
} LogicLayerAttr_t;

typedef struct
{
    uint16_t     u16JPEGWinWidth;
    uint16_t     u16JPEGWinHeight;
    uint16_t     u16JPEGWinPitch;
    uint16_t     u16LocWinWidth;
    uint16_t     u16LocWinHeight;
    uint16_t     u16LocWinPitch;
    uint8_t      u8ScreenRefrsh;   //单位Unit = 10ms
    uint8_t      u8NumOfMainScreenSprite;
    uint8_t      u8NumofAllSprite;
    uint16_t     u16NumofImage;
} r_screen_attr_t;

/**********************************************APP**********************************************/
void loc_App(void *pSpriteHandler, void *pScreenAttr);
r_Error_t loc_RenderTexture_Normal(SpriteName_t SpriteID, LogicLayerAttr_t locParam);
r_Error_t loc_Unicode_Normal(SpriteName_t  SpriteID, LogicLayerAttr_t locParam, uint16_t Unicode[], uint8_t Length);
void loc_Disable_Window_App(void);
void loc_Enable_Window_App(void);
void loc_Display_Service(void);   //要求10ms任务调用
void loc_power_off(void);
void loc_memset_LogicLayerAttr(LogicLayerAttr_t *locParam);
void loc_Del_Sprite(SpriteName_t DelStartID, SpriteName_t DelEndID);
void loc_free_mem(uint8_t startID, uint8_t endID);
void loc_enable_mem(uint8_t startID, uint8_t endID);
void loc_Move_Sprite(SpriteName_t SpriteID, uint32_t PosX, uint32_t PosY, uint32_t PosZ);

#endif



