/****************************************************************************
 *  License : All rights reserved for TES Electronic Solutions GmbH
 *            See included /docs/license.txt for details
 *  Project : D/AVE HD
 *  Purpose : Memory transfer and cache control
 ****************************************************************************
 * Version Control Information :
 *  $Revision: 3935 $
 *  $Date: 2014-09-23 10:52:32 +0200 (Di, 23. Sep 2014) $
 *  $LastChangedBy: golczewskim $
 ****************************************************************************
 * Change History (autogenerated):
 ****************************************************************************/    

#ifndef DAVEHD_KERNEL_MEMORY_H_INCLUDED
#define DAVEHD_KERNEL_MEMORY_H_INCLUDED

#include "davehd_types.h"


/*----------------------------------------------------------------------------------------------------------*/

dhd_enum_t dhd_gpu_internal_can_map_mem(dhd_gpu_device_data_t *a_device,  dhd_vidmem_t *a_memory, dhd_enum_t a_access);
dhd_enum_t dhd_gpu_internal_map_mem(dhd_gpu_device_data_t *a_device, dhd_vidmem_t *a_memory, dhd_enum_t a_access);
dhd_enum_t dhd_gpu_internal_unmap_mem(dhd_gpu_device_data_t *a_device, dhd_vidmem_t *a_memory, dhd_enum_t a_access);
dhd_enum_t dhd_gpu_internal_upload(dhd_gpu_device_data_t *a_device, const dhd_uint8_t *a_src, dhd_gpu_ptr_t a_dest, dhd_uint32_t a_size);
dhd_enum_t dhd_gpu_internal_download(dhd_gpu_device_data_t *a_device, dhd_gpu_ptr_t a_src, dhd_uint8_t *a_dest, dhd_uint32_t a_size);
void dhd_gpu_internal_cflush(dhd_gpu_device_data_t *a_device, const dhd_uint8_t *a_address, dhd_uint32_t a_size);
void dhd_gpu_internal_cinvalidate(dhd_gpu_device_data_t *a_device, const dhd_uint8_t *a_address, dhd_uint32_t a_size);

#ifdef DHD_KERNEL_VALLOC_HOOK
dhd_enum_t dhd_gpu_internal_alloc_hook( dhd_gpu_device_data_t *a_device, dhd_uint32_t a_size, dhd_uint32_t a_alignment, dhd_uint32_t a_tag, dhd_memory_usage_t a_usage, dhd_vidmem_t *a_result );
void       dhd_gpu_internal_free_hook( dhd_gpu_device_data_t *a_device, dhd_vidmem_t *a_memory );
#endif


/*----------------------------------------------------------------------------------------------------------*/

#endif /*DAVEHD_KERNEL_MEMORY_H_INCLUDED*/
