#ifndef _SERVICE_DRIVE_TIME_H_
#define _SERVICE_DRIVE_TIME_H_
#include "TYW_stdint.h"
typedef enum
{
 	Timer_OFF=0u,
 	Timer_ON    ,
}DriveTimerStatus;
typedef enum
{
 	Mode_IGNON=0u    ,
 	Mode_ESpeed      ,
 	Mode_VSpeed      ,
 	Mode_BothSpeed   ,
 	Mode_Unavailable ,
}DriveTimerMode;
typedef struct
{
	uint32_t        BaseTime             ;
	uint16_t        ESpeedStartThre      ;
	uint16_t        ESpeedStopThre       ;
	uint16_t        VSpeedRunThre        ;
	uint16_t        VSpeedStopThre       ;
	DriveTimerMode  Mode                 ;
} _DriveTimeInitStruct;

typedef struct
{
	DriveTimerStatus  	TimerStatus;
	uint16_t          	Timer_ms;
	uint32_t          	Timer_Min;
} _DriveTimeScheduleStruct;
void Service_Drive_Timing_KL30Init(DriveTimerMode mode,uint32_t BaseTime,uint16_t ESpeedStartThre,uint16_t ESpeedStartThreHyst,uint16_t VSpeedRunThre,uint16_t VSpeedRunThreHyst);
void Service_Drive_Timing_Reset(void);
uint32_t Service_Drive_Timing_GetMin(void);
void Service_Drive_Timing_Process(uint16_t Nms,uint16_t ESpeed,uint16_t VSpeed);
#endif