#include "PowerManagement.h"
#include "System_Monitor.h"
#include "Common_Interface.h"
#include "Data_CoolantTemperature.h"
#include "Data_VehicleSpeed.h"
#include "Data_EngineSpeed.h"
#include "Service_TPMS.h"
#include "Services_Mileage.h"
#include "Data_Gear.h"
#include "Data_Time.h"
#include "AC_TEMP.h"
#include "Service_OFF_Time.h"
#include "RTE_CAN_NM.h"
#include "Telltales.h"
#include "Line_in.h"
#include "Seg_Ref.h"
#include "Seatbelt.h"
#include "Door.h"
#include "Data_AirPressure.h"
#include "Key.h"
#include "Menu.h"
#include "Services_ODO_User.h"
#include "AvgSpeed.h"
#include "Maintenance.h"
#include "GaugesInterface.h"
#include "Popup_Scheduler.h"
#include "GPIO.h"
#include "dr7f701441.dvf.h"
#include "Sound_Scheduler.h"
#include "Sound_Player.h"
#include "RTE_PWM_OUT.h"
#include "BackLight_APP.h"
#include "Clock.h"
#include "TimerB.h"
#include "SEG_DISPLAY.h"
#include "CD4051.h"
#include "GaugesInterface.h"
#include "DisplaySch_user.h"
#include "Data_FuelConsump.h"
#include "IS31FL3236.h"

#include "GUI.h"
#include "Data_Fuel_User.h"

#include "app_Service.h"
#include "UART.h"
#include "kwp2000_tp.h"
#include "kwp2000_protocol.h"
#include "kwp2000_service.h"

#include "RTE_TIME.h"
#include "Watchdog.h"
#include "GenDelay.h"
#include "DoCAN_ISO15765.h"
#include "UDS_ISO14229_Server.h"
#include "Analog_Signals.h"
#include "BGLInterface.h"
#include "BU98R10.h"

#define POWER_NM_SLEEP  0U
#define POWER_NM_WAKEUP 1U

static uint8_t PowerGetNMStatus(void);
extern void SEG_LCD_Window_Switch(uint8_t Sw);

Power_Status_t Power_KL30_Init ( void )
{
    Power_Status_t u8PowerSts;
    RTE_RTC_KL30_Init();
    CD4051B_KL15Init();
    /*电源 指示灯 硬线 通用信息部分  赵建智 维护开始*/
    ClearNoInitArea();
    Common_DataInit();
    Sys_KL30_Init();
    Line_In_KL30_Init();
    Telltales_Left_Right_KL30_Init();
    Telltales_KL30_Init();
    SEG_BUFF_Init();
    DispSch_TotalInit();
    /*电源 指示灯 硬线 通用信息部分  赵建智 维护结束*/

    /*车速 转速 水温表头 初始化 田雨 维护开始*/
    UserGaugeK30Init();
    /*车速 转速 水温表头 初始化 田雨 维护开始*/

    /*里程 大小计部分 刘明月 胡志松 辛雨 维护开始*/
    Service_OFF_Timing_KL30Init();
    Data_User_Mileage_KL30Init();
    Data_AvgSpeed_KL30_Init();
    Data_Maintenance_Service_KL30_Init();
    /*里程 大小计部分 刘明月 胡志松 辛雨 维护结束*/

    /*室外温度 胎压部分  档位 清大计 报警 对时 胡迎秋 维护开始*/
    Data_AC_Temp_KL30_Init();
    Data_TPMS_KL30_Init();
    Data_Gear_KL30_Init();
    Data_ODO_Clear_KL30Init();
    /*室外温度 胎压部分  档位 清大计 报警 对时 胡迎秋 维护结束*/

    /*安全带 车门部分  李茂军维护开始*/
    SeatbeltInit();
    Door_WakeUpInit();
    /*安全带 车门部分  李茂军维护结束*/

    /*按键部分 杨真东维护开始*/
    Key_Init();

    VCC12V0_OUT_EN = 1U;        /*12V 电源使能*/
    D1530_EN_MCU_OUT = 1U;      /*1530 使能*/
    //BL_ACC_EN = 1U;       /*8867 使能*/
    Fuel_VCC05V_OUT_EN = 1U ;   /*燃油电源 使能*/
    AIR_5V_OUT_EN = 1u;         /*气压 5V*/
    ACC5V_LED_PWM_MCU = 1u;
    BUZZER_ACC_OUT_EN = 1u;

    IS31_Init();

    Sound_Scheduler_Init();
    Sound_Player_Init();
    RTE_PWM_Init();
    /*按键部分 杨真东维护结束*/

    /*报警调度初始化*/
    Popup_Scheduler_Init();
    /*报警调度初始化*/

    /*5s不按按键计时清零*/
    //LongTimeNoKey_Operation_TimeRest();
    BL_Init();

    /*****油耗类****/
    Fuel_User_KL30_Init();
    u8PowerSts = m_IGN_OFF_Init;
    return  u8PowerSts;
}


void Power_Sleep_Init(void)
{
    /*数据*/
    Speed_Sleep_Init();
    Tacho_Sleep_Init();
    Coolant_Sleep_Init();

    /*燃油库睡眠前需要调用 ----20220503----*/
    Fuel_User_Sleep_Init();

    /*外设*/
    Seg_Display_OFF();
    IS31_Shutdown();
    UART_Sleep_Init();
    Buzzer_Shutdown(); /*蜂鸣器*/
    TimerB_PWM_Channel_Sleep(TIMERB_0_CH15);
    TimerB_PWM_Channel_Sleep(TIMERB_2_CH1);
    TimerB_PWM_Channel_Sleep(TIMERB_2_CH7);
    TimerB_PWM_Channel_Sleep(TIMERB_1_CH15);
    TimerB_PWM_Channel_Sleep(TIMERB_0_CH7);

    VCC12V0_OUT_EN = 0u;        /*12V 电源使能*/
    VCC05V0_OUT_EN = 0u;        /*外设5V 电源使能*/
    D1530_EN_MCU_OUT = 0u;      /*1530 使能*/
    //BL_ACC_EN = 1U;             /*8867 使能*/
    Fuel_VCC05V_OUT_EN = 0u ;   /*燃油电源 使能*/
    AIR_5V_OUT_EN = 0u;         /*气压 5V*/
    ACC5V_LED_PWM_MCU = 0u;
    BUZZER_ACC_OUT_EN = 0u;

    GPIO_Init(GPIO_SLEEP_MODE );
}


Power_Status_t Power_Wakeup_Init ( void )
{
    Kwp2000_Init();

    Power_Status_t u8PowerSts;
    /*电源 指示灯 硬线 通用信息部分  赵建智 维护开始*/
    Common_DataInit();
    Sys_WakeUp_Init();
    Line_In_KL30_Init();
    Telltales_Left_Right_KL30_Init();
    Telltales_KL30_Init();
    SEG_BUFF_Init();
    DispSch_TotalInit();
    /*电源 指示灯 硬线 通用信息部分  赵建智 维护结束*/
    Telltales_Wakeup_Init();
    Data_Time_WakeUp_Init();
    /*车速 转速 水温表头 初始化 田雨 维护开始*/
    UserGaugeK30Init();
    /*车速 转速 水温表头 初始化 田雨 维护开始*/
    Data_User_Mileage_KL15Init();
    Maintenance_WakeUp_Init();
    /*安全带 车门部分  李茂军维护开始*/
    SeatbeltInit();
    Door_WakeUpInit();
    /*安全带 车门部分  李茂军维护结束*/
    RTE_PWM_Init();

    /*燃油新增 ----20220503----*/
    Fuel_User_Wakeup_Init();

    VCC12V0_OUT_EN = 1u;        /*12V 电源使能*/
    D1530_EN_MCU_OUT = 1u;      /*1530 使能*/
    //BL_ACC_EN = 1U;             /*8867 使能*/
    Fuel_VCC05V_OUT_EN = 1u ;   /*燃油电源 使能*/
    AIR_5V_OUT_EN = 1u;         /*气压 5V*/
    ACC5V_LED_PWM_MCU = 1u;
    BUZZER_ACC_OUT_EN = 1u;

    IS31_Init();
    /*报警调度初始化*/
    Popup_Scheduler_Init();
    /*报警调度初始化*/
    Sound_Scheduler_Init();
    Sound_Player_Init();
    u8PowerSts = m_IGN_OFF_Init;
    return  u8PowerSts;
}




void Power_IG_OFF_Init(void)
{
    Line_In_KL15_OFF_Init();
    Speed_KL15_OFF_Init();
    Tacho_KL15_OFF_Init();
    Coolant_KL15_OFF_Init();
    //Maintenance_KL15_OFF_Init();
    /*表头参数初始OFF下调用 added by yutian*/
    GaugesK15Init_OFF() ;/*仪表IGOFF调用*/
    /*end*/
    /*报警调度*/
    Popup_Scheduler_OFF();
    //Menu_Init_IG(0u);
    GUI_Display_KL15_OFF_Init();

    /*关闭所有断码*/
    Seg_Display_OFF();
}
void Power_IG_ON_Init(void)
{
    Kwp2000_Init();
    DiagnosisInit_main();
    Data_ODO_Clear_KL15Init();
    Telltales_KL15_Init();
    Line_In_KL15_ON_Init();
    Coolant_KL15_ON_Init();
    Data_Time_KL15_Init();
    Data_AC_Temp_KL15_Init();
    Data_TPMS_KL15_ON_Init();
    Service_OFF_Timing_KL15Init();
    Tacho_KL15_ON_Init();
    Speed_KL15_ON_Init();
    Data_Gear_KL15_Init();
    /*表头数据处理 added by yutian*/
    UserGaugeK15Init() ;/*仪表IGON调用*/
    /*end*/
    CD4051B_KL15Init();
    /*5s不按按键计时清零*/
    //LongTimeNoKey_Operation_TimeRest();

    DispSch_TotalInit();
    GUI_Display_KL15_ON_Init();

    /*气压1 气压2 WET气压数据初始化*/
    AirPressure_KL15_ON_Init();
}

Power_Status_t Power_Stay_ON(void)
{
    Power_Status_t u8PowerSts;
    uint8_t u8Condition1;
    uint8_t u8Condition2;
    uint8_t u8Condition3;
    u8Condition1 = Common_Get_IG_Sts() ;
    u8Condition2 = Common_Get_IG_Sts_Valid();
    u8Condition3 = System_FUN_KL30_Status_Get();
    if ((u8Condition1 == COMMON_POWER_ON ) && ( u8Condition2 == COMMON_Valid))
    {
        u8PowerSts = m_IGN_ON;
    }
    else
    {
        if ((u8Condition1 == COMMON_POWER_OFF ) && (u8Condition2 == COMMON_Valid))
        {
            u8PowerSts = m_IGN_OFF_Init;
        }
        else
        {
            u8PowerSts = m_IGN_ON;
        }
    }
    if (((u8Condition3 == 1u) || (u8Condition3 >= 7u)))
    {
        u8PowerSts = m_IGN_LIMIT;
    }
    return  u8PowerSts;
}

Power_Status_t Power_Stay_OFF(void)
{
    Power_Status_t u8PowerSts;
    uint8_t u8Condition1;
    uint8_t u8Condition2;
    uint32_t Get_Menu_Off_Time;

    u8Condition1 = Common_Get_IG_Sts() ;
    u8Condition2 = Common_Get_IG_Sts_Valid();
    Get_Menu_Off_Time = Coom_Get_Menu_Off_Time();

    if ((u8Condition1 == COMMON_POWER_ON ) && (u8Condition2 == COMMON_Valid))
    {
        u8PowerSts = m_IGN_ON_Init;
    }
    else
    {
        if ((u8Condition1 == COMMON_POWER_OFF ) && (u8Condition2 == COMMON_Valid))
        {
            if (
                (PowerGetNMStatus() == POWER_NM_SLEEP) &&
                (LED_WAKEUP == LEVEL_LOW) &&
                (Get_Menu_Off_Time >= 7600u)
            )
            {
                u8PowerSts = m_IGN_Sleep_Init;
            }
            else
            {
                u8PowerSts = m_IGN_OFF;
            }
        }
        else
        {
            u8PowerSts = m_IGN_OFF;
        }
    }
    return  u8PowerSts;
}



Power_Status_t  Power_Stay_Protect(void)
{
    Power_Status_t u8PowerSts = m_IGN_OFF_Init;
    uint32_t Delaycnt = 0;

    /*关应用关闭了段码，所有背光，CAN 屏幕显示没有关闭 123……*/
    Seg_Display_OFF();
    BackLightSchedu(0, 0);
    SEG_LCD_Window_Switch(0);
    BU98R10_Shutdown();
    Line_In_KL15_OFF_Init();

    for (;;)
    {
        /*喂狗*/
        WDT_Clear( );
        CAN_TX_SetEnable(0);

        /*一定周期调用2ms*/
        Gen_TimeDelay(2000u, 50u);
        DoCAN_Communication_Service( );
        UDS_Server_Application_Service( );
        UDS_10ms_Service( );
        Analog_Signal_Conv_Service();
        Sys_Status_Update_Service( );

        Seg_Buffer_Commit();

        Delaycnt++;
        if ( Delaycnt >= 5u )
        {
            Delaycnt = 0u;
            CAN_BUSOFF_Recover();
            //Can_BusOff_Fun();
        }

        /*- 电源模式正常，退出 -*/
        if ( SYS_OPR_STAT_RUN )
        {
            CAN_TX_SetEnable(0x55);
            CD4051B_KL15Init();
            Line_In_KL15_ON_Init();
            SEG_BUFF_Init();
            BU98R10_Init();

            return u8PowerSts;
        }
    }

    return  u8PowerSts;
}



Power_Status_t Power_Stay_Sleep ( void )
{
    Power_Status_t u8PowerSts;

    Sys_Enter_Sleep_Mode();




    u8PowerSts = m_IGN_OFF_Init;
    return  u8PowerSts;
}


static uint8_t PowerGetNMStatus(void)
{
    uint8_t u8NMStatus = 0U;
    NM_Mode_t m_condition;
    m_condition = RTE_CAN_NM_GetStatus();

    if (m_condition == NM_Mode_Sleep)
    {
        u8NMStatus = POWER_NM_SLEEP;
    }
    else
    {
        u8NMStatus = POWER_NM_WAKEUP;
    }




    return u8NMStatus;
}




void ClearNoInitArea(void)
{
    uint32_t  *pRam;
    uint32_t  p;
    pRam = (unsigned int*)0x3FCE4000ul;
    for (p = 0ul; p < 4096ul; p ++)
    {
        pRam[ p ] = 0ul;
    }
}
