/****************************************************************************
 *  License : All rights reserved for TES Electronic Solutions GmbH
 *            See included /docs/license.txt for details
 *  Project : D/AVE HD
 *  Purpose : HW Register Interface defines
 ****************************************************************************
 * Version Control Information :
 * DO NOT EDIT THIS FILE - This file will be automatically generated by
 * 'gen_register_headers_sw.py'
 ****************************************************************************
 * Change History (autogenerated):
 ****************************************************************************/    

#ifndef DAVEHD_REGISTERMAP_D1MX_H_INCLUDED
#define DAVEHD_REGISTERMAP_D1MX_H_INCLUDED

#include "davehd_types.h"

/* create a register value*/
#define REG_VALUE(value, low) (dhd_uint_t)(((dhd_uint_t)(value)) << (low))    /* PRQA S 3453*/

/*----------------------------------------------------------------------------------------------------------*/
/* All register offsets                                                                                     */
/*                                                                                                          */

#define DHD_REG_PSU_LIM_BBOX_MIN           0x80   /* Bounding box upper left corner*/
#define DHD_REG_PSU_LIM_BBOX_MAX           0x81   /* Bounding box lower right corner*/
#define DHD_REG_PSU_LIM_START              0x82   /* Start position for enumeration*/
#define DHD_REG_PSU_LIM_CTRL               0x83   /* Pixel selection unit Limiter+Bezier control registers*/
#define DHD_REG_PSU_LIM_STRIPE             0x84   /* Enumeration stripes width and offset*/
#define DHD_REG_PSU_BEZ_CTRL               0x85   /* Bezier control*/
#define DHD_REG_PSU_BEZ_VOFF_0             0x86   /* Offset to Limiter #0 value for Bezier function (14.18 signed fixed point)*/
#define DHD_REG_PSU_BEZ_VOFF_1             0x87   /* Offset to Limiter #1 value for Bezier function (14.18 signed fixed point)*/
#define DHD_REG_PSU_BEZ_AA_CTRL            0x88   /* Bezier anti-aliasing and width control*/
#define DHD_REG_PSU_LIM_VSTART_0           0x89   /* Initial value of limiter #0 at enumeration start position (14.18 signed fixed point)*/
#define DHD_REG_PSU_LIM_DX_0               0x8a   /* Fractional part of Limiter #0 x step (2.18 signed fixed point)*/
#define DHD_REG_PSU_LIM_DY_0               0x8b   /* Fractional part of Limiter y #0 step (2.18 signed fixed point)*/
#define DHD_REG_PSU_LIM_VSTART_1           0x8c   /* Initial value of limiter #1 at enumeration start position (14.18 signed fixed point)*/
#define DHD_REG_PSU_LIM_DX_1               0x8d   /* Fractional part of Limiter #1 x step (2.18 signed fixed point)*/
#define DHD_REG_PSU_LIM_DY_1               0x8e   /* Fractional part of Limiter y #1 step (2.18 signed fixed point)*/
#define DHD_REG_PSU_LIM_VSTART_2           0x8f   /* Initial value of limiter #2 at enumeration start position (14.18 signed fixed point)*/
#define DHD_REG_PSU_LIM_DX_2               0x90   /* Fractional part of Limiter #2 x step (2.18 signed fixed point)*/
#define DHD_REG_PSU_LIM_DY_2               0x91   /* Fractional part of Limiter y #2 step (2.18 signed fixed point)*/
#define DHD_REG_PSU_LIM_VSTART_3           0x92   /* Initial value of limiter #3 at enumeration start position (14.18 signed fixed point)*/
#define DHD_REG_PSU_LIM_DX_3               0x93   /* Fractional part of Limiter #3 x step (2.18 signed fixed point)*/
#define DHD_REG_PSU_LIM_DY_3               0x94   /* Fractional part of Limiter y #3 step (2.18 signed fixed point)*/
#define DHD_REG_PSU_LIM_VSTART_4           0x95   /* Initial value of limiter #4 at enumeration start position (14.18 signed fixed point)*/
#define DHD_REG_PSU_LIM_DX_4               0x96   /* Fractional part of Limiter #4 x step (2.18 signed fixed point)*/
#define DHD_REG_PSU_LIM_DY_4               0x97   /* Fractional part of Limiter y #4 step (2.18 signed fixed point)*/
#define DHD_REG_PSU_LIM_VSTART_5           0x98   /* Initial value of limiter #5 at enumeration start position (14.18 signed fixed point)*/
#define DHD_REG_PSU_LIM_DX_5               0x99   /* Fractional part of Limiter #5 x step (2.18 signed fixed point)*/
#define DHD_REG_PSU_LIM_DY_5               0x9a   /* Fractional part of Limiter y #5 step (2.18 signed fixed point)*/
#define DHD_REG_PSU_DEBUG_CTRL             0x9b   /* Debug control*/
#define DHD_REG_PSU_LIM_MAX_COORD          0x9c   /* Maximum coordinates generated by PSU, clipping limits for bounding box*/
#define DHD_REG_TXA_U_OFFSET_0             0xc0   /* Start value for texture U coordinate of texture unit #0.*/
#define DHD_REG_TXA_V_OFFSET_0             0xc1   /* Start value for texture V coordinate of texture unit #0.*/
#define DHD_REG_TXA_DUX_0                  0xc2   /* Increment of texture U coordinate for a pixel step in X direction of texture unit #0*/
#define DHD_REG_TXA_DUY_0                  0xc3   /* Increment of texture U coordinate for a pixel step in Y direction of texture unit #0*/
#define DHD_REG_TXA_DVX_0                  0xc4   /* Increment of texture V coordinate for a pixel step in X direction of texture unit #0*/
#define DHD_REG_TXA_DVY_0                  0xc5   /* Increment of texture V coordinate for a pixel step in Y direction of texture unit #0*/
#define DHD_REG_TXA_U_OFFSET_1             0xc6   /* Start value for texture U coordinate of texture unit #1.*/
#define DHD_REG_TXA_V_OFFSET_1             0xc7   /* Start value for texture V coordinate of texture unit #1.*/
#define DHD_REG_TXA_DUX_1                  0xc8   /* Increment of texture U coordinate for a pixel step in X direction of texture unit #1*/
#define DHD_REG_TXA_DUY_1                  0xc9   /* Increment of texture U coordinate for a pixel step in Y direction of texture unit #1*/
#define DHD_REG_TXA_DVX_1                  0xca   /* Increment of texture V coordinate for a pixel step in X direction of texture unit #1*/
#define DHD_REG_TXA_DVY_1                  0xcb   /* Increment of texture V coordinate for a pixel step in Y direction of texture unit #1*/
#define DHD_REG_ZSS_PITCH                 0x100   /* ZSA cache scheduler pitch*/
#define DHD_REG_ZSS_SPAN_CONFIG           0x101   /* ZSA cache scheduler span config*/
#define DHD_REG_TXA_Z_OFFSET              0x102   /* Start value for Z coordinate*/
#define DHD_REG_TXA_DZX                   0x103   /* Increment of Z coordinate for a pixel step in X direction*/
#define DHD_REG_TXA_DZY                   0x104   /* Increment of Z coordinate for a pixel step in Y direction*/
#define DHD_REG_TXA_Z_RHW_OFFSET          0x105   /* Start value for RHW attribute (1/w) of Z*/
#define DHD_REG_TXA_Z_DRHWX               0x106   /* Increment of RHW attribute of Z for a pixel step in X direction*/
#define DHD_REG_TXA_Z_DRHWY               0x107   /* Increment of RHW attribute of Z for a pixel step in Y direction*/
#define DHD_REG_TXA_RHW_OFFSET_0          0x108   /* Start value for RHW attribute (1/w) of texture unit #0*/
#define DHD_REG_TXA_DRHWX_0               0x109   /* Increment of RHW attribute for a pixel step in X direction of texture unit #0*/
#define DHD_REG_TXA_DRHWY_0               0x10a   /* Increment of RHW attribute for a pixel step in Y direction of texture unit #0*/
#define DHD_REG_TXA_RHW_OFFSET_1          0x10b   /* Start value for RHW attribute (1/w) of texture unit #1*/
#define DHD_REG_TXA_DRHWX_1               0x10c   /* Increment of RHW attribute for a pixel step in X direction of texture unit #1*/
#define DHD_REG_TXA_DRHWY_1               0x10d   /* Increment of RHW attribute for a pixel step in Y direction of texture unit #1*/
#define DHD_REG_ZSA_CTRL                  0x180   /* ZSA control registers*/
#define DHD_REG_ZSC_START_ADDRESS         0x181   /* ZSA buffer start address*/
#define DHD_REG_ZSU_CTRL1                 0x182   /* ZSA Unit Control register 1*/
#define DHD_REG_ZSU_CTRL2                 0x183   /* ZSA Unit Control register 2*/
#define DHD_REG_TXA_SIZE_0                0x184   /* Texture size of texture unit #0*/
#define DHD_REG_TXA_ACCESS_0              0x185   /* Filter shape, size and texture pitch of texture unit #0*/
#define DHD_REG_TXA_SIZE_1                0x186   /* Texture size of texture unit #1*/
#define DHD_REG_TXA_ACCESS_1              0x187   /* Filter shape, size and texture pitch of texture unit #1*/
#define DHD_REG_TEX_GLOBAL                0x200   /* Global texture unit register*/
#define DHD_REG_COL_GLOBAL                0x201   /* Global color unit registers*/
#define DHD_REG_FBD_CONFIG                0x202   /* Framebuffer read decision registers*/
#define DHD_REG_FBS_PITCH                 0x203   /* Framebuffer cache scheduler pitch and debug control*/
#define DHD_REG_FBS_SPAN_CONFIG           0x204   /* Framebuffer cache scheduler span config*/
#define DHD_REG_RLD_START_ADDRESS         0x205   /* Start address of RLE code of the texture in memory*/
#define DHD_REG_COL_CONST_COLOR_0         0x206   /* Constant color register #0*/
#define DHD_REG_COL_CONST_COLOR_1         0x207   /* Constant color register #1*/
#define DHD_REG_COL_CONST_COLOR_2         0x208   /* Constant color register #2*/
#define DHD_REG_COL_CONST_COLOR_3         0x209   /* Constant color register #3*/
#define DHD_REG_TEX_MODE_0                0x280   /* Texture mode of texture unit #0*/
#define DHD_REG_TXC_START_ADDRESS_0       0x281   /* Start address of top-left texel of the texture in memory of texture unit #0*/
#define DHD_REG_TXP_CTRL_0                0x282   /* TXP control of texture unit #0*/
#define DHD_REG_TXP_CLUT_OFFSET_0         0x283   /* Offset for CLUT lookups of texture unit #0*/
#define DHD_REG_TXP_COLOR_KEY_0           0x284   /* Color key comparison value of texture unit #0*/
#define DHD_REG_TXP_FILL_COLOR_0          0x285   /* Texel fill color for wrap mode FILL of texture unit #0*/
#define DHD_REG_TXP_FILTER_SCALE_BIAS_0   0x286   /* Scale and bias for filter in TXP of texture unit #0*/
#define DHD_REG_TEX_MODE_1                0x287   /* Texture mode of texture unit #1*/
#define DHD_REG_TXC_START_ADDRESS_1       0x288   /* Start address of top-left texel of the texture in memory of texture unit #1*/
#define DHD_REG_TXP_CTRL_1                0x289   /* TXP control of texture unit #1*/
#define DHD_REG_TXP_CLUT_OFFSET_1         0x28a   /* Offset for CLUT lookups of texture unit #1*/
#define DHD_REG_TXP_COLOR_KEY_1           0x28b   /* Color key comparison value of texture unit #1*/
#define DHD_REG_TXP_FILL_COLOR_1          0x28c   /* Texel fill color for wrap mode FILL of texture unit #1*/
#define DHD_REG_TXP_FILTER_SCALE_BIAS_1   0x28d   /* Scale and bias for filter in TXP of texture unit #1*/
#define DHD_REG_COL_ARGB_OP1A_0           0x2c0   /* Control structure for Op1a of color pass 0 (Alpha and RGB path)*/
#define DHD_REG_COL_ARGB_OP1B_0           0x2c1   /* Control structure for Op1b of color pass 0 (Alpha and RGB path)*/
#define DHD_REG_COL_ARGB_OP2A_0           0x2c2   /* Control structure for Op2a of color pass 0 (Alpha and RGB path)*/
#define DHD_REG_COL_ARGB_OP2B_0           0x2c3   /* Control structure for Op2b of color pass 0 (Alpha and RGB path)*/
#define DHD_REG_COL_ARGB_OP3_0            0x2c4   /* Control structure for Op3 of color pass 0 (Alpha and RGB path)*/
#define DHD_REG_COL_ARGB_OUT_0            0x2c5   /* Control structure for core output of color pass 0 (Alpha and RGB path)*/
#define DHD_REG_COL_ARGB_OP1A_1           0x2c6   /* Control structure for Op1a of color pass 1 (Alpha and RGB path)*/
#define DHD_REG_COL_ARGB_OP1B_1           0x2c7   /* Control structure for Op1b of color pass 1 (Alpha and RGB path)*/
#define DHD_REG_COL_ARGB_OP2A_1           0x2c8   /* Control structure for Op2a of color pass 1 (Alpha and RGB path)*/
#define DHD_REG_COL_ARGB_OP2B_1           0x2c9   /* Control structure for Op2b of color pass 1 (Alpha and RGB path)*/
#define DHD_REG_COL_ARGB_OP3_1            0x2ca   /* Control structure for Op3 of color pass 1 (Alpha and RGB path)*/
#define DHD_REG_COL_ARGB_OUT_1            0x2cb   /* Control structure for core output of color pass 1 (Alpha and RGB path)*/
#define DHD_REG_COL_ARGB_OP1A_2           0x2cc   /* Control structure for Op1a of color pass 2 (Alpha and RGB path)*/
#define DHD_REG_COL_ARGB_OP1B_2           0x2cd   /* Control structure for Op1b of color pass 2 (Alpha and RGB path)*/
#define DHD_REG_COL_ARGB_OP2A_2           0x2ce   /* Control structure for Op2a of color pass 2 (Alpha and RGB path)*/
#define DHD_REG_COL_ARGB_OP2B_2           0x2cf   /* Control structure for Op2b of color pass 2 (Alpha and RGB path)*/
#define DHD_REG_COL_ARGB_OP3_2            0x2d0   /* Control structure for Op3 of color pass 2 (Alpha and RGB path)*/
#define DHD_REG_COL_ARGB_OUT_2            0x2d1   /* Control structure for core output of color pass 2 (Alpha and RGB path)*/
#define DHD_REG_FB_PIXEL_ORG              0x300   /* Framebuffer pixel organization/format*/
#define DHD_REG_FBC_START_ADDRESS         0x301   /* Framebuffer start address*/
#define DHD_REG_BLU_BLEND                 0x302   /* Blend unit factor and mode*/
#define DHD_REG_BLU_DITHER                0x303   /* Blend unit dither control*/
#define DHD_REG_BLU_WRITE                 0x304   /* Blend unit write control*/
#define DHD_REG_PFC_ENABLE                0x380   /* Performance counter enable*/
#define DHD_REG_PFC_CLEAR                 0x381   /* Performance counter clear*/
#define DHD_REG_PFC_EVENT_SELECT_0        0x382   /* Performance counter #0 event selection*/
#define DHD_REG_PFC_EVENT_SELECT_1        0x383   /* Performance counter #1 event selection*/
#define DHD_REG_PFC_EVENT_SELECT_2        0x384   /* Performance counter #2 event selection*/
#define DHD_REG_PFC_EVENT_SELECT_3        0x385   /* Performance counter #3 event selection*/
#define DHD_REG_CLR_VALUE                 0x3c0   /* Clear unit color value*/
#define DHD_REG_CLR_LINE_CONFIG           0x3c1   /* Clear unit line config*/
#define DHD_REG_CLR_CTRL                  0x3c2   /* Clear unit number of lines*/
#define DHD_REG_CLR_START_ADDRESS         0x3c3   /* Start address for clear unit*/
#define DHD_REG_COUNT                       120   /* dave register count*/

/*----------------------------------------------------------------------------------------------------------*/
/* All register layouts                                                                                     */
/*                                                                                                          */

/*----------------------------------------------------------------------------------------------------------*/
/* PSU_Lim_Bbox_Min layout ( Bounding box upper left corner )*/
/**/
typedef union tagdhd_reg_psu_lim_bbox_min_t {
  struct tagdhd_reg_psu_lim_bbox_min_fields_t {
    dhd_uint32_t m_lim_bbox_xmin : 12;  /* Bounding box left border*/
    dhd_uint32_t m_reserved2     : 4;   
    dhd_uint32_t m_lim_bbox_ymin : 12;  /* Bounding box upper border*/
    dhd_uint32_t m_reserved1     : 4;   
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_psu_lim_bbox_min_t;

/*----------------------------------------------------------------------------------------------------------*/
/* PSU_Lim_Bbox_Max layout ( Bounding box lower right corner )*/
/**/
typedef union tagdhd_reg_psu_lim_bbox_max_t {
  struct tagdhd_reg_psu_lim_bbox_max_fields_t {
    dhd_uint32_t m_lim_bbox_xmax : 12;  /* Bounding box right border*/
    dhd_uint32_t m_reserved2     : 4;   
    dhd_uint32_t m_lim_bbox_ymax : 12;  /* Bounding box lower border*/
    dhd_uint32_t m_reserved1     : 4;   
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_psu_lim_bbox_max_t;

/*----------------------------------------------------------------------------------------------------------*/
/* PSU_Lim_Start layout ( Start position for enumeration )*/
/**/
typedef union tagdhd_reg_psu_lim_start_t {
  struct tagdhd_reg_psu_lim_start_fields_t {
    dhd_uint32_t m_reserved2   : 16;  
    dhd_uint32_t m_lim_start_y : 12;  /* Y start position for enumeration (X start position is at left border of Bbox)*/
    dhd_uint32_t m_reserved1   : 4;   
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_psu_lim_start_t;

/*----------------------------------------------------------------------------------------------------------*/
/* PSU_Lim_Ctrl layout ( Pixel selection unit Limiter+Bezier control registers )*/
/**/
typedef union tagdhd_reg_psu_lim_ctrl_t {
  struct tagdhd_reg_psu_lim_ctrl_fields_t {
    dhd_uint32_t m_lim_ctrl_0 : 4;  /* Control structure for Limiter 0*/
    dhd_uint32_t m_lim_ctrl_1 : 4;  /* Control structure for Limiter 1*/
    dhd_uint32_t m_lim_ctrl_2 : 4;  /* Control structure for Limiter 2*/
    dhd_uint32_t m_lim_ctrl_3 : 4;  /* Control structure for Limiter 3*/
    dhd_uint32_t m_lim_ctrl_4 : 4;  /* Control structure for Limiter 4*/
    dhd_uint32_t m_lim_ctrl_5 : 4;  /* Control structure for Limiter 5*/
    dhd_uint32_t m_reserved2  : 4;  
    dhd_uint32_t m_bez_ctrl   : 2;  /* Control structure for Bezier function*/
    dhd_uint32_t m_reserved1  : 2;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_psu_lim_ctrl_t;

/*----------------------------------------------------------------------------------------------------------*/
/* PSU_Lim_Stripe layout ( Enumeration stripes width and offset )*/
/**/
typedef union tagdhd_reg_psu_lim_stripe_t {
  struct tagdhd_reg_psu_lim_stripe_fields_t {
    dhd_uint32_t m_lim_stripe_width  : 10;  /* Width of stripes for stripe-wise enumeration (0 = full span, no stripe-wise enumeration)*/
    dhd_uint32_t m_reserved2         : 6;   
    dhd_uint32_t m_lim_stripe_offset : 10;  /* Offset for first width of stripe*/
    dhd_uint32_t m_reserved1         : 6;   
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_psu_lim_stripe_t;

/*----------------------------------------------------------------------------------------------------------*/
/* PSU_Bez_Ctrl layout ( Bezier control )*/
/**/
typedef union tagdhd_reg_psu_bez_ctrl_t {
  struct tagdhd_reg_psu_bez_ctrl_fields_t {
    dhd_uint32_t m_bez_lim_scale : 6;   /* Scaling factor for Bezier limiter values*/
    dhd_uint32_t m_reserved1     : 26;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_psu_bez_ctrl_t;

/*----------------------------------------------------------------------------------------------------------*/
/* PSU_Bez_Voff_0 layout ( Offset to Limiter #0 value for Bezier function (14.18 signed fixed point) )*/
/**/
typedef union tagdhd_reg_psu_bez_voff_0_t {
  struct tagdhd_reg_psu_bez_voff_0_fields_t {
    dhd_int32_t  m_bez_voff_0 : 32;  /* Offset to Limiter value for Bezier function (14.18 signed fixed point)*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_psu_bez_voff_0_t;

/*----------------------------------------------------------------------------------------------------------*/
/* PSU_Bez_Voff_1 layout ( Offset to Limiter #1 value for Bezier function (14.18 signed fixed point) )*/
/**/
typedef union tagdhd_reg_psu_bez_voff_1_t {
  struct tagdhd_reg_psu_bez_voff_1_fields_t {
    dhd_int32_t  m_bez_voff_1 : 32;  /* Offset to Limiter value for Bezier function (14.18 signed fixed point)*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_psu_bez_voff_1_t;

/*----------------------------------------------------------------------------------------------------------*/
/* PSU_Bez_AA_Ctrl layout ( Bezier anti-aliasing and width control )*/
/**/
typedef union tagdhd_reg_psu_bez_aa_ctrl_t {
  struct tagdhd_reg_psu_bez_aa_ctrl_fields_t {
    dhd_uint32_t m_bez_width     : 8;   /* Bezier width control (4.4 unsigned fixed point): 0 = full convex or concave Bezier segment, >0 = Bezier line*/
    dhd_int32_t  m_bez_aa_offset : 8;   /* Anti-aliasing offset to shift anti-aliasing region from inside to outside of curve (4.4 signed fixed point)*/
    dhd_uint32_t m_bez_aa        : 16;  /* 1/width of anti-aliasing for Bezier element (4.6 unsigned fixed point)*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_psu_bez_aa_ctrl_t;

/*----------------------------------------------------------------------------------------------------------*/
/* PSU_Lim_Vstart_0 layout ( Initial value of limiter #0 at enumeration start position (14.18 signed fixed point) )*/
/**/
typedef union tagdhd_reg_psu_lim_vstart_0_t {
  struct tagdhd_reg_psu_lim_vstart_0_fields_t {
    dhd_int32_t  m_lim_vstart_0 : 32;  /* Initial Limiter value of enumeration start position (14.18 signed fixed point)*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_psu_lim_vstart_0_t;

/*----------------------------------------------------------------------------------------------------------*/
/* PSU_Lim_dx_0 layout ( Fractional part of Limiter #0 x step (2.18 signed fixed point) )*/
/**/
typedef union tagdhd_reg_psu_lim_dx_0_t {
  struct tagdhd_reg_psu_lim_dx_0_fields_t {
    dhd_int32_t  m_lim_dx_0  : 20;  /* Fractional part of Limiter x step (2.18 signed fixed point)*/
    dhd_uint32_t m_reserved1 : 12;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_psu_lim_dx_0_t;

/*----------------------------------------------------------------------------------------------------------*/
/* PSU_Lim_dy_0 layout ( Fractional part of Limiter y #0 step (2.18 signed fixed point) )*/
/**/
typedef union tagdhd_reg_psu_lim_dy_0_t {
  struct tagdhd_reg_psu_lim_dy_0_fields_t {
    dhd_int32_t  m_lim_dy_0  : 20;  /* Fractional part of Limiter y step (2.18 signed fixed point)*/
    dhd_uint32_t m_reserved1 : 12;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_psu_lim_dy_0_t;

/*----------------------------------------------------------------------------------------------------------*/
/* PSU_Lim_Vstart_1 layout ( Initial value of limiter #1 at enumeration start position (14.18 signed fixed point) )*/
/**/
typedef union tagdhd_reg_psu_lim_vstart_1_t {
  struct tagdhd_reg_psu_lim_vstart_1_fields_t {
    dhd_int32_t  m_lim_vstart_1 : 32;  /* Initial Limiter value of enumeration start position (14.18 signed fixed point)*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_psu_lim_vstart_1_t;

/*----------------------------------------------------------------------------------------------------------*/
/* PSU_Lim_dx_1 layout ( Fractional part of Limiter #1 x step (2.18 signed fixed point) )*/
/**/
typedef union tagdhd_reg_psu_lim_dx_1_t {
  struct tagdhd_reg_psu_lim_dx_1_fields_t {
    dhd_int32_t  m_lim_dx_1  : 20;  /* Fractional part of Limiter x step (2.18 signed fixed point)*/
    dhd_uint32_t m_reserved1 : 12;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_psu_lim_dx_1_t;

/*----------------------------------------------------------------------------------------------------------*/
/* PSU_Lim_dy_1 layout ( Fractional part of Limiter y #1 step (2.18 signed fixed point) )*/
/**/
typedef union tagdhd_reg_psu_lim_dy_1_t {
  struct tagdhd_reg_psu_lim_dy_1_fields_t {
    dhd_int32_t  m_lim_dy_1  : 20;  /* Fractional part of Limiter y step (2.18 signed fixed point)*/
    dhd_uint32_t m_reserved1 : 12;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_psu_lim_dy_1_t;

/*----------------------------------------------------------------------------------------------------------*/
/* PSU_Lim_Vstart_2 layout ( Initial value of limiter #2 at enumeration start position (14.18 signed fixed point) )*/
/**/
typedef union tagdhd_reg_psu_lim_vstart_2_t {
  struct tagdhd_reg_psu_lim_vstart_2_fields_t {
    dhd_int32_t  m_lim_vstart_2 : 32;  /* Initial Limiter value of enumeration start position (14.18 signed fixed point)*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_psu_lim_vstart_2_t;

/*----------------------------------------------------------------------------------------------------------*/
/* PSU_Lim_dx_2 layout ( Fractional part of Limiter #2 x step (2.18 signed fixed point) )*/
/**/
typedef union tagdhd_reg_psu_lim_dx_2_t {
  struct tagdhd_reg_psu_lim_dx_2_fields_t {
    dhd_int32_t  m_lim_dx_2  : 20;  /* Fractional part of Limiter x step (2.18 signed fixed point)*/
    dhd_uint32_t m_reserved1 : 12;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_psu_lim_dx_2_t;

/*----------------------------------------------------------------------------------------------------------*/
/* PSU_Lim_dy_2 layout ( Fractional part of Limiter y #2 step (2.18 signed fixed point) )*/
/**/
typedef union tagdhd_reg_psu_lim_dy_2_t {
  struct tagdhd_reg_psu_lim_dy_2_fields_t {
    dhd_int32_t  m_lim_dy_2  : 20;  /* Fractional part of Limiter y step (2.18 signed fixed point)*/
    dhd_uint32_t m_reserved1 : 12;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_psu_lim_dy_2_t;

/*----------------------------------------------------------------------------------------------------------*/
/* PSU_Lim_Vstart_3 layout ( Initial value of limiter #3 at enumeration start position (14.18 signed fixed point) )*/
/**/
typedef union tagdhd_reg_psu_lim_vstart_3_t {
  struct tagdhd_reg_psu_lim_vstart_3_fields_t {
    dhd_int32_t  m_lim_vstart_3 : 32;  /* Initial Limiter value of enumeration start position (14.18 signed fixed point)*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_psu_lim_vstart_3_t;

/*----------------------------------------------------------------------------------------------------------*/
/* PSU_Lim_dx_3 layout ( Fractional part of Limiter #3 x step (2.18 signed fixed point) )*/
/**/
typedef union tagdhd_reg_psu_lim_dx_3_t {
  struct tagdhd_reg_psu_lim_dx_3_fields_t {
    dhd_int32_t  m_lim_dx_3  : 20;  /* Fractional part of Limiter x step (2.18 signed fixed point)*/
    dhd_uint32_t m_reserved1 : 12;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_psu_lim_dx_3_t;

/*----------------------------------------------------------------------------------------------------------*/
/* PSU_Lim_dy_3 layout ( Fractional part of Limiter y #3 step (2.18 signed fixed point) )*/
/**/
typedef union tagdhd_reg_psu_lim_dy_3_t {
  struct tagdhd_reg_psu_lim_dy_3_fields_t {
    dhd_int32_t  m_lim_dy_3  : 20;  /* Fractional part of Limiter y step (2.18 signed fixed point)*/
    dhd_uint32_t m_reserved1 : 12;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_psu_lim_dy_3_t;

/*----------------------------------------------------------------------------------------------------------*/
/* PSU_Lim_Vstart_4 layout ( Initial value of limiter #4 at enumeration start position (14.18 signed fixed point) )*/
/**/
typedef union tagdhd_reg_psu_lim_vstart_4_t {
  struct tagdhd_reg_psu_lim_vstart_4_fields_t {
    dhd_int32_t  m_lim_vstart_4 : 32;  /* Initial Limiter value of enumeration start position (14.18 signed fixed point)*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_psu_lim_vstart_4_t;

/*----------------------------------------------------------------------------------------------------------*/
/* PSU_Lim_dx_4 layout ( Fractional part of Limiter #4 x step (2.18 signed fixed point) )*/
/**/
typedef union tagdhd_reg_psu_lim_dx_4_t {
  struct tagdhd_reg_psu_lim_dx_4_fields_t {
    dhd_int32_t  m_lim_dx_4  : 20;  /* Fractional part of Limiter x step (2.18 signed fixed point)*/
    dhd_uint32_t m_reserved1 : 12;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_psu_lim_dx_4_t;

/*----------------------------------------------------------------------------------------------------------*/
/* PSU_Lim_dy_4 layout ( Fractional part of Limiter y #4 step (2.18 signed fixed point) )*/
/**/
typedef union tagdhd_reg_psu_lim_dy_4_t {
  struct tagdhd_reg_psu_lim_dy_4_fields_t {
    dhd_int32_t  m_lim_dy_4  : 20;  /* Fractional part of Limiter y step (2.18 signed fixed point)*/
    dhd_uint32_t m_reserved1 : 12;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_psu_lim_dy_4_t;

/*----------------------------------------------------------------------------------------------------------*/
/* PSU_Lim_Vstart_5 layout ( Initial value of limiter #5 at enumeration start position (14.18 signed fixed point) )*/
/**/
typedef union tagdhd_reg_psu_lim_vstart_5_t {
  struct tagdhd_reg_psu_lim_vstart_5_fields_t {
    dhd_int32_t  m_lim_vstart_5 : 32;  /* Initial Limiter value of enumeration start position (14.18 signed fixed point)*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_psu_lim_vstart_5_t;

/*----------------------------------------------------------------------------------------------------------*/
/* PSU_Lim_dx_5 layout ( Fractional part of Limiter #5 x step (2.18 signed fixed point) )*/
/**/
typedef union tagdhd_reg_psu_lim_dx_5_t {
  struct tagdhd_reg_psu_lim_dx_5_fields_t {
    dhd_int32_t  m_lim_dx_5  : 20;  /* Fractional part of Limiter x step (2.18 signed fixed point)*/
    dhd_uint32_t m_reserved1 : 12;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_psu_lim_dx_5_t;

/*----------------------------------------------------------------------------------------------------------*/
/* PSU_Lim_dy_5 layout ( Fractional part of Limiter y #5 step (2.18 signed fixed point) )*/
/**/
typedef union tagdhd_reg_psu_lim_dy_5_t {
  struct tagdhd_reg_psu_lim_dy_5_fields_t {
    dhd_int32_t  m_lim_dy_5  : 20;  /* Fractional part of Limiter y step (2.18 signed fixed point)*/
    dhd_uint32_t m_reserved1 : 12;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_psu_lim_dy_5_t;

/*----------------------------------------------------------------------------------------------------------*/
/* PSU_Debug_Ctrl layout ( Debug control )*/
/**/
typedef union tagdhd_reg_psu_debug_ctrl_t {
  struct tagdhd_reg_psu_debug_ctrl_fields_t {
    dhd_uint32_t m_bez_debug : 4;   /* Bezier debug control bits (reserved)*/
    dhd_uint32_t m_lim_debug : 4;   /* Limiter debug control bits (reserved)*/
    dhd_uint32_t m_reserved1 : 24;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_psu_debug_ctrl_t;

/*----------------------------------------------------------------------------------------------------------*/
/* PSU_Lim_Max_Coord layout ( Maximum coordinates generated by PSU, clipping limits for bounding box )*/
/**/
typedef union tagdhd_reg_psu_lim_max_coord_t {
  struct tagdhd_reg_psu_lim_max_coord_fields_t {
    dhd_uint32_t m_lim_xmax  : 12;  /* Maximum X coordinate*/
    dhd_uint32_t m_reserved2 : 4;   
    dhd_uint32_t m_lim_ymax  : 12;  /* Maximum Y coordinate*/
    dhd_uint32_t m_reserved1 : 4;   
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_psu_lim_max_coord_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TXA_U_Offset_0 layout ( Start value for texture U coordinate of texture unit #0. )*/
/**/
typedef union tagdhd_reg_txa_u_offset_0_t {
  struct tagdhd_reg_txa_u_offset_0_fields_t {
    dhd_float32_t m_txa_u_offset_0; /* Start value for texture U coordinate. Refers to the object start position respectively to the screen origin (depends on the implementation of the texel coordinate calculation)*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_txa_u_offset_0_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TXA_V_Offset_0 layout ( Start value for texture V coordinate of texture unit #0. )*/
/**/
typedef union tagdhd_reg_txa_v_offset_0_t {
  struct tagdhd_reg_txa_v_offset_0_fields_t {
    dhd_float32_t m_txa_v_offset_0; /* Start value for texture V coordinate. Refers to the object start position respectively to the screen origin (depends on the implementation of the texel coordinate calculation)*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_txa_v_offset_0_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TXA_dUX_0 layout ( Increment of texture U coordinate for a pixel step in X direction of texture unit #0 )*/
/**/
typedef union tagdhd_reg_txa_dux_0_t {
  struct tagdhd_reg_txa_dux_0_fields_t {
    dhd_float32_t m_txa_dux_0; /* Increment of texture U coordinate for a pixel step in X direction*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_txa_dux_0_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TXA_dUY_0 layout ( Increment of texture U coordinate for a pixel step in Y direction of texture unit #0 )*/
/**/
typedef union tagdhd_reg_txa_duy_0_t {
  struct tagdhd_reg_txa_duy_0_fields_t {
    dhd_float32_t m_txa_duy_0; /* Increment of texture U coordinate for a pixel step in Y direction*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_txa_duy_0_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TXA_dVX_0 layout ( Increment of texture V coordinate for a pixel step in X direction of texture unit #0 )*/
/**/
typedef union tagdhd_reg_txa_dvx_0_t {
  struct tagdhd_reg_txa_dvx_0_fields_t {
    dhd_float32_t m_txa_dvx_0; /* Increment of texture V coordinate for a pixel step in X direction*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_txa_dvx_0_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TXA_dVY_0 layout ( Increment of texture V coordinate for a pixel step in Y direction of texture unit #0 )*/
/**/
typedef union tagdhd_reg_txa_dvy_0_t {
  struct tagdhd_reg_txa_dvy_0_fields_t {
    dhd_float32_t m_txa_dvy_0; /* Increment of texture V coordinate for a pixel step in Y direction*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_txa_dvy_0_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TXA_U_Offset_1 layout ( Start value for texture U coordinate of texture unit #1. )*/
/**/
typedef union tagdhd_reg_txa_u_offset_1_t {
  struct tagdhd_reg_txa_u_offset_1_fields_t {
    dhd_float32_t m_txa_u_offset_1; /* Start value for texture U coordinate. Refers to the object start position respectively to the screen origin (depends on the implementation of the texel coordinate calculation)*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_txa_u_offset_1_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TXA_V_Offset_1 layout ( Start value for texture V coordinate of texture unit #1. )*/
/**/
typedef union tagdhd_reg_txa_v_offset_1_t {
  struct tagdhd_reg_txa_v_offset_1_fields_t {
    dhd_float32_t m_txa_v_offset_1; /* Start value for texture V coordinate. Refers to the object start position respectively to the screen origin (depends on the implementation of the texel coordinate calculation)*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_txa_v_offset_1_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TXA_dUX_1 layout ( Increment of texture U coordinate for a pixel step in X direction of texture unit #1 )*/
/**/
typedef union tagdhd_reg_txa_dux_1_t {
  struct tagdhd_reg_txa_dux_1_fields_t {
    dhd_float32_t m_txa_dux_1; /* Increment of texture U coordinate for a pixel step in X direction*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_txa_dux_1_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TXA_dUY_1 layout ( Increment of texture U coordinate for a pixel step in Y direction of texture unit #1 )*/
/**/
typedef union tagdhd_reg_txa_duy_1_t {
  struct tagdhd_reg_txa_duy_1_fields_t {
    dhd_float32_t m_txa_duy_1; /* Increment of texture U coordinate for a pixel step in Y direction*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_txa_duy_1_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TXA_dVX_1 layout ( Increment of texture V coordinate for a pixel step in X direction of texture unit #1 )*/
/**/
typedef union tagdhd_reg_txa_dvx_1_t {
  struct tagdhd_reg_txa_dvx_1_fields_t {
    dhd_float32_t m_txa_dvx_1; /* Increment of texture V coordinate for a pixel step in X direction*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_txa_dvx_1_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TXA_dVY_1 layout ( Increment of texture V coordinate for a pixel step in Y direction of texture unit #1 )*/
/**/
typedef union tagdhd_reg_txa_dvy_1_t {
  struct tagdhd_reg_txa_dvy_1_fields_t {
    dhd_float32_t m_txa_dvy_1; /* Increment of texture V coordinate for a pixel step in Y direction*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_txa_dvy_1_t;

/*----------------------------------------------------------------------------------------------------------*/
/* ZSS_Pitch layout ( ZSA cache scheduler pitch )*/
/**/
typedef union tagdhd_reg_zss_pitch_t {
  struct tagdhd_reg_zss_pitch_fields_t {
    dhd_uint32_t m_zss_pitch : 13;  /* ZSA buffer pitch*/
    dhd_uint32_t m_reserved1 : 19;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_zss_pitch_t;

/*----------------------------------------------------------------------------------------------------------*/
/* ZSS_Span_Config layout ( ZSA cache scheduler span config )*/
/**/
typedef union tagdhd_reg_zss_span_config_t {
  struct tagdhd_reg_zss_span_config_fields_t {
    dhd_uint32_t m_zss_span_length_limit : 10;  /* Maximum length of a span for the ZSA buffer cache in pixels-1*/
    dhd_uint32_t m_reserved1             : 22;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_zss_span_config_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TXA_Z_Offset layout ( Start value for Z coordinate )*/
/**/
typedef union tagdhd_reg_txa_z_offset_t {
  struct tagdhd_reg_txa_z_offset_fields_t {
    dhd_float32_t m_txa_z_offset; /* Start value for Z coordinate*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_txa_z_offset_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TXA_dZX layout ( Increment of Z coordinate for a pixel step in X direction )*/
/**/
typedef union tagdhd_reg_txa_dzx_t {
  struct tagdhd_reg_txa_dzx_fields_t {
    dhd_float32_t m_txa_dzx; /* Increment of Z coordinate for a pixel step in X direction*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_txa_dzx_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TXA_dZY layout ( Increment of Z coordinate for a pixel step in Y direction )*/
/**/
typedef union tagdhd_reg_txa_dzy_t {
  struct tagdhd_reg_txa_dzy_fields_t {
    dhd_float32_t m_txa_dzy; /* Increment of Z coordinate for a pixel step in Y direction*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_txa_dzy_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TXA_Z_RHW_Offset layout ( Start value for RHW attribute (1/w) of Z )*/
/**/
typedef union tagdhd_reg_txa_z_rhw_offset_t {
  struct tagdhd_reg_txa_z_rhw_offset_fields_t {
    dhd_float32_t m_txa_z_rhw_offset; /* Start value for RHW attribute (1/w) of Z.*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_txa_z_rhw_offset_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TXA_Z_dRHWX layout ( Increment of RHW attribute of Z for a pixel step in X direction )*/
/**/
typedef union tagdhd_reg_txa_z_drhwx_t {
  struct tagdhd_reg_txa_z_drhwx_fields_t {
    dhd_float32_t m_txa_z_drhwx; /* Increment of RHW attribute of Z for a pixel step in X direction*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_txa_z_drhwx_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TXA_Z_dRHWY layout ( Increment of RHW attribute of Z for a pixel step in Y direction )*/
/**/
typedef union tagdhd_reg_txa_z_drhwy_t {
  struct tagdhd_reg_txa_z_drhwy_fields_t {
    dhd_float32_t m_txa_z_drhwy; /* Increment of RHW attribute of Z for a pixel step in Y direction*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_txa_z_drhwy_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TXA_RHW_Offset_0 layout ( Start value for RHW attribute (1/w) of texture unit #0 )*/
/**/
typedef union tagdhd_reg_txa_rhw_offset_0_t {
  struct tagdhd_reg_txa_rhw_offset_0_fields_t {
    dhd_float32_t m_txa_rhw_offset_0; /* Start value for RHW attribute (1/w)*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_txa_rhw_offset_0_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TXA_dRHWX_0 layout ( Increment of RHW attribute for a pixel step in X direction of texture unit #0 )*/
/**/
typedef union tagdhd_reg_txa_drhwx_0_t {
  struct tagdhd_reg_txa_drhwx_0_fields_t {
    dhd_float32_t m_txa_drhwx_0; /* Increment of RHW attribute for a pixel step in X direction*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_txa_drhwx_0_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TXA_dRHWY_0 layout ( Increment of RHW attribute for a pixel step in Y direction of texture unit #0 )*/
/**/
typedef union tagdhd_reg_txa_drhwy_0_t {
  struct tagdhd_reg_txa_drhwy_0_fields_t {
    dhd_float32_t m_txa_drhwy_0; /* Increment of RHW attribute for a pixel step in Y direction*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_txa_drhwy_0_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TXA_RHW_Offset_1 layout ( Start value for RHW attribute (1/w) of texture unit #1 )*/
/**/
typedef union tagdhd_reg_txa_rhw_offset_1_t {
  struct tagdhd_reg_txa_rhw_offset_1_fields_t {
    dhd_float32_t m_txa_rhw_offset_1; /* Start value for RHW attribute (1/w)*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_txa_rhw_offset_1_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TXA_dRHWX_1 layout ( Increment of RHW attribute for a pixel step in X direction of texture unit #1 )*/
/**/
typedef union tagdhd_reg_txa_drhwx_1_t {
  struct tagdhd_reg_txa_drhwx_1_fields_t {
    dhd_float32_t m_txa_drhwx_1; /* Increment of RHW attribute for a pixel step in X direction*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_txa_drhwx_1_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TXA_dRHWY_1 layout ( Increment of RHW attribute for a pixel step in Y direction of texture unit #1 )*/
/**/
typedef union tagdhd_reg_txa_drhwy_1_t {
  struct tagdhd_reg_txa_drhwy_1_fields_t {
    dhd_float32_t m_txa_drhwy_1; /* Increment of RHW attribute for a pixel step in Y direction*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_txa_drhwy_1_t;

/*----------------------------------------------------------------------------------------------------------*/
/* ZSA_Ctrl layout ( ZSA control registers )*/
/**/
typedef union tagdhd_reg_zsa_ctrl_t {
  struct tagdhd_reg_zsa_ctrl_fields_t {
    dhd_uint32_t m_zsa_buffer_org         : 3;   /* ZSA buffer data organization*/
    dhd_uint32_t m_reserved3              : 1;   
    dhd_uint32_t m_zsc_read_enable        : 1;   /* Enable read of ZSA buffer*/
    dhd_uint32_t m_reserved2              : 3;   
    dhd_uint32_t m_zsc_discard_noncovered : 1;   /* Enable discarding of pixels which have a coverage of 0*/
    dhd_uint32_t m_reserved1              : 23;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_zsa_ctrl_t;

/*----------------------------------------------------------------------------------------------------------*/
/* ZSC_Start_Address layout ( ZSA buffer start address )*/
/**/
typedef union tagdhd_reg_zsc_start_address_t {
  struct tagdhd_reg_zsc_start_address_fields_t {
    dhd_uint32_t m_zsc_start_address : 32;  /* ZSA buffer start address. Must be aligned to MBI bus width.*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_zsc_start_address_t;

/*----------------------------------------------------------------------------------------------------------*/
/* ZSU_Ctrl1 layout ( ZSA Unit Control register 1 )*/
/**/
typedef union tagdhd_reg_zsu_ctrl1_t {
  struct tagdhd_reg_zsu_ctrl1_fields_t {
    dhd_uint32_t m_zsu_alpha_mask_enable            : 1;  /* Enable global alpha mask*/
    dhd_uint32_t m_zsu_alpha_mask_mode              : 1;  /* Global alpha mask mode*/
    dhd_uint32_t m_zsu_alpha_mask_write_mode        : 2;  /* Alpha mask write mode*/
    dhd_uint32_t m_zsu_depth_func                   : 3;  /* Depth test function*/
    dhd_uint32_t m_reserved6                        : 1;  
    dhd_uint32_t m_zsu_depth_write                  : 1;  /* Depth write enable*/
    dhd_uint32_t m_zsu_antialias_invert_on_opaque   : 1;  /* Invert alpha mask on opaque input coverage in polygon anti-aliasing mode*/
    dhd_uint32_t m_reserved5                        : 2;  
    dhd_uint32_t m_zsu_stencil_func                 : 3;  /* Stencil buffer test function*/
    dhd_uint32_t m_reserved4                        : 1;  
    dhd_uint32_t m_zsu_stencil_depth_test_failed_op : 3;  /* Stencil operation on passed stencil test and failed depth test*/
    dhd_uint32_t m_reserved3                        : 1;  
    dhd_uint32_t m_zsu_stencil_depth_test_passed_op : 3;  /* Stencil operation on passed stencil test and passed depth test*/
    dhd_uint32_t m_reserved2                        : 1;  
    dhd_uint32_t m_zsu_stencil_test_failed_op       : 3;  /* Stencil operation on and failed stencil test*/
    dhd_uint32_t m_reserved1                        : 5;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_zsu_ctrl1_t;

/*----------------------------------------------------------------------------------------------------------*/
/* ZSU_Ctrl2 layout ( ZSA Unit Control register 2 )*/
/**/
typedef union tagdhd_reg_zsu_ctrl2_t {
  struct tagdhd_reg_zsu_ctrl2_fields_t {
    dhd_uint32_t m_zsu_stencil_mask       : 8;  /* Stencil comparison mask*/
    dhd_uint32_t m_zsu_stencil_ref        : 8;  /* Stencil comparison reference value*/
    dhd_uint32_t m_zsu_stencil_write_mask : 8;  /* Stencil comparison write mask*/
    dhd_uint32_t m_zsu_stencil_bias       : 8;  /* Stencil bias*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_zsu_ctrl2_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TXA_Size_0 layout ( Texture size of texture unit #0 )*/
/**/
typedef union tagdhd_reg_txa_size_0_t {
  struct tagdhd_reg_txa_size_0_fields_t {
    dhd_uint32_t m_txa_width_0  : 13;  /* Width of the texture in texels*/
    dhd_uint32_t m_reserved2    : 3;   
    dhd_uint32_t m_txa_height_0 : 13;  /* Height of the texture in texels*/
    dhd_uint32_t m_reserved1    : 3;   
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_txa_size_0_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TXA_Access_0 layout ( Filter shape, size and texture pitch of texture unit #0 )*/
/**/
typedef union tagdhd_reg_txa_access_0_t {
  struct tagdhd_reg_txa_access_0_fields_t {
    dhd_uint32_t m_txa_pitch_0                : 13;  /* Unsigned pitch of the texture in texels. Needs to be 0 in case of full swizzling!*/
    dhd_uint32_t m_reserved3                  : 3;   
    dhd_uint32_t m_txa_filter_kernel_height_0 : 4;   /* Size of filter kernel in V direction-1*/
    dhd_uint32_t m_reserved2                  : 4;   
    dhd_uint32_t m_txa_filter_kernel_width_0  : 4;   /* Size of filter kernel in U direction-1*/
    dhd_uint32_t m_reserved1                  : 2;   
    dhd_uint32_t m_txa_filter_sample_shape_0  : 2;   /* Shape of a texture filter sample*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_txa_access_0_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TXA_Size_1 layout ( Texture size of texture unit #1 )*/
/**/
typedef union tagdhd_reg_txa_size_1_t {
  struct tagdhd_reg_txa_size_1_fields_t {
    dhd_uint32_t m_txa_width_1  : 13;  /* Width of the texture in texels*/
    dhd_uint32_t m_reserved2    : 3;   
    dhd_uint32_t m_txa_height_1 : 13;  /* Height of the texture in texels*/
    dhd_uint32_t m_reserved1    : 3;   
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_txa_size_1_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TXA_Access_1 layout ( Filter shape, size and texture pitch of texture unit #1 )*/
/**/
typedef union tagdhd_reg_txa_access_1_t {
  struct tagdhd_reg_txa_access_1_fields_t {
    dhd_uint32_t m_txa_pitch_1                : 13;  /* Unsigned pitch of the texture in texels. Needs to be 0 in case of full swizzling!*/
    dhd_uint32_t m_reserved3                  : 3;   
    dhd_uint32_t m_txa_filter_kernel_height_1 : 4;   /* Size of filter kernel in V direction-1*/
    dhd_uint32_t m_reserved2                  : 4;   
    dhd_uint32_t m_txa_filter_kernel_width_1  : 4;   /* Size of filter kernel in U direction-1*/
    dhd_uint32_t m_reserved1                  : 2;   
    dhd_uint32_t m_txa_filter_sample_shape_1  : 2;   /* Shape of a texture filter sample*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_txa_access_1_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TEX_Global layout ( Global texture unit register )*/
/**/
typedef union tagdhd_reg_tex_global_t {
  struct tagdhd_reg_tex_global_fields_t {
    dhd_uint32_t m_tex_num_units    : 4;   /* Number of active texture units*/
    dhd_uint32_t m_tex_depth_enable : 1;   /* Activate interpolation of depth as additional pair of U/V coordinates*/
    dhd_uint32_t m_reserved2        : 7;   
    dhd_uint32_t m_rld_pixel_width  : 2;   /* Number of bytes per pixel (0=1byte; 1=2bytes; 2=3bytes; 3=4bytes)*/
    dhd_uint32_t m_reserved1        : 16;  
    dhd_uint32_t m_txc_debug_mode   : 2;   /* Texture cache debug mode*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_tex_global_t;

/*----------------------------------------------------------------------------------------------------------*/
/* COL_Global layout ( Global color unit registers )*/
/**/
typedef union tagdhd_reg_col_global_t {
  struct tagdhd_reg_col_global_fields_t {
    dhd_uint32_t m_col_num_passes : 5;   /* Number of active color unit passes*/
    dhd_uint32_t m_reserved1      : 27;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_col_global_t;

/*----------------------------------------------------------------------------------------------------------*/
/* FBD_Config layout ( Framebuffer read decision registers )*/
/**/
typedef union tagdhd_reg_fbd_config_t {
  struct tagdhd_reg_fbd_config_fields_t {
    dhd_uint32_t m_fbd_alpha_test_op       : 3;   /* Alpha test operation: Decides whether the source pixel is passed on or dropped*/
    dhd_uint32_t m_reserved3               : 1;   
    dhd_uint32_t m_fbd_read_decision_flags : 3;   /* Framebuffer read decision flags*/
    dhd_uint32_t m_reserved2               : 1;   
    dhd_uint32_t m_fbd_alpha_test_ref      : 8;   /* Alpha test comparison reference value*/
    dhd_uint32_t m_reserved1               : 16;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_fbd_config_t;

/*----------------------------------------------------------------------------------------------------------*/
/* FBS_Pitch layout ( Framebuffer cache scheduler pitch and debug control )*/
/**/
typedef union tagdhd_reg_fbs_pitch_t {
  struct tagdhd_reg_fbs_pitch_fields_t {
    dhd_uint32_t m_fbs_pitch        : 13;  /* Framebuffer pitch*/
    dhd_uint32_t m_reserved2        : 3;   
    dhd_uint32_t m_fbs_debug_enable : 1;   /* Enable framebuffer cache scheduler debug mode*/
    dhd_uint32_t m_reserved1        : 15;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_fbs_pitch_t;

/*----------------------------------------------------------------------------------------------------------*/
/* FBS_Span_Config layout ( Framebuffer cache scheduler span config )*/
/**/
typedef union tagdhd_reg_fbs_span_config_t {
  struct tagdhd_reg_fbs_span_config_fields_t {
    dhd_uint32_t m_fbs_span_length_limit     : 10;  /* Maximum length of a span for the framebuffer cache in pixels-1*/
    dhd_uint32_t m_reserved2                 : 6;   
    dhd_uint32_t m_fbs_read_gap_length_limit : 10;  /* Maximum length of a read gap inside a span for the framebuffer cache in pixels*/
    dhd_uint32_t m_reserved1                 : 6;   
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_fbs_span_config_t;

/*----------------------------------------------------------------------------------------------------------*/
/* RLD_Start_Address layout ( Start address of RLE code of the texture in memory )*/
/**/
typedef union tagdhd_reg_rld_start_address_t {
  struct tagdhd_reg_rld_start_address_fields_t {
    dhd_uint32_t m_rld_start_address : 32;  /* Start address of RLE code of the texture in memory. Must be aligned to MBI bus width.*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_rld_start_address_t;

/*----------------------------------------------------------------------------------------------------------*/
/* COL_Const_Color_0 layout ( Constant color register #0 )*/
/**/
typedef union tagdhd_reg_col_const_color_0_t {
  struct tagdhd_reg_col_const_color_0_fields_t {
    dhd_uint32_t m_col_const_color_0 : 32;  /* constant color register*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_col_const_color_0_t;

/*----------------------------------------------------------------------------------------------------------*/
/* COL_Const_Color_1 layout ( Constant color register #1 )*/
/**/
typedef union tagdhd_reg_col_const_color_1_t {
  struct tagdhd_reg_col_const_color_1_fields_t {
    dhd_uint32_t m_col_const_color_1 : 32;  /* constant color register*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_col_const_color_1_t;

/*----------------------------------------------------------------------------------------------------------*/
/* COL_Const_Color_2 layout ( Constant color register #2 )*/
/**/
typedef union tagdhd_reg_col_const_color_2_t {
  struct tagdhd_reg_col_const_color_2_fields_t {
    dhd_uint32_t m_col_const_color_2 : 32;  /* constant color register*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_col_const_color_2_t;

/*----------------------------------------------------------------------------------------------------------*/
/* COL_Const_Color_3 layout ( Constant color register #3 )*/
/**/
typedef union tagdhd_reg_col_const_color_3_t {
  struct tagdhd_reg_col_const_color_3_fields_t {
    dhd_uint32_t m_col_const_color_3 : 32;  /* constant color register*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_col_const_color_3_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TEX_Mode_0 layout ( Texture mode of texture unit #0 )*/
/**/
typedef union tagdhd_reg_tex_mode_0_t {
  struct tagdhd_reg_tex_mode_0_fields_t {
    dhd_uint32_t m_txa_wrap_mode_u_0          : 2;  /* Wrap mode in U direction*/
    dhd_uint32_t m_reserved8                  : 1;  
    dhd_uint32_t m_tex_filter_u_0             : 1;  /* Filter enable in U direction*/
    dhd_uint32_t m_txa_wrap_mode_v_0          : 2;  /* Wrap mode in V direction*/
    dhd_uint32_t m_reserved7                  : 1;  
    dhd_uint32_t m_tex_filter_v_0             : 1;  /* Filter enable in V direction*/
    dhd_uint32_t m_tex_org_0                  : 4;  /* Texel organization/format of texture*/
    dhd_uint32_t m_reserved6                  : 1;  
    dhd_uint32_t m_txp_limit_color_to_alpha_0 : 1;  /* Boolean value: Limit color values of R,G and B channels to the alpha channel value when enabled (for pre-multiplied formats).*/
    dhd_uint32_t m_reserved5                  : 2;  
    dhd_uint32_t m_txa_swizzle_mode_0         : 3;  /* Swizzle mode of texture*/
    dhd_uint32_t m_reserved4                  : 1;  
    dhd_uint32_t m_tex_virtual_tiling_mode_0  : 3;  /* Virtual tiling mode of texture*/
    dhd_uint32_t m_reserved3                  : 1;  
    dhd_uint32_t m_txa_address_bit_offset_0   : 3;  /* Bit offset of start of texture relative to byte pointed to by Txc_Start_Address_Reg.*/
    dhd_uint32_t m_reserved2                  : 1;  
    dhd_uint32_t m_txp_discard_alpha_0        : 1;  /* Boolean value: Set alpha to 1.0 instead of using value read from texture. Can be used to set alpha to 1.0 in RGB565 and luminance formats. When CLUT is enabled and contains an alpha value, the alpha value from the CLUT is used instead of a constant 1.0.*/
    dhd_uint32_t m_reserved1                  : 3;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_tex_mode_0_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TXC_Start_Address_0 layout ( Start address of top-left texel of the texture in memory of texture unit #0 )*/
/**/
typedef union tagdhd_reg_txc_start_address_0_t {
  struct tagdhd_reg_txc_start_address_0_fields_t {
    dhd_uint32_t m_txc_start_address_0 : 32;  /* Start address of top-left texel of the texture in memory. May be unaligned to MBI bus width in case of linear stored textures with linear addressing: LSB part is applied inside TXA module.*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_txc_start_address_0_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TXP_Ctrl_0 layout ( TXP control of texture unit #0 )*/
/**/
typedef union tagdhd_reg_txp_ctrl_0_t {
  struct tagdhd_reg_txp_ctrl_0_fields_t {
    dhd_uint32_t m_txp_clut_mode_0        : 3;   /* Configure usage of LUT in texel processing*/
    dhd_uint32_t m_reserved4              : 1;   
    dhd_uint32_t m_txp_color_key_enable_0 : 1;   /* Boolean value: Replace alpha and RGB of pixel by all 0 when color key matches.*/
    dhd_uint32_t m_reserved3              : 3;   
    dhd_uint32_t m_txc_use_rld_0          : 1;   /* Texture is run length encoded (RLE), use RLD for decoding (since there is only one RLD unit max one of the texture units can set this bit)*/
    dhd_uint32_t m_reserved2              : 7;   
    dhd_uint32_t m_txc_burst_pitch_0      : 15;  /* Pitch in bytes between two bursts if texture cache operates in virtual tiling mode.*/
    dhd_uint32_t m_reserved1              : 1;   
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_txp_ctrl_0_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TXP_Clut_Offset_0 layout ( Offset for CLUT lookups of texture unit #0 )*/
/**/
typedef union tagdhd_reg_txp_clut_offset_0_t {
  struct tagdhd_reg_txp_clut_offset_0_fields_t {
    dhd_uint32_t m_txp_clut_offset_0 : 11;  /* Offset for all CLUT lookups of the texture unit*/
    dhd_uint32_t m_reserved1         : 21;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_txp_clut_offset_0_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TXP_Color_Key_0 layout ( Color key comparison value of texture unit #0 )*/
/**/
typedef union tagdhd_reg_txp_color_key_0_t {
  struct tagdhd_reg_txp_color_key_0_fields_t {
    dhd_uint32_t m_txp_color_key_0 : 24;  /* Color key comparison value*/
    dhd_uint32_t m_reserved1       : 8;   
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_txp_color_key_0_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TXP_Fill_Color_0 layout ( Texel fill color for wrap mode FILL of texture unit #0 )*/
/**/
typedef union tagdhd_reg_txp_fill_color_0_t {
  struct tagdhd_reg_txp_fill_color_0_fields_t {
    dhd_uint32_t m_txp_fill_color_0 : 32;  /* Texel fill color for wrap mode FILL*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_txp_fill_color_0_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TXP_Filter_Scale_Bias_0 layout ( Scale and bias for filter in TXP of texture unit #0 )*/
/**/
typedef union tagdhd_reg_txp_filter_scale_bias_0_t {
  struct tagdhd_reg_txp_filter_scale_bias_0_fields_t {
    dhd_uint32_t m_txp_filter_scale_0 : 10;  /* Scale for filtering in TXP unit*/
    dhd_uint32_t m_reserved3          : 2;   
    dhd_int32_t  m_txp_filter_shift_0 : 6;   /* Shift of scale for filtering in TXP unit*/
    dhd_uint32_t m_reserved2          : 2;   
    dhd_int32_t  m_txp_filter_bias_0  : 9;   /* Bias for filtering in TXP unit*/
    dhd_uint32_t m_reserved1          : 3;   
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_txp_filter_scale_bias_0_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TEX_Mode_1 layout ( Texture mode of texture unit #1 )*/
/**/
typedef union tagdhd_reg_tex_mode_1_t {
  struct tagdhd_reg_tex_mode_1_fields_t {
    dhd_uint32_t m_txa_wrap_mode_u_1          : 2;  /* Wrap mode in U direction*/
    dhd_uint32_t m_reserved8                  : 1;  
    dhd_uint32_t m_tex_filter_u_1             : 1;  /* Filter enable in U direction*/
    dhd_uint32_t m_txa_wrap_mode_v_1          : 2;  /* Wrap mode in V direction*/
    dhd_uint32_t m_reserved7                  : 1;  
    dhd_uint32_t m_tex_filter_v_1             : 1;  /* Filter enable in V direction*/
    dhd_uint32_t m_tex_org_1                  : 4;  /* Texel organization/format of texture*/
    dhd_uint32_t m_reserved6                  : 1;  
    dhd_uint32_t m_txp_limit_color_to_alpha_1 : 1;  /* Boolean value: Limit color values of R,G and B channels to the alpha channel value when enabled (for pre-multiplied formats).*/
    dhd_uint32_t m_reserved5                  : 2;  
    dhd_uint32_t m_txa_swizzle_mode_1         : 3;  /* Swizzle mode of texture*/
    dhd_uint32_t m_reserved4                  : 1;  
    dhd_uint32_t m_tex_virtual_tiling_mode_1  : 3;  /* Virtual tiling mode of texture*/
    dhd_uint32_t m_reserved3                  : 1;  
    dhd_uint32_t m_txa_address_bit_offset_1   : 3;  /* Bit offset of start of texture relative to byte pointed to by Txc_Start_Address_Reg.*/
    dhd_uint32_t m_reserved2                  : 1;  
    dhd_uint32_t m_txp_discard_alpha_1        : 1;  /* Boolean value: Set alpha to 1.0 instead of using value read from texture. Can be used to set alpha to 1.0 in RGB565 and luminance formats. When CLUT is enabled and contains an alpha value, the alpha value from the CLUT is used instead of a constant 1.0.*/
    dhd_uint32_t m_reserved1                  : 3;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_tex_mode_1_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TXC_Start_Address_1 layout ( Start address of top-left texel of the texture in memory of texture unit #1 )*/
/**/
typedef union tagdhd_reg_txc_start_address_1_t {
  struct tagdhd_reg_txc_start_address_1_fields_t {
    dhd_uint32_t m_txc_start_address_1 : 32;  /* Start address of top-left texel of the texture in memory. May be unaligned to MBI bus width in case of linear stored textures with linear addressing: LSB part is applied inside TXA module.*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_txc_start_address_1_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TXP_Ctrl_1 layout ( TXP control of texture unit #1 )*/
/**/
typedef union tagdhd_reg_txp_ctrl_1_t {
  struct tagdhd_reg_txp_ctrl_1_fields_t {
    dhd_uint32_t m_txp_clut_mode_1        : 3;   /* Configure usage of LUT in texel processing*/
    dhd_uint32_t m_reserved4              : 1;   
    dhd_uint32_t m_txp_color_key_enable_1 : 1;   /* Boolean value: Replace alpha and RGB of pixel by all 0 when color key matches.*/
    dhd_uint32_t m_reserved3              : 3;   
    dhd_uint32_t m_txc_use_rld_1          : 1;   /* Texture is run length encoded (RLE), use RLD for decoding (since there is only one RLD unit max one of the texture units can set this bit)*/
    dhd_uint32_t m_reserved2              : 7;   
    dhd_uint32_t m_txc_burst_pitch_1      : 15;  /* Pitch in bytes between two bursts if texture cache operates in virtual tiling mode.*/
    dhd_uint32_t m_reserved1              : 1;   
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_txp_ctrl_1_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TXP_Clut_Offset_1 layout ( Offset for CLUT lookups of texture unit #1 )*/
/**/
typedef union tagdhd_reg_txp_clut_offset_1_t {
  struct tagdhd_reg_txp_clut_offset_1_fields_t {
    dhd_uint32_t m_txp_clut_offset_1 : 11;  /* Offset for all CLUT lookups of the texture unit*/
    dhd_uint32_t m_reserved1         : 21;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_txp_clut_offset_1_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TXP_Color_Key_1 layout ( Color key comparison value of texture unit #1 )*/
/**/
typedef union tagdhd_reg_txp_color_key_1_t {
  struct tagdhd_reg_txp_color_key_1_fields_t {
    dhd_uint32_t m_txp_color_key_1 : 24;  /* Color key comparison value*/
    dhd_uint32_t m_reserved1       : 8;   
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_txp_color_key_1_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TXP_Fill_Color_1 layout ( Texel fill color for wrap mode FILL of texture unit #1 )*/
/**/
typedef union tagdhd_reg_txp_fill_color_1_t {
  struct tagdhd_reg_txp_fill_color_1_fields_t {
    dhd_uint32_t m_txp_fill_color_1 : 32;  /* Texel fill color for wrap mode FILL*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_txp_fill_color_1_t;

/*----------------------------------------------------------------------------------------------------------*/
/* TXP_Filter_Scale_Bias_1 layout ( Scale and bias for filter in TXP of texture unit #1 )*/
/**/
typedef union tagdhd_reg_txp_filter_scale_bias_1_t {
  struct tagdhd_reg_txp_filter_scale_bias_1_fields_t {
    dhd_uint32_t m_txp_filter_scale_1 : 10;  /* Scale for filtering in TXP unit*/
    dhd_uint32_t m_reserved3          : 2;   
    dhd_int32_t  m_txp_filter_shift_1 : 6;   /* Shift of scale for filtering in TXP unit*/
    dhd_uint32_t m_reserved2          : 2;   
    dhd_int32_t  m_txp_filter_bias_1  : 9;   /* Bias for filtering in TXP unit*/
    dhd_uint32_t m_reserved1          : 3;   
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_txp_filter_scale_bias_1_t;

/*----------------------------------------------------------------------------------------------------------*/
/* COL_ARGB_Op1a_0 layout ( Control structure for Op1a of color pass 0 (Alpha and RGB path) )*/
/**/
typedef union tagdhd_reg_col_argb_op1a_0_t {
  struct tagdhd_reg_col_argb_op1a_0_fields_t {
    dhd_uint32_t m_col_rgb_op1a_input_select_0   : 5;  /* Select input for Op*/
    dhd_uint32_t m_reserved5                     : 1;  
    dhd_uint32_t m_col_blue_op1a_argb_select_0   : 2;  /* Select A, R, G or B for Op (blue path)*/
    dhd_uint32_t m_col_green_op1a_argb_select_0  : 2;  /* Select A, R, G or B for Op (green path)*/
    dhd_uint32_t m_col_red_op1a_argb_select_0    : 2;  /* Select A, R, G or B for Op (red path)*/
    dhd_uint32_t m_col_rgb_op1a_invert_mode_0    : 2;  /* Select inversion mode for Op*/
    dhd_uint32_t m_col_rgb_op1a_mul2_0           : 1;  /* Enable shift left by 1 for Op*/
    dhd_uint32_t m_reserved4                     : 1;  
    dhd_uint32_t m_col_alpha_op1a_input_select_0 : 5;  /* Select input for Op*/
    dhd_uint32_t m_reserved3                     : 3;  
    dhd_uint32_t m_col_alpha_op1a_argb_select_0  : 2;  /* Select A, R, G or B for Op*/
    dhd_uint32_t m_reserved2                     : 2;  
    dhd_uint32_t m_col_alpha_op1a_invert_mode_0  : 2;  /* Select inversion mode for Op*/
    dhd_uint32_t m_col_alpha_op1a_mul2_0         : 1;  /* Enable shift left by 1 for Op*/
    dhd_uint32_t m_reserved1                     : 1;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_col_argb_op1a_0_t;

/*----------------------------------------------------------------------------------------------------------*/
/* COL_ARGB_Op1b_0 layout ( Control structure for Op1b of color pass 0 (Alpha and RGB path) )*/
/**/
typedef union tagdhd_reg_col_argb_op1b_0_t {
  struct tagdhd_reg_col_argb_op1b_0_fields_t {
    dhd_uint32_t m_col_rgb_op1b_input_select_0   : 5;  /* Select input for Op*/
    dhd_uint32_t m_reserved3                     : 1;  
    dhd_uint32_t m_col_blue_op1b_argb_select_0   : 2;  /* Select A, R, G or B for Op (blue path)*/
    dhd_uint32_t m_col_green_op1b_argb_select_0  : 2;  /* Select A, R, G or B for Op (green path)*/
    dhd_uint32_t m_col_red_op1b_argb_select_0    : 2;  /* Select A, R, G or B for Op (red path)*/
    dhd_uint32_t m_col_rgb_op1b_invert_mode_0    : 2;  /* Select inversion mode for Op*/
    dhd_uint32_t m_col_rgb_op1b_mul2_0           : 1;  /* Enable shift left by 1 for Op*/
    dhd_uint32_t m_col_rgb_carry1_0              : 1;  /* Enable carry in for first adder in color unit*/
    dhd_uint32_t m_col_alpha_op1b_input_select_0 : 5;  /* Select input for Op*/
    dhd_uint32_t m_reserved2                     : 3;  
    dhd_uint32_t m_col_alpha_op1b_argb_select_0  : 2;  /* Select A, R, G or B for Op*/
    dhd_uint32_t m_reserved1                     : 2;  
    dhd_uint32_t m_col_alpha_op1b_invert_mode_0  : 2;  /* Select inversion mode for Op*/
    dhd_uint32_t m_col_alpha_op1b_mul2_0         : 1;  /* Enable shift left by 1 for Op*/
    dhd_uint32_t m_col_alpha_carry1_0            : 1;  /* Enable carry in for first adder in color unit*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_col_argb_op1b_0_t;

/*----------------------------------------------------------------------------------------------------------*/
/* COL_ARGB_Op2a_0 layout ( Control structure for Op2a of color pass 0 (Alpha and RGB path) )*/
/**/
typedef union tagdhd_reg_col_argb_op2a_0_t {
  struct tagdhd_reg_col_argb_op2a_0_fields_t {
    dhd_uint32_t m_col_rgb_op2a_input_select_0   : 5;  /* Select input for Op*/
    dhd_uint32_t m_reserved5                     : 1;  
    dhd_uint32_t m_col_blue_op2a_argb_select_0   : 2;  /* Select A, R, G or B for Op (blue path)*/
    dhd_uint32_t m_col_green_op2a_argb_select_0  : 2;  /* Select A, R, G or B for Op (green path)*/
    dhd_uint32_t m_col_red_op2a_argb_select_0    : 2;  /* Select A, R, G or B for Op (red path)*/
    dhd_uint32_t m_col_rgb_op2a_invert_mode_0    : 2;  /* Select inversion mode for Op*/
    dhd_uint32_t m_col_rgb_op2a_mul2_0           : 1;  /* Enable shift left by 1 for Op*/
    dhd_uint32_t m_reserved4                     : 1;  
    dhd_uint32_t m_col_alpha_op2a_input_select_0 : 5;  /* Select input for Op*/
    dhd_uint32_t m_reserved3                     : 3;  
    dhd_uint32_t m_col_alpha_op2a_argb_select_0  : 2;  /* Select A, R, G or B for Op*/
    dhd_uint32_t m_reserved2                     : 2;  
    dhd_uint32_t m_col_alpha_op2a_invert_mode_0  : 2;  /* Select inversion mode for Op*/
    dhd_uint32_t m_col_alpha_op2a_mul2_0         : 1;  /* Enable shift left by 1 for Op*/
    dhd_uint32_t m_reserved1                     : 1;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_col_argb_op2a_0_t;

/*----------------------------------------------------------------------------------------------------------*/
/* COL_ARGB_Op2b_0 layout ( Control structure for Op2b of color pass 0 (Alpha and RGB path) )*/
/**/
typedef union tagdhd_reg_col_argb_op2b_0_t {
  struct tagdhd_reg_col_argb_op2b_0_fields_t {
    dhd_uint32_t m_col_rgb_op2b_input_select_0   : 5;  /* Select input for Op*/
    dhd_uint32_t m_reserved3                     : 1;  
    dhd_uint32_t m_col_blue_op2b_argb_select_0   : 2;  /* Select A, R, G or B for Op (blue path)*/
    dhd_uint32_t m_col_green_op2b_argb_select_0  : 2;  /* Select A, R, G or B for Op (green path)*/
    dhd_uint32_t m_col_red_op2b_argb_select_0    : 2;  /* Select A, R, G or B for Op (red path)*/
    dhd_uint32_t m_col_rgb_op2b_invert_mode_0    : 2;  /* Select inversion mode for Op*/
    dhd_uint32_t m_col_rgb_op2b_mul2_0           : 1;  /* Enable shift left by 1 for Op*/
    dhd_uint32_t m_col_rgb_carry2_0              : 1;  /* Enable carry in for second adder in color unit*/
    dhd_uint32_t m_col_alpha_op2b_input_select_0 : 5;  /* Select input for Op*/
    dhd_uint32_t m_reserved2                     : 3;  
    dhd_uint32_t m_col_alpha_op2b_argb_select_0  : 2;  /* Select A, R, G or B for Op*/
    dhd_uint32_t m_reserved1                     : 2;  
    dhd_uint32_t m_col_alpha_op2b_invert_mode_0  : 2;  /* Select inversion mode for Op*/
    dhd_uint32_t m_col_alpha_op2b_mul2_0         : 1;  /* Enable shift left by 1 for Op*/
    dhd_uint32_t m_col_alpha_carry2_0            : 1;  /* Enable carry in for second adder in color unit*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_col_argb_op2b_0_t;

/*----------------------------------------------------------------------------------------------------------*/
/* COL_ARGB_Op3_0 layout ( Control structure for Op3 of color pass 0 (Alpha and RGB path) )*/
/**/
typedef union tagdhd_reg_col_argb_op3_0_t {
  struct tagdhd_reg_col_argb_op3_0_fields_t {
    dhd_uint32_t m_col_rgb_op3_input_select_0   : 5;  /* Select input for Op*/
    dhd_uint32_t m_reserved5                    : 1;  
    dhd_uint32_t m_col_blue_op3_argb_select_0   : 2;  /* Select A, R, G or B for Op (blue path)*/
    dhd_uint32_t m_col_green_op3_argb_select_0  : 2;  /* Select A, R, G or B for Op (green path)*/
    dhd_uint32_t m_col_red_op3_argb_select_0    : 2;  /* Select A, R, G or B for Op (red path)*/
    dhd_uint32_t m_col_rgb_op3_invert_mode_0    : 2;  /* Select inversion mode for Op*/
    dhd_uint32_t m_col_rgb_op3_mul2_0           : 1;  /* Enable shift left by 1 for Op*/
    dhd_uint32_t m_reserved4                    : 1;  
    dhd_uint32_t m_col_alpha_op3_input_select_0 : 5;  /* Select input for Op*/
    dhd_uint32_t m_reserved3                    : 3;  
    dhd_uint32_t m_col_alpha_op3_argb_select_0  : 2;  /* Select A, R, G or B for Op*/
    dhd_uint32_t m_reserved2                    : 2;  
    dhd_uint32_t m_col_alpha_op3_invert_mode_0  : 2;  /* Select inversion mode for Op*/
    dhd_uint32_t m_col_alpha_op3_mul2_0         : 1;  /* Enable shift left by 1 for Op*/
    dhd_uint32_t m_reserved1                    : 1;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_col_argb_op3_0_t;

/*----------------------------------------------------------------------------------------------------------*/
/* COL_ARGB_Out_0 layout ( Control structure for core output of color pass 0 (Alpha and RGB path) )*/
/**/
typedef union tagdhd_reg_col_argb_out_0_t {
  struct tagdhd_reg_col_argb_out_0_fields_t {
    dhd_uint32_t m_col_rgb_scale_out_0   : 2;   /* Select scale mode for output value*/
    dhd_uint32_t m_reserved4             : 10;  
    dhd_uint32_t m_col_rgb_clamp_out_0   : 1;   /* Enable clamping of output value to range 0..255 (-256 to 255 otherwise)*/
    dhd_uint32_t m_reserved3             : 3;   
    dhd_uint32_t m_col_alpha_scale_out_0 : 2;   /* Select scale mode for output value*/
    dhd_uint32_t m_reserved2             : 10;  
    dhd_uint32_t m_col_alpha_clamp_out_0 : 1;   /* Enable clamping of output value to range 0..255 (-256 to 255 otherwise)*/
    dhd_uint32_t m_reserved1             : 3;   
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_col_argb_out_0_t;

/*----------------------------------------------------------------------------------------------------------*/
/* COL_ARGB_Op1a_1 layout ( Control structure for Op1a of color pass 1 (Alpha and RGB path) )*/
/**/
typedef union tagdhd_reg_col_argb_op1a_1_t {
  struct tagdhd_reg_col_argb_op1a_1_fields_t {
    dhd_uint32_t m_col_rgb_op1a_input_select_1   : 5;  /* Select input for Op*/
    dhd_uint32_t m_reserved5                     : 1;  
    dhd_uint32_t m_col_blue_op1a_argb_select_1   : 2;  /* Select A, R, G or B for Op (blue path)*/
    dhd_uint32_t m_col_green_op1a_argb_select_1  : 2;  /* Select A, R, G or B for Op (green path)*/
    dhd_uint32_t m_col_red_op1a_argb_select_1    : 2;  /* Select A, R, G or B for Op (red path)*/
    dhd_uint32_t m_col_rgb_op1a_invert_mode_1    : 2;  /* Select inversion mode for Op*/
    dhd_uint32_t m_col_rgb_op1a_mul2_1           : 1;  /* Enable shift left by 1 for Op*/
    dhd_uint32_t m_reserved4                     : 1;  
    dhd_uint32_t m_col_alpha_op1a_input_select_1 : 5;  /* Select input for Op*/
    dhd_uint32_t m_reserved3                     : 3;  
    dhd_uint32_t m_col_alpha_op1a_argb_select_1  : 2;  /* Select A, R, G or B for Op*/
    dhd_uint32_t m_reserved2                     : 2;  
    dhd_uint32_t m_col_alpha_op1a_invert_mode_1  : 2;  /* Select inversion mode for Op*/
    dhd_uint32_t m_col_alpha_op1a_mul2_1         : 1;  /* Enable shift left by 1 for Op*/
    dhd_uint32_t m_reserved1                     : 1;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_col_argb_op1a_1_t;

/*----------------------------------------------------------------------------------------------------------*/
/* COL_ARGB_Op1b_1 layout ( Control structure for Op1b of color pass 1 (Alpha and RGB path) )*/
/**/
typedef union tagdhd_reg_col_argb_op1b_1_t {
  struct tagdhd_reg_col_argb_op1b_1_fields_t {
    dhd_uint32_t m_col_rgb_op1b_input_select_1   : 5;  /* Select input for Op*/
    dhd_uint32_t m_reserved3                     : 1;  
    dhd_uint32_t m_col_blue_op1b_argb_select_1   : 2;  /* Select A, R, G or B for Op (blue path)*/
    dhd_uint32_t m_col_green_op1b_argb_select_1  : 2;  /* Select A, R, G or B for Op (green path)*/
    dhd_uint32_t m_col_red_op1b_argb_select_1    : 2;  /* Select A, R, G or B for Op (red path)*/
    dhd_uint32_t m_col_rgb_op1b_invert_mode_1    : 2;  /* Select inversion mode for Op*/
    dhd_uint32_t m_col_rgb_op1b_mul2_1           : 1;  /* Enable shift left by 1 for Op*/
    dhd_uint32_t m_col_rgb_carry1_1              : 1;  /* Enable carry in for first adder in color unit*/
    dhd_uint32_t m_col_alpha_op1b_input_select_1 : 5;  /* Select input for Op*/
    dhd_uint32_t m_reserved2                     : 3;  
    dhd_uint32_t m_col_alpha_op1b_argb_select_1  : 2;  /* Select A, R, G or B for Op*/
    dhd_uint32_t m_reserved1                     : 2;  
    dhd_uint32_t m_col_alpha_op1b_invert_mode_1  : 2;  /* Select inversion mode for Op*/
    dhd_uint32_t m_col_alpha_op1b_mul2_1         : 1;  /* Enable shift left by 1 for Op*/
    dhd_uint32_t m_col_alpha_carry1_1            : 1;  /* Enable carry in for first adder in color unit*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_col_argb_op1b_1_t;

/*----------------------------------------------------------------------------------------------------------*/
/* COL_ARGB_Op2a_1 layout ( Control structure for Op2a of color pass 1 (Alpha and RGB path) )*/
/**/
typedef union tagdhd_reg_col_argb_op2a_1_t {
  struct tagdhd_reg_col_argb_op2a_1_fields_t {
    dhd_uint32_t m_col_rgb_op2a_input_select_1   : 5;  /* Select input for Op*/
    dhd_uint32_t m_reserved5                     : 1;  
    dhd_uint32_t m_col_blue_op2a_argb_select_1   : 2;  /* Select A, R, G or B for Op (blue path)*/
    dhd_uint32_t m_col_green_op2a_argb_select_1  : 2;  /* Select A, R, G or B for Op (green path)*/
    dhd_uint32_t m_col_red_op2a_argb_select_1    : 2;  /* Select A, R, G or B for Op (red path)*/
    dhd_uint32_t m_col_rgb_op2a_invert_mode_1    : 2;  /* Select inversion mode for Op*/
    dhd_uint32_t m_col_rgb_op2a_mul2_1           : 1;  /* Enable shift left by 1 for Op*/
    dhd_uint32_t m_reserved4                     : 1;  
    dhd_uint32_t m_col_alpha_op2a_input_select_1 : 5;  /* Select input for Op*/
    dhd_uint32_t m_reserved3                     : 3;  
    dhd_uint32_t m_col_alpha_op2a_argb_select_1  : 2;  /* Select A, R, G or B for Op*/
    dhd_uint32_t m_reserved2                     : 2;  
    dhd_uint32_t m_col_alpha_op2a_invert_mode_1  : 2;  /* Select inversion mode for Op*/
    dhd_uint32_t m_col_alpha_op2a_mul2_1         : 1;  /* Enable shift left by 1 for Op*/
    dhd_uint32_t m_reserved1                     : 1;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_col_argb_op2a_1_t;

/*----------------------------------------------------------------------------------------------------------*/
/* COL_ARGB_Op2b_1 layout ( Control structure for Op2b of color pass 1 (Alpha and RGB path) )*/
/**/
typedef union tagdhd_reg_col_argb_op2b_1_t {
  struct tagdhd_reg_col_argb_op2b_1_fields_t {
    dhd_uint32_t m_col_rgb_op2b_input_select_1   : 5;  /* Select input for Op*/
    dhd_uint32_t m_reserved3                     : 1;  
    dhd_uint32_t m_col_blue_op2b_argb_select_1   : 2;  /* Select A, R, G or B for Op (blue path)*/
    dhd_uint32_t m_col_green_op2b_argb_select_1  : 2;  /* Select A, R, G or B for Op (green path)*/
    dhd_uint32_t m_col_red_op2b_argb_select_1    : 2;  /* Select A, R, G or B for Op (red path)*/
    dhd_uint32_t m_col_rgb_op2b_invert_mode_1    : 2;  /* Select inversion mode for Op*/
    dhd_uint32_t m_col_rgb_op2b_mul2_1           : 1;  /* Enable shift left by 1 for Op*/
    dhd_uint32_t m_col_rgb_carry2_1              : 1;  /* Enable carry in for second adder in color unit*/
    dhd_uint32_t m_col_alpha_op2b_input_select_1 : 5;  /* Select input for Op*/
    dhd_uint32_t m_reserved2                     : 3;  
    dhd_uint32_t m_col_alpha_op2b_argb_select_1  : 2;  /* Select A, R, G or B for Op*/
    dhd_uint32_t m_reserved1                     : 2;  
    dhd_uint32_t m_col_alpha_op2b_invert_mode_1  : 2;  /* Select inversion mode for Op*/
    dhd_uint32_t m_col_alpha_op2b_mul2_1         : 1;  /* Enable shift left by 1 for Op*/
    dhd_uint32_t m_col_alpha_carry2_1            : 1;  /* Enable carry in for second adder in color unit*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_col_argb_op2b_1_t;

/*----------------------------------------------------------------------------------------------------------*/
/* COL_ARGB_Op3_1 layout ( Control structure for Op3 of color pass 1 (Alpha and RGB path) )*/
/**/
typedef union tagdhd_reg_col_argb_op3_1_t {
  struct tagdhd_reg_col_argb_op3_1_fields_t {
    dhd_uint32_t m_col_rgb_op3_input_select_1   : 5;  /* Select input for Op*/
    dhd_uint32_t m_reserved5                    : 1;  
    dhd_uint32_t m_col_blue_op3_argb_select_1   : 2;  /* Select A, R, G or B for Op (blue path)*/
    dhd_uint32_t m_col_green_op3_argb_select_1  : 2;  /* Select A, R, G or B for Op (green path)*/
    dhd_uint32_t m_col_red_op3_argb_select_1    : 2;  /* Select A, R, G or B for Op (red path)*/
    dhd_uint32_t m_col_rgb_op3_invert_mode_1    : 2;  /* Select inversion mode for Op*/
    dhd_uint32_t m_col_rgb_op3_mul2_1           : 1;  /* Enable shift left by 1 for Op*/
    dhd_uint32_t m_reserved4                    : 1;  
    dhd_uint32_t m_col_alpha_op3_input_select_1 : 5;  /* Select input for Op*/
    dhd_uint32_t m_reserved3                    : 3;  
    dhd_uint32_t m_col_alpha_op3_argb_select_1  : 2;  /* Select A, R, G or B for Op*/
    dhd_uint32_t m_reserved2                    : 2;  
    dhd_uint32_t m_col_alpha_op3_invert_mode_1  : 2;  /* Select inversion mode for Op*/
    dhd_uint32_t m_col_alpha_op3_mul2_1         : 1;  /* Enable shift left by 1 for Op*/
    dhd_uint32_t m_reserved1                    : 1;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_col_argb_op3_1_t;

/*----------------------------------------------------------------------------------------------------------*/
/* COL_ARGB_Out_1 layout ( Control structure for core output of color pass 1 (Alpha and RGB path) )*/
/**/
typedef union tagdhd_reg_col_argb_out_1_t {
  struct tagdhd_reg_col_argb_out_1_fields_t {
    dhd_uint32_t m_col_rgb_scale_out_1   : 2;   /* Select scale mode for output value*/
    dhd_uint32_t m_reserved4             : 10;  
    dhd_uint32_t m_col_rgb_clamp_out_1   : 1;   /* Enable clamping of output value to range 0..255 (-256 to 255 otherwise)*/
    dhd_uint32_t m_reserved3             : 3;   
    dhd_uint32_t m_col_alpha_scale_out_1 : 2;   /* Select scale mode for output value*/
    dhd_uint32_t m_reserved2             : 10;  
    dhd_uint32_t m_col_alpha_clamp_out_1 : 1;   /* Enable clamping of output value to range 0..255 (-256 to 255 otherwise)*/
    dhd_uint32_t m_reserved1             : 3;   
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_col_argb_out_1_t;

/*----------------------------------------------------------------------------------------------------------*/
/* COL_ARGB_Op1a_2 layout ( Control structure for Op1a of color pass 2 (Alpha and RGB path) )*/
/**/
typedef union tagdhd_reg_col_argb_op1a_2_t {
  struct tagdhd_reg_col_argb_op1a_2_fields_t {
    dhd_uint32_t m_col_rgb_op1a_input_select_2   : 5;  /* Select input for Op*/
    dhd_uint32_t m_reserved5                     : 1;  
    dhd_uint32_t m_col_blue_op1a_argb_select_2   : 2;  /* Select A, R, G or B for Op (blue path)*/
    dhd_uint32_t m_col_green_op1a_argb_select_2  : 2;  /* Select A, R, G or B for Op (green path)*/
    dhd_uint32_t m_col_red_op1a_argb_select_2    : 2;  /* Select A, R, G or B for Op (red path)*/
    dhd_uint32_t m_col_rgb_op1a_invert_mode_2    : 2;  /* Select inversion mode for Op*/
    dhd_uint32_t m_col_rgb_op1a_mul2_2           : 1;  /* Enable shift left by 1 for Op*/
    dhd_uint32_t m_reserved4                     : 1;  
    dhd_uint32_t m_col_alpha_op1a_input_select_2 : 5;  /* Select input for Op*/
    dhd_uint32_t m_reserved3                     : 3;  
    dhd_uint32_t m_col_alpha_op1a_argb_select_2  : 2;  /* Select A, R, G or B for Op*/
    dhd_uint32_t m_reserved2                     : 2;  
    dhd_uint32_t m_col_alpha_op1a_invert_mode_2  : 2;  /* Select inversion mode for Op*/
    dhd_uint32_t m_col_alpha_op1a_mul2_2         : 1;  /* Enable shift left by 1 for Op*/
    dhd_uint32_t m_reserved1                     : 1;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_col_argb_op1a_2_t;

/*----------------------------------------------------------------------------------------------------------*/
/* COL_ARGB_Op1b_2 layout ( Control structure for Op1b of color pass 2 (Alpha and RGB path) )*/
/**/
typedef union tagdhd_reg_col_argb_op1b_2_t {
  struct tagdhd_reg_col_argb_op1b_2_fields_t {
    dhd_uint32_t m_col_rgb_op1b_input_select_2   : 5;  /* Select input for Op*/
    dhd_uint32_t m_reserved3                     : 1;  
    dhd_uint32_t m_col_blue_op1b_argb_select_2   : 2;  /* Select A, R, G or B for Op (blue path)*/
    dhd_uint32_t m_col_green_op1b_argb_select_2  : 2;  /* Select A, R, G or B for Op (green path)*/
    dhd_uint32_t m_col_red_op1b_argb_select_2    : 2;  /* Select A, R, G or B for Op (red path)*/
    dhd_uint32_t m_col_rgb_op1b_invert_mode_2    : 2;  /* Select inversion mode for Op*/
    dhd_uint32_t m_col_rgb_op1b_mul2_2           : 1;  /* Enable shift left by 1 for Op*/
    dhd_uint32_t m_col_rgb_carry1_2              : 1;  /* Enable carry in for first adder in color unit*/
    dhd_uint32_t m_col_alpha_op1b_input_select_2 : 5;  /* Select input for Op*/
    dhd_uint32_t m_reserved2                     : 3;  
    dhd_uint32_t m_col_alpha_op1b_argb_select_2  : 2;  /* Select A, R, G or B for Op*/
    dhd_uint32_t m_reserved1                     : 2;  
    dhd_uint32_t m_col_alpha_op1b_invert_mode_2  : 2;  /* Select inversion mode for Op*/
    dhd_uint32_t m_col_alpha_op1b_mul2_2         : 1;  /* Enable shift left by 1 for Op*/
    dhd_uint32_t m_col_alpha_carry1_2            : 1;  /* Enable carry in for first adder in color unit*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_col_argb_op1b_2_t;

/*----------------------------------------------------------------------------------------------------------*/
/* COL_ARGB_Op2a_2 layout ( Control structure for Op2a of color pass 2 (Alpha and RGB path) )*/
/**/
typedef union tagdhd_reg_col_argb_op2a_2_t {
  struct tagdhd_reg_col_argb_op2a_2_fields_t {
    dhd_uint32_t m_col_rgb_op2a_input_select_2   : 5;  /* Select input for Op*/
    dhd_uint32_t m_reserved5                     : 1;  
    dhd_uint32_t m_col_blue_op2a_argb_select_2   : 2;  /* Select A, R, G or B for Op (blue path)*/
    dhd_uint32_t m_col_green_op2a_argb_select_2  : 2;  /* Select A, R, G or B for Op (green path)*/
    dhd_uint32_t m_col_red_op2a_argb_select_2    : 2;  /* Select A, R, G or B for Op (red path)*/
    dhd_uint32_t m_col_rgb_op2a_invert_mode_2    : 2;  /* Select inversion mode for Op*/
    dhd_uint32_t m_col_rgb_op2a_mul2_2           : 1;  /* Enable shift left by 1 for Op*/
    dhd_uint32_t m_reserved4                     : 1;  
    dhd_uint32_t m_col_alpha_op2a_input_select_2 : 5;  /* Select input for Op*/
    dhd_uint32_t m_reserved3                     : 3;  
    dhd_uint32_t m_col_alpha_op2a_argb_select_2  : 2;  /* Select A, R, G or B for Op*/
    dhd_uint32_t m_reserved2                     : 2;  
    dhd_uint32_t m_col_alpha_op2a_invert_mode_2  : 2;  /* Select inversion mode for Op*/
    dhd_uint32_t m_col_alpha_op2a_mul2_2         : 1;  /* Enable shift left by 1 for Op*/
    dhd_uint32_t m_reserved1                     : 1;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_col_argb_op2a_2_t;

/*----------------------------------------------------------------------------------------------------------*/
/* COL_ARGB_Op2b_2 layout ( Control structure for Op2b of color pass 2 (Alpha and RGB path) )*/
/**/
typedef union tagdhd_reg_col_argb_op2b_2_t {
  struct tagdhd_reg_col_argb_op2b_2_fields_t {
    dhd_uint32_t m_col_rgb_op2b_input_select_2   : 5;  /* Select input for Op*/
    dhd_uint32_t m_reserved3                     : 1;  
    dhd_uint32_t m_col_blue_op2b_argb_select_2   : 2;  /* Select A, R, G or B for Op (blue path)*/
    dhd_uint32_t m_col_green_op2b_argb_select_2  : 2;  /* Select A, R, G or B for Op (green path)*/
    dhd_uint32_t m_col_red_op2b_argb_select_2    : 2;  /* Select A, R, G or B for Op (red path)*/
    dhd_uint32_t m_col_rgb_op2b_invert_mode_2    : 2;  /* Select inversion mode for Op*/
    dhd_uint32_t m_col_rgb_op2b_mul2_2           : 1;  /* Enable shift left by 1 for Op*/
    dhd_uint32_t m_col_rgb_carry2_2              : 1;  /* Enable carry in for second adder in color unit*/
    dhd_uint32_t m_col_alpha_op2b_input_select_2 : 5;  /* Select input for Op*/
    dhd_uint32_t m_reserved2                     : 3;  
    dhd_uint32_t m_col_alpha_op2b_argb_select_2  : 2;  /* Select A, R, G or B for Op*/
    dhd_uint32_t m_reserved1                     : 2;  
    dhd_uint32_t m_col_alpha_op2b_invert_mode_2  : 2;  /* Select inversion mode for Op*/
    dhd_uint32_t m_col_alpha_op2b_mul2_2         : 1;  /* Enable shift left by 1 for Op*/
    dhd_uint32_t m_col_alpha_carry2_2            : 1;  /* Enable carry in for second adder in color unit*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_col_argb_op2b_2_t;

/*----------------------------------------------------------------------------------------------------------*/
/* COL_ARGB_Op3_2 layout ( Control structure for Op3 of color pass 2 (Alpha and RGB path) )*/
/**/
typedef union tagdhd_reg_col_argb_op3_2_t {
  struct tagdhd_reg_col_argb_op3_2_fields_t {
    dhd_uint32_t m_col_rgb_op3_input_select_2   : 5;  /* Select input for Op*/
    dhd_uint32_t m_reserved5                    : 1;  
    dhd_uint32_t m_col_blue_op3_argb_select_2   : 2;  /* Select A, R, G or B for Op (blue path)*/
    dhd_uint32_t m_col_green_op3_argb_select_2  : 2;  /* Select A, R, G or B for Op (green path)*/
    dhd_uint32_t m_col_red_op3_argb_select_2    : 2;  /* Select A, R, G or B for Op (red path)*/
    dhd_uint32_t m_col_rgb_op3_invert_mode_2    : 2;  /* Select inversion mode for Op*/
    dhd_uint32_t m_col_rgb_op3_mul2_2           : 1;  /* Enable shift left by 1 for Op*/
    dhd_uint32_t m_reserved4                    : 1;  
    dhd_uint32_t m_col_alpha_op3_input_select_2 : 5;  /* Select input for Op*/
    dhd_uint32_t m_reserved3                    : 3;  
    dhd_uint32_t m_col_alpha_op3_argb_select_2  : 2;  /* Select A, R, G or B for Op*/
    dhd_uint32_t m_reserved2                    : 2;  
    dhd_uint32_t m_col_alpha_op3_invert_mode_2  : 2;  /* Select inversion mode for Op*/
    dhd_uint32_t m_col_alpha_op3_mul2_2         : 1;  /* Enable shift left by 1 for Op*/
    dhd_uint32_t m_reserved1                    : 1;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_col_argb_op3_2_t;

/*----------------------------------------------------------------------------------------------------------*/
/* COL_ARGB_Out_2 layout ( Control structure for core output of color pass 2 (Alpha and RGB path) )*/
/**/
typedef union tagdhd_reg_col_argb_out_2_t {
  struct tagdhd_reg_col_argb_out_2_fields_t {
    dhd_uint32_t m_col_rgb_scale_out_2   : 2;   /* Select scale mode for output value*/
    dhd_uint32_t m_reserved4             : 10;  
    dhd_uint32_t m_col_rgb_clamp_out_2   : 1;   /* Enable clamping of output value to range 0..255 (-256 to 255 otherwise)*/
    dhd_uint32_t m_reserved3             : 3;   
    dhd_uint32_t m_col_alpha_scale_out_2 : 2;   /* Select scale mode for output value*/
    dhd_uint32_t m_reserved2             : 10;  
    dhd_uint32_t m_col_alpha_clamp_out_2 : 1;   /* Enable clamping of output value to range 0..255 (-256 to 255 otherwise)*/
    dhd_uint32_t m_reserved1             : 3;   
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_col_argb_out_2_t;

/*----------------------------------------------------------------------------------------------------------*/
/* FB_Pixel_Org layout ( Framebuffer pixel organization/format )*/
/**/
typedef union tagdhd_reg_fb_pixel_org_t {
  struct tagdhd_reg_fb_pixel_org_fields_t {
    dhd_uint32_t m_fb_pixel_org                : 4;   /* Framebuffer pixel organization/format*/
    dhd_uint32_t m_reserved2                   : 1;   
    dhd_uint32_t m_blu_fb_limit_color_to_alpha : 1;   /* Boolean value: Limit color values of R,G and B channels to the alpha channel value after frame buffer read when enabled (for pre-multiplied formats).*/
    dhd_uint32_t m_reserved1                   : 26;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_fb_pixel_org_t;

/*----------------------------------------------------------------------------------------------------------*/
/* FBC_Start_Address layout ( Framebuffer start address )*/
/**/
typedef union tagdhd_reg_fbc_start_address_t {
  struct tagdhd_reg_fbc_start_address_fields_t {
    dhd_uint32_t m_fbc_start_address : 32;  /* Framebuffer start address. Must be aligned to MBI bus width.*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_fbc_start_address_t;

/*----------------------------------------------------------------------------------------------------------*/
/* BLU_Blend layout ( Blend unit factor and mode )*/
/**/
typedef union tagdhd_reg_blu_blend_t {
  struct tagdhd_reg_blu_blend_fields_t {
    dhd_uint32_t m_blu_color_src_blend_factor_select    : 2;  /* Source blend factor for color channel blending*/
    dhd_uint32_t m_reserved7                            : 2;  
    dhd_uint32_t m_blu_color_dst_blend_factor_select    : 2;  /* Destination blend factor for color channel blending*/
    dhd_uint32_t m_reserved6                            : 2;  
    dhd_uint32_t m_blu_color_src_blend_factor_invert    : 1;  /* Source blend factor inversion for color channel blending*/
    dhd_uint32_t m_blu_color_dst_blend_factor_invert    : 1;  /* Destination blend factor inversion for color channel blending*/
    dhd_uint32_t m_blu_color_src_blend_factor_use_alpha : 1;  /* Source blend factor A / RGB selection for color channel blending*/
    dhd_uint32_t m_blu_color_dst_blend_factor_use_alpha : 1;  /* Destination blend factor A / RGB selection for color channel blending*/
    dhd_uint32_t m_blu_color_blend_mode                 : 3;  /* Color channel blending blend mode*/
    dhd_uint32_t m_reserved5                            : 1;  
    dhd_uint32_t m_blu_alpha_src_blend_factor_select    : 2;  /* Source blend factor for alpha channel blending*/
    dhd_uint32_t m_reserved4                            : 2;  
    dhd_uint32_t m_blu_alpha_dst_blend_factor_select    : 2;  /* Destination blend factor for alpha channel blending*/
    dhd_uint32_t m_reserved3                            : 2;  
    dhd_uint32_t m_blu_alpha_src_blend_factor_invert    : 1;  /* Source blend factor inversion for alpha channel blending*/
    dhd_uint32_t m_blu_alpha_dst_blend_factor_invert    : 1;  /* Destination blend factor inversion for alpha channel blending*/
    dhd_uint32_t m_reserved2                            : 2;  
    dhd_uint32_t m_blu_alpha_blend_mode                 : 1;  /* Alpha channel blending blend mode*/
    dhd_uint32_t m_reserved1                            : 1;  
    dhd_uint32_t m_blu_fb_premultiply_enable            : 1;  /* Multiply destination colors by destination alpha before blending when enabled.*/
    dhd_uint32_t m_blu_fb_postdivide_enable             : 1;  /* Divide color channels by alpha channel after blending (before coverage blending) when enabled.*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_blu_blend_t;

/*----------------------------------------------------------------------------------------------------------*/
/* BLU_Dither layout ( Blend unit dither control )*/
/**/
typedef union tagdhd_reg_blu_dither_t {
  struct tagdhd_reg_blu_dither_fields_t {
    dhd_uint32_t m_blu_dither_enable      : 1;  /* Enable dithering after blending*/
    dhd_uint32_t m_reserved5              : 3;  
    dhd_uint32_t m_blu_dither_base        : 4;  /* X/Y shift of the dither matrix relative to the dither offset of the pixel*/
    dhd_uint32_t m_reserved4              : 8;  
    dhd_uint32_t m_blu_dither_shift_red   : 2;  /* Right shift for the dither value for the red channel*/
    dhd_uint32_t m_reserved3              : 2;  
    dhd_uint32_t m_blu_dither_shift_green : 2;  /* Right shift for the dither value for the green channel*/
    dhd_uint32_t m_reserved2              : 2;  
    dhd_uint32_t m_blu_dither_shift_blue  : 2;  /* Right shift for the dither value for the blue channel*/
    dhd_uint32_t m_reserved1              : 6;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_blu_dither_t;

/*----------------------------------------------------------------------------------------------------------*/
/* BLU_Write layout ( Blend unit write control )*/
/**/
typedef union tagdhd_reg_blu_write_t {
  struct tagdhd_reg_blu_write_fields_t {
    dhd_uint32_t m_blu_write_blue               : 1;   /* Enable writing of the blue channel*/
    dhd_uint32_t m_blu_write_green              : 1;   /* Enable writing of the green channel*/
    dhd_uint32_t m_blu_write_red                : 1;   /* Enable writing of the red channel*/
    dhd_uint32_t m_blu_write_alpha              : 1;   /* Enable writing of the alpha channel*/
    dhd_uint32_t m_reserved2                    : 12;  
    dhd_uint32_t m_blu_coverage_blending_enable : 1;   /* Enable coverage blending*/
    dhd_uint32_t m_blu_coverage_debug_enable    : 1;   /* Enable coverage debug mode*/
    dhd_uint32_t m_reserved1                    : 14;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_blu_write_t;

/*----------------------------------------------------------------------------------------------------------*/
/* PFC_Enable layout ( Performance counter enable )*/
/**/
typedef union tagdhd_reg_pfc_enable_t {
  struct tagdhd_reg_pfc_enable_fields_t {
    dhd_uint32_t m_pfc_enable_0 : 1;   /* Enable for Performance counter*/
    dhd_uint32_t m_pfc_enable_1 : 1;   /* Enable for Performance counter*/
    dhd_uint32_t m_pfc_enable_2 : 1;   /* Enable for Performance counter*/
    dhd_uint32_t m_pfc_enable_3 : 1;   /* Enable for Performance counter*/
    dhd_uint32_t m_reserved1    : 28;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_pfc_enable_t;

/*----------------------------------------------------------------------------------------------------------*/
/* PFC_Clear layout ( Performance counter clear )*/
/**/
typedef union tagdhd_reg_pfc_clear_t {
  struct tagdhd_reg_pfc_clear_fields_t {
    dhd_uint32_t m_pfc_clear_0 : 1;   /* Clear for Performance counter*/
    dhd_uint32_t m_pfc_clear_1 : 1;   /* Clear for Performance counter*/
    dhd_uint32_t m_pfc_clear_2 : 1;   /* Clear for Performance counter*/
    dhd_uint32_t m_pfc_clear_3 : 1;   /* Clear for Performance counter*/
    dhd_uint32_t m_reserved1   : 28;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_pfc_clear_t;

/*----------------------------------------------------------------------------------------------------------*/
/* PFC_Event_Select_0 layout ( Performance counter #0 event selection )*/
/**/
typedef union tagdhd_reg_pfc_event_select_0_t {
  struct tagdhd_reg_pfc_event_select_0_fields_t {
    dhd_uint32_t m_pfc_event_select_0 : 7;   /* Performance counter event selection*/
    dhd_uint32_t m_reserved1          : 25;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_pfc_event_select_0_t;

/*----------------------------------------------------------------------------------------------------------*/
/* PFC_Event_Select_1 layout ( Performance counter #1 event selection )*/
/**/
typedef union tagdhd_reg_pfc_event_select_1_t {
  struct tagdhd_reg_pfc_event_select_1_fields_t {
    dhd_uint32_t m_pfc_event_select_1 : 7;   /* Performance counter event selection*/
    dhd_uint32_t m_reserved1          : 25;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_pfc_event_select_1_t;

/*----------------------------------------------------------------------------------------------------------*/
/* PFC_Event_Select_2 layout ( Performance counter #2 event selection )*/
/**/
typedef union tagdhd_reg_pfc_event_select_2_t {
  struct tagdhd_reg_pfc_event_select_2_fields_t {
    dhd_uint32_t m_pfc_event_select_2 : 7;   /* Performance counter event selection*/
    dhd_uint32_t m_reserved1          : 25;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_pfc_event_select_2_t;

/*----------------------------------------------------------------------------------------------------------*/
/* PFC_Event_Select_3 layout ( Performance counter #3 event selection )*/
/**/
typedef union tagdhd_reg_pfc_event_select_3_t {
  struct tagdhd_reg_pfc_event_select_3_fields_t {
    dhd_uint32_t m_pfc_event_select_3 : 7;   /* Performance counter event selection*/
    dhd_uint32_t m_reserved1          : 25;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_pfc_event_select_3_t;

/*----------------------------------------------------------------------------------------------------------*/
/* CLR_Value layout ( Clear unit color value )*/
/**/
typedef union tagdhd_reg_clr_value_t {
  struct tagdhd_reg_clr_value_fields_t {
    dhd_uint32_t m_clr_value : 32;  /* Clear unit color value*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_clr_value_t;

/*----------------------------------------------------------------------------------------------------------*/
/* CLR_Line_Config layout ( Clear unit line config )*/
/**/
typedef union tagdhd_reg_clr_line_config_t {
  struct tagdhd_reg_clr_line_config_fields_t {
    dhd_uint32_t m_clr_line_length : 14;  /* Clear unit line length in bytes-1*/
    dhd_uint32_t m_reserved2       : 2;   
    dhd_uint32_t m_clr_pitch       : 15;  /* Clear unit pitch in bytes*/
    dhd_uint32_t m_reserved1       : 1;   
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_clr_line_config_t;

/*----------------------------------------------------------------------------------------------------------*/
/* CLR_Ctrl layout ( Clear unit number of lines )*/
/**/
typedef union tagdhd_reg_clr_ctrl_t {
  struct tagdhd_reg_clr_ctrl_fields_t {
    dhd_uint32_t m_clr_num_lines : 12;  /* Clear unit number of lines-1 (height-1)*/
    dhd_uint32_t m_reserved2     : 4;   
    dhd_uint32_t m_clr_mask      : 4;   /* Clear unit write byte mask*/
    dhd_uint32_t m_reserved1     : 12;  
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_clr_ctrl_t;

/*----------------------------------------------------------------------------------------------------------*/
/* CLR_Start_Address layout ( Start address for clear unit )*/
/**/
typedef union tagdhd_reg_clr_start_address_t {
  struct tagdhd_reg_clr_start_address_fields_t {
    dhd_uint32_t m_clr_start_address : 32;  /* Start address for clear unit*/
  }        m_fields;
  dhd_uint32_t m_value;
} dhd_reg_clr_start_address_t;


/*----------------------------------------------------------------------------------------------------------*/
/* All register range definitions                                                                           */
/*                                                                                                          */

/* Register PSU_Lim_Bbox_Min at offset 128(0x80): Bounding box upper left corner*/
#define DHD_REG_LIM_BBOX_YMIN_MASK   0x0FFF0000u
#define DHD_REG_LIM_BBOX_XMIN_MASK   0x00000FFFu

/* Register PSU_Lim_Bbox_Max at offset 129(0x81): Bounding box lower right corner*/
#define DHD_REG_LIM_BBOX_YMAX_MASK   0x0FFF0000u
#define DHD_REG_LIM_BBOX_XMAX_MASK   0x00000FFFu

/* Register PSU_Lim_Start at offset 130(0x82): Start position for enumeration*/
#define DHD_REG_LIM_START_Y_MASK   0x0FFF0000u

/* Register PSU_Lim_Ctrl at offset 131(0x83): Pixel selection unit Limiter+Bezier control registers*/
#define DHD_REG_BEZ_CTRL_MASK     0x30000000u
#define DHD_REG_LIM_CTRL_5_MASK   0x00F00000u
#define DHD_REG_LIM_CTRL_4_MASK   0x000F0000u
#define DHD_REG_LIM_CTRL_3_MASK   0x0000F000u
#define DHD_REG_LIM_CTRL_2_MASK   0x00000F00u
#define DHD_REG_LIM_CTRL_1_MASK   0x000000F0u
#define DHD_REG_LIM_CTRL_0_MASK   0x0000000Fu

/* Register PSU_Lim_Stripe at offset 132(0x84): Enumeration stripes width and offset*/
#define DHD_REG_LIM_STRIPE_OFFSET_MASK   0x03FF0000u
#define DHD_REG_LIM_STRIPE_WIDTH_MASK    0x000003FFu

/* Register PSU_Bez_Ctrl at offset 133(0x85): Bezier control*/
#define DHD_REG_BEZ_LIM_SCALE_MASK   0x0000003Fu

/* Register PSU_Bez_Voff_0 at offset 134(0x86): Offset to Limiter #0 value for Bezier function (14.18 signed fixed point)*/
#define DHD_REG_BEZ_VOFF_0_MASK   0xFFFFFFFFu

/* Register PSU_Bez_Voff_1 at offset 135(0x87): Offset to Limiter #1 value for Bezier function (14.18 signed fixed point)*/
#define DHD_REG_BEZ_VOFF_1_MASK   0xFFFFFFFFu

/* Register PSU_Bez_AA_Ctrl at offset 136(0x88): Bezier anti-aliasing and width control*/
#define DHD_REG_BEZ_AA_MASK          0xFFFF0000u
#define DHD_REG_BEZ_AA_OFFSET_MASK   0x0000FF00u
#define DHD_REG_BEZ_WIDTH_MASK       0x000000FFu

/* Register PSU_Lim_Vstart_0 at offset 137(0x89): Initial value of limiter #0 at enumeration start position (14.18 signed fixed point)*/
#define DHD_REG_LIM_VSTART_0_MASK   0xFFFFFFFFu

/* Register PSU_Lim_dx_0 at offset 138(0x8A): Fractional part of Limiter #0 x step (2.18 signed fixed point)*/
#define DHD_REG_LIM_DX_0_MASK   0x000FFFFFu

/* Register PSU_Lim_dy_0 at offset 139(0x8B): Fractional part of Limiter y #0 step (2.18 signed fixed point)*/
#define DHD_REG_LIM_DY_0_MASK   0x000FFFFFu

/* Register PSU_Lim_Vstart_1 at offset 140(0x8C): Initial value of limiter #1 at enumeration start position (14.18 signed fixed point)*/
#define DHD_REG_LIM_VSTART_1_MASK   0xFFFFFFFFu

/* Register PSU_Lim_dx_1 at offset 141(0x8D): Fractional part of Limiter #1 x step (2.18 signed fixed point)*/
#define DHD_REG_LIM_DX_1_MASK   0x000FFFFFu

/* Register PSU_Lim_dy_1 at offset 142(0x8E): Fractional part of Limiter y #1 step (2.18 signed fixed point)*/
#define DHD_REG_LIM_DY_1_MASK   0x000FFFFFu

/* Register PSU_Lim_Vstart_2 at offset 143(0x8F): Initial value of limiter #2 at enumeration start position (14.18 signed fixed point)*/
#define DHD_REG_LIM_VSTART_2_MASK   0xFFFFFFFFu

/* Register PSU_Lim_dx_2 at offset 144(0x90): Fractional part of Limiter #2 x step (2.18 signed fixed point)*/
#define DHD_REG_LIM_DX_2_MASK   0x000FFFFFu

/* Register PSU_Lim_dy_2 at offset 145(0x91): Fractional part of Limiter y #2 step (2.18 signed fixed point)*/
#define DHD_REG_LIM_DY_2_MASK   0x000FFFFFu

/* Register PSU_Lim_Vstart_3 at offset 146(0x92): Initial value of limiter #3 at enumeration start position (14.18 signed fixed point)*/
#define DHD_REG_LIM_VSTART_3_MASK   0xFFFFFFFFu

/* Register PSU_Lim_dx_3 at offset 147(0x93): Fractional part of Limiter #3 x step (2.18 signed fixed point)*/
#define DHD_REG_LIM_DX_3_MASK   0x000FFFFFu

/* Register PSU_Lim_dy_3 at offset 148(0x94): Fractional part of Limiter y #3 step (2.18 signed fixed point)*/
#define DHD_REG_LIM_DY_3_MASK   0x000FFFFFu

/* Register PSU_Lim_Vstart_4 at offset 149(0x95): Initial value of limiter #4 at enumeration start position (14.18 signed fixed point)*/
#define DHD_REG_LIM_VSTART_4_MASK   0xFFFFFFFFu

/* Register PSU_Lim_dx_4 at offset 150(0x96): Fractional part of Limiter #4 x step (2.18 signed fixed point)*/
#define DHD_REG_LIM_DX_4_MASK   0x000FFFFFu

/* Register PSU_Lim_dy_4 at offset 151(0x97): Fractional part of Limiter y #4 step (2.18 signed fixed point)*/
#define DHD_REG_LIM_DY_4_MASK   0x000FFFFFu

/* Register PSU_Lim_Vstart_5 at offset 152(0x98): Initial value of limiter #5 at enumeration start position (14.18 signed fixed point)*/
#define DHD_REG_LIM_VSTART_5_MASK   0xFFFFFFFFu

/* Register PSU_Lim_dx_5 at offset 153(0x99): Fractional part of Limiter #5 x step (2.18 signed fixed point)*/
#define DHD_REG_LIM_DX_5_MASK   0x000FFFFFu

/* Register PSU_Lim_dy_5 at offset 154(0x9A): Fractional part of Limiter y #5 step (2.18 signed fixed point)*/
#define DHD_REG_LIM_DY_5_MASK   0x000FFFFFu

/* Register PSU_Debug_Ctrl at offset 155(0x9B): Debug control*/
#define DHD_REG_LIM_DEBUG_MASK   0x000000F0u
#define DHD_REG_BEZ_DEBUG_MASK   0x0000000Fu

/* Register PSU_Lim_Max_Coord at offset 156(0x9C): Maximum coordinates generated by PSU, clipping limits for bounding box*/
#define DHD_REG_LIM_YMAX_MASK   0x0FFF0000u
#define DHD_REG_LIM_XMAX_MASK   0x00000FFFu

/* Register TXA_U_Offset_0 at offset 192(0xC0): Start value for texture U coordinate of texture unit #0.*/
#define DHD_REG_TXA_U_OFFSET_0_MASK   0xFFFFFFFFu

/* Register TXA_V_Offset_0 at offset 193(0xC1): Start value for texture V coordinate of texture unit #0.*/
#define DHD_REG_TXA_V_OFFSET_0_MASK   0xFFFFFFFFu

/* Register TXA_dUX_0 at offset 194(0xC2): Increment of texture U coordinate for a pixel step in X direction of texture unit #0*/
#define DHD_REG_TXA_DUX_0_MASK   0xFFFFFFFFu

/* Register TXA_dUY_0 at offset 195(0xC3): Increment of texture U coordinate for a pixel step in Y direction of texture unit #0*/
#define DHD_REG_TXA_DUY_0_MASK   0xFFFFFFFFu

/* Register TXA_dVX_0 at offset 196(0xC4): Increment of texture V coordinate for a pixel step in X direction of texture unit #0*/
#define DHD_REG_TXA_DVX_0_MASK   0xFFFFFFFFu

/* Register TXA_dVY_0 at offset 197(0xC5): Increment of texture V coordinate for a pixel step in Y direction of texture unit #0*/
#define DHD_REG_TXA_DVY_0_MASK   0xFFFFFFFFu

/* Register TXA_U_Offset_1 at offset 198(0xC6): Start value for texture U coordinate of texture unit #1.*/
#define DHD_REG_TXA_U_OFFSET_1_MASK   0xFFFFFFFFu

/* Register TXA_V_Offset_1 at offset 199(0xC7): Start value for texture V coordinate of texture unit #1.*/
#define DHD_REG_TXA_V_OFFSET_1_MASK   0xFFFFFFFFu

/* Register TXA_dUX_1 at offset 200(0xC8): Increment of texture U coordinate for a pixel step in X direction of texture unit #1*/
#define DHD_REG_TXA_DUX_1_MASK   0xFFFFFFFFu

/* Register TXA_dUY_1 at offset 201(0xC9): Increment of texture U coordinate for a pixel step in Y direction of texture unit #1*/
#define DHD_REG_TXA_DUY_1_MASK   0xFFFFFFFFu

/* Register TXA_dVX_1 at offset 202(0xCA): Increment of texture V coordinate for a pixel step in X direction of texture unit #1*/
#define DHD_REG_TXA_DVX_1_MASK   0xFFFFFFFFu

/* Register TXA_dVY_1 at offset 203(0xCB): Increment of texture V coordinate for a pixel step in Y direction of texture unit #1*/
#define DHD_REG_TXA_DVY_1_MASK   0xFFFFFFFFu

/* Register ZSS_Pitch at offset 256(0x100): ZSA cache scheduler pitch*/
#define DHD_REG_ZSS_PITCH_MASK   0x00001FFFu

/* Register ZSS_Span_Config at offset 257(0x101): ZSA cache scheduler span config*/
#define DHD_REG_ZSS_SPAN_LENGTH_LIMIT_MASK   0x000003FFu

/* Register TXA_Z_Offset at offset 258(0x102): Start value for Z coordinate*/
#define DHD_REG_TXA_Z_OFFSET_MASK   0xFFFFFFFFu

/* Register TXA_dZX at offset 259(0x103): Increment of Z coordinate for a pixel step in X direction*/
#define DHD_REG_TXA_DZX_MASK   0xFFFFFFFFu

/* Register TXA_dZY at offset 260(0x104): Increment of Z coordinate for a pixel step in Y direction*/
#define DHD_REG_TXA_DZY_MASK   0xFFFFFFFFu

/* Register TXA_Z_RHW_Offset at offset 261(0x105): Start value for RHW attribute (1/w) of Z*/
#define DHD_REG_TXA_Z_RHW_OFFSET_MASK   0xFFFFFFFFu

/* Register TXA_Z_dRHWX at offset 262(0x106): Increment of RHW attribute of Z for a pixel step in X direction*/
#define DHD_REG_TXA_Z_DRHWX_MASK   0xFFFFFFFFu

/* Register TXA_Z_dRHWY at offset 263(0x107): Increment of RHW attribute of Z for a pixel step in Y direction*/
#define DHD_REG_TXA_Z_DRHWY_MASK   0xFFFFFFFFu

/* Register TXA_RHW_Offset_0 at offset 264(0x108): Start value for RHW attribute (1/w) of texture unit #0*/
#define DHD_REG_TXA_RHW_OFFSET_0_MASK   0xFFFFFFFFu

/* Register TXA_dRHWX_0 at offset 265(0x109): Increment of RHW attribute for a pixel step in X direction of texture unit #0*/
#define DHD_REG_TXA_DRHWX_0_MASK   0xFFFFFFFFu

/* Register TXA_dRHWY_0 at offset 266(0x10A): Increment of RHW attribute for a pixel step in Y direction of texture unit #0*/
#define DHD_REG_TXA_DRHWY_0_MASK   0xFFFFFFFFu

/* Register TXA_RHW_Offset_1 at offset 267(0x10B): Start value for RHW attribute (1/w) of texture unit #1*/
#define DHD_REG_TXA_RHW_OFFSET_1_MASK   0xFFFFFFFFu

/* Register TXA_dRHWX_1 at offset 268(0x10C): Increment of RHW attribute for a pixel step in X direction of texture unit #1*/
#define DHD_REG_TXA_DRHWX_1_MASK   0xFFFFFFFFu

/* Register TXA_dRHWY_1 at offset 269(0x10D): Increment of RHW attribute for a pixel step in Y direction of texture unit #1*/
#define DHD_REG_TXA_DRHWY_1_MASK   0xFFFFFFFFu

/* Register ZSA_Ctrl at offset 384(0x180): ZSA control registers*/
#define DHD_REG_ZSC_DISCARD_NONCOVERED_MASK   0x00000100u
#define DHD_REG_ZSC_READ_ENABLE_MASK          0x00000010u
#define DHD_REG_ZSA_BUFFER_ORG_MASK           0x00000007u

/* Register ZSC_Start_Address at offset 385(0x181): ZSA buffer start address*/
#define DHD_REG_ZSC_START_ADDRESS_MASK   0xFFFFFFFFu

/* Register ZSU_Ctrl1 at offset 386(0x182): ZSA Unit Control register 1*/
#define DHD_REG_ZSU_STENCIL_TEST_FAILED_OP_MASK         0x07000000u
#define DHD_REG_ZSU_STENCIL_DEPTH_TEST_PASSED_OP_MASK   0x00700000u
#define DHD_REG_ZSU_STENCIL_DEPTH_TEST_FAILED_OP_MASK   0x00070000u
#define DHD_REG_ZSU_STENCIL_FUNC_MASK                   0x00007000u
#define DHD_REG_ZSU_ANTIALIAS_INVERT_ON_OPAQUE_MASK     0x00000200u
#define DHD_REG_ZSU_DEPTH_WRITE_MASK                    0x00000100u
#define DHD_REG_ZSU_DEPTH_FUNC_MASK                     0x00000070u
#define DHD_REG_ZSU_ALPHA_MASK_WRITE_MODE_MASK          0x0000000Cu
#define DHD_REG_ZSU_ALPHA_MASK_MODE_MASK                0x00000002u
#define DHD_REG_ZSU_ALPHA_MASK_ENABLE_MASK              0x00000001u

/* Register ZSU_Ctrl2 at offset 387(0x183): ZSA Unit Control register 2*/
#define DHD_REG_ZSU_STENCIL_BIAS_MASK         0xFF000000u
#define DHD_REG_ZSU_STENCIL_WRITE_MASK_MASK   0x00FF0000u
#define DHD_REG_ZSU_STENCIL_REF_MASK          0x0000FF00u
#define DHD_REG_ZSU_STENCIL_MASK_MASK         0x000000FFu

/* Register TXA_Size_0 at offset 388(0x184): Texture size of texture unit #0*/
#define DHD_REG_TXA_HEIGHT_0_MASK   0x1FFF0000u
#define DHD_REG_TXA_WIDTH_0_MASK    0x00001FFFu

/* Register TXA_Access_0 at offset 389(0x185): Filter shape, size and texture pitch of texture unit #0*/
#define DHD_REG_TXA_FILTER_SAMPLE_SHAPE_0_MASK    0xC0000000u
#define DHD_REG_TXA_FILTER_KERNEL_WIDTH_0_MASK    0x0F000000u
#define DHD_REG_TXA_FILTER_KERNEL_HEIGHT_0_MASK   0x000F0000u
#define DHD_REG_TXA_PITCH_0_MASK                  0x00001FFFu

/* Register TXA_Size_1 at offset 390(0x186): Texture size of texture unit #1*/
#define DHD_REG_TXA_HEIGHT_1_MASK   0x1FFF0000u
#define DHD_REG_TXA_WIDTH_1_MASK    0x00001FFFu

/* Register TXA_Access_1 at offset 391(0x187): Filter shape, size and texture pitch of texture unit #1*/
#define DHD_REG_TXA_FILTER_SAMPLE_SHAPE_1_MASK    0xC0000000u
#define DHD_REG_TXA_FILTER_KERNEL_WIDTH_1_MASK    0x0F000000u
#define DHD_REG_TXA_FILTER_KERNEL_HEIGHT_1_MASK   0x000F0000u
#define DHD_REG_TXA_PITCH_1_MASK                  0x00001FFFu

/* Register TEX_Global at offset 512(0x200): Global texture unit register*/
#define DHD_REG_TXC_DEBUG_MODE_MASK     0xC0000000u
#define DHD_REG_RLD_PIXEL_WIDTH_MASK    0x00003000u
#define DHD_REG_TEX_DEPTH_ENABLE_MASK   0x00000010u
#define DHD_REG_TEX_NUM_UNITS_MASK      0x0000000Fu

/* Register COL_Global at offset 513(0x201): Global color unit registers*/
#define DHD_REG_COL_NUM_PASSES_MASK   0x0000001Fu

/* Register FBD_Config at offset 514(0x202): Framebuffer read decision registers*/
#define DHD_REG_FBD_ALPHA_TEST_REF_MASK        0x0000FF00u
#define DHD_REG_FBD_READ_DECISION_FLAGS_MASK   0x00000070u
#define DHD_REG_FBD_ALPHA_TEST_OP_MASK         0x00000007u

/* Register FBS_Pitch at offset 515(0x203): Framebuffer cache scheduler pitch and debug control*/
#define DHD_REG_FBS_DEBUG_ENABLE_MASK   0x00010000u
#define DHD_REG_FBS_PITCH_MASK          0x00001FFFu

/* Register FBS_Span_Config at offset 516(0x204): Framebuffer cache scheduler span config*/
#define DHD_REG_FBS_READ_GAP_LENGTH_LIMIT_MASK   0x03FF0000u
#define DHD_REG_FBS_SPAN_LENGTH_LIMIT_MASK       0x000003FFu

/* Register RLD_Start_Address at offset 517(0x205): Start address of RLE code of the texture in memory*/
#define DHD_REG_RLD_START_ADDRESS_MASK   0xFFFFFFFFu

/* Register COL_Const_Color_0 at offset 518(0x206): Constant color register #0*/
#define DHD_REG_COL_CONST_COLOR_0_MASK   0xFFFFFFFFu

/* Register COL_Const_Color_1 at offset 519(0x207): Constant color register #1*/
#define DHD_REG_COL_CONST_COLOR_1_MASK   0xFFFFFFFFu

/* Register COL_Const_Color_2 at offset 520(0x208): Constant color register #2*/
#define DHD_REG_COL_CONST_COLOR_2_MASK   0xFFFFFFFFu

/* Register COL_Const_Color_3 at offset 521(0x209): Constant color register #3*/
#define DHD_REG_COL_CONST_COLOR_3_MASK   0xFFFFFFFFu

/* Register TEX_Mode_0 at offset 640(0x280): Texture mode of texture unit #0*/
#define DHD_REG_TXP_DISCARD_ALPHA_0_MASK          0x10000000u
#define DHD_REG_TXA_ADDRESS_BIT_OFFSET_0_MASK     0x07000000u
#define DHD_REG_TEX_VIRTUAL_TILING_MODE_0_MASK    0x00700000u
#define DHD_REG_TXA_SWIZZLE_MODE_0_MASK           0x00070000u
#define DHD_REG_TXP_LIMIT_COLOR_TO_ALPHA_0_MASK   0x00002000u
#define DHD_REG_TEX_ORG_0_MASK                    0x00000F00u
#define DHD_REG_TEX_FILTER_V_0_MASK               0x00000080u
#define DHD_REG_TXA_WRAP_MODE_V_0_MASK            0x00000030u
#define DHD_REG_TEX_FILTER_U_0_MASK               0x00000008u
#define DHD_REG_TXA_WRAP_MODE_U_0_MASK            0x00000003u

/* Register TXC_Start_Address_0 at offset 641(0x281): Start address of top-left texel of the texture in memory of texture unit #0*/
#define DHD_REG_TXC_START_ADDRESS_0_MASK   0xFFFFFFFFu

/* Register TXP_Ctrl_0 at offset 642(0x282): TXP control of texture unit #0*/
#define DHD_REG_TXC_BURST_PITCH_0_MASK        0x7FFF0000u
#define DHD_REG_TXC_USE_RLD_0_MASK            0x00000100u
#define DHD_REG_TXP_COLOR_KEY_ENABLE_0_MASK   0x00000010u
#define DHD_REG_TXP_CLUT_MODE_0_MASK          0x00000007u

/* Register TXP_Clut_Offset_0 at offset 643(0x283): Offset for CLUT lookups of texture unit #0*/
#define DHD_REG_TXP_CLUT_OFFSET_0_MASK   0x000007FFu

/* Register TXP_Color_Key_0 at offset 644(0x284): Color key comparison value of texture unit #0*/
#define DHD_REG_TXP_COLOR_KEY_0_MASK   0x00FFFFFFu

/* Register TXP_Fill_Color_0 at offset 645(0x285): Texel fill color for wrap mode FILL of texture unit #0*/
#define DHD_REG_TXP_FILL_COLOR_0_MASK   0xFFFFFFFFu

/* Register TXP_Filter_Scale_Bias_0 at offset 646(0x286): Scale and bias for filter in TXP of texture unit #0*/
#define DHD_REG_TXP_FILTER_BIAS_0_MASK    0x1FF00000u
#define DHD_REG_TXP_FILTER_SHIFT_0_MASK   0x0003F000u
#define DHD_REG_TXP_FILTER_SCALE_0_MASK   0x000003FFu

/* Register TEX_Mode_1 at offset 647(0x287): Texture mode of texture unit #1*/
#define DHD_REG_TXP_DISCARD_ALPHA_1_MASK          0x10000000u
#define DHD_REG_TXA_ADDRESS_BIT_OFFSET_1_MASK     0x07000000u
#define DHD_REG_TEX_VIRTUAL_TILING_MODE_1_MASK    0x00700000u
#define DHD_REG_TXA_SWIZZLE_MODE_1_MASK           0x00070000u
#define DHD_REG_TXP_LIMIT_COLOR_TO_ALPHA_1_MASK   0x00002000u
#define DHD_REG_TEX_ORG_1_MASK                    0x00000F00u
#define DHD_REG_TEX_FILTER_V_1_MASK               0x00000080u
#define DHD_REG_TXA_WRAP_MODE_V_1_MASK            0x00000030u
#define DHD_REG_TEX_FILTER_U_1_MASK               0x00000008u
#define DHD_REG_TXA_WRAP_MODE_U_1_MASK            0x00000003u

/* Register TXC_Start_Address_1 at offset 648(0x288): Start address of top-left texel of the texture in memory of texture unit #1*/
#define DHD_REG_TXC_START_ADDRESS_1_MASK   0xFFFFFFFFu

/* Register TXP_Ctrl_1 at offset 649(0x289): TXP control of texture unit #1*/
#define DHD_REG_TXC_BURST_PITCH_1_MASK        0x7FFF0000u
#define DHD_REG_TXC_USE_RLD_1_MASK            0x00000100u
#define DHD_REG_TXP_COLOR_KEY_ENABLE_1_MASK   0x00000010u
#define DHD_REG_TXP_CLUT_MODE_1_MASK          0x00000007u

/* Register TXP_Clut_Offset_1 at offset 650(0x28A): Offset for CLUT lookups of texture unit #1*/
#define DHD_REG_TXP_CLUT_OFFSET_1_MASK   0x000007FFu

/* Register TXP_Color_Key_1 at offset 651(0x28B): Color key comparison value of texture unit #1*/
#define DHD_REG_TXP_COLOR_KEY_1_MASK   0x00FFFFFFu

/* Register TXP_Fill_Color_1 at offset 652(0x28C): Texel fill color for wrap mode FILL of texture unit #1*/
#define DHD_REG_TXP_FILL_COLOR_1_MASK   0xFFFFFFFFu

/* Register TXP_Filter_Scale_Bias_1 at offset 653(0x28D): Scale and bias for filter in TXP of texture unit #1*/
#define DHD_REG_TXP_FILTER_BIAS_1_MASK    0x1FF00000u
#define DHD_REG_TXP_FILTER_SHIFT_1_MASK   0x0003F000u
#define DHD_REG_TXP_FILTER_SCALE_1_MASK   0x000003FFu

/* Register COL_ARGB_Op1a_0 at offset 704(0x2C0): Control structure for Op1a of color pass 0 (Alpha and RGB path)*/
#define DHD_REG_COL_ALPHA_OP1A_MUL2_0_MASK           0x40000000u
#define DHD_REG_COL_ALPHA_OP1A_INVERT_MODE_0_MASK    0x30000000u
#define DHD_REG_COL_ALPHA_OP1A_ARGB_SELECT_0_MASK    0x03000000u
#define DHD_REG_COL_ALPHA_OP1A_INPUT_SELECT_0_MASK   0x001F0000u
#define DHD_REG_COL_RGB_OP1A_MUL2_0_MASK             0x00004000u
#define DHD_REG_COL_RGB_OP1A_INVERT_MODE_0_MASK      0x00003000u
#define DHD_REG_COL_RED_OP1A_ARGB_SELECT_0_MASK      0x00000C00u
#define DHD_REG_COL_GREEN_OP1A_ARGB_SELECT_0_MASK    0x00000300u
#define DHD_REG_COL_BLUE_OP1A_ARGB_SELECT_0_MASK     0x000000C0u
#define DHD_REG_COL_RGB_OP1A_INPUT_SELECT_0_MASK     0x0000001Fu

/* Register COL_ARGB_Op1b_0 at offset 705(0x2C1): Control structure for Op1b of color pass 0 (Alpha and RGB path)*/
#define DHD_REG_COL_ALPHA_CARRY1_0_MASK              0x80000000u
#define DHD_REG_COL_ALPHA_OP1B_MUL2_0_MASK           0x40000000u
#define DHD_REG_COL_ALPHA_OP1B_INVERT_MODE_0_MASK    0x30000000u
#define DHD_REG_COL_ALPHA_OP1B_ARGB_SELECT_0_MASK    0x03000000u
#define DHD_REG_COL_ALPHA_OP1B_INPUT_SELECT_0_MASK   0x001F0000u
#define DHD_REG_COL_RGB_CARRY1_0_MASK                0x00008000u
#define DHD_REG_COL_RGB_OP1B_MUL2_0_MASK             0x00004000u
#define DHD_REG_COL_RGB_OP1B_INVERT_MODE_0_MASK      0x00003000u
#define DHD_REG_COL_RED_OP1B_ARGB_SELECT_0_MASK      0x00000C00u
#define DHD_REG_COL_GREEN_OP1B_ARGB_SELECT_0_MASK    0x00000300u
#define DHD_REG_COL_BLUE_OP1B_ARGB_SELECT_0_MASK     0x000000C0u
#define DHD_REG_COL_RGB_OP1B_INPUT_SELECT_0_MASK     0x0000001Fu

/* Register COL_ARGB_Op2a_0 at offset 706(0x2C2): Control structure for Op2a of color pass 0 (Alpha and RGB path)*/
#define DHD_REG_COL_ALPHA_OP2A_MUL2_0_MASK           0x40000000u
#define DHD_REG_COL_ALPHA_OP2A_INVERT_MODE_0_MASK    0x30000000u
#define DHD_REG_COL_ALPHA_OP2A_ARGB_SELECT_0_MASK    0x03000000u
#define DHD_REG_COL_ALPHA_OP2A_INPUT_SELECT_0_MASK   0x001F0000u
#define DHD_REG_COL_RGB_OP2A_MUL2_0_MASK             0x00004000u
#define DHD_REG_COL_RGB_OP2A_INVERT_MODE_0_MASK      0x00003000u
#define DHD_REG_COL_RED_OP2A_ARGB_SELECT_0_MASK      0x00000C00u
#define DHD_REG_COL_GREEN_OP2A_ARGB_SELECT_0_MASK    0x00000300u
#define DHD_REG_COL_BLUE_OP2A_ARGB_SELECT_0_MASK     0x000000C0u
#define DHD_REG_COL_RGB_OP2A_INPUT_SELECT_0_MASK     0x0000001Fu

/* Register COL_ARGB_Op2b_0 at offset 707(0x2C3): Control structure for Op2b of color pass 0 (Alpha and RGB path)*/
#define DHD_REG_COL_ALPHA_CARRY2_0_MASK              0x80000000u
#define DHD_REG_COL_ALPHA_OP2B_MUL2_0_MASK           0x40000000u
#define DHD_REG_COL_ALPHA_OP2B_INVERT_MODE_0_MASK    0x30000000u
#define DHD_REG_COL_ALPHA_OP2B_ARGB_SELECT_0_MASK    0x03000000u
#define DHD_REG_COL_ALPHA_OP2B_INPUT_SELECT_0_MASK   0x001F0000u
#define DHD_REG_COL_RGB_CARRY2_0_MASK                0x00008000u
#define DHD_REG_COL_RGB_OP2B_MUL2_0_MASK             0x00004000u
#define DHD_REG_COL_RGB_OP2B_INVERT_MODE_0_MASK      0x00003000u
#define DHD_REG_COL_RED_OP2B_ARGB_SELECT_0_MASK      0x00000C00u
#define DHD_REG_COL_GREEN_OP2B_ARGB_SELECT_0_MASK    0x00000300u
#define DHD_REG_COL_BLUE_OP2B_ARGB_SELECT_0_MASK     0x000000C0u
#define DHD_REG_COL_RGB_OP2B_INPUT_SELECT_0_MASK     0x0000001Fu

/* Register COL_ARGB_Op3_0 at offset 708(0x2C4): Control structure for Op3 of color pass 0 (Alpha and RGB path)*/
#define DHD_REG_COL_ALPHA_OP3_MUL2_0_MASK           0x40000000u
#define DHD_REG_COL_ALPHA_OP3_INVERT_MODE_0_MASK    0x30000000u
#define DHD_REG_COL_ALPHA_OP3_ARGB_SELECT_0_MASK    0x03000000u
#define DHD_REG_COL_ALPHA_OP3_INPUT_SELECT_0_MASK   0x001F0000u
#define DHD_REG_COL_RGB_OP3_MUL2_0_MASK             0x00004000u
#define DHD_REG_COL_RGB_OP3_INVERT_MODE_0_MASK      0x00003000u
#define DHD_REG_COL_RED_OP3_ARGB_SELECT_0_MASK      0x00000C00u
#define DHD_REG_COL_GREEN_OP3_ARGB_SELECT_0_MASK    0x00000300u
#define DHD_REG_COL_BLUE_OP3_ARGB_SELECT_0_MASK     0x000000C0u
#define DHD_REG_COL_RGB_OP3_INPUT_SELECT_0_MASK     0x0000001Fu

/* Register COL_ARGB_Out_0 at offset 709(0x2C5): Control structure for core output of color pass 0 (Alpha and RGB path)*/
#define DHD_REG_COL_ALPHA_CLAMP_OUT_0_MASK   0x10000000u
#define DHD_REG_COL_ALPHA_SCALE_OUT_0_MASK   0x00030000u
#define DHD_REG_COL_RGB_CLAMP_OUT_0_MASK     0x00001000u
#define DHD_REG_COL_RGB_SCALE_OUT_0_MASK     0x00000003u

/* Register COL_ARGB_Op1a_1 at offset 710(0x2C6): Control structure for Op1a of color pass 1 (Alpha and RGB path)*/
#define DHD_REG_COL_ALPHA_OP1A_MUL2_1_MASK           0x40000000u
#define DHD_REG_COL_ALPHA_OP1A_INVERT_MODE_1_MASK    0x30000000u
#define DHD_REG_COL_ALPHA_OP1A_ARGB_SELECT_1_MASK    0x03000000u
#define DHD_REG_COL_ALPHA_OP1A_INPUT_SELECT_1_MASK   0x001F0000u
#define DHD_REG_COL_RGB_OP1A_MUL2_1_MASK             0x00004000u
#define DHD_REG_COL_RGB_OP1A_INVERT_MODE_1_MASK      0x00003000u
#define DHD_REG_COL_RED_OP1A_ARGB_SELECT_1_MASK      0x00000C00u
#define DHD_REG_COL_GREEN_OP1A_ARGB_SELECT_1_MASK    0x00000300u
#define DHD_REG_COL_BLUE_OP1A_ARGB_SELECT_1_MASK     0x000000C0u
#define DHD_REG_COL_RGB_OP1A_INPUT_SELECT_1_MASK     0x0000001Fu

/* Register COL_ARGB_Op1b_1 at offset 711(0x2C7): Control structure for Op1b of color pass 1 (Alpha and RGB path)*/
#define DHD_REG_COL_ALPHA_CARRY1_1_MASK              0x80000000u
#define DHD_REG_COL_ALPHA_OP1B_MUL2_1_MASK           0x40000000u
#define DHD_REG_COL_ALPHA_OP1B_INVERT_MODE_1_MASK    0x30000000u
#define DHD_REG_COL_ALPHA_OP1B_ARGB_SELECT_1_MASK    0x03000000u
#define DHD_REG_COL_ALPHA_OP1B_INPUT_SELECT_1_MASK   0x001F0000u
#define DHD_REG_COL_RGB_CARRY1_1_MASK                0x00008000u
#define DHD_REG_COL_RGB_OP1B_MUL2_1_MASK             0x00004000u
#define DHD_REG_COL_RGB_OP1B_INVERT_MODE_1_MASK      0x00003000u
#define DHD_REG_COL_RED_OP1B_ARGB_SELECT_1_MASK      0x00000C00u
#define DHD_REG_COL_GREEN_OP1B_ARGB_SELECT_1_MASK    0x00000300u
#define DHD_REG_COL_BLUE_OP1B_ARGB_SELECT_1_MASK     0x000000C0u
#define DHD_REG_COL_RGB_OP1B_INPUT_SELECT_1_MASK     0x0000001Fu

/* Register COL_ARGB_Op2a_1 at offset 712(0x2C8): Control structure for Op2a of color pass 1 (Alpha and RGB path)*/
#define DHD_REG_COL_ALPHA_OP2A_MUL2_1_MASK           0x40000000u
#define DHD_REG_COL_ALPHA_OP2A_INVERT_MODE_1_MASK    0x30000000u
#define DHD_REG_COL_ALPHA_OP2A_ARGB_SELECT_1_MASK    0x03000000u
#define DHD_REG_COL_ALPHA_OP2A_INPUT_SELECT_1_MASK   0x001F0000u
#define DHD_REG_COL_RGB_OP2A_MUL2_1_MASK             0x00004000u
#define DHD_REG_COL_RGB_OP2A_INVERT_MODE_1_MASK      0x00003000u
#define DHD_REG_COL_RED_OP2A_ARGB_SELECT_1_MASK      0x00000C00u
#define DHD_REG_COL_GREEN_OP2A_ARGB_SELECT_1_MASK    0x00000300u
#define DHD_REG_COL_BLUE_OP2A_ARGB_SELECT_1_MASK     0x000000C0u
#define DHD_REG_COL_RGB_OP2A_INPUT_SELECT_1_MASK     0x0000001Fu

/* Register COL_ARGB_Op2b_1 at offset 713(0x2C9): Control structure for Op2b of color pass 1 (Alpha and RGB path)*/
#define DHD_REG_COL_ALPHA_CARRY2_1_MASK              0x80000000u
#define DHD_REG_COL_ALPHA_OP2B_MUL2_1_MASK           0x40000000u
#define DHD_REG_COL_ALPHA_OP2B_INVERT_MODE_1_MASK    0x30000000u
#define DHD_REG_COL_ALPHA_OP2B_ARGB_SELECT_1_MASK    0x03000000u
#define DHD_REG_COL_ALPHA_OP2B_INPUT_SELECT_1_MASK   0x001F0000u
#define DHD_REG_COL_RGB_CARRY2_1_MASK                0x00008000u
#define DHD_REG_COL_RGB_OP2B_MUL2_1_MASK             0x00004000u
#define DHD_REG_COL_RGB_OP2B_INVERT_MODE_1_MASK      0x00003000u
#define DHD_REG_COL_RED_OP2B_ARGB_SELECT_1_MASK      0x00000C00u
#define DHD_REG_COL_GREEN_OP2B_ARGB_SELECT_1_MASK    0x00000300u
#define DHD_REG_COL_BLUE_OP2B_ARGB_SELECT_1_MASK     0x000000C0u
#define DHD_REG_COL_RGB_OP2B_INPUT_SELECT_1_MASK     0x0000001Fu

/* Register COL_ARGB_Op3_1 at offset 714(0x2CA): Control structure for Op3 of color pass 1 (Alpha and RGB path)*/
#define DHD_REG_COL_ALPHA_OP3_MUL2_1_MASK           0x40000000u
#define DHD_REG_COL_ALPHA_OP3_INVERT_MODE_1_MASK    0x30000000u
#define DHD_REG_COL_ALPHA_OP3_ARGB_SELECT_1_MASK    0x03000000u
#define DHD_REG_COL_ALPHA_OP3_INPUT_SELECT_1_MASK   0x001F0000u
#define DHD_REG_COL_RGB_OP3_MUL2_1_MASK             0x00004000u
#define DHD_REG_COL_RGB_OP3_INVERT_MODE_1_MASK      0x00003000u
#define DHD_REG_COL_RED_OP3_ARGB_SELECT_1_MASK      0x00000C00u
#define DHD_REG_COL_GREEN_OP3_ARGB_SELECT_1_MASK    0x00000300u
#define DHD_REG_COL_BLUE_OP3_ARGB_SELECT_1_MASK     0x000000C0u
#define DHD_REG_COL_RGB_OP3_INPUT_SELECT_1_MASK     0x0000001Fu

/* Register COL_ARGB_Out_1 at offset 715(0x2CB): Control structure for core output of color pass 1 (Alpha and RGB path)*/
#define DHD_REG_COL_ALPHA_CLAMP_OUT_1_MASK   0x10000000u
#define DHD_REG_COL_ALPHA_SCALE_OUT_1_MASK   0x00030000u
#define DHD_REG_COL_RGB_CLAMP_OUT_1_MASK     0x00001000u
#define DHD_REG_COL_RGB_SCALE_OUT_1_MASK     0x00000003u

/* Register COL_ARGB_Op1a_2 at offset 716(0x2CC): Control structure for Op1a of color pass 2 (Alpha and RGB path)*/
#define DHD_REG_COL_ALPHA_OP1A_MUL2_2_MASK           0x40000000u
#define DHD_REG_COL_ALPHA_OP1A_INVERT_MODE_2_MASK    0x30000000u
#define DHD_REG_COL_ALPHA_OP1A_ARGB_SELECT_2_MASK    0x03000000u
#define DHD_REG_COL_ALPHA_OP1A_INPUT_SELECT_2_MASK   0x001F0000u
#define DHD_REG_COL_RGB_OP1A_MUL2_2_MASK             0x00004000u
#define DHD_REG_COL_RGB_OP1A_INVERT_MODE_2_MASK      0x00003000u
#define DHD_REG_COL_RED_OP1A_ARGB_SELECT_2_MASK      0x00000C00u
#define DHD_REG_COL_GREEN_OP1A_ARGB_SELECT_2_MASK    0x00000300u
#define DHD_REG_COL_BLUE_OP1A_ARGB_SELECT_2_MASK     0x000000C0u
#define DHD_REG_COL_RGB_OP1A_INPUT_SELECT_2_MASK     0x0000001Fu

/* Register COL_ARGB_Op1b_2 at offset 717(0x2CD): Control structure for Op1b of color pass 2 (Alpha and RGB path)*/
#define DHD_REG_COL_ALPHA_CARRY1_2_MASK              0x80000000u
#define DHD_REG_COL_ALPHA_OP1B_MUL2_2_MASK           0x40000000u
#define DHD_REG_COL_ALPHA_OP1B_INVERT_MODE_2_MASK    0x30000000u
#define DHD_REG_COL_ALPHA_OP1B_ARGB_SELECT_2_MASK    0x03000000u
#define DHD_REG_COL_ALPHA_OP1B_INPUT_SELECT_2_MASK   0x001F0000u
#define DHD_REG_COL_RGB_CARRY1_2_MASK                0x00008000u
#define DHD_REG_COL_RGB_OP1B_MUL2_2_MASK             0x00004000u
#define DHD_REG_COL_RGB_OP1B_INVERT_MODE_2_MASK      0x00003000u
#define DHD_REG_COL_RED_OP1B_ARGB_SELECT_2_MASK      0x00000C00u
#define DHD_REG_COL_GREEN_OP1B_ARGB_SELECT_2_MASK    0x00000300u
#define DHD_REG_COL_BLUE_OP1B_ARGB_SELECT_2_MASK     0x000000C0u
#define DHD_REG_COL_RGB_OP1B_INPUT_SELECT_2_MASK     0x0000001Fu

/* Register COL_ARGB_Op2a_2 at offset 718(0x2CE): Control structure for Op2a of color pass 2 (Alpha and RGB path)*/
#define DHD_REG_COL_ALPHA_OP2A_MUL2_2_MASK           0x40000000u
#define DHD_REG_COL_ALPHA_OP2A_INVERT_MODE_2_MASK    0x30000000u
#define DHD_REG_COL_ALPHA_OP2A_ARGB_SELECT_2_MASK    0x03000000u
#define DHD_REG_COL_ALPHA_OP2A_INPUT_SELECT_2_MASK   0x001F0000u
#define DHD_REG_COL_RGB_OP2A_MUL2_2_MASK             0x00004000u
#define DHD_REG_COL_RGB_OP2A_INVERT_MODE_2_MASK      0x00003000u
#define DHD_REG_COL_RED_OP2A_ARGB_SELECT_2_MASK      0x00000C00u
#define DHD_REG_COL_GREEN_OP2A_ARGB_SELECT_2_MASK    0x00000300u
#define DHD_REG_COL_BLUE_OP2A_ARGB_SELECT_2_MASK     0x000000C0u
#define DHD_REG_COL_RGB_OP2A_INPUT_SELECT_2_MASK     0x0000001Fu

/* Register COL_ARGB_Op2b_2 at offset 719(0x2CF): Control structure for Op2b of color pass 2 (Alpha and RGB path)*/
#define DHD_REG_COL_ALPHA_CARRY2_2_MASK              0x80000000u
#define DHD_REG_COL_ALPHA_OP2B_MUL2_2_MASK           0x40000000u
#define DHD_REG_COL_ALPHA_OP2B_INVERT_MODE_2_MASK    0x30000000u
#define DHD_REG_COL_ALPHA_OP2B_ARGB_SELECT_2_MASK    0x03000000u
#define DHD_REG_COL_ALPHA_OP2B_INPUT_SELECT_2_MASK   0x001F0000u
#define DHD_REG_COL_RGB_CARRY2_2_MASK                0x00008000u
#define DHD_REG_COL_RGB_OP2B_MUL2_2_MASK             0x00004000u
#define DHD_REG_COL_RGB_OP2B_INVERT_MODE_2_MASK      0x00003000u
#define DHD_REG_COL_RED_OP2B_ARGB_SELECT_2_MASK      0x00000C00u
#define DHD_REG_COL_GREEN_OP2B_ARGB_SELECT_2_MASK    0x00000300u
#define DHD_REG_COL_BLUE_OP2B_ARGB_SELECT_2_MASK     0x000000C0u
#define DHD_REG_COL_RGB_OP2B_INPUT_SELECT_2_MASK     0x0000001Fu

/* Register COL_ARGB_Op3_2 at offset 720(0x2D0): Control structure for Op3 of color pass 2 (Alpha and RGB path)*/
#define DHD_REG_COL_ALPHA_OP3_MUL2_2_MASK           0x40000000u
#define DHD_REG_COL_ALPHA_OP3_INVERT_MODE_2_MASK    0x30000000u
#define DHD_REG_COL_ALPHA_OP3_ARGB_SELECT_2_MASK    0x03000000u
#define DHD_REG_COL_ALPHA_OP3_INPUT_SELECT_2_MASK   0x001F0000u
#define DHD_REG_COL_RGB_OP3_MUL2_2_MASK             0x00004000u
#define DHD_REG_COL_RGB_OP3_INVERT_MODE_2_MASK      0x00003000u
#define DHD_REG_COL_RED_OP3_ARGB_SELECT_2_MASK      0x00000C00u
#define DHD_REG_COL_GREEN_OP3_ARGB_SELECT_2_MASK    0x00000300u
#define DHD_REG_COL_BLUE_OP3_ARGB_SELECT_2_MASK     0x000000C0u
#define DHD_REG_COL_RGB_OP3_INPUT_SELECT_2_MASK     0x0000001Fu

/* Register COL_ARGB_Out_2 at offset 721(0x2D1): Control structure for core output of color pass 2 (Alpha and RGB path)*/
#define DHD_REG_COL_ALPHA_CLAMP_OUT_2_MASK   0x10000000u
#define DHD_REG_COL_ALPHA_SCALE_OUT_2_MASK   0x00030000u
#define DHD_REG_COL_RGB_CLAMP_OUT_2_MASK     0x00001000u
#define DHD_REG_COL_RGB_SCALE_OUT_2_MASK     0x00000003u

/* Register FB_Pixel_Org at offset 768(0x300): Framebuffer pixel organization/format*/
#define DHD_REG_BLU_FB_LIMIT_COLOR_TO_ALPHA_MASK   0x00000020u
#define DHD_REG_FB_PIXEL_ORG_MASK                  0x0000000Fu

/* Register FBC_Start_Address at offset 769(0x301): Framebuffer start address*/
#define DHD_REG_FBC_START_ADDRESS_MASK   0xFFFFFFFFu

/* Register BLU_Blend at offset 770(0x302): Blend unit factor and mode*/
#define DHD_REG_BLU_FB_POSTDIVIDE_ENABLE_MASK               0x80000000u
#define DHD_REG_BLU_FB_PREMULTIPLY_ENABLE_MASK              0x40000000u
#define DHD_REG_BLU_ALPHA_BLEND_MODE_MASK                   0x10000000u
#define DHD_REG_BLU_ALPHA_DST_BLEND_FACTOR_INVERT_MASK      0x02000000u
#define DHD_REG_BLU_ALPHA_SRC_BLEND_FACTOR_INVERT_MASK      0x01000000u
#define DHD_REG_BLU_ALPHA_DST_BLEND_FACTOR_SELECT_MASK      0x00300000u
#define DHD_REG_BLU_ALPHA_SRC_BLEND_FACTOR_SELECT_MASK      0x00030000u
#define DHD_REG_BLU_COLOR_BLEND_MODE_MASK                   0x00007000u
#define DHD_REG_BLU_COLOR_DST_BLEND_FACTOR_USE_ALPHA_MASK   0x00000800u
#define DHD_REG_BLU_COLOR_SRC_BLEND_FACTOR_USE_ALPHA_MASK   0x00000400u
#define DHD_REG_BLU_COLOR_DST_BLEND_FACTOR_INVERT_MASK      0x00000200u
#define DHD_REG_BLU_COLOR_SRC_BLEND_FACTOR_INVERT_MASK      0x00000100u
#define DHD_REG_BLU_COLOR_DST_BLEND_FACTOR_SELECT_MASK      0x00000030u
#define DHD_REG_BLU_COLOR_SRC_BLEND_FACTOR_SELECT_MASK      0x00000003u

/* Register BLU_Dither at offset 771(0x303): Blend unit dither control*/
#define DHD_REG_BLU_DITHER_SHIFT_BLUE_MASK    0x03000000u
#define DHD_REG_BLU_DITHER_SHIFT_GREEN_MASK   0x00300000u
#define DHD_REG_BLU_DITHER_SHIFT_RED_MASK     0x00030000u
#define DHD_REG_BLU_DITHER_BASE_MASK          0x000000F0u
#define DHD_REG_BLU_DITHER_ENABLE_MASK        0x00000001u

/* Register BLU_Write at offset 772(0x304): Blend unit write control*/
#define DHD_REG_BLU_COVERAGE_DEBUG_ENABLE_MASK      0x00020000u
#define DHD_REG_BLU_COVERAGE_BLENDING_ENABLE_MASK   0x00010000u
#define DHD_REG_BLU_WRITE_ALPHA_MASK                0x00000008u
#define DHD_REG_BLU_WRITE_RED_MASK                  0x00000004u
#define DHD_REG_BLU_WRITE_GREEN_MASK                0x00000002u
#define DHD_REG_BLU_WRITE_BLUE_MASK                 0x00000001u

/* Register PFC_Enable at offset 896(0x380): Performance counter enable*/
#define DHD_REG_PFC_ENABLE_3_MASK   0x00000008u
#define DHD_REG_PFC_ENABLE_2_MASK   0x00000004u
#define DHD_REG_PFC_ENABLE_1_MASK   0x00000002u
#define DHD_REG_PFC_ENABLE_0_MASK   0x00000001u

/* Register PFC_Clear at offset 897(0x381): Performance counter clear*/
#define DHD_REG_PFC_CLEAR_3_MASK   0x00000008u
#define DHD_REG_PFC_CLEAR_2_MASK   0x00000004u
#define DHD_REG_PFC_CLEAR_1_MASK   0x00000002u
#define DHD_REG_PFC_CLEAR_0_MASK   0x00000001u

/* Register PFC_Event_Select_0 at offset 898(0x382): Performance counter #0 event selection*/
#define DHD_REG_PFC_EVENT_SELECT_0_MASK   0x0000007Fu

/* Register PFC_Event_Select_1 at offset 899(0x383): Performance counter #1 event selection*/
#define DHD_REG_PFC_EVENT_SELECT_1_MASK   0x0000007Fu

/* Register PFC_Event_Select_2 at offset 900(0x384): Performance counter #2 event selection*/
#define DHD_REG_PFC_EVENT_SELECT_2_MASK   0x0000007Fu

/* Register PFC_Event_Select_3 at offset 901(0x385): Performance counter #3 event selection*/
#define DHD_REG_PFC_EVENT_SELECT_3_MASK   0x0000007Fu

/* Register CLR_Value at offset 960(0x3C0): Clear unit color value*/
#define DHD_REG_CLR_VALUE_MASK   0xFFFFFFFFu

/* Register CLR_Line_Config at offset 961(0x3C1): Clear unit line config*/
#define DHD_REG_CLR_PITCH_MASK         0x7FFF0000u
#define DHD_REG_CLR_LINE_LENGTH_MASK   0x00003FFFu

/* Register CLR_Ctrl at offset 962(0x3C2): Clear unit number of lines*/
#define DHD_REG_CLR_MASK_MASK        0x000F0000u
#define DHD_REG_CLR_NUM_LINES_MASK   0x00000FFFu

/* Register CLR_Start_Address at offset 963(0x3C3): Start address for clear unit*/
#define DHD_REG_CLR_START_ADDRESS_MASK   0xFFFFFFFFu

#endif /*DAVEHD_REGISTERMAP_D1MX_H_INCLUDED*/

