#include "GaugesInterface.h"
#include "Menu.h"
/**@struct _GaugesInfoInit
 *this is _GaugesInfoInit
 */
#include "Common_Interface.h"

#define Self_time   450u

static const uint16_t GaugesDataInInit[GaugesTotal][3][25] =
{
    /*车速*/
    {
        {0, 200, 400, 600, 800, 1000, 1200, 1400,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {0, 200, 400, 600, 800, 1000, 1200, 1400,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {1,   5,   9,  13,  17,   21,   25,   29,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
    },
    /*转速*/
    {   {0u,  900, 1400, 1900, 2400, 2900, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {0u, 1000, 1500, 2000, 2500, 3000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {1u,    6,   11,   16,   21,   27, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
    },
    /*水温*/
    {   { 0, 50, 55, 61, 66, 72,  77, 102, 104, 106, 108, 110, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {49, 54, 60, 65, 71, 76, 101, 103, 105, 107, 109, 110, 210, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        { 0,  1,  2,  3,  4,  5,   6,   7,   8,   9,  10,  11,  12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
    },
    /*PRI气压*/
    {   {500, 720,  940, 1160, 1380, 1600, 1820, 2040, 2260, 2480, 2700, 2920, 3140, 3360, 3580, 3800, 4020, 4240, 4500, 0, 0, 0, 0, 0},
        {610, 830, 1050, 1270, 1490, 1710, 1930, 2150, 2370, 2590, 2810, 3030, 3250, 3470, 3690, 3910, 4130, 4350, 4500, 0, 0, 0, 0, 0},
        {  0,   1,    2,    3,    4,    5,    6,    7,    8,    9,   10,   11,   12,   13,   14,   15,   16,   17,   18, 0, 0, 0, 0, 0}
    },
    /*SEC气压*/
    {   {500, 720,  940, 1160, 1380, 1600, 1820, 2040, 2260, 2480, 2700, 2920, 3140, 3360, 3580, 3800, 4020, 4240, 4500, 0, 0, 0, 0, 0},
        {610, 830, 1050, 1270, 1490, 1710, 1930, 2150, 2370, 2590, 2810, 3030, 3250, 3470, 3690, 3910, 4130, 4350, 4500, 0, 0, 0, 0, 0},
        {  0,   1,    2,    3,    4,    5,    6,    7,    8,    9,   10,   11,   12,   13,   14,   15,   16,   17,   18, 0, 0, 0, 0, 0}
    },
    /*WET气压*/
    {   {500, 730,  960, 1190, 1420, 1650, 1880, 2100, 2330, 2560, 2790, 3020, 3250, 3480, 3710, 3940, 4170, 4400, 4500, 0, 0, 0, 0, 0, 0},
        {600, 830, 1060, 1290, 1520, 1750, 1980, 2200, 2430, 2660, 2890, 3120, 3350, 3580, 3810, 4040, 4270, 4500, 4500, 0, 0, 0, 0, 0, 0},
        {  0,   1,    2,    3,    4,    5,    6,    7,    8,    9,   10,   11,   12,   13,   14,   15,   16,   17,   18, 0, 0, 0, 0, 0, 0}
    },
    /*电池电压*/
    {   {0,     18000, 19000, 20000, 21000, 22000, 23000, 24000, 25000, 26000, 27000, 28000, 29000, 30000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {17500, 18500, 19500, 20500, 21500, 22500, 23500, 24500, 25500, 26500, 27500, 28500, 29500, 30500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        {0,     1,     2,     3,     4,     5,     6,     7,     8,     9,     10,    11,    12,    13,    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
    },

};

/*指示类型*/ /*表头1        表头2        表头3        表头4*/ /*表头5*/ /*表头6*/                                                                  /*表头7*/
static const uint8_t GaugesIndicatType[GaugesTotal] = {LEDOtherType, LEDOtherType, LEDTempType, LEDGasType, LEDGasType, LEDGasType, LEDBattery}; /*初始化表头显示类型，例如水温，气压*/
/*每个表头包含的参数个数*/                                                                                                                         /*表头1 表头2 表头3 表头4*/
static const uint8_t GaugesParaNum[GaugesTotal] = {8, 6, 13, 19, 19, 19, 14};

/*每个表头IGON后开始走动时间*/                             /*表头1 表头2 表头3 表头4 表头5  表头6*/
static const uint16_t GaugesStarMoveTime[GaugesTotal] = {0, 0, 0, 0, 0, 0, 0,};                  /*0是上电就开始走动，其他参数是ms*/
/*每个表头IGON后是否自检*/ /*表头1 表头2 表头3 表头4 表头5  表头6*/
static const uint16_t GaugesTest[GaugesTotal] = {1, 1, 1, 1, 1, 0, 0,}; /*1是自检，0不自检*/
/*每个表头自检走动每格时间*/
const uint16_t SeftTest_Gauges_Times[GaugesTotal] = {(Self_time / (30 + 1)), (Self_time / (27 + 1)), (Self_time / (12 + 1)), (Self_time / (18 + 1)), (Self_time / (18 + 1)), 0, 0};
uint16_t RealDataIn[GaugesTotal];
_GaugesInfoInit GaugesInfo_Init_Table[GaugesTotal];
/**@brief User Gauge K30 Init function
 * @author TYW
 * @param[in] GaugeNum  Gauge Postion
 * @param[in] GParam  Gauge Struct
 * @since 1.0.0.0
 */
void UserGaugeK30Init(void)
{
    uint8_t i = 0u;
    uint8_t j = 0u;
    for (i = 0u; i < GaugesTotal; i++)
    {
        GaugesInfo_Init_Table[i].SectorNum = GaugesParaNum[i];
        GaugesInfo_Init_Table[i].GaugesType = GaugesIndicatType[i];
        GaugesInfo_Init_Table[i].GaugesDataIn = &RealDataIn[i];
        GaugesInfo_Init_Table[i].GaugesStartTime = GaugesStarMoveTime[i];
        GaugesInfo_Init_Table[i].GaugesTestFlag = GaugesTest[i];

        for (j = 0u; j < GaugesParaNum[i]; j++)
        {
            GaugesInfo_Init_Table[i].ReferenceDataInUp[j] = GaugesDataInInit[i][0][j];
            GaugesInfo_Init_Table[i].ReferenceDataInDown[j] = GaugesDataInInit[i][1][j];
            GaugesInfo_Init_Table[i].ReferenceDataInOut[j] = GaugesDataInInit[i][2][j];
        }
    }
    GaugesK15Init_OFF();
}

/**@brief User Gauge K15 Init function
 * @author TYW
 * @param[in] GaugeNum  Gauge Postion
 * @param[in] GParam  Gauge Struct
 * @since 1.0.0.0
 */
void UserGaugeK15Init(void)
{
    uint8_t i = 0u;
    uint8_t j = 0u;
    for (i = 0u; i < GaugesTotal; i++)
    {
        GaugesInfo_Init_Table[i].SectorNum = GaugesParaNum[i];
        GaugesInfo_Init_Table[i].GaugesType = GaugesIndicatType[i];
        GaugesInfo_Init_Table[i].GaugesDataIn = &RealDataIn[i];
        GaugesInfo_Init_Table[i].GaugesStartTime = GaugesStarMoveTime[i];
        GaugesInfo_Init_Table[i].GaugesTestFlag = GaugesTest[i];

        for (j = 0u; j < GaugesParaNum[i]; j++)
        {
            GaugesInfo_Init_Table[i].ReferenceDataInUp[j] = GaugesDataInInit[i][0][j];
            GaugesInfo_Init_Table[i].ReferenceDataInDown[j] = GaugesDataInInit[i][1][j];
            GaugesInfo_Init_Table[i].ReferenceDataInOut[j] = GaugesDataInInit[i][2][j];
        }
    }
    GaugesK15Init_ON();
}
/**@brief Gauge Schedule function
 * @author TYW
 * @param[in] GaugeNum  Gauge Postion
 * @param[in] GParam  Gauge Struct
 * @since 1.0.0.0
 */
void UserGaugeSchedule(void)
{
    uint8_t i = 0u;

    for (i = 0u; i < GaugesTotal; i++)
    {
        GaugeSchedule(i, &GaugesInfo_Init_Table[i]);
    }
}

/**@brief Set Gauges Paragram function
 * @author TYW
 * @param[in] GaugesID  Gauge Name
 * @param[in] GaugesVal  Gauges Val
 * @since 1.0.0.0
 */
void SetGaugesPara(uint8_t GaugesID, uint16_t GaugesVal)
{
    RealDataIn[GaugesID] = GaugesVal;
}

/**@brief Get Gauges Max Out Val function
 * @author TYW
 * @param[in] GaugesID  Gauge Name
 * @since 1.0.0.0
 */
uint16_t GetGaugesMaxOutVal(uint8_t GaugesID)
{

    return GaugesInfo_Init_Table[GaugesID].ReferenceDataInOut[GaugesParaNum[GaugesID] - 1u];
}

/**@brief Set Gauges Up Val function
 * @author TYW
 * @param[in] GaugesID  Gauge Name
 * @param[in] GaugesVal  Gauges Val
 * @since 1.0.0.0
 */
void SetGaugesUpVal(uint8_t GaugesID, uint16_t GaugesUpVal[])
{
    uint8_t i;
    for (i = 0u; i < GaugesParaNum[GaugesID]; i++)
    {
        GaugesInfo_Init_Table[GaugesID].ReferenceDataInUp[i] = GaugesUpVal[i];
    }
}

/**@brief Set Gauges Dwom Val function
 * @author TYW
 * @param[in] GaugesID  Gauge Name
 * @param[in] GaugesVal  Gauges Val
 * @since 1.0.0.0
 */
void SetGaugesDownVal(uint8_t GaugesID, uint16_t GaugesDownVal[])
{
    uint8_t i;
    for (i = 0u; i < GaugesParaNum[GaugesID]; i++)
    {

        GaugesInfo_Init_Table[GaugesID].ReferenceDataInDown[i] = GaugesDownVal[i];
    }
}

/**@brief Set Gauges Out Val function
 * @author TYW
 * @param[in] GaugesID  Gauge Name
 * @param[in] GaugesVal  Gauges Val
 * @since 1.0.0.0
 */
void SetGaugesOutVal(uint8_t GaugesID, uint16_t GaugesOutVal[])
{
    uint8_t i;
    for (i = 0u; i < GaugesParaNum[GaugesID]; i++)
    {
        GaugesInfo_Init_Table[GaugesID].ReferenceDataInOut[i] = GaugesOutVal[i];
    }
}