#ifndef __UDS_22SERVICE_FILTER_H
#define __UDS_22SERVICE_FILTER_H

#include "TYW_stdint.h"
#include "UDS_Common.h"
#include "UDS_ISO14229_Server.h"

#define ProgrammingCounter                                      0x0200u
#define ProgrammingAttempCounter                                0x0201u
#define BackupConfigurationInformation                          0xDFEFu
#define VehicleName                                             0xF112u
#define DiagnosticVersion                                       0xF113u
#define BootSoftwareIdentification                              0xF180u
#define ActiveDiagnosticSession                                 0xF186u
#define GeelySparePartNumber                                    0xF187u
#define VehicleManufacturerECUSoftwareVersionNumber             0xF189u
#define SystemSupplierIdentifier                                0xF18Au
#define ECUManufacturingDate                                    0xF18Bu
#define ECUSerialNumber                                         0xF18Cu
#define VehicleIdentificationNumber                             0xF190u
#define SystemSupplierECUHardwareVersionNumber                  0xF193u
#define SystemSupplierECUSoftwareVersionNumber                  0xF195u
#define SystemNameOrEngineType                                  0xF197u
#define RepairShopCodeOrTesterSerialNumber                      0xF198u
#define ProgrammingOrConfigurationDate                          0xF199u
#define ECUInstallationDateDataIdentifier                       0xF19Du
#define ECUPowerSupplyVoltage                                   0xDF00u
#define ReadVehicleSpeed                                        0xDF01u
#define ReadEngineSpeed                                         0xDF05u
#define VehicleNetworkConfiguration                             0xF110u
#define Configurationinformation                                0xF101u
#define CoolantTemperature                                      0x6200u
#define TotalOdometer                                           0x6204u
#define ZeroClearingNumberOfOdometer                            0x6207u
#define OdometerBackup                                          0x6208u
#define OdometerBackupCounter                                   0x620Au
#define VehicleSpeedDisplay                                     0x620Cu
#define FuelData                                                0xF306u

uint8_t UDS_22Service_NRC11(void);
uint8_t UDS_22Service_NRC7F(void);
uint8_t UDS_22Service_NRC33(void);
uint8_t UDS_22Service_NRC13_MinLengthCheck(void);
uint8_t UDS_22Service_NRC31(void);
uint8_t UDS_22Service_NRC13_TotalLengthCheck(void);
uint8_t UDS_22Service_NRC22(void);

#endif