#include "CAN_FUNC.h"
#include "CAN_Communication_Matrix.h"
/*增加外发计算部分引用文件*/
#include "Common_Interface.h"
#include "app_ServiceProc.h"
#include "Gauges.h"
#include "GaugesInterface.h"
#include "Telltales.h"

#include "GUI.h"
#include "Data_CoolantTemperature.h"
#include "Data_Voltmeter.h"
#include "Data_AirPressure.h"
#include "RTE_TIME.h"
#include "Services_Mileage.h"
#include "RTE_ADC.h"
#include "Data_Fuel_User.h"

#include "Line_in.h"
#include "Menu.h"
#include "kwp2000_service.h"
#include "DisplaySch_user.h"
#include "DispSch.h"
#include "FuelConfig.h"
#include "CD4051.h"

/*---------------------------------------------------------------------------
使用しない Byte、bit に関しては全て 1(B)をセットして出力すること
对于不使用的Byte、bit，全部设置1(B)并输出
----------------------------------------------------------------------------*/
USER_ECU User_ECU;

#pragma alignvar(8)
uint8_t Msg_18021733[8];
static uint32_t TXNum_18033317;
static uint32_t Water_Temp_Level_Flag;
static uint32_t User_BCM_Flag = 12u;
static uint32_t Send_18EF1718_Msg_Sta = 0u;

//uint32_t DisDTCNumber[50];

uint32_t DTCNumberEngine[DTCNumberBuf];
uint32_t DTCNumberBrake[DTCNumberBuf];
uint32_t DTCNumberAMT[DTCNumberBuf];
uint32_t DTCNumberRadar[DTCNumberBuf];
uint32_t DTCNumberCamera[DTCNumberBuf];
uint32_t DTCNumberRetarder[DTCNumberBuf];

//uint32_t DisDTCNum;
uint32_t DisDTCNumEngine ;
uint32_t DisDTCNumBrake ;
uint32_t DisDTCNumAMT ;
uint32_t DisDTCNumRadar ;
uint32_t DisDTCNumCamera ;
uint32_t DisDTCNumRetarder ;

uint32_t Id18FFE517Msg_TXSUCCESSNum;

#pragma alignvar(8)
MULCANMSG ECM18EBFF00;
#pragma alignvar(8)
MULCANMSG ECM18EBFF03;
#pragma alignvar(8)
MULCANMSG ECM18EBFF0B;
#pragma alignvar(8)
MULCANMSG ECM18EBFF10;
#pragma alignvar(8)
MULCANMSG ECM18EBFFA0;
#pragma alignvar(8)
MULCANMSG ECM18EBFFE8;

/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_18FEAE17
 * Description    :
 * Input          : None  18FEAE17
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Can_Set_Buff_18FEAE17(uint8_t CopyData[])
{
    uint16_t Main_Air_Pressure = 0u;                  /*0～FA:0～2000 [kPa] FB～FF:Not used  8倍*/
    uint16_t Service_Brake_Circuit1_AirPressure = 0u; /*0～FA:0～2000 [kPa] FB～FF:Not used  8倍*/
    uint16_t Service_Brake_Circuit2_AirPressure = 0u; /*0～FA:0～2000 [kPa] FB～FF:Not used  8倍*/
    uint16_t Power_Supply_Voltage = 0u;               /*0～2D0:0～36 [V] 2D1～FFFF:Not used*/
    uint8_t Parking_Brake_Switch = 0u;
    uint8_t Rader_Stain_Information = 0u;
    uint8_t SW_ECONO = 0u;

    /*WET*/
    Main_Air_Pressure = (uint8_t)((Common_Get_WET_Data() - 500u) / 20u);

    /*气压状态*//*禅道836*/
    if (K_Line_Set.K_Line_LID42 == 0x00u)
    {
        if (Common_Get_Air2_Data() != 0u)
        {
            Service_Brake_Circuit1_AirPressure = (uint8_t)((Common_Get_Air2_Data() - 500u) / 20u);
        }
        else
        {
            Service_Brake_Circuit1_AirPressure = 0u;
        }

        if (Common_Get_Air1_Data() != 0u)
        {
            Service_Brake_Circuit2_AirPressure = (uint8_t)((Common_Get_Air1_Data() - 500u) / 20u);
        }
        else
        {
            Service_Brake_Circuit2_AirPressure = 0u;
        }
    }
    else if ((K_Line_Set.K_Line_LID42 == 0x01u) || (K_Line_Set.K_Line_LID42 == 0x02u) || (K_Line_Set.K_Line_LID42 == 0x03u))
    {
        if (Common_Get_Air1_Data() != 0u)
        {
            Service_Brake_Circuit1_AirPressure = (uint8_t)((Common_Get_Air1_Data() - 500u) / 20u);
        }
        else
        {
            Service_Brake_Circuit1_AirPressure = 0u;
        }

        if (Common_Get_Air2_Data() != 0u)
        {
            Service_Brake_Circuit2_AirPressure = (uint8_t)((Common_Get_Air2_Data() - 500u) / 20u);
        }
        else
        {
            Service_Brake_Circuit2_AirPressure = 0u;
        }
    }
    /*
    if ((K_Line_Set.K_Line_LID42 == 0x02u) || (K_Line_Set.K_Line_LID42 == 0x03u))
    {
        if (Common_Get_Air1_Data() != 0u)
        {
            Service_Brake_Circuit1_AirPressure = (uint8_t)((Common_Get_Air1_Data() - 500u) / 20u);
        }
        else
        {
            Service_Brake_Circuit1_AirPressure = 0u;
        }

        if (Common_Get_Air2_Data() != 0u)
        {
            Service_Brake_Circuit2_AirPressure = (uint8_t)((Common_Get_Air2_Data() - 500u) / 20u);
        }
        else
        {
            Service_Brake_Circuit2_AirPressure = 0u;
        }
    }
    else if ((K_Line_Set.K_Line_LID42 == 0x00u) || (K_Line_Set.K_Line_LID42 == 0x01u))
    {
        if (Common_Get_Air2_Data() != 0u)
        {
            Service_Brake_Circuit1_AirPressure = (uint8_t)((Common_Get_Air2_Data() - 500u) / 20u);
        }
        else
        {
            Service_Brake_Circuit1_AirPressure = 0u;
        }

        if (Common_Get_Air1_Data() != 0u)
        {
            Service_Brake_Circuit2_AirPressure = (uint8_t)((Common_Get_Air1_Data() - 500u) / 20u);
        }
        else
        {
            Service_Brake_Circuit2_AirPressure = 0u;
        }
    }
    */
    /*电源电压*/
    Power_Supply_Voltage = 0u;

    /*驻车制动外发*//*18FEAE17  byte8  bit 8-7 要改成，悬空=00  接地=01 20230114*/
    Parking_Brake_Switch = Line_In_Get_Status(LINE_IN_PARK_BRAKE);

    Rader_Stain_Information = 0u;
    SW_ECONO = 0u;

    CopyData[0] = (uint8_t)(Main_Air_Pressure & 0xFFu);                  /* 1  */
    CopyData[1] = 0u;                                                    /* 2  */
    CopyData[2] = (uint8_t)(Service_Brake_Circuit1_AirPressure & 0xFFu); /* 3  */
    CopyData[3] = (uint8_t)(Service_Brake_Circuit2_AirPressure & 0xFFu); /* 4  */
    CopyData[4] = 0u;                                                    /* 5  */
    CopyData[5] = (uint8_t)(Power_Supply_Voltage & 0xFFU);               /* 6  */
    CopyData[6] = (uint8_t)((Power_Supply_Voltage >> 8u) & 0xFFu);       /* 7  */
    CopyData[7] = (uint8_t)(((Parking_Brake_Switch << 6u) & 0xC0u) |
                            ((Rader_Stain_Information << 2u) & 0x0Cu) |
                            (SW_ECONO & 0x03u)); /* 8  */
}

/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_18FF3E17
 * Description    :
 * Input          : None   18FF3E17
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Can_Set_Buff_18FF3E17(uint8_t CopyData[])
{
    uint32_t Pulse_Correction_Facor = 0u;
    uint8_t SW_PTO = 0u;
    uint8_t AEBS_ON_OFF_Info = 0u;
    uint8_t HID_Auto_Leveling = 0u;
    uint8_t MIL_Lamp_Status = 0u;
    uint16_t Fuel_Gauges_AD_Value = 0u;
    uint8_t TURN_L_Lamp_Status = 0u;
    uint8_t DstWarnVolume_Set = 0u;

    CopyData[0] = (uint8_t)((Pulse_Correction_Facor) & 0xFFu);       /* 1  */
    CopyData[1] = (uint8_t)((Pulse_Correction_Facor >> 8u) & 0xFFu); /* 2  */
    CopyData[2] = (uint8_t)(((SW_PTO << 7u) & 0x80u) |
                            ((AEBS_ON_OFF_Info << 4u) & 0x30u) |
                            ((HID_Auto_Leveling << 1u) & 0x02u));       /* 3  */
    CopyData[3] = (uint8_t)(((MIL_Lamp_Status << 7u) & 0x80u) | 0x7Fu); /* 4  */
    CopyData[4] = (uint8_t)(Fuel_Gauges_AD_Value & 0xFFu);              /* 5  */
    CopyData[5] = 0u;                                                   /* 6  */
    CopyData[6] = 0u;                                                   /* 7  */
    CopyData[7] = (uint8_t)(((TURN_L_Lamp_Status << 5u) & 0x10u) |
                            ((DstWarnVolume_Set & 0x07))); /* 8  */
}
/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_18FED917
 * Description    :
 * Input          : None  18FED917
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Can_Set_Buff_18FED917(uint8_t CopyData[])
{
    uint8_t Blanding_SW_Signal = 0u;/*1 5-6*/
    uint8_t Tralier_ABS_Fully_Operational = 0u;/*2 3-4*/
    uint8_t Tlailer_ABS_Detect = 0u;/*2 5-6*/
    uint8_t Tlailer_Connected = 0u; /*2 7-8*/

    Blanding_SW_Signal = Line_In_Get_Status(LINE_IN_RET_BLENDING); /*A10*/

    /*根据禅道编号5102内容修改----start----*/
    if (Line_In_Get_Status(LINE_IN_TRAILER_ABS) == 1u) /*B33*/
    {
        Tralier_ABS_Fully_Operational = 0x00u;
    }
    else
    {
        Tralier_ABS_Fully_Operational = 0x01u;
    }

    if (
        (Line_In_Get_Status(LINE_IN_TRAILER_CONNECT) == 1u) && /*B06 LOW*/
        (Line_In_Get_Status(LINE_IN_ABS_DETECT) == 0u) &&      /*A33 HIGH*/
        (Line_In_Get_Status(LINE_IN_TRAILER_ABS_INFO) == 0u)   /*B03 HIGH*/
    )
    {
        Tlailer_ABS_Detect = 0x1u;
    }
    else
    {
        Tlailer_ABS_Detect = 0x0u;
    }
    /*根据禅道编号5102内容修改----end----*/

    Tlailer_Connected = Line_In_Get_Status(LINE_IN_TRAILER_CONNECT); /*B6*/

    CopyData[0] = (uint8_t)(((Blanding_SW_Signal << 4u) & 0x30u) |
                            0xCFu); /* 1  */
    CopyData[1] = (uint8_t)(((Tralier_ABS_Fully_Operational << 2u) & 0x0Cu) |
                            ((Tlailer_ABS_Detect << 4u) & 0x30u) |
                            ((Tlailer_Connected << 6u) & 0xC0u) |
                            0x03u); /* 2  */
    CopyData[2] = 0xFFu;            /* 3  */
    CopyData[3] = 0xFFu;            /* 4  */
    CopyData[4] = 0xFFu;            /* 5  */
    CopyData[5] = 0xFFu;            /* 6  */
    CopyData[6] = 0xFFu;            /* 7  */
    CopyData[7] = 0xFFu;            /* 8  */
}

/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_18FEE617
 * Description    :
 * Input          : None  18FEE617
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Can_Set_Buff_18FEE617(uint8_t CopyData[])
{
    uint8_t Seconds = 0u;
    uint8_t Minutes = 0u;
    uint8_t Hours = 0u;
    uint8_t Month = 0u;
    uint8_t Day = 0u;
    uint8_t Year = 0u;

    //Seconds = Get_RTC_SECOND() * 4u;
    //Minutes = Get_RTC_MINUTE();
    //Hours   = Get_RTC_HOUR();
    //Month   = Get_RTC_MONTH();
    //Day     = Get_RTC_DATE() * 4u;
    //Year    = (uint8_t)((Get_RTC_YEAR() + 2000u - 1985u) & 0xFFu);

    Seconds = (uint8_t)Get_ID_18FEE64A_Sig_TBOX_Seconds();
    Minutes = (uint8_t)Get_ID_18FEE64A_Sig_TBOX_Minutes();
    Hours   = (uint8_t)Get_ID_18FEE64A_Sig_TBOX_Hours();
    Month   = (uint8_t)Get_ID_18FEE64A_Sig_TBOX_Month();
    Day     = (uint8_t)Get_ID_18FEE64A_Sig_TBOX_Day();
    Year    = (uint8_t)Get_ID_18FEE64A_Sig_TBOX_Year();

    CopyData[0] = (uint8_t)Seconds; /* 1  */
    CopyData[1] = (uint8_t)Minutes; /* 2  */
    CopyData[2] = (uint8_t)Hours;   /* 3  */
    CopyData[3] = (uint8_t)Month;   /* 4  */
    CopyData[4] = (uint8_t)Day;     /* 5  */
    CopyData[5] = (uint8_t)Year;    /* 6  */
    CopyData[6] = 0u;               /* 7  */
    CopyData[7] = 0u;               /* 8  */
}

/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_18FEE017
 * Description    :
 * Input          : None  18FEE017
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Can_Set_Buff_18FEE017(uint8_t CopyData[])
{
    uint32_t Total_Vehicle_Distance = 0u; /*总计里程*/

    Total_Vehicle_Distance = Data_ODO_Read();

    CopyData[0] = 0xFFu;                                                           /* 1  */
    CopyData[1] = 0xFFu;                                                           /* 2  */
    CopyData[2] = 0xFFu;                                                           /* 3  */
    CopyData[3] = 0xFFu;                                                           /* 4  */
    CopyData[4] = (uint8_t)((Total_Vehicle_Distance * 8u / 10u) & 0xFFu);          /* 5  */
    CopyData[5] = (uint8_t)(((Total_Vehicle_Distance * 8u / 10u) >> 8u) & 0xFFu);  /* 6  */
    CopyData[6] = (uint8_t)(((Total_Vehicle_Distance * 8u / 10u) >> 16u) & 0xFFu); /* 7  */
    CopyData[7] = (uint8_t)(((Total_Vehicle_Distance * 8u / 10u) >> 24u) & 0xFFu); /* 8  */
}

/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_18FEFC17
 * Description    :
 * Input          : None  18FEFC17
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Can_Set_Buff_18FEFC17(uint8_t CopyData[])
{
    uint8_t Washer_Fluid_Level = 0u;
    uint8_t Fuel_Level_1 = 0u; /*仪表外发*/
    uint8_t Engine_Fuel_Filter_Differential_Pressure = 0u;
    uint8_t Engine_Oil_Filter_Differential_Pressure = 0u;
    uint16_t Cargo_Ambient_Temperature = 0u;
    uint8_t Fuel_Level_2 = 0u;
    uint8_t Engine_Oil_Filter_Differential = 0u;

    uint16_t Get_Step = 0u;
    Get_Step = Fuel_Get_Step();

    if (Get_Step > 10u)
    {
        Fuel_Level_1 = (uint8_t)((Get_Step - 10u) * 50u / 24u);
    }
    else
    {
        Fuel_Level_1 = 0u;
    }

    CopyData[0] = (uint8_t)Washer_Fluid_Level;                          /* 1  */
    CopyData[1] = (uint8_t)Fuel_Level_1;                                /* 2  */
    CopyData[2] = (uint8_t)Engine_Fuel_Filter_Differential_Pressure;    /* 3  */
    CopyData[3] = (uint8_t)Engine_Oil_Filter_Differential_Pressure;     /* 4  */
    CopyData[4] = (uint8_t)(Cargo_Ambient_Temperature & 0xFFu);         /* 5  */
    CopyData[5] = (uint8_t)((Cargo_Ambient_Temperature >> 8u) & 0xFFu); /* 6  */
    CopyData[6] = (uint8_t)Fuel_Level_2;                                /* 7  */
    CopyData[7] = (uint8_t)Engine_Oil_Filter_Differential;              /* 8  */
}

/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_18FF2517
 * Description    :
 * Input          : None  18FF2517
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Can_Set_Buff_18FF2517(uint8_t CopyData[])
{
    uint16_t Year = 0u;
    uint8_t Month = 0u;
    uint8_t Day = 0u;
    uint8_t Hour = 0u;
    uint8_t Minute = 0u;
    uint32_t ODO_Meter = 0u;

    //Year = Get_RTC_YEAR();
    //Month = Get_RTC_MONTH();
    //Day = Get_RTC_DATE();
    //Hour = Get_RTC_HOUR();
    //Minute = Get_RTC_MINUTE();

    /*根据禅道编号5095内容修改----start----*/
    Year = (uint16_t)Get_ID_18FEE64A_Sig_TBOX_Year();
    Year  = (Year & 0xFF) + 1985u;
    Month = (uint8_t)Get_ID_18FEE64A_Sig_TBOX_Month();
    Day = (uint8_t)Get_ID_18FEE64A_Sig_TBOX_Day();
    Day = Day / 4;
    Hour = (uint8_t)Get_ID_18FEE64A_Sig_TBOX_Hours();
    Minute = (uint8_t)Get_ID_18FEE64A_Sig_TBOX_Minutes();
    /*根据禅道编号5095内容修改----end----*/

    CopyData[0] = (uint8_t)(Year & 0xFFu);               /* 1  */
    CopyData[1] = (uint8_t)Month;                        /* 2  */
    CopyData[2] = (uint8_t)Day;                          /* 3  */
    CopyData[3] = (uint8_t)Hour;                         /* 4  */
    CopyData[4] = (uint8_t)Minute;                       /* 5  */
    CopyData[5] = (uint8_t)(ODO_Meter & 0xFFu);          /* 6  */
    CopyData[6] = (uint8_t)((ODO_Meter >> 8u) & 0xFFu);  /* 7  */
    CopyData[7] = (uint8_t)((ODO_Meter >> 16u) & 0xFFu); /* 8  */
}

/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_18FF2A17
 * Description    :
 * Input          : None 18FF2A17
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Can_Set_Buff_18FF2A17(uint8_t CopyData[])
{
    uint8_t Water_Temp_Level = 0u;            /*水温状态*/
    uint8_t Remining_Fuel_Warning = 0u;       /*剩余燃料报警*/
    uint8_t Battery_Maintenance_Warning = 0u; /*电池维护报警*/
    uint8_t Over_Heat_Warning_Status = 0u;    /*水温状态*/
    uint8_t Meter_Malfunction = 0u;           /*仪表故障*/
    uint8_t SRS_Input = 0u;
    uint8_t SW_Rear_Body_Warning = 0u;
    uint8_t SW_Sheetbelt = 0u;
    uint8_t SW_Oil_Pressure = 0u;
    uint8_t SW_Coolant_Level = 0u;
    uint8_t SW_Water_Separator = 0u;
    uint8_t SW_Clutch = 0u;
    uint8_t SW_Air_Low_Pressure = 0u;
    uint8_t SW_MT_Range = 0u;
    uint8_t SW_MT_Spriter = 0u;
    uint8_t SW_KickDrive = 0u;
    uint8_t SW_DefLock = 0u;
    uint8_t ACG_L_Terminal = 0u;
    uint8_t Reserve = 0u;
    uint8_t SW_Dr_Door = 0u;
    uint8_t EDS_Smoother_WL_Status = 0u;
    uint8_t EBS_Warning_Red = 0u;
    uint8_t EBS_Warning_Yellow = 0u;
    uint8_t ESC_Operating = 0u;
    uint8_t Air_Sus_Warning = 0u;
    uint8_t Roll_Warning = 0u;
    uint8_t ROWS_Warning = 0u;
    uint8_t Mult_Indication = 0u;
    uint8_t SW_KeyRemind = 0u;
    uint8_t SW_Hi_Beam = 0u;
    uint8_t TURN_R_Lamp_Status = 0u;
    uint8_t SW_Illmi = 0u;
    uint8_t SW_SpotLamp = 0u;
    uint8_t SW_Accessory_Air = 0u;
    uint8_t SW_Trailer_Brake = 0u;
    uint8_t Input_Trailer_Info = 0u;
    uint8_t Input_Trailer_ABS = 0u;
    uint8_t SW_Coupler_Lock = 0u;
    uint8_t SW_Parking = 0u;
    uint16_t IGN_Voltage = 0u;
    uint8_t MJX_MEB9_Manual_TM_Range_Low = 0u;
    uint8_t Range_Air_Cut_Warning = 0u;
    uint8_t IRIS_Warning_Lamp_Status = 0u;
    uint8_t Temperature = 0u;

    uint16_t E_Speed = 0u;

    E_Speed = Common_Get_Act_E_Speed();  /*转速*/
    /*手刹状态*/
    if (Line_In_Get_Status(LINE_IN_PARK_BRAKE) == 1u)
    {
        SW_Parking = 1 ;
    }
    else
    {
        SW_Parking = 0 ;
    }

    Temperature = Get_ID_18FEEE00_Sig_Engine_Coolant_Temperature();
    /*水温状态*/
    if ((Temperature > 0xFA) || (CAN_SIG_LOST == CAN_MSG_Status(ID_CanMsg18FEEE00_Msg_Count)))
    {
        Water_Temp_Level = 2;
    }
    else if ((Coolant_Get_CurSeg() >= 0) && (Coolant_Get_CurSeg() < 11))
    {
        Water_Temp_Level = 0 ;
    }
    else if ((Coolant_Get_CurSeg() >= 11) && (Coolant_Get_CurSeg() <= 12))
    {
        Water_Temp_Level = 1 ;
    }
    else
    {
        Water_Temp_Level = 0 ;
    }

    if ((Coolant_Get_Valid() == 1u) && (Coolant_Get_CurSeg() >= 11u) && (Temperature >= 0x96u))
    {
        Water_Temp_Level_Flag = 1u;
    }
    else if (Coolant_Get_CurSeg() <= 9)
    {
        Water_Temp_Level_Flag = 0u;
    }

    if ((Common_Get_Water_Temp_Level_Flag() == 1) && (Common_Get_Disp_V_Speed() > 20))
    {
        Over_Heat_Warning_Status = 1 ;
    }
    else
    {
        Over_Heat_Warning_Status = 0 ;
    }

    /*剩余燃料报警*/
    Remining_Fuel_Warning = Fuel_Get_Popup_Sta();

    Battery_Maintenance_Warning = 0u;
    Meter_Malfunction = 0u;
    SRS_Input = 0u;
    SW_Rear_Body_Warning = 0u;

    /*安全带外发报文*/
    if (Line_In_Get_Status(LINE_IN_SEAT_BELT) == 1)
    {
        SW_Sheetbelt = 1u;
    }
    else
    {
        SW_Sheetbelt = 0u;
    }

    /*油压外发报文*/
    if ((Line_In_Get_Status(LINE_IN_ENG_OIL) == 1) && (E_Speed >= 350u))
    {
        SW_Oil_Pressure = 1u;
    }
    else
    {
        SW_Oil_Pressure = 0u;
    }

    /*冷却水不足外发报文*/
    if (CD4051_COM5_X4_IN == 0)
    {
        SW_Coolant_Level = 1u;
    }
    else
    {
        SW_Coolant_Level = 0u;
    }

    SW_Water_Separator = 0u;
    SW_Clutch = 0u;
    SW_Air_Low_Pressure = 0u;
    SW_MT_Range = 0u;
    SW_MT_Spriter = 0u;
    SW_KickDrive = 0u;
    SW_DefLock = 0u;
    ACG_L_Terminal = 0u;
    Reserve = 0u;
    SW_Dr_Door = 0u;
    EDS_Smoother_WL_Status = 0u;
    EBS_Warning_Red = 0u;
    EBS_Warning_Yellow = 0u;
    ESC_Operating = 0u;

    /*AIR SUS灯外发*/
    if (Line_In_Get_Status(LINE_IN_AIR_SUS) == 1)
    {
        Air_Sus_Warning = 1u;
    }
    else
    {
        Air_Sus_Warning = 0u;
    }

    Roll_Warning = 0u;
    ROWS_Warning = 0u;
    Mult_Indication = 0u;

    /*钥匙状态*/
    /*A3-28 A20-GND B39-OPEN  A2-OPEN*/
    if (
        (CD4051_COM3_X7_IN == 1u) &&
        (CD4051_COM3_X5_IN == 0u) &&
        (Line_In_Get_Status(LINE_IN_ACC) == 0u) &&
        (Common_Get_IG_Sts() != COMMON_POWER_ON)
    )
    {
        SW_KeyRemind = 0u;
    }
    else
    {
        SW_KeyRemind = 1u;
    }

    /*远光灯状态*/
    if (Line_In_Get_Status(LINE_IN_HI_BEAM) == 1)
    {
        SW_Hi_Beam = 1u;
    }
    else
    {
        SW_Hi_Beam = 0u;
    }

    TURN_R_Lamp_Status = 0u;
    SW_Illmi = 0u;
    SW_SpotLamp = 0u;
    SW_Accessory_Air = 0u;
    SW_Trailer_Brake = 0u;
    Input_Trailer_Info = 0u;
    Input_Trailer_ABS = 0u;
    SW_Coupler_Lock = 0u;

    /*电源电压*/
    /*IGN_Voltage = (9 + Gui_Get_Voltmeter_DisplayMode()) * 10 ;*/

    IGN_Voltage = Get_Voltmeter_AvrVoltage();
    if (IGN_Voltage >= 9000)
    {
        IGN_Voltage = IGN_Voltage / 100 - 90;
    }
    else
    {
        IGN_Voltage = 90;
    }

    MJX_MEB9_Manual_TM_Range_Low = 0u;
    Range_Air_Cut_Warning = 0u;
    IRIS_Warning_Lamp_Status = 0u;
    Temperature = 0u;

    CopyData[0] = (uint8_t)(((Water_Temp_Level << 6u) & 0xC0u) |
                            ((Remining_Fuel_Warning << 5u) & 0x20u) |
                            ((Battery_Maintenance_Warning << 3u) & 0x18u) |
                            ((Over_Heat_Warning_Status << 2u) & 0x04u) |
                            (Meter_Malfunction & 0x03u)); /* 1  */
    CopyData[1] = (uint8_t)(((SRS_Input << 7u) & 0x80u) |
                            ((SW_Rear_Body_Warning << 6u) & 0x040u) |
                            ((SW_Sheetbelt << 5u) & 0x20u) |
                            ((SW_Oil_Pressure << 4u) & 0x10u) |
                            ((SW_Coolant_Level << 3u) & 0x08u) |
                            ((SW_Water_Separator << 2u) & 0x04u) |
                            ((SW_Clutch << 1u) & 0x02u) |
                            (SW_Air_Low_Pressure & 0x01u)); /* 2  */
    CopyData[2] = (uint8_t)(((SW_MT_Range << 7u) & 0x80u) |
                            ((SW_MT_Spriter << 6u) & 0x040u) |
                            ((SW_KickDrive << 5u) & 0x20u) |
                            ((SW_DefLock << 4u) & 0x10u) |
                            ((ACG_L_Terminal << 3u) & 0x08u) |
                            ((SW_Dr_Door << 1u) & 0x02u) |
                            (EDS_Smoother_WL_Status & 0x01u)); /* 3  */
    CopyData[3] = (uint8_t)(((EBS_Warning_Red << 7u) & 0x80u) |
                            ((EBS_Warning_Yellow << 6u) & 0x040u) |
                            ((ESC_Operating << 5u) & 0x20u) |
                            ((Air_Sus_Warning << 4u) & 0x10u) |
                            ((Roll_Warning << 3u) & 0x08u) |
                            ((ROWS_Warning << 2u) & 0x04u) |
                            (Mult_Indication & 0x03u)); /* 4  */
    CopyData[4] = (uint8_t)(((SW_KeyRemind << 7u) & 0x80u) |
                            ((SW_Hi_Beam << 6u) & 0x040u) |
                            ((TURN_R_Lamp_Status << 5u) & 0x20u) |
                            ((SW_Illmi << 3u) & 0x08u) |
                            ((SW_SpotLamp << 1u) & 0x02u) |
                            (SW_Accessory_Air & 0x01u)); /* 5  */
    CopyData[5] = (uint8_t)(((SW_Trailer_Brake << 6u) & 0xC0u) |
                            ((Input_Trailer_Info << 5u) & 0x20u) |
                            ((Input_Trailer_ABS << 4u) & 0x10u) |
                            ((SW_Coupler_Lock << 3u) & 0x04u) |
                            (SW_Parking & 0x03)); /* 6  */
    CopyData[6] = (uint8_t)(IGN_Voltage & 0xFFu); /* 7  */
    CopyData[7] = (uint8_t)(((MJX_MEB9_Manual_TM_Range_Low << 7u) & 0x80u) |
                            ((Range_Air_Cut_Warning << 6u) & 0x40u) |
                            ((IRIS_Warning_Lamp_Status << 5u) & 0x20u)); /* 8  */
}

uint8_t Common_Get_Water_Temp_Level_Flag(void)
{
    return (uint8_t)Water_Temp_Level_Flag ;
}

/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_18FF9D17
 * Description    :
 * Input          : None 18FF9D17
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Can_Set_Buff_18FF9D17(uint8_t CopyData[])
{
    uint8_t Fuel_Level = 0u;

    uint16_t Get_Step = 0u;
    Get_Step = Fuel_Get_Step();

    /*燃油剩余百分比     精度 1% 偏移量 0 */
    if (Get_Step > 10u)
    {
        Fuel_Level = (uint8_t)((Get_Step - 10u) * 100u / 120u);
    }
    else
    {
        Fuel_Level = 0u;
    }

    CopyData[0] = (uint8_t)(Fuel_Level & 0xFFu); /* 1  */
    CopyData[1] = 0u;                            /* 2  */
    CopyData[2] = 0u;                            /* 3  */
    CopyData[3] = 0u;                            /* 4  */
    CopyData[4] = 0u;                            /* 5  */
    CopyData[5] = 0u;                            /* 6  */
    CopyData[6] = 0u;                            /* 7  */
    CopyData[7] = 0u;                            /* 8  */
}

/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_18FFE517
 * Description    :
 * Input          : None  18FFE517
 * Output         : None
 * Return         : None
 * onther         : Event triggered   事件型报文
 --------------------------------------------------------------------------*/
uint8_t LDWS_Flag_Sta = 0u;

void Can_Set_Buff_18FFE517(uint8_t CopyData[])
{
    uint8_t DTC_Clear_Request = 0u;
    uint8_t Req_0Point = 0u;
    uint8_t Ferry_Mode_Cancel = 0u;
    uint8_t System_Demonstration_Request = 0u;

    DTC_Clear_Request = 0u;
    Req_0Point = 0u;
    Ferry_Mode_Cancel = 0u;
    System_Demonstration_Request = 0u;

    //CopyData[0] = (uint8_t)(DTC_Clear_Request & 0xFFu); /* 1  */
    //CopyData[1] = (uint8_t)(Req_0Point & 0xFFu);        /* 2  */
    //CopyData[2] = (uint8_t)(((Ferry_Mode_Cancel << 7u) & 0x80U) |
    //                        (System_Demonstration_Request & 0x7Fu)); /* 3  */
    //CopyData[3] = 0u;                                                /* 4  */
    //CopyData[4] = 0u;                                                /* 5  */
    //CopyData[5] = 0u;                                                /* 6  */
    //CopyData[6] = 0u;                                                /* 7  */
    //CopyData[7] = 0u;                                                /* 8  */

    if (bCurMenuIDX == _MN_DSP_LEVEL3_5_MENU_1) /*LDWS警报模拟*/
    {
        if (Common_Get_LDWS_Flag_Sta() == 1)
        {
            CopyData[0] = 0x00u; /* 1  */
            CopyData[1] = 0x00u; /* 2  */
            CopyData[2] = 0x00u; /* 3  */
            CopyData[3] = 0xFFu; /* 4  */
            CopyData[4] = 0xFFu; /* 5  */
            CopyData[5] = 0xFFu; /* 6  */
            CopyData[6] = 0xFFu; /* 7  */
            CopyData[7] = 0xFFu; /* 8  */
        }
        else if (Common_Get_LDWS_Flag_Sta() == 3)
        {
            CopyData[0] = 0x00u; /* 1  */
            CopyData[1] = 0x00u; /* 2  */
            CopyData[2] = 0x01u; /* 3  */
            CopyData[3] = 0xFFu; /* 4  */
            CopyData[4] = 0xFFu; /* 5  */
            CopyData[5] = 0xFFu; /* 6  */
            CopyData[6] = 0xFFu; /* 7  */
            CopyData[7] = 0xFFu; /* 8  */
        }
        else if (Common_Get_LDWS_Flag_Sta() == 5)
        {
            CopyData[0] = 0x00u; /* 1  */
            CopyData[1] = 0x00u; /* 2  */
            CopyData[2] = 0x00u; /* 3  */
            CopyData[3] = 0xFFu; /* 4  */
            CopyData[4] = 0xFFu; /* 5  */
            CopyData[5] = 0xFFu; /* 6  */
            CopyData[6] = 0xFFu; /* 7  */
            CopyData[7] = 0xFFu; /* 8  */
        }
    }
    else if (bCurMenuIDX == _MN_DSP_LEVEL3_5_MENU_2) /*AEBS第一警报模拟*/
    {
        if (Common_Get_LDWS_Flag_Sta() == 1)
        {
            CopyData[0] = 0x00u; /* 1  */
            CopyData[1] = 0x00u; /* 2  */
            CopyData[2] = 0x00u; /* 3  */
            CopyData[3] = 0xFFu; /* 4  */
            CopyData[4] = 0xFFu; /* 5  */
            CopyData[5] = 0xFFu; /* 6  */
            CopyData[6] = 0xFFu; /* 7  */
            CopyData[7] = 0xFFu; /* 8  */
        }
        else if (Common_Get_LDWS_Flag_Sta() == 3)
        {
            CopyData[0] = 0x00u; /* 1  */
            CopyData[1] = 0x00u; /* 2  */
            CopyData[2] = 0x02u; /* 3  */
            CopyData[3] = 0xFFu; /* 4  */
            CopyData[4] = 0xFFu; /* 5  */
            CopyData[5] = 0xFFu; /* 6  */
            CopyData[6] = 0xFFu; /* 7  */
            CopyData[7] = 0xFFu; /* 8  */
        }
        else if (Common_Get_LDWS_Flag_Sta() == 5)
        {
            CopyData[0] = 0x00u; /* 1  */
            CopyData[1] = 0x00u; /* 2  */
            CopyData[2] = 0x00u; /* 3  */
            CopyData[3] = 0xFFu; /* 4  */
            CopyData[4] = 0xFFu; /* 5  */
            CopyData[5] = 0xFFu; /* 6  */
            CopyData[6] = 0xFFu; /* 7  */
            CopyData[7] = 0xFFu; /* 8  */
        }
    }
    else if (bCurMenuIDX == _MN_DSP_LEVEL3_5_MENU_3)/*AEBS第二警报模拟*/
    {
        if (Common_Get_LDWS_Flag_Sta() == 1)
        {
            CopyData[0] = 0x00u; /* 1  */
            CopyData[1] = 0x00u; /* 2  */
            CopyData[2] = 0x00u; /* 3  */
            CopyData[3] = 0xFFu; /* 4  */
            CopyData[4] = 0xFFu; /* 5  */
            CopyData[5] = 0xFFu; /* 6  */
            CopyData[6] = 0xFFu; /* 7  */
            CopyData[7] = 0xFFu; /* 8  */
        }
        else if (Common_Get_LDWS_Flag_Sta() == 3)
        {
            CopyData[0] = 0x00u; /* 1  */
            CopyData[1] = 0x00u; /* 2  */
            CopyData[2] = 0x03u; /* 3  */
            CopyData[3] = 0xFFu; /* 4  */
            CopyData[4] = 0xFFu; /* 5  */
            CopyData[5] = 0xFFu; /* 6  */
            CopyData[6] = 0xFFu; /* 7  */
            CopyData[7] = 0xFFu; /* 8  */
        }
        else if (Common_Get_LDWS_Flag_Sta() == 5)
        {
            CopyData[0] = 0x00u; /* 1  */
            CopyData[1] = 0x00u; /* 2  */
            CopyData[2] = 0x00u; /* 3  */
            CopyData[3] = 0xFFu; /* 4  */
            CopyData[4] = 0xFFu; /* 5  */
            CopyData[5] = 0xFFu; /* 6  */
            CopyData[6] = 0xFFu; /* 7  */
            CopyData[7] = 0xFFu; /* 8  */
        }
    }
    else if (bCurMenuIDX == _MN_DSP_LEVEL3_5_MENU_4)/*AEBS本质动警报模拟*/
    {
        if (Common_Get_LDWS_Flag_Sta() == 1)
        {
            CopyData[0] = 0x00u; /* 1  */
            CopyData[1] = 0x00u; /* 2  */
            CopyData[2] = 0x00u; /* 3  */
            CopyData[3] = 0xFFu; /* 4  */
            CopyData[4] = 0xFFu; /* 5  */
            CopyData[5] = 0xFFu; /* 6  */
            CopyData[6] = 0xFFu; /* 7  */
            CopyData[7] = 0xFFu; /* 8  */
        }
        else if (Common_Get_LDWS_Flag_Sta() == 3)
        {
            CopyData[0] = 0x00u; /* 1  */
            CopyData[1] = 0x00u; /* 2  */
            CopyData[2] = 0x04u; /* 3  */
            CopyData[3] = 0xFFu; /* 4  */
            CopyData[4] = 0xFFu; /* 5  */
            CopyData[5] = 0xFFu; /* 6  */
            CopyData[6] = 0xFFu; /* 7  */
            CopyData[7] = 0xFFu; /* 8  */
        }
        else if (Common_Get_LDWS_Flag_Sta() == 5)
        {
            CopyData[0] = 0x00u; /* 1  */
            CopyData[1] = 0x00u; /* 2  */
            CopyData[2] = 0x00u; /* 3  */
            CopyData[3] = 0xFFu; /* 4  */
            CopyData[4] = 0xFFu; /* 5  */
            CopyData[5] = 0xFFu; /* 6  */
            CopyData[6] = 0xFFu; /* 7  */
            CopyData[7] = 0xFFu; /* 8  */
        }
    }
    else if ((bCurMenuIDX == _FAC_DSP_LEVEL1_2MENU_3) || (bCurMenuIDX == _DEA_DSP_LEVEL1_2MENU_3)) /*DTC清除界面时外发*/
    {
        /* _FAC_DSP_LEVEL1_2MENU_3 _DEA_DSP_LEVEL1_2MENU_3 界面发送 两帧 500ms */
        CopyData[0] = 0x55u; /* 1  */
        CopyData[1] = 0x00u; /* 2  */
        CopyData[2] = 0x00u; /* 3  */
        CopyData[3] = 0xFFu; /* 4  */
        CopyData[4] = 0xFFu; /* 5  */
        CopyData[5] = 0xFFu; /* 6  */
        CopyData[6] = 0xFFu; /* 7  */
        CopyData[7] = 0xFFu; /* 8  */
    }
}

/*事件型外发控制server*/
void Id18FFE517_Send_Service(void)
{
    if ((bCurMenuIDX >= _MN_DSP_LEVEL3_5_MENU_1) && (bCurMenuIDX <= _MN_DSP_LEVEL3_5_MENU_4))
    {
        if (Common_Get_LDWS_Flag_Sta() == 0u)
        {
            Id18FFE517Msg_TXSUCCESSNum = 0u;
            Can_Msg_Tx_Overwrite(MSGID_18FFE517, 10u, 100 * 1000);
            Common_Set_LDWS_Flag_Sta(1u);
        }
        else if (Common_Get_LDWS_Flag_Sta() == 1u)
        {
            if (Common_GetId18FFE517Msg_TXSUCCESS() == 10)
            {
                Id18FFE517Msg_TXSUCCESSNum = 0u;
                Common_Set_LDWS_Flag_Sta(2);
            }
        }
        else if (Common_Get_LDWS_Flag_Sta() == 2u)
        {
            Can_Msg_Tx_Overwrite(MSGID_18FFE517, 30u, 100 * 1000);
            Common_Set_LDWS_Flag_Sta(3u);
        }
        else if (Common_Get_LDWS_Flag_Sta() == 3u)
        {
            if (Common_GetId18FFE517Msg_TXSUCCESS() == 30)
            {
                Id18FFE517Msg_TXSUCCESSNum = 0u;
                Common_Set_LDWS_Flag_Sta(4);
            }
        }
        else if (Common_Get_LDWS_Flag_Sta() == 4u)
        {
            Can_Msg_Tx_Overwrite(MSGID_18FFE517, 10u, 100 * 1000);
            Common_Set_LDWS_Flag_Sta(5u);
        }
        else if (Common_Get_LDWS_Flag_Sta() == 5u)
        {
            if (Common_GetId18FFE517Msg_TXSUCCESS() == 10)
            {
                Id18FFE517Msg_TXSUCCESSNum = 0u;
                Common_Set_LDWS_Flag_Sta(6);
            }
        }
    }
    else if ((bCurMenuIDX == _FAC_DSP_LEVEL1_2MENU_3) || (bCurMenuIDX == _DEA_DSP_LEVEL1_2MENU_3))
    {
        if (Common_Get_LDWS_Flag_Sta() == 7u)
        {
            Can_Msg_Tx_Overwrite(MSGID_18FFE517, 2u, 500 * 1000);
            Common_Set_LDWS_Flag_Sta(0);
        }
    }
}

void Common_SetId18FFE517Msg_TXSUCCESS(void)
{
    Id18FFE517Msg_TXSUCCESSNum++;
}

uint8_t Common_GetId18FFE517Msg_TXSUCCESS(void)
{
    return Id18FFE517Msg_TXSUCCESSNum;
}

void Common_Set_LDWS_Flag_Sta(uint8_t Vol)
{
    LDWS_Flag_Sta = Vol;
}

uint8_t Common_Get_LDWS_Flag_Sta(void)
{
    return LDWS_Flag_Sta;
}
/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_18EF2D17
 * Description    :
 * Input          : None 18EF2D17  未见此报文
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Can_Set_Buff_18EF2D17(uint8_t CopyData[])
{
    CopyData[0] = 0u; /* 1  */
    CopyData[1] = 0u; /* 2  */
    CopyData[2] = 0u; /* 3  */
    CopyData[3] = 0u; /* 4  */
    CopyData[4] = 0u; /* 5  */
    CopyData[5] = 0u; /* 6  */
    CopyData[6] = 0u; /* 7  */
    CopyData[7] = 0u; /* 8  */
}
/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_18033317
 * Description    : 胎压匹配外发报文 事件型
 * Input          : None  18033317
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Can_Set_Buff_18033317(uint8_t CopyData[])
{
    uint8_t Pair_cmd = 0u;

    Common_SetTXNum_18033317();

    if (User_set_Num.User_TpmsStatus == 2)
    {
        CopyData[0] = 0x61u;
        switch (User_set_Num.User_Tpms)
        {
        case 1 :
            CopyData[1] = 0x12;
            break;
        case 2 :
            CopyData[1] = 0x13;
            break;
        case 3 :
            CopyData[1] = 0x22;
            break;
        case 4 :
            CopyData[1] = 0x23;
            break;
        case 5 :
            CopyData[1] = 0x31;
            break;
        case 6 :
            CopyData[1] = 0x32;
            break;
        case 7 :
            CopyData[1] = 0x33;
            break;
        case 8 :
            CopyData[1] = 0x34;
            break;
        case 9 :
            CopyData[1] = 0x41;
            break;
        case 10 :
            CopyData[1] = 0x42;
            break;
        case 11 :
            CopyData[1] = 0x43;
            break;
        case 12 :
            CopyData[1] = 0x44;
            break;
        default    :
            break   ;
        }
    }
    else if (User_set_Num.User_TpmsStatus == 1)
    {
        CopyData[0] = 0x91;                    /* 1  */
        CopyData[1] = 0u;                      /* 2  */
    }

    CopyData[2] = 0u;                          /* 3  */
    CopyData[3] = 0u;                          /* 4  */
    CopyData[4] = 0u;                          /* 5  */
    CopyData[5] = 0u;                          /* 6  */
    CopyData[6] = 0u;                          /* 7  */
    CopyData[7] = 0u;                          /* 8  */
}
void Id18033317_Send_Service(void)
{
    if (User_set_Num.User_TpmsSend == 3u)
    {
        Can_Msg_Tx_Overwrite(MSGID_18033317, 3u, 50 * 1000);

        User_set_Num.User_TpmsSend = 0u;
        TXNum_18033317 = 0u;
    }
}
/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_180433A2
 * Description    :
 * Input          : None 180433A2
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Can_Set_Buff_180433A2(uint8_t CopyData[])
{
    uint8_t Setup_cmd = 0u;

    Setup_cmd = 0u;

    CopyData[0] = (uint8_t)(Setup_cmd & 0xFFu); /* 1  */
    CopyData[1] = 0u;                           /* 2  */
    CopyData[2] = 0u;                           /* 3  */
    CopyData[3] = 0u;                           /* 4  */
    CopyData[4] = 0u;                           /* 5  */
    CopyData[5] = 0u;                           /* 6  */
    CopyData[6] = 0u;                           /* 7  */
    CopyData[7] = 0u;                           /* 8  */
}

/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_18EA0017
 * Description    :
 * Input          : None 18EA0017 (发送定值)
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Can_Set_Buff_18EA0017(uint8_t  CopyData[])
{
    CopyData[0] = 0xEDU;                           /* 1  */
    CopyData[1] = 0xFEU;                           /* 2  */
    CopyData[2] = 0x00u;                           /* 3  */
    CopyData[3] = 0xFFu;                           /* 4  */
    CopyData[4] = 0xFFu;                           /* 5  */
    CopyData[5] = 0xFFu;                           /* 6  */
    CopyData[6] = 0xFFu;                           /* 7  */
    CopyData[7] = 0xFFu;                           /* 8  */
}

/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_18EF1817
 * Description    :
 * Input          : None 18EF1817
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Can_Set_Buff_18EF1817(uint8_t CopyData[])
{
    uint8_t Trip_Type = 0u;
    uint8_t Engine_Oil_Num_Cup = 0u;

    Trip_Type = User_set_Num.Trip_Type ;

    if (State_Flag.FState_ClearOilTx == 0x02u)
    {
        if (Trip_Type == TRAPA)
        {
            CopyData[0] = 0x40;
            CopyData[1] = 0x50;
            CopyData[2] = 0x00;
            CopyData[3] = 0x00;
            CopyData[4] = 0x00;
            CopyData[5] = 0x00;
            CopyData[6] = 0xFF;
            CopyData[7] = 0xFF;
        }
        else if (Trip_Type == TRAPB)
        {
            CopyData[0] = 0x40;
            CopyData[1] = 0x60;
            CopyData[2] = 0x00;
            CopyData[3] = 0x00;
            CopyData[4] = 0x00;
            CopyData[5] = 0x00;
            CopyData[6] = 0xFF;
            CopyData[7] = 0xFF;
        }

        User_BCM_Flag = 1u; /*从头轮询*/
        State_Flag.FState_ClearOilTx = 0x03u;
        State_Flag.FState_ClearOilRx = 0u;
        State_Flag.FState_COilTimeOut = 0u;
    }
    else
    {
        /*清空发动机油＆滤清器残留距离 (m) 请求*/
        if (Common_Get_Can_Engine_Oil_Sta() == 1)
        {
            CopyData[0] = 0x40;
            CopyData[1] = 0x20;
            CopyData[2] = 0x00;
            CopyData[3] = 0x00;
            CopyData[4] = 0x00;
            CopyData[5] = 0x00;
            CopyData[6] = 0xFF;
            CopyData[7] = 0xFF;

            Common_Set_Can_Engine_Oil_Sta(0);
        }
        /*上电连续发送五次 发动机油＆滤清器警报阈值 (m) 请求*/
        else if (Common_Get_Can_Engine_Oil_Num() < 5)
        {
            Engine_Oil_Num_Cup = Common_Get_Can_Engine_Oil_Num();
            Engine_Oil_Num_Cup++;
            Common_Set_Can_Engine_Oil_Num(Engine_Oil_Num_Cup);

            CopyData[0] = 0x01;
            CopyData[1] = 0x30;
            CopyData[2] = 0x00;
            CopyData[3] = 0x00;
            CopyData[4] = 0x00;
            CopyData[5] = 0x00;
            CopyData[6] = 0xFF;
            CopyData[7] = 0xFF;
        }
        /*正常状态发送数据*/
        else
        {
            /*增加发送5次机制*/
            if (((Common_Get_18EF1718_Msg_Sta() == COMMON_Valid) && (Send_18EF1718_Msg_Sta >= 1u)) ||
                    (Send_18EF1718_Msg_Sta >= 6u))
            {
                User_BCM_Flag++;
                if (User_BCM_Flag > 12u)
                {
                    User_BCM_Flag = 1u;
                }
            }
            else
            {
                if (Send_18EF1718_Msg_Sta <= 10)
                    Send_18EF1718_Msg_Sta++;
            }

            switch (User_BCM_Flag)
            {
            case 1:
                CopyData[0] = 0x01;
                CopyData[1] = 0x50;
                CopyData[2] = 0x00;
                CopyData[3] = 0x00;
                CopyData[4] = 0x00;
                CopyData[5] = 0x00;
                CopyData[6] = 0xFF;
                CopyData[7] = 0xFF;
                break;
            case 2:
                CopyData[0] = 0x01;
                CopyData[1] = 0x51;
                CopyData[2] = 0x00;
                CopyData[3] = 0x00;
                CopyData[4] = 0x00;
                CopyData[5] = 0x00;
                CopyData[6] = 0xFF;
                CopyData[7] = 0xFF;
                break;
            case 3:
                CopyData[0] = 0x01;
                CopyData[1] = 0x52;
                CopyData[2] = 0x00;
                CopyData[3] = 0x00;
                CopyData[4] = 0x00;
                CopyData[5] = 0x00;
                CopyData[6] = 0xFF;
                CopyData[7] = 0xFF;
                break;
            case 4:
                CopyData[0] = 0x01;
                CopyData[1] = 0x53;
                CopyData[2] = 0x00;
                CopyData[3] = 0x00;
                CopyData[4] = 0x00;
                CopyData[5] = 0x00;
                CopyData[6] = 0xFF;
                CopyData[7] = 0xFF;
                break;
            case 5:
                CopyData[0] = 0x01;
                CopyData[1] = 0x54;
                CopyData[2] = 0x00;
                CopyData[3] = 0x00;
                CopyData[4] = 0x00;
                CopyData[5] = 0x00;
                CopyData[6] = 0xFF;
                CopyData[7] = 0xFF;
                break;
            case 6:
                CopyData[0] = 0x01;
                CopyData[1] = 0x60;
                CopyData[2] = 0x00;
                CopyData[3] = 0x00;
                CopyData[4] = 0x00;
                CopyData[5] = 0x00;
                CopyData[6] = 0xFF;
                CopyData[7] = 0xFF;
                break;
            case 7:
                CopyData[0] = 0x01;
                CopyData[1] = 0x61;
                CopyData[2] = 0x00;
                CopyData[3] = 0x00;
                CopyData[4] = 0x00;
                CopyData[5] = 0x00;
                CopyData[6] = 0xFF;
                CopyData[7] = 0xFF;
                break;
            case 8:
                CopyData[0] = 0x01;
                CopyData[1] = 0x62;
                CopyData[2] = 0x00;
                CopyData[3] = 0x00;
                CopyData[4] = 0x00;
                CopyData[5] = 0x00;
                CopyData[6] = 0xFF;
                CopyData[7] = 0xFF;
                break;
            case 9:
                CopyData[0] = 0x01;
                CopyData[1] = 0x63;
                CopyData[2] = 0x00;
                CopyData[3] = 0x00;
                CopyData[4] = 0x00;
                CopyData[5] = 0x00;
                CopyData[6] = 0xFF;
                CopyData[7] = 0xFF;
                break;
            case 10:
                CopyData[0] = 0x01;
                CopyData[1] = 0x64;
                CopyData[2] = 0x00;
                CopyData[3] = 0x00;
                CopyData[4] = 0x00;
                CopyData[5] = 0x00;
                CopyData[6] = 0xFF;
                CopyData[7] = 0xFF;
                break;
            case 11:
                CopyData[0] = 0x01;
                CopyData[1] = 0x22;
                CopyData[2] = 0x00;
                CopyData[3] = 0x00;
                CopyData[4] = 0x00;
                CopyData[5] = 0x00;
                CopyData[6] = 0xFF;
                CopyData[7] = 0xFF;
                break;
            case 12:
                CopyData[0] = 0x01;
                CopyData[1] = 0x30;
                CopyData[2] = 0x00;
                CopyData[3] = 0x00;
                CopyData[4] = 0x00;
                CopyData[5] = 0x00;
                CopyData[6] = 0xFF;
                CopyData[7] = 0xFF;
                break;
            default:
                break;
            }
        }
    }
}

void Id18EF1817_Send_Service(void)
{
    if (State_Flag.FState_ClearOilTx == 1u)
    {
        Can_Msg_Tx_Overwrite(MSGID_18EF1817, 1u, 100 * 1000);

        State_Flag.FState_ClearOilTx = 2u;
    }
    else
    {
        if ((State_Flag.FState_ClearOilRx == 0u) && (State_Flag.FState_COilTimeOut != FState_COilTimeOutNum))
        {
            Can_Msg_Tx_Overwrite(MSGID_18EF1817, 0u, 100 * 1000);
        }
        else
        {
            Can_Msg_Tx_Overwrite(MSGID_18EF1817, 0xFFFFu, 100 * 1000);
            State_Flag.FState_ClearOilTx = 0u;
        }
    }
}

/*-------------------------------------------------------------------------
 * Function Name  : Drive_Info_IC1_STATUS_Rx
 * Description    : 18EF1718 报文循环接收处理  50ms任务中执行
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Drive_Info_IC1_STATUS_Rx(void)
{
    uint32_t Temp = 0u;
    uint8_t Data_Sig = 0u;
    uint8_t Data_Type = 0u;

    Data_Sig = Get_ID_18EF1718_Sig_Response_Code();
    Data_Type = Get_ID_18EF1718_Sig_Data_Type();
    Temp = Get_ID_18EF1718_Sig_Date();

    switch (Data_Sig)
    {
    case 0x81:
        switch (Data_Type)
        {
        case 0x50:
            User_ECU.TripA_Fuel = Temp;
            break;
        case 0x51:
            User_ECU.TripA_Average_Speed = Temp;
            break;
        case 0x52:
            User_ECU.TripA_Fuel_Consume = Temp;
            break;
        case 0x53:
            User_ECU.TripA_Idling = Temp;
            break;
        case 0x54:
            User_ECU.TripA_Runing = Temp;
            break;
        case 0x60:
            User_ECU.TripB_Fuel = Temp;
            break;
        case 0x61:
            User_ECU.TripB_Average_Speed = Temp;
            break;
        case 0x62:
            User_ECU.TripB_Fuel_Consume = Temp;
            break;
        case 0x63:
            User_ECU.TripB_Idling = Temp;
            break;
        case 0x64:
            User_ECU.TripB_Runing = Temp;
            break;
        case 0x20:
            User_ECU.Engine_Oil = Temp;
            State_Flag.Engine_Oil_Time = 0u;
        case 0x22:
            User_ECU.Engine_Surplus = Temp;
            break;
        default:
            break;
        }
        break;
    case 0x40:
        switch (Data_Type)
        {
        case 0x50:
            User_ECU.TripA_Fuel = Temp;
            break;
        case 0x51:
            User_ECU.TripA_Average_Speed = Temp;
            break;
        case 0x52:
            User_ECU.TripA_Fuel_Consume = Temp;
            break;
        case 0x53:
            User_ECU.TripA_Idling = Temp;
            break;
        case 0x54:
            User_ECU.TripA_Runing = Temp;
            break;
        case 0x60:
            User_ECU.TripB_Fuel = Temp;
            break;
        case 0x61:
            User_ECU.TripB_Average_Speed = Temp;
            break;
        case 0x62:
            User_ECU.TripB_Fuel_Consume = Temp;
            break;
        case 0x63:
            User_ECU.TripB_Idling = Temp;
            break;
        case 0x64:
            User_ECU.TripB_Runing = Temp;
            break;
        case 0x20:
            User_ECU.Engine_Oil = Temp;
        case 0x22:
            User_ECU.Engine_Surplus = Temp;
            break;
        default:
            break;
        }
        break;
    default:
        break;
    }

    /*单报文掉线计时----针对"发动机油 ＆滤清器"此功能----20220718*/
    if (State_Flag.Engine_Oil_Time < 0xFFu)
    {
        State_Flag.Engine_Oil_Time++;
    }

    if (State_Flag.FState_COilTimeOut < FState_COilTimeOutNum)
    {
        State_Flag.FState_COilTimeOut++;
    }

    if (Data_Sig == 0x40u)
    {
        State_Flag.FState_ClearOilRx = 1;
    }
}

/*-------------------------------------------------------------------------
 * Function Name  : Drive_Info_IC3_STATUS_Rx
 * Description    : 50ms任务中执行
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Drive_Info_IC3_STATUS_Rx(void)
{
    if (bCurMenuIDX != _MN_DSP_LEVEL3_4_MENU_5)
    {
        if (TPMS_Matching.FLAG == 1)
            return;

        TPMS_Matching.T01 = 0u;
        TPMS_Matching.T02 = 0u;
        TPMS_Matching.T03 = 0u;
        TPMS_Matching.T04 = 0u;
        TPMS_Matching.T05 = 0u;
        TPMS_Matching.T06 = 0u;
        TPMS_Matching.T07 = 0u;
        TPMS_Matching.T08 = 0u;
        TPMS_Matching.T09 = 0u;
        TPMS_Matching.T10 = 0u;
        TPMS_Matching.T11 = 0u;
        TPMS_Matching.T12 = 0u;

        TPMS_Matching.FLAG = 1u;
    }

    if ((Msg_18021733[0] == 0x61) && (Common_Get_TPMS_TEST_OFF_Time_Sta() == 0))
    {
        TPMS_Matching.FLAG = 0;

        Msg_18021733[0] = 0;

        if ((User_set_Num.User_TpmsStatus == 2) && (Common_GetTXNum_18033317() >= 3u))
        {
            switch (User_set_Num.User_Tpms)
            {
            case 1:
                TPMS_Matching.T01 = 1;
                break;
            case 2:
                TPMS_Matching.T02 = 1;
                break;
            case 3:
                TPMS_Matching.T03 = 1;
                break;
            case 4:
                TPMS_Matching.T04 = 1;
                break;
            case 5:
                TPMS_Matching.T05 = 1;
                break;
            case 6:
                TPMS_Matching.T06 = 1;
                break;
            case 7:
                TPMS_Matching.T07 = 1;
                break;
            case 8:
                TPMS_Matching.T08 = 1;
                break;
            case 9:
                TPMS_Matching.T09 = 1;
                break;
            case 10:
                TPMS_Matching.T10 = 1;
                break;
            case 11:
                TPMS_Matching.T11 = 1;
                break;
            case 12:
                TPMS_Matching.T12 = 1;
                break;
            default:
                break;
            }

            User_set_Num.User_Tpms ++;

            if (User_set_Num.User_Tpms == 0x0Du)
            {
                User_set_Num.User_TpmsStatus = 0;
            }
            else
            {
                User_set_Num.User_TpmsStatus = 1;
            }
        }
    }
    else  if ((Msg_18021733[0]  == 0xFFu) && (Msg_18021733[1]  == 0x06u))
    {
        TPMS_Matching.FLAG = 0;

        Msg_18021733[0] = 0;
        Msg_18021733[1] = 0;
        User_set_Num.User_TpmsStatus = 1;
    }
    else if (Common_Get_TPMS_TEST_OFF_Time_Sta() == 1u)
    {
        TPMS_Matching.FLAG = 0;

        Msg_18021733[0] = 0;
        Msg_18021733[1] = 0;
        User_set_Num.User_TpmsStatus = 1;
    }
}

void MSG_18021733_REC_COPY(uint8_t copy[])
{
    uint8_t i = 0u;

    for (i = 0u; i < 8u; i++)
    {
        Msg_18021733[i] = copy[i];
    }
}
/*-------------------------------------------------------------------------
 * Function Name  : Common_Data_Get_TripA_Fuel
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint32_t Common_Data_Get_TripA_Fuel(void)
{
    return User_ECU.TripA_Fuel;
}

/*-------------------------------------------------------------------------
 * Function Name  : Common_Data_Get_TripA_Average_Speed
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint32_t Common_Data_Get_TripA_Average_Speed(void)
{
    return User_ECU.TripA_Average_Speed;
}

/*-------------------------------------------------------------------------
 * Function Name  : Common_Data_Get_TripB_Fuel
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint32_t Common_Data_Get_TripB_Fuel(void)
{
    return User_ECU.TripB_Fuel;
}

/*-------------------------------------------------------------------------
 * Function Name  : Common_Data_Get_TripB_Average_Speed
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint32_t Common_Data_Get_TripB_Average_Speed(void)
{
    return User_ECU.TripB_Average_Speed;
}

void Common_SetTXNum_18033317(void)
{
    TXNum_18033317 ++;
}

uint8_t Common_GetTXNum_18033317(void)
{
    return (uint8_t)TXNum_18033317;
}

/*-------------------------------------------------------------------------
 * Function Name  : Common_DTC_Server
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Common_DTCEngine_Server(void)
{
    static uint32_t CurFault[25];
    static uint32_t HisFault[25];
    uint8_t CurFaultNum = 0;
    uint8_t HisFaultNum = 0;
    uint8_t i = 0U;
    uint8_t j = 0u;

    GetAllDtcEngineFault(CurFault, &CurFaultNum, HisFault, &HisFaultNum);

    for (i = 0; i < CurFaultNum; i++)
    {
        DTCNumberEngine[i] = CurFault[i];
    }

    for (j = 0; j < HisFaultNum; j++)
    {
        DTCNumberEngine[i + j] = HisFault[j];
    }

    DisDTCNumEngine = CurFaultNum + HisFaultNum;
}
/*-------------------------------------------------------------------------
 * Function Name  : GetAllDtcFault
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void GetAllDtcEngineFault(uint32_t* pCurFault, uint8_t* pCurFaultNum, uint32_t* pHisFault, uint8_t* pHisFaultNum)
{

    uint8_t i = 0;
    uint8_t DtcCurFaultCn = 0;
    uint8_t DtcHisFaultCn = 0;
    uint32_t DtcFaultTmp = 0;

    for (i = 0; i < 25; i++)
    {
        DtcFaultTmp = DiagReciveDTCEngine.SubDTC.StructDTC[i];
        swap32(&DtcFaultTmp);
        if ((DtcFaultTmp & 0x01) == 0x01)    /*当前故障*/
        {
            pCurFault[DtcCurFaultCn] = DtcFaultTmp;
            DtcCurFaultCn++;
        }
        //if ((DtcFaultTmp & 0x21) == 0x20)   /*历史故障*/
        //{
        //    pHisFault[DtcHisFaultCn] = DtcFaultTmp;
        //    DtcHisFaultCn++;
        //}
    }
    *pCurFaultNum = DtcCurFaultCn;
    *pHisFaultNum = DtcHisFaultCn;
}

/*-------------------------------------------------------------------------
 * Function Name  : Common_DTC_Server
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Common_DTCBrake_Server(void)
{
    static uint32_t CurFault[25];
    static uint32_t HisFault[25];
    uint8_t CurFaultNum = 0;
    uint8_t HisFaultNum = 0;
    uint8_t i = 0U;
    uint8_t j = 0u;

    GetAllDtcBrakeFault(CurFault, &CurFaultNum, HisFault, &HisFaultNum);

    for (i = 0; i < CurFaultNum; i++)
    {
        DTCNumberBrake[i] = CurFault[i];
    }

    for (j = 0; j < HisFaultNum; j++)
    {
        DTCNumberBrake[i + j] = HisFault[j];
    }

    DisDTCNumBrake = CurFaultNum + HisFaultNum;
}
/*-------------------------------------------------------------------------
 * Function Name  : GetAllDtcFault
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void GetAllDtcBrakeFault(uint32_t* pCurFault, uint8_t* pCurFaultNum, uint32_t* pHisFault, uint8_t* pHisFaultNum)
{

    uint8_t i = 0;
    uint8_t DtcCurFaultCn = 0;
    uint8_t DtcHisFaultCn = 0;
    uint32_t DtcFaultTmp = 0;

    for (i = 0; i < 25; i++)
    {
        DtcFaultTmp = DiagReciveDTCBrake.SubDTC.StructDTC[i];
        swap32(&DtcFaultTmp);
        if ((DtcFaultTmp & 0x01) == 0x01)    /*当前故障*/
        {
            pCurFault[DtcCurFaultCn] = DtcFaultTmp;
            DtcCurFaultCn++;
        }
        //if ((DtcFaultTmp & 0x21) == 0x20)   /*历史故障*/
        //{
        //    pHisFault[DtcHisFaultCn] = DtcFaultTmp;
        //    DtcHisFaultCn++;
        //}
    }
    *pCurFaultNum = DtcCurFaultCn;
    *pHisFaultNum = DtcHisFaultCn;
}

/*-------------------------------------------------------------------------
 * Function Name  : Common_DTC_Server
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Common_DTCAMT_Server(void)
{
    static uint32_t CurFault[25];
    static uint32_t HisFault[25];
    uint8_t CurFaultNum = 0;
    uint8_t HisFaultNum = 0;
    uint8_t i = 0U;
    uint8_t j = 0u;

    GetAllDtcAMTFault(CurFault, &CurFaultNum, HisFault, &HisFaultNum);

    for (i = 0; i < CurFaultNum; i++)
    {
        DTCNumberAMT[i] = CurFault[i];
    }

    for (j = 0; j < HisFaultNum; j++)
    {
        DTCNumberAMT[i + j] = HisFault[j];
    }

    DisDTCNumAMT = CurFaultNum + HisFaultNum;
}
/*-------------------------------------------------------------------------
 * Function Name  : GetAllDtcFault
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void GetAllDtcAMTFault(uint32_t* pCurFault, uint8_t* pCurFaultNum, uint32_t* pHisFault, uint8_t* pHisFaultNum)
{
    uint8_t i = 0;
    uint8_t DtcCurFaultCn = 0;
    uint8_t DtcHisFaultCn = 0;
    uint32_t DtcFaultTmp = 0;

    for (i = 0; i < 25; i++)
    {
        DtcFaultTmp = DiagReciveDTCAMT.SubDTC.StructDTC[i];
        swap32(&DtcFaultTmp);
        if ((DtcFaultTmp & 0x01) == 0x01)    /*当前故障*/
        {
            pCurFault[DtcCurFaultCn] = DtcFaultTmp;
            DtcCurFaultCn++;
        }
        //if ((DtcFaultTmp & 0x21) == 0x20)   /*历史故障*/
        //{
        //    pHisFault[DtcHisFaultCn] = DtcFaultTmp;
        //    DtcHisFaultCn++;
        //}
    }
    *pCurFaultNum = DtcCurFaultCn;
    *pHisFaultNum = DtcHisFaultCn;
}

/*-------------------------------------------------------------------------
 * Function Name  : Common_DTC_Server
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Common_DTCRadar_Server(void)
{
    static uint32_t CurFault[25];
    static uint32_t HisFault[25];
    uint8_t CurFaultNum = 0;
    uint8_t HisFaultNum = 0;
    uint8_t i = 0U;
    uint8_t j = 0u;

    GetAllDtcRadarFault(CurFault, &CurFaultNum, HisFault, &HisFaultNum);

    for (i = 0; i < CurFaultNum; i++)
    {
        DTCNumberRadar[i] = CurFault[i];
    }

    for (j = 0; j < HisFaultNum; j++)
    {
        DTCNumberRadar[i + j] = HisFault[j];
    }

    DisDTCNumRadar = CurFaultNum + HisFaultNum;
}
/*-------------------------------------------------------------------------
 * Function Name  : GetAllDtcFault
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void GetAllDtcRadarFault(uint32_t* pCurFault, uint8_t* pCurFaultNum, uint32_t* pHisFault, uint8_t* pHisFaultNum)
{

    uint8_t i = 0;
    uint8_t DtcCurFaultCn = 0;
    uint8_t DtcHisFaultCn = 0;
    uint32_t DtcFaultTmp = 0;

    for (i = 0; i < 25; i++)
    {
        DtcFaultTmp = DiagReciveDTCRadar.SubDTC.StructDTC[i];
        swap32(&DtcFaultTmp);
        if ((DtcFaultTmp & 0x01) == 0x01)    /*当前故障*/
        {
            pCurFault[DtcCurFaultCn] = DtcFaultTmp;
            DtcCurFaultCn++;
        }
        //if ((DtcFaultTmp & 0x21) == 0x20)   /*历史故障*/
        //{
        //    pHisFault[DtcHisFaultCn] = DtcFaultTmp;
        //    DtcHisFaultCn++;
        //}
    }
    *pCurFaultNum = DtcCurFaultCn;
    *pHisFaultNum = DtcHisFaultCn;
}

/*-------------------------------------------------------------------------
 * Function Name  : Common_DTC_Server
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Common_DTCCamera_Server(void)
{
    static uint32_t CurFault[25];
    static uint32_t HisFault[25];
    uint8_t CurFaultNum = 0;
    uint8_t HisFaultNum = 0;
    uint8_t i = 0U;
    uint8_t j = 0u;

    GetAllDtcCameraFault(CurFault, &CurFaultNum, HisFault, &HisFaultNum);

    for (i = 0; i < CurFaultNum; i++)
    {
        DTCNumberCamera[i] = CurFault[i];
    }

    for (j = 0; j < HisFaultNum; j++)
    {
        DTCNumberCamera[i + j] = HisFault[j];
    }

    DisDTCNumCamera = CurFaultNum + HisFaultNum;
}

/*-------------------------------------------------------------------------
 * Function Name  : GetAllDtcFault
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void GetAllDtcCameraFault(uint32_t* pCurFault, uint8_t* pCurFaultNum, uint32_t* pHisFault, uint8_t* pHisFaultNum)
{

    uint8_t i = 0;
    uint8_t DtcCurFaultCn = 0;
    uint8_t DtcHisFaultCn = 0;
    uint32_t DtcFaultTmp = 0;

    for (i = 0; i < 25; i++)
    {
        DtcFaultTmp = DiagReciveDTCCamera.SubDTC.StructDTC[i];
        swap32(&DtcFaultTmp);
        if ((DtcFaultTmp & 0x01) == 0x01)    /*当前故障*/
        {
            pCurFault[DtcCurFaultCn] = DtcFaultTmp;
            DtcCurFaultCn++;
        }
        //if ((DtcFaultTmp & 0x21) == 0x20)   /*历史故障*/
        //{
        //    pHisFault[DtcHisFaultCn] = DtcFaultTmp;
        //    DtcHisFaultCn++;
        //}
    }
    *pCurFaultNum = DtcCurFaultCn;
    *pHisFaultNum = DtcHisFaultCn;
}
/*-------------------------------------------------------------------------
 * Function Name  : Common_DTC_Server
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Common_DTCRetarder_Server(void)
{
    static uint32_t CurFault[25];
    static uint32_t HisFault[25];
    uint8_t CurFaultNum = 0;
    uint8_t HisFaultNum = 0;
    uint8_t i = 0U;
    uint8_t j = 0u;

    GetAllDtcRetarderFault(CurFault, &CurFaultNum, HisFault, &HisFaultNum);

    for (i = 0; i < CurFaultNum; i++)
    {
        DTCNumberRetarder[i] = CurFault[i];
    }

    for (j = 0; j < HisFaultNum; j++)
    {
        DTCNumberRetarder[i + j] = HisFault[j];
    }

    DisDTCNumRetarder = CurFaultNum + HisFaultNum;
}
/*-------------------------------------------------------------------------
 * Function Name  : GetAllDtcFault
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void GetAllDtcRetarderFault(uint32_t* pCurFault, uint8_t* pCurFaultNum, uint32_t* pHisFault, uint8_t* pHisFaultNum)
{

    uint8_t i = 0;
    uint8_t DtcCurFaultCn = 0;
    uint8_t DtcHisFaultCn = 0;
    uint32_t DtcFaultTmp = 0;

    for (i = 0; i < 25; i++)
    {
        DtcFaultTmp = DiagReciveDTCRetarder.SubDTC.StructDTC[i];
        swap32(&DtcFaultTmp);
        if ((DtcFaultTmp & 0x01) == 0x01)    /*当前故障*/
        {
            pCurFault[DtcCurFaultCn] = DtcFaultTmp;
            DtcCurFaultCn++;
        }
        //if ((DtcFaultTmp & 0x21) == 0x20)   /*历史故障*/
        //{
        //    pHisFault[DtcHisFaultCn] = DtcFaultTmp;
        //    DtcHisFaultCn++;
        //}
    }
    *pCurFaultNum = DtcCurFaultCn;
    *pHisFaultNum = DtcHisFaultCn;
}

/*-------------------------------------------------------------------------
 * Function Name  : GetAllDtcFault
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
--------------------------------------------------------------------------*/
void swap32(uint32_t *DwData)
{
    uint8_t *ptmp = (uint8_t *)DwData;
    ptmp[0] ^= ptmp[3];
    ptmp[3] ^= ptmp[0];
    ptmp[0] ^= ptmp[3];

    ptmp[1] ^= ptmp[2];
    ptmp[2] ^= ptmp[1];
    ptmp[1] ^= ptmp[2];
}


/*-------------------------------------------------------------------------
 * Function Name  : DoCAN_Get_Multi_frame00_Recv
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
--------------------------------------------------------------------------*/
void DoCAN_Get_Multi_frame00_Recv(void)
{
    uint8_t i = 0u;;
    uint8_t PRIO = 0u;
    uint16_t PGN = 0u;

    uint8_t CanStatus ;

    PRIO = Get_ID_18ECFF00_Sig_PRIO();
    /*数据头*/
    if (PRIO != 0x20u)
    {
        return ;
    }

    /*判断PGN*/
    PGN = Get_ID_18ECFF00_Sig_PGN();
    if (PGN == 0xFECAu)
    {
        ECM18EBFF00.bPackage = Get_ID_18ECFF00_Sig_FRAME_NUM();     /*包个数*/
        ECM18EBFF00.bLength  = Get_ID_18ECFF00_Sig_DATA_NUM();      /*数据个数*/

        CanStatus = CAN_MSG_Status(ID_CanMsg18ECFF00_Msg_Count);

        /*存储*/
        if (
            (ECM18EBFF00.bPrePckNum < ECM18EBFF00.bPackage) &&
            (Get_ID_18EBFF00_Sig_DATA(0u) == (ECM18EBFF00.bPrePckNum + 1))
        )
        {
            for (i = 1 ; i < 8; i++)
            {
                ECM18EBFF00.DataDTC.UnionDTC[ECM18EBFF00.bCtrByte++] = Get_ID_18EBFF00_Sig_DATA(i);
            }
            ECM18EBFF00.bPrePckNum ++;
            ECM18EBFF00.bRcvBusy = 1;    /*正在接收*/
        }

        /*存储后清空各个标识*/
        if ( ECM18EBFF00.bPrePckNum == ECM18EBFF00.bPackage)
        {
            ECM18EBFF00.bRcvBusy = 2;     /*接收完成*/
            ECM18EBFF00.bPrePckNum = 0;
            ECM18EBFF00.bCtrByte  = 0;
        }
    }
}

/*-------------------------------------------------------------------------
 * Function Name  : DoCAN_Get_Multi_frame03_Recv
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
--------------------------------------------------------------------------*/
void DoCAN_Get_Multi_frame03_Recv(void)
{
    uint8_t i = 0u;;
    uint8_t PRIO = 0u;
    uint16_t PGN = 0u;

    uint8_t CanStatus ;

    PRIO = Get_ID_18ECFF03_Sig_PRIO();
    /*数据头*/
    if (PRIO != 0x20u)
    {
        return ;
    }

    /*判断PGN*/
    PGN = Get_ID_18ECFF03_Sig_PGN();
    if (PGN == 0xFECAu)
    {
        ECM18EBFF03.bPackage = Get_ID_18ECFF03_Sig_FRAME_NUM();     /*包个数*/
        ECM18EBFF03.bLength  = Get_ID_18ECFF03_Sig_DATA_NUM();      /*数据个数*/

        CanStatus = CAN_MSG_Status(ID_CanMsg18ECFF03_Msg_Count);

        /*存储*/
        if (
            (ECM18EBFF03.bPrePckNum < ECM18EBFF03.bPackage) &&
            (Get_ID_18EBFF03_Sig_DATA(0u) == (ECM18EBFF03.bPrePckNum + 1))
        )
        {
            for (i = 1 ; i < 8; i++)
            {
                ECM18EBFF03.DataDTC.UnionDTC[ECM18EBFF03.bCtrByte++] = Get_ID_18EBFF03_Sig_DATA(i);
            }
            ECM18EBFF03.bPrePckNum ++;
            ECM18EBFF03.bRcvBusy = 1;    /*正在接收*/
        }

        /*存储后清空各个标识*/
        if ( ECM18EBFF03.bPrePckNum == ECM18EBFF03.bPackage)
        {
            ECM18EBFF03.bRcvBusy = 2;     /*接收完成*/
            ECM18EBFF03.bPrePckNum = 0;
            ECM18EBFF03.bCtrByte  = 0;
        }
    }
}

/*-------------------------------------------------------------------------
 * Function Name  : DoCAN_Get_Multi_frame0B_Recv
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
--------------------------------------------------------------------------*/
void DoCAN_Get_Multi_frame0B_Recv(void)
{
    uint8_t i = 0u;;
    uint8_t PRIO = 0u;
    uint16_t PGN = 0u;

    uint8_t CanStatus ;

    PRIO = Get_ID_18ECFF0B_Sig_PRIO();
    /*数据头*/
    if (PRIO != 0x20u)
    {
        return ;
    }

    /*判断PGN*/
    PGN = Get_ID_18ECFF0B_Sig_PGN();
    if (PGN == 0xFECAu)
    {
        ECM18EBFF0B.bPackage = Get_ID_18ECFF0B_Sig_FRAME_NUM();     /*包个数*/
        ECM18EBFF0B.bLength  = Get_ID_18ECFF0B_Sig_DATA_NUM();      /*数据个数*/

        CanStatus = CAN_MSG_Status(ID_CanMsg18ECFF0B_Msg_Count);

        /*存储*/
        if (
            (ECM18EBFF0B.bPrePckNum < ECM18EBFF0B.bPackage) &&
            (Get_ID_18EBFF0B_Sig_DATA(0u) == (ECM18EBFF0B.bPrePckNum + 1))
        )
        {
            for (i = 1 ; i < 8; i++)
            {
                ECM18EBFF0B.DataDTC.UnionDTC[ECM18EBFF0B.bCtrByte++] = Get_ID_18EBFF0B_Sig_DATA(i);
            }
            ECM18EBFF0B.bPrePckNum ++;
            ECM18EBFF0B.bRcvBusy = 1;    /*正在接收*/
        }
        /*存储后清空各个标识*/
        if ( ECM18EBFF0B.bPrePckNum == ECM18EBFF0B.bPackage)
        {
            ECM18EBFF0B.bRcvBusy = 2;     /*接收完成*/
            ECM18EBFF0B.bPrePckNum = 0;
            ECM18EBFF0B.bCtrByte  = 0;
        }
    }
}

/*-------------------------------------------------------------------------
 * Function Name  : DoCAN_Get_Multi_frame10_Recv
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
--------------------------------------------------------------------------*/
void DoCAN_Get_Multi_frame10_Recv(void)
{
    uint8_t i = 0u;;
    uint8_t PRIO = 0u;
    uint16_t PGN = 0u;

    uint8_t CanStatus ;

    PRIO = Get_ID_18ECFF10_Sig_PRIO();
    /*数据头*/
    if (PRIO != 0x20u)
    {
        return ;
    }
    /*判断PGN*/
    PGN = Get_ID_18ECFF10_Sig_PGN();
    if (PGN == 0xFECAu)
    {
        ECM18EBFF10.bPackage = Get_ID_18ECFF10_Sig_FRAME_NUM();     /*包个数*/
        ECM18EBFF10.bLength  = Get_ID_18ECFF10_Sig_DATA_NUM();      /*数据个数*/

        CanStatus = CAN_MSG_Status(ID_CanMsg18ECFF10_Msg_Count);

        /*存储*/
        if (
            (ECM18EBFF10.bPrePckNum < ECM18EBFF10.bPackage) &&
            (Get_ID_18EBFF10_Sig_DATA(0u) == (ECM18EBFF10.bPrePckNum + 1))
        )
        {
            for (i = 1 ; i < 8; i++)
            {
                ECM18EBFF10.DataDTC.UnionDTC[ECM18EBFF10.bCtrByte++] = Get_ID_18EBFF10_Sig_DATA(i);
            }
            ECM18EBFF10.bPrePckNum ++;
            ECM18EBFF10.bRcvBusy = 1;    /*正在接收*/
        }
        /*存储后清空各个标识*/
        if ( ECM18EBFF10.bPrePckNum == ECM18EBFF10.bPackage)
        {
            ECM18EBFF10.bRcvBusy = 2;     /*接收完成*/
            ECM18EBFF10.bPrePckNum = 0;
            ECM18EBFF10.bCtrByte  = 0;
        }
    }
}

/*-------------------------------------------------------------------------
 * Function Name  : DoCAN_Get_Multi_frameA0_Recv
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
--------------------------------------------------------------------------*/
void DoCAN_Get_Multi_frameA0_Recv(void)
{
    uint8_t i = 0u;;
    uint8_t PRIO = 0u;
    uint16_t PGN = 0u;

    uint8_t CanStatus ;

    PRIO = Get_ID_18ECFFA0_Sig_PRIO();
    /*数据头*/
    if (PRIO != 0x20u)
    {
        return ;
    }
    /*判断PGN*/
    PGN = Get_ID_18ECFFA0_Sig_PGN();
    if (PGN == 0xFECAu)
    {
        ECM18EBFFA0.bPackage = Get_ID_18ECFFA0_Sig_FRAME_NUM();     /*包个数*/
        ECM18EBFFA0.bLength  = Get_ID_18ECFFA0_Sig_DATA_NUM();      /*数据个数*/

        CanStatus = CAN_MSG_Status(ID_CanMsg18ECFFA0_Msg_Count);

        /*存储*/
        if (
            (ECM18EBFFA0.bPrePckNum < ECM18EBFFA0.bPackage) &&
            (Get_ID_18EBFFA0_Sig_DATA(0u) == (ECM18EBFFA0.bPrePckNum + 1))
        )
        {
            for (i = 1 ; i < 8; i++)
            {
                ECM18EBFFA0.DataDTC.UnionDTC[ECM18EBFFA0.bCtrByte++] = Get_ID_18EBFFA0_Sig_DATA(i);
            }
            ECM18EBFFA0.bPrePckNum ++;
            ECM18EBFFA0.bRcvBusy = 1;    /*正在接收*/
        }
        /*存储后清空各个标识*/
        if ( ECM18EBFFA0.bPrePckNum == ECM18EBFFA0.bPackage)
        {
            ECM18EBFFA0.bRcvBusy = 2;     /*接收完成*/
            ECM18EBFFA0.bPrePckNum = 0;
            ECM18EBFFA0.bCtrByte  = 0;
        }
    }
}

/*-------------------------------------------------------------------------
 * Function Name  : DoCAN_Get_Multi_frameE8_Recv
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
--------------------------------------------------------------------------*/
void DoCAN_Get_Multi_frameE8_Recv(void)
{
    uint8_t i = 0u;;
    uint8_t PRIO = 0u;
    uint16_t PGN = 0u;

    uint8_t CanStatus ;

    PRIO = Get_ID_18ECFFE8_Sig_PRIO();
    /*数据头*/
    if (PRIO != 0x20u)
    {
        return ;
    }
    /*判断PGN*/
    PGN = Get_ID_18ECFFE8_Sig_PGN();
    if (PGN == 0xFECAu)
    {
        ECM18EBFFE8.bPackage = Get_ID_18ECFFE8_Sig_FRAME_NUM();     /*包个数*/
        ECM18EBFFE8.bLength  = Get_ID_18ECFFE8_Sig_DATA_NUM();      /*数据个数*/

        CanStatus = CAN_MSG_Status(ID_CanMsg18ECFFE8_Msg_Count);

        /*存储*/
        if (
            (ECM18EBFFE8.bPrePckNum < ECM18EBFFE8.bPackage) &&
            (Get_ID_18EBFFE8_Sig_DATA(0u) == (ECM18EBFFE8.bPrePckNum + 1))
        )
        {
            for (i = 1 ; i < 8; i++)
            {
                ECM18EBFFE8.DataDTC.UnionDTC[ECM18EBFFE8.bCtrByte++] = Get_ID_18EBFFE8_Sig_DATA(i);
            }
            ECM18EBFFE8.bPrePckNum ++;
            ECM18EBFFE8.bRcvBusy = 1;    /*正在接收*/
        }
        /*存储后清空各个标识*/
        if ( ECM18EBFFE8.bPrePckNum == ECM18EBFFE8.bPackage)
        {
            ECM18EBFFE8.bRcvBusy = 2;     /*接收完成*/
            ECM18EBFFE8.bPrePckNum = 0;
            ECM18EBFFE8.bCtrByte  = 0;
        }
    }
}
