/******************************************************************************
�� �� ����Simulated_IIC_Master.c
����������IO�˿�ģ���IIC(I2C)�����������ļ�
��    �ߣ�����
��    ����V1.0
��    �ڣ�2016.12.21
******************************************************************************/

#include "Simulated_IIC_2_Master.h"
#include "rh850_macros.h"

uint8_t u8SimulatedIIC2ReceivedACK;

/******************************************************************************
��������IIC_Init
��  �ܣ���ʼ��IIC����
��  ������
����ֵ����
******************************************************************************/
void Simulated_IIC_2_Init(void)
{
    SIMULATED_IIC_2_SCL_DIR = GPIO_DIR_IN; //SCL������Ϊ����,IO��Ϊ����״̬,������SCL�ź���������������,��ʱSCL = 1
    Simulated_IIC_2_Delay();
    Simulated_IIC_2_Delay();

    SIMULATED_IIC_2_SDA_DIR = GPIO_DIR_IN; //SDA������Ϊ����,IO��Ϊ����״̬,������SDA�ź���������������,��ʱSDA = 1
    Simulated_IIC_2_Delay();
    Simulated_IIC_2_Delay();

    u8SimulatedIIC2ReceivedACK = SIMULATED_IIC_2_INVALID_ACK;
    
}

/******************************************************************************
��������IIC_Start
��  �ܣ���IIC�����Ϸ�����ʼ�ź�,����һ��IICͨ��
��  ������
����ֵ����
******************************************************************************/
void Simulated_IIC_2_Start(void)
{
    
    u8SimulatedIIC2ReceivedACK = SIMULATED_IIC_2_INVALID_ACK;

    SIMULATED_IIC_2_SDA_DIR = GPIO_DIR_IN; //SDA������Ϊ����,IO��Ϊ����״̬,������SDA�ź���������������,��ʱSDA = 1
    Simulated_IIC_2_Delay();
    Simulated_IIC_2_Delay();

    SIMULATED_IIC_2_SCL_DIR = GPIO_DIR_IN; //SCL������Ϊ����,IO��Ϊ����״̬,������SCL�ź���������������,��ʱSCL = 1
    Simulated_IIC_2_Delay();
    Simulated_IIC_2_Delay();

    SIMULATED_IIC_2_SDA_DIR = GPIO_DIR_OUT; //SDA���0,��ʱSDA = 0
    SIMULATED_IIC_2_OUT_SDA = 0;
    Simulated_IIC_2_Delay();
    Simulated_IIC_2_Delay();

    SIMULATED_IIC_2_SCL_DIR = GPIO_DIR_OUT; //SCL���0,��ʱSCL = 0
    SIMULATED_IIC_2_SCL = 0;
    Simulated_IIC_2_Delay();
    
}

/******************************************************************************
��������IIC_Stop
��  �ܣ���IIC�����Ϸ���ֹͣ�ź�,��ֹ��ǰIICͨ��
��  ������
����ֵ����
******************************************************************************/
void Simulated_IIC_2_Stop(void)
{
    
    u8SimulatedIIC2ReceivedACK = SIMULATED_IIC_2_INVALID_ACK;

    SIMULATED_IIC_2_SDA_DIR = GPIO_DIR_OUT; //SDA���0,��ʱSDA = 0
    SIMULATED_IIC_2_OUT_SDA = 0;
    Simulated_IIC_2_Delay();
    Simulated_IIC_2_Delay();

    SIMULATED_IIC_2_SCL_DIR = GPIO_DIR_IN; //SCL������Ϊ����,IO��Ϊ����״̬,������SCL�ź���������������,��ʱSCL = 1
    Simulated_IIC_2_Delay();
    Simulated_IIC_2_Delay();

    SIMULATED_IIC_2_SDA_DIR = GPIO_DIR_IN; //SDA������Ϊ����,IO��Ϊ����״̬,������SDA�ź���������������,��ʱSDA = 1
    Simulated_IIC_2_Delay();
    Simulated_IIC_2_Delay();
    
}

/******************************************************************************
��������IIC_Transmit_Data
��  �ܣ���IIC�����Ϸ���1�ֽ�����
��  ����Data�����͵�����
����ֵ��������������ȷ��(ACK)  0 - ACK  1 - NAK
******************************************************************************/
void Simulated_IIC_2_Transmit_Data(uint8_t Data)
{
    
    uint8_t i;

    u8SimulatedIIC2ReceivedACK = SIMULATED_IIC_2_INVALID_ACK;

    for (i = 0; i < 8; i++)
    {
        if (Data & 0x80)
            SIMULATED_IIC_2_SDA_DIR = GPIO_DIR_IN; //SDA������Ϊ����,IO��Ϊ����״̬,������SDA�ź���������������,��ʱSDA = 1
        else
        {
            SIMULATED_IIC_2_SDA_DIR = GPIO_DIR_OUT; //SDA���0,��ʱSDA = 0
            SIMULATED_IIC_2_OUT_SDA = 0;
        }
        Simulated_IIC_2_Delay();
        Simulated_IIC_2_Delay();

        SIMULATED_IIC_2_SCL_DIR = GPIO_DIR_IN; //SCL������Ϊ����,IO��Ϊ����״̬,������SCL�ź���������������,��ʱSCL = 1
        Simulated_IIC_2_Delay();
        Simulated_IIC_2_Delay();

        SIMULATED_IIC_2_SCL_DIR = GPIO_DIR_OUT; //SCL���0,��ʱSCL = 0
        SIMULATED_IIC_2_SCL = 0;
        Simulated_IIC_2_Delay();

        Data <<= 1;
    }

    SIMULATED_IIC_2_SDA_DIR = GPIO_DIR_IN; //����SDAΪ����״̬
    Simulated_IIC_2_Delay();
    Simulated_IIC_2_Delay();

    SIMULATED_IIC_2_SCL_DIR = GPIO_DIR_IN; //SCL������Ϊ����,IO��Ϊ����״̬,������SCL�ź���������������,��ʱSCL = 1
    Simulated_IIC_2_Delay();
    Simulated_IIC_2_Delay();

    u8SimulatedIIC2ReceivedACK = SIMULATED_IIC_2_IN_SDA;

    SIMULATED_IIC_2_SCL_DIR = GPIO_DIR_OUT; //SCL���0,��ʱSCL = 0
    SIMULATED_IIC_2_SCL = 0;
    Simulated_IIC_2_Delay();
    
}

/******************************************************************************
��������IIC_Receive_Data
��  �ܣ���IIC�����Ͻ���1�ֽ�����
��  ������
����ֵ�����յ�������
******************************************************************************/
uint8_t Simulated_IIC_2_Receive_Data(void)
{
    
    uint8_t i;
    uint8_t Data;

    Data = 0;

    SIMULATED_IIC_2_SDA_DIR = GPIO_DIR_IN; //����SDAΪ����״̬
    Simulated_IIC_2_Delay();
    Simulated_IIC_2_Delay();

    for (i = 0; i < 8; i++)
    {
        Data <<= 1;

        SIMULATED_IIC_2_SCL_DIR = GPIO_DIR_IN; //SCL������Ϊ����,IO��Ϊ����״̬,������SCL�ź���������������,��ʱSCL = 1
        Simulated_IIC_2_Delay();
        Simulated_IIC_2_Delay();
        Simulated_IIC_2_Delay();

        Data |= SIMULATED_IIC_2_IN_SDA;

        SIMULATED_IIC_2_SCL_DIR = GPIO_DIR_OUT; //SCL���0,��ʱSCL = 0
        SIMULATED_IIC_2_SCL = 0;
        Simulated_IIC_2_Delay();
        Simulated_IIC_2_Delay();
    }

    return Data;
    
}

/******************************************************************************
��������IIC_Transmit_ACK
��  �ܣ���IIC�����Ϸ���ȷ���ź�
��  ����ACK��ȷ���źŵ����ͣ� SIMULATED_IIC_2_ACK  �϶�Ӧ��
                              IIC_NAK  ��Ӧ��
����ֵ����
******************************************************************************/
void Simulated_IIC_2_Transmit_ACK(uint8_t ACK)
{
    
    u8SimulatedIIC2ReceivedACK = SIMULATED_IIC_2_INVALID_ACK;

    if (ACK > SIMULATED_IIC_2_NAK)
        return;

    if (ACK)
        SIMULATED_IIC_2_SDA_DIR = GPIO_DIR_IN; //SDA������Ϊ����,IO��Ϊ����״̬,������SDA�ź���������������,��ʱSDA = 1
    else
    {
        SIMULATED_IIC_2_SDA_DIR = GPIO_DIR_OUT; //SDA���0,��ʱSDA = 0
        SIMULATED_IIC_2_OUT_SDA = 0;
    }
    Simulated_IIC_2_Delay();

    SIMULATED_IIC_2_SCL_DIR = GPIO_DIR_IN; //SCL������Ϊ����,IO��Ϊ����״̬,������SCL�ź���������������,��ʱSCL = 1
    Simulated_IIC_2_Delay();
    Simulated_IIC_2_Delay();

    SIMULATED_IIC_2_SCL_DIR = GPIO_DIR_OUT; //SCL���0,��ʱSCL = 0
    SIMULATED_IIC_2_SCL = 0;
    Simulated_IIC_2_Delay();
    
}

/******************************************************************************
��������IIC_Receive_ACK
��  �ܣ���ȡ�������Ͻ��յ���ȷ���ź�
��  ������
����ֵ��������������ȷ���ź����ͣ�Simulated_IIC_ACK        �϶�Ӧ��
                                  SIMULATED_IIC_2_NAK         ��Ӧ��
                                  IIC_INVALID_ACK ��Ч��Ӧ���ź�(Ӧ���źŻ�δ�յ�)
******************************************************************************/
uint8_t Simulated_IIC_2_Receive_ACK(void)
{
    
    uint8_t ACK;

    ACK = u8SimulatedIIC2ReceivedACK;
    u8SimulatedIIC2ReceivedACK = SIMULATED_IIC_2_INVALID_ACK;

    return ACK;
    
}

/******************************************************************************
��������IIC_Delay
��  �ܣ���ʱ5us,�����շ������е�ʱ�����
        ע�⣺�������IIC_5us_DELAY_CALIBRATION����У׼��ʱʱ����5us����
��  ����ACK��ȷ���źŵ�����  0 - ACK  1 - NAK
����ֵ����
******************************************************************************/
void Simulated_IIC_2_Delay(void)
{
    
    uint8_t i;

    for (i = 0; i < SIMULATED_IIC_2_FREQ_CALIBRATION; i++)
        nop();
        
}
