#ifndef _SERVICE_TPMS_H_
#define _SERVICE_TPMS_H_

#include "TYW_stdint.h"

#define FirstLOutID 0x12u
#define FirstROutID 0x13u
#define SecondLInID 0x22u
#define SecondRInID 0x23u
#define ThirdLOutID 0x31u
#define ThirdLInID 0x32u
#define ThirdRInID 0x33u
#define ThirdROutID 0x34u
#define FourthLOutID 0x41u
#define FourthLInID 0x42u
#define FourthRInID 0x43u
#define FourthROutID 0x44u

#define TYRETEMP_OFFSET_VALUE (128u) /*胎温数据偏移量*/

typedef enum
{
    FirstLOut = 0,
    FirstROut,
    SecondLIn,
    SecondRIn,
    ThirdLOut,
    ThirdLIn,
    ThirdRIn,
    ThirdROut,
    FourthLOut,
    FourthLIn,
    FourthRIn,
    FourthROut,

    TPMSNumMax,
} TPMSNUM_t;

typedef struct
{
    uint8_t TPMSTyreID;                     /*轮胎位置*/
    uint16_t TPMSPressure;                  /*轮胎气压*/
    uint8_t TPMSTempSign;                   /*轮胎温度正负*/
    uint8_t TPMSTemp;                       /*轮胎温度*/
    uint8_t TPMSLowpressure;                /*低气压报警*/
    uint8_t TPMSHighpressure;               /*高气压报警*/
    uint8_t TPMSHightemperature;            /*高温报警*/
    uint8_t TPMSRapidleakage;               /*快速漏气报警*/
    uint8_t TPMSLowvoltage;                 /*低电压报警*/
    uint8_t TPMSNosignal;                   /*无信号报警*/
    uint8_t TPMSDataupdating;               /*数据更新*/
    uint8_t TPMSDatainvalid;                /*数据无效*/
    uint8_t TPMSSensorfault;                /*传感器故障信息*/
    uint16_t TPMSDataInvalidTime;           /*数据无效计时器*/
} _USER_TPMS;

extern _USER_TPMS TPMS_Out[TPMSNumMax];

void Data_TPMS_KL30_Init(void);
void Data_TPMS_KL15_ON_Init(void);

void Get_Data_TPMS_Value(TPMSNUM_t TPMSTyreID);
void Get_Data_TPMS_Status(TPMSNUM_t TPMSTyreID);
void Get_Data_TPMS_Pair(TPMSNUM_t TPMSTyreID);

void Data_TPMS_Value_Processing(void);

uint16_t Get_DataTPMS_Pressure_Value(TPMSNUM_t TPMSTyreID);
uint16_t Get_DataTPMS_Pressure_Sta(TPMSNUM_t TPMSTyreID);
uint8_t Get_DataTPMS_Pressure_FLashSta(TPMSNUM_t TPMSTyreID);

uint16_t Get_DataTPMS_Temp_Value(TPMSNUM_t TPMSTyreID);
uint16_t Get_DataTPMS_Temp_Sta(TPMSNUM_t TPMSTyreID);
uint8_t Get_DataTPMS_Temp_FLashSta(TPMSNUM_t TPMSTyreID);

uint16_t Get_DataTPMS_Leakrate_Value(TPMSNUM_t TPMSTyreID);
uint8_t Get_DataTPMS_SensorErrorWarningSig_Value(TPMSNUM_t TPMSTyreID);

uint8_t Get_DataTPMS_TireStandarPressureSettingSts_Value(TPMSNUM_t TPMSTyreID);
uint8_t Get_DataTPMS_RapidLeakWarningSig_Value(TPMSNUM_t TPMSTyreID);
uint8_t Get_TPMSLowvoltage_Sta(TPMSNUM_t TPMSTyreID);
uint8_t Get_TPMSHigTemp_Sta(TPMSNUM_t TPMSTyreID);

uint8_t Get_TPMSLowpressure_Sta(TPMSNUM_t TPMSTyreID);
uint8_t Get_TPMSHighpressure_Sta(TPMSNUM_t TPMSTyreID);
uint8_t Get_TPMSNosignal_Sta(TPMSNUM_t TPMSTyreID);
uint8_t Get_TPMSPresure_Alarm(TPMSNUM_t TPMSTyreID);

uint8_t Get_DataTPMS_Tyre_Red_Sta(TPMSNUM_t TPMSTyreID);
uint8_t Get_DataTPMS_Tyre_FLASH_Sta(TPMSNUM_t TPMSTyreID);


uint8_t Get_TPMSLow_Presure_Sta(void);
uint8_t Get_TPMSHigh_Presure_Sta(void);
uint8_t Get_TPMSHigh_Temperature_Sta(void);
uint8_t Get_TPMSFast_air_leakage (void);
uint8_t Get_TPMSLow_Voltage_Sta(void);
uint8_t Get_TPMSNo_signal_Sta(void);
uint8_t Get_TPMSSensor_fault_Sta(void);

#endif