
#ifndef _POPUP_MESSAGE_LIST_H_
#define _POPUP_MESSAGE_LIST_H_

#include "TYW_stdint.h"

/******************************************************************************
报警文字消息名称列表
******************************************************************************/
enum PopupMessageName
{
    POPUP1_MSG_BRAKE_BLACK          = 0           ,
    POPUP1_MSG_BRAKE_BRAKE                        ,
    POPUP1_MSG_BRAKE_SPACING_R                    ,
    POPUP1_MSG_BRAKE_SPACING_COLLISION            ,
    POPUP1_MSG_BRAKE_SPACING_Y                    ,
    POPUT1_MSG_ASR_OPERATE                        ,
    POPUT2_MSG_PTO                                ,
    POPUP2_MSG_PARKING_BRAKE                      ,
    POPUP2_MSG_AIRMATIC_HIGHT                     ,
    POPUP3_MSG_CRUISE                             ,
    POPUP3_MSG_VARIABLE_SLD                       ,
    POPUT4_MSG_ABNORMAL_CHARGE                    ,
    POPUP4_MSG_OIL_PRESSURE                       ,
    POPUP4_MSG_AMT_INIT_EXCE                      ,
    POPUP4_MSG_ADBLUE_QUALITY                     ,
    POPUP4_MSG_ADBLUE_SPRAY                       ,
    POPUP4_MSG_ADBLUE_SUPPLY                      ,
    POPUP4_MSG_START_ENG                          ,
    POPUP4_MSG_DPD_AUTO                           ,
    POPUP5_MSG_OVER_HEAT_SPEED                    ,
    POPUP5_MSG_OVER_HEAT                          ,
    POPUP5_MSG_LOW_COOLANT_SPEED                  ,
    POPUP5_MSG_LOW_COOLANT                        ,
    POPUP5_MSG_ENGINE_OIL_PRESSURE_SPEED          ,
    POPUP5_MSG_ENGINE_OIL_PRESSURE                ,
    POPUP5_MSG_METER_FAILURE_SPEED                ,
    POPUP5_MSG_METER_FAILURE                      ,
    POPUP5_MSG_CAN_ERROR_SPEED                    ,
    POPUP5_MSG_CAN_ERROR                          ,
    POPUP5_MSG_SPEED_LIMIT_SPEED                  ,
    POPUP5_MSG_SPEED_LIMIT                        ,
    POPUP5_MSG_TORQUE_REDUCTION_SPEED             ,
    POPUP5_MSG_TORQUE_REDUCTION                   ,
    POPUP5_MSG_SPEED_TORQUE                       ,
    POPUP5_MSG_INCORRECT_ADBLUE_SPEED             ,
    POPUP5_MSG_INCORRECT_ADBLUE                   ,
    POPUP5_MSG_CRITICAL_EMISSION_SPEED            ,
    POPUP5_MSG_CRITICAL_EMISSION                  ,
    POPUP5_MSG_AMT_SPANNER_WARNING_SPEED          ,
    POPUP5_MSG_AMT_SPANNER_WARNING                ,
    POPUP5_MSG_AMT_LOW_AIR_WARNING_SPEED          ,
    POPUP5_MSG_AMT_LOW_AIR_WARNING                ,
    POPUP5_MSG_LOW_PRESSURE_ALARM_SPEED           ,
    POPUP5_MSG_LOW_PRESSURE_ALARM                 ,
    POPUP5_MSG_APP_ADBLUE_SPEED                   ,
    POPUP5_MSG_APP_ADBLUE                         ,
    POPUP5_MSG_ADBLUE_LEVEL_LOW_SPEED             ,
    POPUP5_MSG_ADBLUE_LEVEL_LOW                   ,
    POPUP5_MSG_LOW_FAILURE_SPEED                  ,
    POPUP5_MSG_LOW_FAILURE                        ,
    POPUP5_MSG_CAMERA_POLLUTION_SPEED             ,
    POPUP5_MSG_CAMERA_POLLUTION                   ,
    POPUP5_MSG_AdBlue_LEVEL_LOW_SPEED             ,
    POPUP5_MSG_AdBlue_LEVEL_LOW                   ,
    POPUP5_MSG_AdBlue_INJ_SYSTEM_SPEED            ,
    POPUP5_MSG_AdBlue_INJ_SYSTEM                  ,
    POPUP5_MSG_TPMS_HIGH_AIR                      ,
    POPUP5_MSG_TPMS_HIGH_TEMP                     ,
    POPUP5_MSG_AdBlue_DOS_MALFUNC                 ,
    POPUP5_MSG_PUSH_DPD_SWITCH1_SPEED             ,
    POPUP5_MSG_PUSH_DPD_SWITCH1                   ,
    POPUP5_MSG_PUSH_DPD_SWITCH2_SPEED             ,
    POPUP5_MSG_PUSH_DPD_SWITCH2                   ,
    POPUP5_MSG_TPMS_FAILURE                       ,
    POPUP5_MSG_TPMS_MONITOR_DROP                  ,
    POPUP6_MSG_PUSH_DPD                           ,
    POPUP6_MSG_HEIGHT_CONTROL                     ,
    POPUP6_MSG_PTO_STOP                           ,
    POPUP7_MSG_CHARGE_ABNORMAL_SPEED              ,
    POPUP7_MSG_CHARGE_ABNORMAL                    ,
    POPUP7_MSG_AMT_ERROR_SPEED                    ,
    POPUP7_MSG_AMT_ERROR                          ,
    POPUP8_MSG_REFUEL                             ,
    POPUP8_MSG_ATM_CLUCH_OVERHEATING_SPEED        ,
    POPUP8_MSG_ATM_CLUCH_OVERHEATING              ,
    POPUP8_MSG_ATM_WORN_OUT                       ,
    POPUP8_MSG_LOW_VOLTAGE_SPEED                  ,
    POPUP8_MSG_OVERVOLTAGE                        ,
    POPUP8_MSG_DPD_AUTO_SPEED                     ,
    POPUP8_MSG_DPD_AUTO                           ,
    POPUP9_MSG_AIR_PRESSURE_SPEED                 ,
    POPUP9_MSG_AIR_PRESSURE                       ,
    POPUP9_MSG_EBS_ERROR_SPEED                    ,
    POPUP9_MSG_EBS_ERROR                          ,
    POPUP10_MSG_RAPID_ACC                         ,
    POPUP10_MSG_RAPID_SUB                         ,
    POPUP10_MSG_REVAL_ENGINE                      ,
    POPUP10_MSG_REVAL_SPEED                       ,
    POPUP11_MSG_ENGINE_OIL_FILTER_ERROR           ,
    POPUP11_MSG_FUEL_FILTER_ERROR                 ,
    POPUP11_MSG_T_MISSION_OIL_ERROR               ,
    POPUP11_MSG_DIFF_OIL_ERROR                    ,
    POPUP11_MSG_CLUTCH_OIL_ERROR                  ,
    POPUP11_MSG_P_STEERING_FRUID_ERROR            ,
    POPUP11_MSG_TIRE_ROTATION                     ,
    POPUP_MSG_MAX                                 ,


};
/******************************************************************************
消息类型定义
******************************************************************************/
#define   POPUP_TYPE_GENERAL                0x00u  /*一般消息*/
#define   POPUP_TYPE_TORQUE_SPEED           0x01u  /*扭矩限制、车速限制 交互显示*/
#define   POPUP_TYPE_ADBULE_ANOMALY         0x02u  /*尿素喷射异常(停止、消耗量)交互显示*/

/******************************************************************************
伪文字消息列表
******************************************************************************/
#define   POPUP_MSG_NONE                    0xFFFFu

/******************************************************************************
报警文字消息属性
******************************************************************************/
typedef struct
{
    uint8_t   Type;   /*类型*/
} PopupMsgAttributeStruct;




static const PopupMsgAttributeStruct PopupMsgAttributeTable[] =
{
    /*=============================================================
                报警文字消息名称           |       消息类型
    -------------------------------------------------------------*/
    { /* POPUP1_MSG_BRAKE_BLACK                 */  POPUP_TYPE_GENERAL,}, //0.紧急警报-刹车
    { /* POPUP1_MSG_BRAKE_BRAKE                 */  POPUP_TYPE_GENERAL,}, //1.紧急警报-紧急制动
    { /* POPUP1_MSG_BRAKE_SPACING_R             */  POPUP_TYPE_GENERAL,}, //2.车间距警报-刹车(红字)
    { /* POPUP1_MSG_BRAKE_SPACING_COLLISION     */  POPUP_TYPE_GENERAL,}, //3.车间距警报-碰撞报警
    { /* POPUP1_MSG_BRAKE_SPACING_Y             */  POPUP_TYPE_GENERAL,}, //4.车间距警报-刹车(黄字)
    { /* POPUT1_MSG_ASR_OPERATE                 */  POPUP_TYPE_GENERAL,}, //5.ASR工作
    { /* POPUT2_MSG_PTO                         */  POPUP_TYPE_GENERAL,}, //6.PTO紧急警报-刹车
    { /* POPUP2_MSG_PARKING_BRAKE               */  POPUP_TYPE_GENERAL,}, //7.忘记松手刹车
    { /* POPUP2_MSG_AIRMATIC_HIGHT              */  POPUP_TYPE_GENERAL,}, //8.遥控调整车辆高度(有车速)
    { /* POPUP3_MSG_CRUISE                      */  POPUP_TYPE_GENERAL,}, //9..自动巡航模式
    { /* POPUP3_MSG_VARIABLE_SLD                */  POPUP_TYPE_GENERAL,}, //10.可变SLD 模式
    { /* POPUT4_MSG_ABNORMAL_CHARGE             */  POPUP_TYPE_GENERAL,}, //11.充电异常（系统检测）
    { /* POPUP4_MSG_OIL_PRESSURE                */  POPUP_TYPE_GENERAL,}, //12.油压（系统检测）
    { /* POPUP4_MSG_AMT_INIT_EXCE               */  POPUP_TYPE_GENERAL,}, //13.AMT初始化异常
    { /* POPUP4_MSG_ADBLUE_QUALITY              */  POPUP_TYPE_GENERAL,}, //14.尿素品质异常（系统检测）
    { /* POPUP4_MSG_ADBLUE_SPRAY                */  POPUP_TYPE_GENERAL,}, //15.尿素喷射异常（系统检测）
    { /* POPUP4_MSG_ADBLUE_SUPPLY               */  POPUP_TYPE_GENERAL,}, //16.尿素水补给（系统检测）
    { /* POPUP4_MSG_START_ENG                   */  POPUP_TYPE_GENERAL,}, //17.AMT初始化结束
    { /* POPUP4_MSG_DPD_AUTO                    */  POPUP_TYPE_GENERAL,}, //18.DPD自动再生
    { /* POPUP5_MSG_OVER_HEAT_SPEED             */  POPUP_TYPE_GENERAL,}, //19.过热（过热，请在安全的场所停车）
    { /* POPUP5_MSG_OVER_HEAT                   */  POPUP_TYPE_GENERAL,}, //20.过热（冷却液温度过高）
    { /* POPUP5_MSG_LOW_COOLANT_SPEED           */  POPUP_TYPE_GENERAL,}, //21.冷却水（冷却液不足）
    { /* POPUP5_MSG_LOW_COOLANT                 */  POPUP_TYPE_GENERAL,}, //22.冷却水（冷却水不足）
    { /* POPUP5_MSG_ENGINE_OIL_PRESSURE_SPEED   */  POPUP_TYPE_GENERAL,}, //23.油压(机油)请在安全场所停车
    { /* POPUP5_MSG_ENGINE_OIL_PRESSURE         */  POPUP_TYPE_GENERAL,}, //24.油压异常
    { /* POPUP5_MSG_METER_FAILURE_SPEED         */  POPUP_TYPE_GENERAL,}, //25.仪表故障-请在安全场所停车
    { /* POPUP5_MSG_METER_FAILURE               */  POPUP_TYPE_GENERAL,}, //26.仪表故障-请与五十铃公司联系
    { /* POPUP5_MSG_CAN_ERROR_SPEED             */  POPUP_TYPE_GENERAL,}, //27.通信系统-请在安全场所停车
    { /* POPUP5_MSG_CAN_ERROR                   */  POPUP_TYPE_GENERAL,}, //28.通信系统-请与五十铃公司联系
    { /* POPUP5_MSG_SPEED_LIMIT_SPEED           */  POPUP_TYPE_GENERAL,}, //29.车速限制-图1
    { /* POPUP5_MSG_SPEED_LIMIT                 */  POPUP_TYPE_GENERAL,}, //30.车速限制-图2
    { /* POPUP5_MSG_TORQUE_REDUCTION_SPEED      */  POPUP_TYPE_GENERAL,}, //31.扭矩限制-图1
    { /* POPUP5_MSG_TORQUE_REDUCTION            */  POPUP_TYPE_GENERAL,}, //32.扭矩限制-图2
    { /* POPUP5_MSG_SPEED_TORQUE                */  POPUP_TYPE_TORQUE_SPEED,}, //33.扭矩限制、车速限制 交互 显示-->扭矩限制
    { /* POPUP5_MSG_INCORRECT_ADBLUE_SPEED      */  POPUP_TYPE_GENERAL,}, //34.尿素品质异常-图1
    { /* POPUP5_MSG_INCORRECT_ADBLUE            */  POPUP_TYPE_GENERAL,}, //35.尿素品质异常-图2
    { /* POPUP5_MSG_CRITICAL_EMISSION_SPEED     */  POPUP_TYPE_GENERAL,}, //36.临界排放故障-图1
    { /* POPUP5_MSG_CRITICAL_EMISSION           */  POPUP_TYPE_GENERAL,}, //37.临界排放故障-图2
    { /* POPUP5_MSG_AMT_SPANNER_WARNING_SPEED   */  POPUP_TYPE_GENERAL,}, //38.AMT异常-图1
    { /* POPUP5_MSG_AMT_SPANNER_WARNING         */  POPUP_TYPE_GENERAL,}, //39.AMT异常-请重启发动机
    { /* POPUP5_MSG_AMT_LOW_AIR_WARNING_SPEED   */  POPUP_TYPE_GENERAL,}, //40.AMT异常(气压低下)-图1
    { /* POPUP5_MSG_AMT_LOW_AIR_WARNING         */  POPUP_TYPE_GENERAL,}, //41.AMT异常(气压低下)-图2
    { /* POPUP5_MSG_LOW_PRESSURE_ALARM_SPEED    */  POPUP_TYPE_GENERAL,}, //42.低圧警報-轮胎漏气警告
    { /* POPUP5_MSG_LOW_PRESSURE_ALARM          */  POPUP_TYPE_GENERAL,}, //43.同——44
    { /* POPUP5_MSG_APP_ADBLUE_SPEED            */  POPUP_TYPE_GENERAL,}, //44.尿素补给-补充尿素溶液-图1
    { /* POPUP5_MSG_APP_ADBLUE                  */  POPUP_TYPE_GENERAL,}, //45.尿素补给-补充尿素溶液-图2
    { /* POPUP5_MSG_ADBLUE_LEVEL_LOW_SPEED      */  POPUP_TYPE_GENERAL,}, //46.尿素余量少-有车速-图1
    { /* POPUP5_MSG_ADBLUE_LEVEL_LOW            */  POPUP_TYPE_GENERAL,}, //47.尿素余量少-无车速-图2
    { /* POPUP5_MSG_LOW_FAILURE_SPEED           */  POPUP_TYPE_GENERAL,}, //48. 低圧警報（低下）
    { /* POPUP5_MSG_LOW_FAILURE                 */  POPUP_TYPE_GENERAL,}, //49. 同——50
    { /* POPUP5_MSG_CAMERA_POLLUTION_SPEED      */  POPUP_TYPE_GENERAL,}, //50.摄像头有污染-图1
    { /* POPUP5_MSG_CAMERA_POLLUTION            */  POPUP_TYPE_GENERAL,}, //51.摄像头有污染-请与五十铃公司联系
    { /* POPUP5_MSG_AdBlue_LEVEL_LOW_SPEED      */  POPUP_TYPE_GENERAL,}, //52.尿素喷射异常（停止）-图1
    { /* POPUP5_MSG_AdBlue_LEVEL_LOW            */  POPUP_TYPE_GENERAL,}, //53.尿素喷射异常（停止）-图2
    { /* POPUP5_MSG_AdBlue_INJ_SYSTEM_SPEED     */  POPUP_TYPE_GENERAL,}, //54.尿素喷射异常（消耗量）-图1
    { /* POPUP5_MSG_AdBlue_INJ_SYSTEM           */  POPUP_TYPE_GENERAL,}, //55.尿素喷射异常（消耗量）-图2
    { /* POPUP5_MSG_TPMS_HIGH_AIR               */  POPUP_TYPE_GENERAL,}, //56.高圧警報-轮胎高压警告
    { /* POPUP5_MSG_TPMS_HIGH_TEMP              */  POPUP_TYPE_GENERAL,}, //57.高温警報-轮胎高温警告
    { /* POPUP5_MSG_AdBlue_DOS_MALFUNC          */  POPUP_TYPE_ADBULE_ANOMALY,}, //58.尿素喷射异常(停止、消耗量)交互显示----尿素喷射系统异
    { /* POPUP5_MSG_PUSH_DPD_SWITCH1_SPEED      */  POPUP_TYPE_GENERAL,}, //59.DPD手动再生要求1-DPD需要再生
    { /* POPUP5_MSG_PUSH_DPD_SWITCH1            */  POPUP_TYPE_GENERAL,}, //60.DPD手动再生要求1-请按下DPD开关
    { /* POPUP5_MSG_PUSH_DPD_SWITCH2_SPEED      */  POPUP_TYPE_GENERAL,}, //61.DPD手动再生要求2-DPD需要再生
    { /* POPUP5_MSG_PUSH_DPD_SWITCH2            */  POPUP_TYPE_GENERAL,}, //62.DPD手动再生要求2-请按下DPD开关
    { /* POPUP5_MSG_TPMS_FAILURE                */  POPUP_TYPE_GENERAL,}, //63.TPMS故障-轮胎监控失败
    { /* POPUP5_MSG_TPMS_MONITOR_DROP           */  POPUP_TYPE_GENERAL,}, //64.TPMS電池低下-轮胎监控传感器电压下降
    { /* POPUP6_MSG_PUSH_DPD                    */  POPUP_TYPE_GENERAL,}, //65.DPD手动再生中
    { /* POPUP6_MSG_HEIGHT_CONTROL              */  POPUP_TYPE_GENERAL,}, //66.遥控车辆高度调整中(无车速)
    { /* POPUP6_MSG_PTO_STOP                    */  POPUP_TYPE_GENERAL,}, //67.PTO(停车中)
    { /* POPUP7_MSG_CHARGE_ABNORMAL_SPEED       */  POPUP_TYPE_GENERAL,}, //68.充电异常-请在安全的场所停车
    { /* POPUP7_MSG_CHARGE_ABNORMAL             */  POPUP_TYPE_GENERAL,}, //69.充电异常-请与五十铃公司联系
    { /* POPUP7_MSG_AMT_ERROR_SPEED             */  POPUP_TYPE_GENERAL,}, //70.AMT異常-AMT异常
    { /* POPUP7_MSG_AMT_ERROR                   */  POPUP_TYPE_GENERAL,}, //71.AMT異常-请联系经销商
    { /* POPUP8_MSG_REFUEL                      */  POPUP_TYPE_GENERAL,}, //72.补充燃料-油箱单位
    { /* POPUP8_MSG_ATM_CLUCH_OVERHEATING_SPEED */  POPUP_TYPE_GENERAL,}, //73.过热-离合器过载
    { /* POPUP8_MSG_ATM_CLUCH_OVERHEATING       */  POPUP_TYPE_GENERAL,}, //74.过热-选择合适的档位
    { /* POPUP8_MSG_ATM_WORN_OUT                */  POPUP_TYPE_GENERAL,}, //75.AMT磨耗-离合器磨损
    { /* POPUP8_MSG_LOW_VOLTAGE_SPEED           */  POPUP_TYPE_GENERAL,}, //76.低电压报警
    { /* POPUP8_MSG_OVERVOLTAGE                 */  POPUP_TYPE_GENERAL,}, //77.过电压报警
    { /* POPUP8_MSG_DPD_AUTO_SPEED              */  POPUP_TYPE_GENERAL,}, //78.DPD自动再生-DPD自动再生中
    { /* POPUP8_MSG_DPD_AUTO                    */  POPUP_TYPE_GENERAL,}, //79.DPD自动再生-再生将自动完成，不需要操作开关
    { /* POPUP9_MSG_AIR_PRESSURE_SPEED          */  POPUP_TYPE_GENERAL,}, //80.气压过低-气压过低请注意
    { /* POPUP9_MSG_AIR_PRESSURE                */  POPUP_TYPE_GENERAL,},//81.气压过低-请冲入空气
    { /* POPUP9_MSG_EBS_ERROR_SPEED             */  POPUP_TYPE_GENERAL,}, //82.EBS故障（红）-请在安全的场所停车
    { /* POPUP9_MSG_EBS_ERROR                   */  POPUP_TYPE_GENERAL,},//83.EBS故障（红）-请与五十铃公司联系
    { /* POPUP10_MSG_RAPID_ACC                  */  POPUP_TYPE_GENERAL,},//84.省油耗建议-急加速
    { /* POPUP10_MSG_RAPID_SUB                  */  POPUP_TYPE_GENERAL,},//85.省油耗建议-急减速
    { /* POPUP10_MSG_REVAL_ENGINE               */  POPUP_TYPE_GENERAL,},//86.省油耗建议-请降低发动机转速
    { /* POPUP10_MSG_REVAL_SPEED                */  POPUP_TYPE_GENERAL,},//87.省油耗建议-请降低速度
    { /* POPUP11_MSG_ENGINE_OIL_FILTER_ERROR    */  POPUP_TYPE_GENERAL,},//88.发动机机油＆滤清器
    { /* POPUP11_MSG_FUEL_FILTER_ERROR          */  POPUP_TYPE_GENERAL,},//89.燃油滤清器
    { /* POPUP11_MSG_T_MISSION_OIL_ERROR        */  POPUP_TYPE_GENERAL,},//90.变速箱油
    { /* POPUP11_MSG_DIFF_OIL_ERROR             */  POPUP_TYPE_GENERAL,},//91.差速器油
    { /* POPUP11_MSG_CLUTCH_OIL_ERROR           */  POPUP_TYPE_GENERAL,},//92.顺畅系统离合器油
    { /* POPUP11_MSG_P_STEERING_FRUID_ERROR     */  POPUP_TYPE_GENERAL,},//93.动力转向液
    { /* POPUP11_MSG_TIRE_ROTATION              */  POPUP_TYPE_GENERAL,},//94.更换轮胎・轮胎位置

};

#define   POPUP_MSG_NUMBER_TOTAL            (sizeof(PopupMsgAttributeTable) / sizeof(PopupMsgAttributeStruct))

#endif
