#ifndef MEMU_H__
#define MEMU_H__

#include "TYW_stdint.h"

#ifdef GLOBALS_MEU_PROCESS
#define EXTERN_MEU_PROCESS
#else
#define EXTERN_MEU_PROCESS extern
#endif

#define _MN_IDX_NULL 0xff
#define _MN_IDX_NULL0 0x00
#define _MN_OPR_NULL (void *)0

typedef enum
{
    /*主界面*/
    _MN_DSP_LEVEL1MENU_1 = 0, /* 00 平均车速，平均油耗*/
    _MN_DSP_LEVEL1MENU_2,     /* 01 电池电量*/
    _MN_DSP_LEVEL1MENU_3,     /* 02 DPD*/
    _MN_DSP_LEVEL1MENU_4,     /* 03 油温-转速时间*/
    _MN_DSP_LEVEL1MENU_5,     /* 04 日历*/
    _MN_DSP_LEVEL1MENU_6,     /* 05 空白*/
    _MN_DSP_LEVEPOPUP,        /* 06 报警界面显示*/
    /*一级菜单*/
    _MN_DSP_LEVEL2MENU_1,     /* 07 故障码*/
    _MN_DSP_LEVEL2MENU_2,     /* 08 保养通知*/
    _MN_DSP_LEVEL2MENU_3,     /* 09 保养通知设定*/
    _MN_DSP_LEVEL2MENU_4,     /* 10 用户设定*/
    _MN_DSP_LEVEL2MENU_5,     /* 11 系统演示模式*/
    _MN_DSP_LEVEL2MENU_6,     /* 12 轮胎状态显示*/

    /*二级菜单*/
    _MN_DSP_LEVEL2_1_MENU_1, // 13
    _MN_DSP_LEVEL2_2_MENU_1, // 14
    _MN_DSP_LEVEL2_2_MENU_2, // 15
    _MN_DSP_LEVEL2_2_MENU_3, // 16
    _MN_DSP_LEVEL2_2_MENU_4, // 17
    _MN_DSP_LEVEL2_2_MENU_5, // 21
    _MN_DSP_LEVEL2_2_MENU_6, // 18
    _MN_DSP_LEVEL2_2_MENU_7, // 19
    _MN_DSP_LEVEL2_2_MENU_8, // 20
    _MN_DSP_LEVEL2_2_MENU_9, // 21

    _MN_DSP_LEVEL2_3_MENU_1, // 22
    _MN_DSP_LEVEL2_3_MENU_2, // 23
    _MN_DSP_LEVEL2_3_MENU_3, // 24
    _MN_DSP_LEVEL2_3_MENU_4, // 25
    _MN_DSP_LEVEL2_3_MENU_5, // 30
    _MN_DSP_LEVEL2_3_MENU_6, // 26
    _MN_DSP_LEVEL2_3_MENU_7, // 27

    _MN_DSP_LEVEL2_4_MENU_1, // 28
    _MN_DSP_LEVEL2_4_MENU_2, // 29
    _MN_DSP_LEVEL2_4_MENU_3, // 30
    _MN_DSP_LEVEL2_4_MENU_A, // 31
    _MN_DSP_LEVEL2_4_MENU_4, // 32
    _MN_DSP_LEVEL2_4_MENU_5, // 33
    _MN_DSP_LEVEL2_4_MENU_6, // 34
    _MN_DSP_LEVEL2_4_MENU_7, // 35
    _MN_DSP_LEVEL2_4_MENU_8, // 36
    _MN_DSP_LEVEL2_4_MENU_9, // 37
    _MN_DSP_LEVEL2_5_MENU_1, // 38
    _MN_DSP_LEVEL2_6_MENU_1,
    /*三级菜单*/
    //_MN_DSP_LEVEL3_1_MENU_1       ,            //42
    //_MN_DSP_LEVEL3_1_MENU_2       ,            //43
    //_MN_DSP_LEVEL3_1_MENU_3       ,            //44
    //_MN_DSP_LEVEL3_1_MENU_4       ,            //45
    //_MN_DSP_LEVEL3_1_MENU_5       ,

    _MN_DSP_LEVEL3_2_MENU_1, // 39
    _MN_DSP_LEVEL3_2_MENU_2, // 40
    _MN_DSP_LEVEL3_2_MENU_3, // 41
    _MN_DSP_LEVEL3_2_MENU_4, // 42
    //_MN_DSP_LEVEL3_2_MENU_5       ,            //50
    _MN_DSP_LEVEL3_2_MENU_6, // 43
    _MN_DSP_LEVEL3_2_MENU_7, // 44
    _MN_DSP_LEVEL3_2_MENU_8, // 45
    _MN_DSP_LEVEL3_2_MENU_9, // 46

    _MN_DSP_LEVEL3_3_MENU_1, // 47
    _MN_DSP_LEVEL3_3_MENU_2, // 48
    _MN_DSP_LEVEL3_3_MENU_3, // 49
    _MN_DSP_LEVEL3_3_MENU_4, // 50
    //_MN_DSP_LEVEL3_3_MENU_5       ,            //59
    _MN_DSP_LEVEL3_3_MENU_6, // 51
    _MN_DSP_LEVEL3_3_MENU_7, // 52

    _MN_DSP_LEVEL3_4_MENU_11, // 53
    _MN_DSP_LEVEL3_4_MENU_12, // 54
    _MN_DSP_LEVEL3_4_MENU_21, // 55
    _MN_DSP_LEVEL3_4_MENU_22, // 56
    _MN_DSP_LEVEL3_4_MENU_3,  // 57
    _MN_DSP_LEVEL3_4_MENU_41, // 58
    _MN_DSP_LEVEL3_4_MENU_42, // 59
    _MN_DSP_LEVEL3_4_MENU_43, // 60
    _MN_DSP_LEVEL3_4_MENU_44, // 61
    _MN_DSP_LEVEL3_4_MENU_45, // 62
    _MN_DSP_LEVEL3_4_MENU_51, // 63
    _MN_DSP_LEVEL3_4_MENU_52, // 64
    _MN_DSP_LEVEL3_4_MENU_6,  // 65
    _MN_DSP_LEVEL3_4_MENU_7,  // 66
    _MN_DSP_LEVEL3_4_MENU_8,  // 67
    _MN_DSP_LEVEL3_4_MENU_9,  // 68
    _MN_DSP_LEVEL3_4_MENU_A,  // 69

    /*四级菜单*/
    _MN_DSP_LEVEL4_1_MENU_1, // 70
    _MN_DSP_LEVEL4_1_MENU_2, // 71
    _MN_DSP_LEVEL4_2_MENU_1, // 72
    _MN_DSP_LEVEL4_2_MENU_2, // 73
    _MN_DSP_LEVEL4_4_MENU_1, // 74
    _MN_DSP_LEVEL4_4_MENU_2, // 75
    _MN_DSP_LEVEL4_4_MENU_3, // 76
    _MN_DSP_LEVEL4_4_MENU_4, // 77
    _MN_DSP_LEVEL4_4_MENU_5, // 78
    _MN_DSP_LEVEL4_5_MENU_1, // 79
    _MN_DSP_LEVEL4_5_MENU_2, // 80

    /*特殊界面*/
    _MN_DSP_HSAENTER_MENU, // 81
    _MN_DSP_ENTER_MENU,    // 82
    _MN_DSP_RETURN_MENU,   // 83
};

typedef uint8_t _MENU_IDX;
typedef struct
{
    _MENU_IDX VK_IDX_ENTER;
    _MENU_IDX VK_IDX_UP;
    _MENU_IDX VK_IDX_DOWN;
    _MENU_IDX VK_IDX_EXIT;

    void (*Enter)(void);
    void (*Do)(void);
    void (*Exit)(void);
} _MenuOptTab;


typedef struct
{
    uint8_t   Menu_Flag               ;   /*主界面标记*/
    uint8_t   Menu_Time_Flag          ;   /*从Enter界面确认退出计时*/
    uint8_t   Menu_Enter_Return       ;   /*进入Enter之前界面*/
    uint8_t   Menu_Return             ;   /*Enter Return界面切换标记*/
    uint8_t   Menu_Key_Time           ;   /*按键长按时间记录*/
    uint16_t  Key_Menu_Popup_time     ;   /*上述状态持续时间*/
    uint8_t   Key_Menu_Popup_Flag     ;   /*报警界面menu按键长按 */
    uint8_t   Menu_Light_Time         ;
    uint8_t   Menu_Light_Time_Flag    ;
} _MenuFlag;

EXTERN_MEU_PROCESS  _MenuFlag    MenuFlag   ;

EXTERN_MEU_PROCESS uint8_t bMenuSwFlag;
EXTERN_MEU_PROCESS uint8_t g_ClearWin1;
EXTERN_MEU_PROCESS uint8_t bNextMenuIDX; // the next index of menu .
EXTERN_MEU_PROCESS uint8_t bCurMenuIDX;  // the current index of menu.
EXTERN_MEU_PROCESS uint8_t bMainMenuIDX; // the current index of menu.
EXTERN_MEU_PROCESS uint8_t bOldMenuIDX;  // the Old index of menu.

EXTERN_MEU_PROCESS const _MenuOptTab MenuOptTab[]; // add
EXTERN_MEU_PROCESS void NextMenu(_MENU_IDX idx);
EXTERN_MEU_PROCESS void MenuInit(void);
EXTERN_MEU_PROCESS void MenuManage(void);

EXTERN_MEU_PROCESS void Level1Menu_1Enter(void);
EXTERN_MEU_PROCESS void Level1Menu_1Do(void);
EXTERN_MEU_PROCESS void Level1Menu_1Exit(void);

EXTERN_MEU_PROCESS void Level1Menu_2Enter(void);
EXTERN_MEU_PROCESS void Level1Menu_2Do(void);
EXTERN_MEU_PROCESS void Level1Menu_2Exit(void);

EXTERN_MEU_PROCESS void Level1Menu_3Enter(void);
EXTERN_MEU_PROCESS void Level1Menu_3Do(void);
EXTERN_MEU_PROCESS void Level1Menu_3Exit(void);

EXTERN_MEU_PROCESS void Level1Menu_4Enter(void);
EXTERN_MEU_PROCESS void Level1Menu_4Do(void);
EXTERN_MEU_PROCESS void Level1Menu_4Exit(void);

EXTERN_MEU_PROCESS void Level1Menu_5Enter(void);
EXTERN_MEU_PROCESS void Level1Menu_5Do(void);
EXTERN_MEU_PROCESS void Level1Menu_5Exit(void);

EXTERN_MEU_PROCESS void Level1Menu_6Enter(void);
EXTERN_MEU_PROCESS void Level1Menu_6Do(void);
EXTERN_MEU_PROCESS void Level1Menu_6Exit(void);

EXTERN_MEU_PROCESS void LevelPopup_Enter(void);
EXTERN_MEU_PROCESS void LevelPopup_Do(void);
EXTERN_MEU_PROCESS void LevelPopup_Exit(void);

EXTERN_MEU_PROCESS   void        Level2Menu_1Enter(void);
EXTERN_MEU_PROCESS   void        Level2Menu_1Do(void);
EXTERN_MEU_PROCESS   void        Level2Menu_1Exit(void);

EXTERN_MEU_PROCESS   void        Level2Menu_2Enter(void);
EXTERN_MEU_PROCESS   void        Level2Menu_2Do(void);
EXTERN_MEU_PROCESS   void        Level2Menu_2Exit(void);

EXTERN_MEU_PROCESS   void        Level2Menu_3Enter(void);
EXTERN_MEU_PROCESS   void        Level2Menu_3Do(void);
EXTERN_MEU_PROCESS   void        Level2Menu_3Exit(void);

EXTERN_MEU_PROCESS   void        Level2Menu_4Enter(void);
EXTERN_MEU_PROCESS   void        Level2Menu_4Do(void);
EXTERN_MEU_PROCESS   void        Level2Menu_4Exit(void);

EXTERN_MEU_PROCESS   void        Level2Menu_5Enter(void);
EXTERN_MEU_PROCESS   void        Level2Menu_5Do(void);
EXTERN_MEU_PROCESS   void        Level2Menu_5Exit(void);

EXTERN_MEU_PROCESS   void        Level2Menu_6Enter(void);
EXTERN_MEU_PROCESS   void        Level2Menu_6Do(void);
EXTERN_MEU_PROCESS   void        Level2Menu_6Exit(void);

EXTERN_MEU_PROCESS   void        Level2_1Menu_1Enter(void);
EXTERN_MEU_PROCESS   void        Level2_1Menu_1Do(void);
EXTERN_MEU_PROCESS   void        Level2_1Menu_1Exit(void);

//EXTERN_MEU_PROCESS   void        Level2_1Menu_2Enter(void);
//EXTERN_MEU_PROCESS   void        Level2_1Menu_2Do(void);
//EXTERN_MEU_PROCESS   void        Level2_1Menu_2Exit(void);

//EXTERN_MEU_PROCESS   void        Level2_1Menu_3Enter(void);
//EXTERN_MEU_PROCESS   void        Level2_1Menu_3Do(void);
//EXTERN_MEU_PROCESS   void        Level2_1Menu_3Exit(void);

//EXTERN_MEU_PROCESS   void        Level2_1Menu_4Enter(void);
//EXTERN_MEU_PROCESS   void        Level2_1Menu_4Do(void);
//EXTERN_MEU_PROCESS   void        Level2_1Menu_4Exit(void);

//EXTERN_MEU_PROCESS   void        Level2_1Menu_5Enter(void);
//EXTERN_MEU_PROCESS   void        Level2_1Menu_5Do(void);
//EXTERN_MEU_PROCESS   void        Level2_1Menu_5Exit(void);

//EXTERN_MEU_PROCESS   void        Level2_1Menu_6Enter(void);
//EXTERN_MEU_PROCESS   void        Level2_1Menu_6Do(void);
//EXTERN_MEU_PROCESS   void        Level2_1Menu_6Exit(void);

EXTERN_MEU_PROCESS   void        Level2_2Menu_1Enter(void);
EXTERN_MEU_PROCESS   void        Level2_2Menu_1Do(void);
EXTERN_MEU_PROCESS   void        Level2_2Menu_1Exit(void);

EXTERN_MEU_PROCESS   void        Level2_2Menu_2Enter(void);
EXTERN_MEU_PROCESS   void        Level2_2Menu_2Do(void);
EXTERN_MEU_PROCESS   void        Level2_2Menu_2Exit(void);

EXTERN_MEU_PROCESS   void        Level2_2Menu_3Enter(void);
EXTERN_MEU_PROCESS   void        Level2_2Menu_3Do(void);
EXTERN_MEU_PROCESS   void        Level2_2Menu_3Exit(void);

EXTERN_MEU_PROCESS   void        Level2_2Menu_4Enter(void);
EXTERN_MEU_PROCESS   void        Level2_2Menu_4Do(void);
EXTERN_MEU_PROCESS   void        Level2_2Menu_4Exit(void);

EXTERN_MEU_PROCESS   void        Level2_2Menu_5Enter(void);
EXTERN_MEU_PROCESS   void        Level2_2Menu_5Do(void);
EXTERN_MEU_PROCESS   void        Level2_2Menu_5Exit(void);

EXTERN_MEU_PROCESS   void        Level2_2Menu_6Enter(void);
EXTERN_MEU_PROCESS   void        Level2_2Menu_6Do(void);
EXTERN_MEU_PROCESS   void        Level2_2Menu_6Exit(void);

EXTERN_MEU_PROCESS   void        Level2_2Menu_7Enter(void);
EXTERN_MEU_PROCESS   void        Level2_2Menu_7Do(void);
EXTERN_MEU_PROCESS   void        Level2_2Menu_7Exit(void);

EXTERN_MEU_PROCESS   void        Level2_2Menu_8Enter(void);
EXTERN_MEU_PROCESS   void        Level2_2Menu_8Do(void);
EXTERN_MEU_PROCESS   void        Level2_2Menu_8Exit(void);

EXTERN_MEU_PROCESS   void        Level2_2Menu_9Enter(void);
EXTERN_MEU_PROCESS   void        Level2_2Menu_9Do(void);
EXTERN_MEU_PROCESS   void        Level2_2Menu_9Exit(void);

EXTERN_MEU_PROCESS   void        Level2_3Menu_1Enter(void);
EXTERN_MEU_PROCESS   void        Level2_3Menu_1Do(void);
EXTERN_MEU_PROCESS   void        Level2_3Menu_1Exit(void);

EXTERN_MEU_PROCESS   void        Level2_3Menu_2Enter(void);
EXTERN_MEU_PROCESS   void        Level2_3Menu_2Do(void);
EXTERN_MEU_PROCESS   void        Level2_3Menu_2Exit(void);

EXTERN_MEU_PROCESS   void        Level2_3Menu_3Enter(void);
EXTERN_MEU_PROCESS   void        Level2_3Menu_3Do(void);
EXTERN_MEU_PROCESS   void        Level2_3Menu_3Exit(void);

EXTERN_MEU_PROCESS   void        Level2_3Menu_4Enter(void);
EXTERN_MEU_PROCESS   void        Level2_3Menu_4Do(void);
EXTERN_MEU_PROCESS   void        Level2_3Menu_4Exit(void);

EXTERN_MEU_PROCESS   void        Level2_3Menu_5Enter(void);
EXTERN_MEU_PROCESS   void        Level2_3Menu_5Do(void);
EXTERN_MEU_PROCESS   void        Level2_3Menu_5Exit(void);

EXTERN_MEU_PROCESS   void        Level2_3Menu_6Enter(void);
EXTERN_MEU_PROCESS   void        Level2_3Menu_6Do(void);
EXTERN_MEU_PROCESS   void        Level2_3Menu_6Exit(void);

EXTERN_MEU_PROCESS   void        Level2_3Menu_7Enter(void);
EXTERN_MEU_PROCESS   void        Level2_3Menu_7Do(void);
EXTERN_MEU_PROCESS   void        Level2_3Menu_7Exit(void);

EXTERN_MEU_PROCESS   void        Level2_4Menu_1Enter(void);
EXTERN_MEU_PROCESS   void        Level2_4Menu_1Do(void);
EXTERN_MEU_PROCESS   void        Level2_4Menu_1Exit(void);

EXTERN_MEU_PROCESS   void        Level2_4Menu_2Enter(void);
EXTERN_MEU_PROCESS   void        Level2_4Menu_2Do(void);
EXTERN_MEU_PROCESS   void        Level2_4Menu_2Exit(void);

EXTERN_MEU_PROCESS   void        Level2_4Menu_3Enter(void);
EXTERN_MEU_PROCESS   void        Level2_4Menu_3Do(void);
EXTERN_MEU_PROCESS   void        Level2_4Menu_3Exit(void);

EXTERN_MEU_PROCESS   void        Level2_4Menu_4Enter(void);
EXTERN_MEU_PROCESS   void        Level2_4Menu_4Do(void);
EXTERN_MEU_PROCESS   void        Level2_4Menu_4Exit(void);

EXTERN_MEU_PROCESS   void        Level2_4Menu_5Enter(void);
EXTERN_MEU_PROCESS   void        Level2_4Menu_5Do(void);
EXTERN_MEU_PROCESS   void        Level2_4Menu_5Exit(void);

EXTERN_MEU_PROCESS   void        Level2_4Menu_6Enter(void);
EXTERN_MEU_PROCESS   void        Level2_4Menu_6Do(void);
EXTERN_MEU_PROCESS   void        Level2_4Menu_6Exit(void);

EXTERN_MEU_PROCESS   void        Level2_4Menu_7Enter(void);
EXTERN_MEU_PROCESS   void        Level2_4Menu_7Do(void);
EXTERN_MEU_PROCESS   void        Level2_4Menu_7Exit(void);

EXTERN_MEU_PROCESS   void        Level2_4Menu_8Enter(void);
EXTERN_MEU_PROCESS   void        Level2_4Menu_8Do(void);
EXTERN_MEU_PROCESS   void        Level2_4Menu_8Exit(void);

EXTERN_MEU_PROCESS   void        Level2_4Menu_9Enter(void);
EXTERN_MEU_PROCESS   void        Level2_4Menu_9Do(void);
EXTERN_MEU_PROCESS   void        Level2_4Menu_9Exit(void);

//EXTERN_MEU_PROCESS   void        Level3_1Menu_1Enter(void);
//EXTERN_MEU_PROCESS   void        Level3_1Menu_1Do(void);
//EXTERN_MEU_PROCESS   void        Level3_1Menu_1Exit(void);

//EXTERN_MEU_PROCESS   void        Level3_1Menu_2Enter(void);
//EXTERN_MEU_PROCESS   void        Level3_1Menu_2Do(void);
//EXTERN_MEU_PROCESS   void        Level3_1Menu_2Exit(void);

//EXTERN_MEU_PROCESS   void        Level3_1Menu_3Enter(void);
//EXTERN_MEU_PROCESS   void        Level3_1Menu_3Do(void);
//EXTERN_MEU_PROCESS   void        Level3_1Menu_3Exit(void);

//EXTERN_MEU_PROCESS   void        Level3_1Menu_4Enter(void);
//EXTERN_MEU_PROCESS   void        Level3_1Menu_4Do(void);
//EXTERN_MEU_PROCESS   void        Level3_1Menu_4Exit(void);

//EXTERN_MEU_PROCESS   void        Level3_1Menu_5Enter(void);
//EXTERN_MEU_PROCESS   void        Level3_1Menu_5Do(void);
//EXTERN_MEU_PROCESS   void        Level3_1Menu_5Exit(void);

//EXTERN_MEU_PROCESS   void        Level3_1Menu_6Enter(void);
//EXTERN_MEU_PROCESS   void        Level3_1Menu_6Do(void);
//EXTERN_MEU_PROCESS   void        Level3_1Menu_6Exit(void);

EXTERN_MEU_PROCESS   void        Level3_2Menu_1Enter(void);
EXTERN_MEU_PROCESS   void        Level3_2Menu_1Do(void);
EXTERN_MEU_PROCESS   void        Level3_2Menu_1Exit(void);

EXTERN_MEU_PROCESS   void        Level3_2Menu_2Enter(void);
EXTERN_MEU_PROCESS   void        Level3_2Menu_2Do(void);
EXTERN_MEU_PROCESS   void        Level3_2Menu_2Exit(void);

EXTERN_MEU_PROCESS   void        Level3_2Menu_3Enter(void);
EXTERN_MEU_PROCESS   void        Level3_2Menu_3Do(void);
EXTERN_MEU_PROCESS   void        Level3_2Menu_3Exit(void);

EXTERN_MEU_PROCESS   void        Level3_2Menu_4Enter(void);
EXTERN_MEU_PROCESS   void        Level3_2Menu_4Do(void);
EXTERN_MEU_PROCESS   void        Level3_2Menu_4Exit(void);

EXTERN_MEU_PROCESS   void        Level3_2Menu_5Enter(void);
EXTERN_MEU_PROCESS   void        Level3_2Menu_5Do(void);
EXTERN_MEU_PROCESS   void        Level3_2Menu_5Exit(void);

EXTERN_MEU_PROCESS   void        Level3_2Menu_6Enter(void);
EXTERN_MEU_PROCESS   void        Level3_2Menu_6Do(void);
EXTERN_MEU_PROCESS   void        Level3_2Menu_6Exit(void);

EXTERN_MEU_PROCESS   void        Level3_2Menu_7Enter(void);
EXTERN_MEU_PROCESS   void        Level3_2Menu_7Do(void);
EXTERN_MEU_PROCESS   void        Level3_2Menu_7Exit(void);

EXTERN_MEU_PROCESS   void        Level3_2Menu_8Enter(void);
EXTERN_MEU_PROCESS   void        Level3_2Menu_8Do(void);
EXTERN_MEU_PROCESS   void        Level3_2Menu_8Exit(void);

EXTERN_MEU_PROCESS   void        Level3_2Menu_9Enter(void);
EXTERN_MEU_PROCESS   void        Level3_2Menu_9Do(void);
EXTERN_MEU_PROCESS   void        Level3_2Menu_9Exit(void);


EXTERN_MEU_PROCESS   void        Level3_3Menu_1Enter(void);
EXTERN_MEU_PROCESS   void        Level3_3Menu_1Do(void);
EXTERN_MEU_PROCESS   void        Level3_3Menu_1Exit(void);

EXTERN_MEU_PROCESS   void        Level3_3Menu_2Enter(void);
EXTERN_MEU_PROCESS   void        Level3_3Menu_2Do(void);
EXTERN_MEU_PROCESS   void        Level3_3Menu_2Exit(void);

EXTERN_MEU_PROCESS   void        Level3_3Menu_3Enter(void);
EXTERN_MEU_PROCESS   void        Level3_3Menu_3Do(void);
EXTERN_MEU_PROCESS   void        Level3_3Menu_3Exit(void);

EXTERN_MEU_PROCESS   void        Level3_3Menu_4Enter(void);
EXTERN_MEU_PROCESS   void        Level3_3Menu_4Do(void);
EXTERN_MEU_PROCESS   void        Level3_3Menu_4Exit(void);

EXTERN_MEU_PROCESS   void        Level3_3Menu_5Enter(void);
EXTERN_MEU_PROCESS   void        Level3_3Menu_5Do(void);
EXTERN_MEU_PROCESS   void        Level3_3Menu_5Exit(void);

EXTERN_MEU_PROCESS   void        Level3_3Menu_6Enter(void);
EXTERN_MEU_PROCESS   void        Level3_3Menu_6Do(void);
EXTERN_MEU_PROCESS   void        Level3_3Menu_6Exit(void);

EXTERN_MEU_PROCESS   void        Level3_3Menu_7Enter(void);
EXTERN_MEU_PROCESS   void        Level3_3Menu_7Do(void);
EXTERN_MEU_PROCESS   void        Level3_3Menu_7Exit(void);


EXTERN_MEU_PROCESS   void        Level3_4Menu_1Enter_1(void);
EXTERN_MEU_PROCESS   void        Level3_4Menu_1Do_1(void);
EXTERN_MEU_PROCESS   void        Level3_4Menu_1Exit_1(void);

EXTERN_MEU_PROCESS   void        Level3_4Menu_1Enter_2(void);
EXTERN_MEU_PROCESS   void        Level3_4Menu_1Do_2(void);
EXTERN_MEU_PROCESS   void        Level3_4Menu_1Exit_2(void);

EXTERN_MEU_PROCESS   void        Level3_4Menu_2Enter_1(void);
EXTERN_MEU_PROCESS   void        Level3_4Menu_2Do_1(void);
EXTERN_MEU_PROCESS   void        Level3_4Menu_2Exit_1(void);

EXTERN_MEU_PROCESS   void        Level3_4Menu_2Enter_2(void);
EXTERN_MEU_PROCESS   void        Level3_4Menu_2Do_2(void);
EXTERN_MEU_PROCESS   void        Level3_4Menu_2Exit_2(void);

EXTERN_MEU_PROCESS   void        Level3_4Menu_3Enter(void);
EXTERN_MEU_PROCESS   void        Level3_4Menu_3Do(void);
EXTERN_MEU_PROCESS   void        Level3_4Menu_3Exit(void);

EXTERN_MEU_PROCESS   void        Level3_4Menu_4Enter_1(void);
EXTERN_MEU_PROCESS   void        Level3_4Menu_4Do_1(void);
EXTERN_MEU_PROCESS   void        Level3_4Menu_4Exit_1(void);

EXTERN_MEU_PROCESS   void        Level3_4Menu_4Enter_2(void);
EXTERN_MEU_PROCESS   void        Level3_4Menu_4Do_2(void);
EXTERN_MEU_PROCESS   void        Level3_4Menu_4Exit_2(void);

EXTERN_MEU_PROCESS   void        Level3_4Menu_4Enter_3(void);
EXTERN_MEU_PROCESS   void        Level3_4Menu_4Do_3(void);
EXTERN_MEU_PROCESS   void        Level3_4Menu_4Exit_3(void);

EXTERN_MEU_PROCESS   void        Level3_4Menu_4Enter_4(void);
EXTERN_MEU_PROCESS   void        Level3_4Menu_4Do_4(void);
EXTERN_MEU_PROCESS   void        Level3_4Menu_4Exit_4(void);

EXTERN_MEU_PROCESS   void        Level3_4Menu_4Enter_5(void);
EXTERN_MEU_PROCESS   void        Level3_4Menu_4Do_5(void);
EXTERN_MEU_PROCESS   void        Level3_4Menu_4Exit_5(void);

EXTERN_MEU_PROCESS   void        Level3_4Menu_5Enter_1(void);
EXTERN_MEU_PROCESS   void        Level3_4Menu_5Do_1(void);
EXTERN_MEU_PROCESS   void        Level3_4Menu_5Exit_1(void);

EXTERN_MEU_PROCESS   void        Level3_4Menu_5Enter_2(void);
EXTERN_MEU_PROCESS   void        Level3_4Menu_5Do_2(void);
EXTERN_MEU_PROCESS   void        Level3_4Menu_5Exit_2(void);

EXTERN_MEU_PROCESS   void        Level3_4Menu_6Enter(void);
EXTERN_MEU_PROCESS   void        Level3_4Menu_6Do(void);
EXTERN_MEU_PROCESS   void        Level3_4Menu_6Exit(void);

EXTERN_MEU_PROCESS   void        Level3_4Menu_7Enter(void);
EXTERN_MEU_PROCESS   void        Level3_4Menu_7Do(void);
EXTERN_MEU_PROCESS   void        Level3_4Menu_7Exit(void);

EXTERN_MEU_PROCESS   void        Level3_4Menu_8Enter(void);
EXTERN_MEU_PROCESS   void        Level3_4Menu_8Do(void);
EXTERN_MEU_PROCESS   void        Level3_4Menu_8Exit(void);

EXTERN_MEU_PROCESS   void        Level3_4Menu_9Enter(void);
EXTERN_MEU_PROCESS   void        Level3_4Menu_9Do(void);
EXTERN_MEU_PROCESS   void        Level3_4Menu_9Exit(void);

EXTERN_MEU_PROCESS   void        Level4_1Menu_1Enter(void);
EXTERN_MEU_PROCESS   void        Level4_1Menu_1Do(void);
EXTERN_MEU_PROCESS   void        Level4_1Menu_1Exit(void);

EXTERN_MEU_PROCESS   void        Level4_1Menu_2Enter(void);
EXTERN_MEU_PROCESS   void        Level4_1Menu_2Do(void);
EXTERN_MEU_PROCESS   void        Level4_1Menu_2Exit(void);

EXTERN_MEU_PROCESS   void        Level4_2Menu_1Enter(void);
EXTERN_MEU_PROCESS   void        Level4_2Menu_1Do(void);
EXTERN_MEU_PROCESS   void        Level4_2Menu_1Exit(void);

EXTERN_MEU_PROCESS   void        Level4_2Menu_2Enter(void);
EXTERN_MEU_PROCESS   void        Level4_2Menu_2Do(void);
EXTERN_MEU_PROCESS   void        Level4_2Menu_2Exit(void);

EXTERN_MEU_PROCESS   void        Level4_4Menu_1Enter(void);
EXTERN_MEU_PROCESS   void        Level4_4Menu_1Do(void);
EXTERN_MEU_PROCESS   void        Level4_4Menu_1Exit(void);

EXTERN_MEU_PROCESS   void        Level4_4Menu_2Enter(void);
EXTERN_MEU_PROCESS   void        Level4_4Menu_2Do(void);
EXTERN_MEU_PROCESS   void        Level4_4Menu_2Exit(void);

EXTERN_MEU_PROCESS   void        Level4_4Menu_3Enter(void);
EXTERN_MEU_PROCESS   void        Level4_4Menu_3Do(void);
EXTERN_MEU_PROCESS   void        Level4_4Menu_3Exit(void);

EXTERN_MEU_PROCESS   void        Level4_4Menu_4Enter(void);
EXTERN_MEU_PROCESS   void        Level4_4Menu_4Do(void);
EXTERN_MEU_PROCESS   void        Level4_4Menu_4Exit(void);

EXTERN_MEU_PROCESS   void        Level4_4Menu_5Enter(void);
EXTERN_MEU_PROCESS   void        Level4_4Menu_5Do(void);
EXTERN_MEU_PROCESS   void        Level4_4Menu_5Exit(void);

EXTERN_MEU_PROCESS   void        Level4_5Menu_1Enter(void);
EXTERN_MEU_PROCESS   void        Level4_5Menu_1Do(void);
EXTERN_MEU_PROCESS   void        Level4_5Menu_1Exit(void);

EXTERN_MEU_PROCESS   void        Level4_5Menu_2Enter(void);
EXTERN_MEU_PROCESS   void        Level4_5Menu_2Do(void);
EXTERN_MEU_PROCESS   void        Level4_5Menu_2Exit(void);

EXTERN_MEU_PROCESS   void        Level_Enter_HMenu_Enter(void);
EXTERN_MEU_PROCESS   void        Level_Enter_HMenu_Do(void);
EXTERN_MEU_PROCESS   void        Level_Enter_HMenu_Exit(void);

EXTERN_MEU_PROCESS   void        Level_Enter_Menu_Enter(void);
EXTERN_MEU_PROCESS   void        Level_Enter_Menu_Do(void);
EXTERN_MEU_PROCESS   void        Level_Enter_Menu_Exit(void);

EXTERN_MEU_PROCESS   void        Level_Return_Menu_Enter(void);
EXTERN_MEU_PROCESS   void        Level_Return_Menu_Do(void);
EXTERN_MEU_PROCESS   void        Level_Return_Menu_Exit(void);

EXTERN_MEU_PROCESS   void        Level2Menu_7Enter(void);               //----Ì¥Ñ¹ÏÔÊ¾Ñ¡Ïî
EXTERN_MEU_PROCESS   void        Level2Menu_7Do(void);
EXTERN_MEU_PROCESS   void        Level2Menu_7Exit(void);

EXTERN_MEU_PROCESS   void        Level2_7Menu_1Enter(void);             //----Ì¥Ñ¹ÏÔÊ¾½çÃæ
EXTERN_MEU_PROCESS   void        Level2_7Menu_1Do(void);
EXTERN_MEU_PROCESS   void        Level2_7Menu_1Exit(void);

EXTERN_MEU_PROCESS   void        Level2_4Menu_AEnter(void);             //----Ì¥Ñ¹ÉèÖÃÑ¡Ïî
EXTERN_MEU_PROCESS   void        Level2_4Menu_ADo(void);
EXTERN_MEU_PROCESS   void        Level2_4Menu_AExit(void);

EXTERN_MEU_PROCESS   void        Level3_4Menu_AEnter(void);             //----Ì¥Ñ¹ÉèÖÃÏÔÊ¾½çÃæ
EXTERN_MEU_PROCESS   void        Level3_4Menu_ADo(void);
EXTERN_MEU_PROCESS   void        Level3_4Menu_AExit(void);

#endif
