/****************************************************************************
 *  License : All rights reserved for TES Electronic Solutions GmbH
 *            See included /docs/license.txt for details
 *  Project : D/AVE HD
 *  Purpose : Simple CPU Pool Memory Manager
 ****************************************************************************
 * Version Control Information :
 *  $Revision: 3935 $
 *  $Date: 2014-09-23 10:52:32 +0200 (Di, 23. Sep 2014) $
 *  $LastChangedBy: golczewskim $
 ****************************************************************************
 * Change History (autogenerated):
 ****************************************************************************/    

#ifndef DAVEHD_KERNEL_POOL_ALLOCATOR_H_INCLUDED
#define DAVEHD_KERNEL_POOL_ALLOCATOR_H_INCLUDED

#include "davehd_types.h"

/*----------------------------------------------------------------------------------------------------------*/
/* all free blocks in the pool use this structure  */

typedef struct tagdhd_gpu_pool_freeblock {
  struct tagdhd_gpu_pool_freeblock *m_next;                 /* next free block*/

} dhd_gpu_pool_freeblock_t;

/*----------------------------------------------------------------------------------------------------------*/
/* control structure for a CPU pool*/

typedef struct tagdhd_gpu_pool {  
  dhd_uint32_t                  m_nodesize;                 /* size of a node in bytes (is always >= sizeof(dhd_gpu_pool_block_t) )*/
  dhd_gpu_pool_freeblock_t     *m_firstfree;                /* first free block (or 0)*/
  dhd_uint32_t                  m_totalsize;                /* size of managed chunk from start of pool in bytes*/

} dhd_gpu_pool_t;

/*----------------------------------------------------------------------------------------------------------*/
/* all used blocks in the pool are preceded by this structure*/

typedef struct tagdhd_gpu_pool_usedblock {
  dhd_gpu_pool_t               *m_pool;                     /* parent pool the block was allocated from  */

} dhd_gpu_pool_usedblock_t;

/*----------------------------------------------------------------------------------------------------------*/
#ifdef DHD_KERNEL_USE_POOLING

dhd_gpu_pool_t *dhd_internal_create_kpool(void *a_memory, dhd_uint32_t  a_size, dhd_uint32_t a_nodesize, dhd_uint32_t a_align);
void *dhd_internal_alloc_kpool(dhd_gpu_pool_t *a_pool);
void dhd_internal_free_kpool(void *a_memory);

#endif
/*----------------------------------------------------------------------------------------------------------*/

#endif /*DAVEHD_KERNEL_POOL_ALLOCATOR_H_INCLUDED*/
