#ifndef _COMMON_INTERFACE_H_
#define _COMMON_INTERFACE_H_

#include "TYW_stdint.h"

/******************************************************************************
K-LINE下线配置
******************************************************************************/
typedef struct
{
    uint32_t Flag       ; /*初始化标记位*/
    // HEX
    uint8_t K_Line_LID20; /* 00 应对ECE R13     //0：非应对、1：应对 */
    uint8_t K_Line_LID21; /* 00 EBS/ABS         //0：无、1：EBS、2：ABS(CAN应对) 3：ABS (CAN非应对) */
    uint8_t K_Line_LID22; /* 00 EVSC            //0：无、1：有 */
    uint8_t K_Line_LID23; /* 00 驻车锁定        //0：无、1：有 */

    uint8_t K_Line_LID24; /* 00 HSA             //0：无、1：有 */
    uint8_t K_Line_LID25; /* 00 AEBS            //0：无、1：有 */
    uint8_t K_Line_LID26; /* 00 ACC             //0：无、1：有 */
    uint8_t K_Line_LID27; /* 00 LDWS            //0：无、1：有 */

    uint8_t K_Line_LID28; /* 00 车辆间报警      //0：无、1：有 */
    uint8_t K_Line_LID29; /* 01 有无巡航        //0：无、1：有          /*初值1*/
    uint8_t K_Line_LID2A; /* 00 气悬            //0：Reef、1：Rear air、2：Full air */
    uint8_t K_Line_LID2B; /* 00 ISS             //0：无、1： eco stop、 2：Idle Stop */

    uint8_t K_Line_LID2C; /* 00 装货台工作警报蜂鸣//0：无、1：有             */
    uint8_t K_Line_LID2D; /* 00 ROWS            //0：无、1：ROWS有、2LOCAL警报有 */
    uint8_t K_Line_LID2E; /* 00 行车记录仪      //0：模拟记录仪、１：数字记录仪或行车记录仪 */
    uint8_t K_Line_LID2F; /* 00 车型            //0：单车、1：拖车、2：全拖车 */

    uint8_t K_Line_LID30; /* 00 缓速器          //0：无、1：有(C&E)、2：有(F) */
    uint8_t K_Line_LID31; /* -- 定速巡航        //0：无、1：有 */
    uint8_t K_Line_LID32; /* 00 装货台种类      //0：一般、1：侧翼、2：倾倒 */
    uint8_t K_Line_LID33; /* 01 SCR?DPD         //0：SCR无/DPD有、1：SCR有/DPD有、2：SCR无/DPD无、3：SCR有/DPD无    /*初值1*/

    uint8_t K_Line_LID34; /* 00 驻车种类        //0：FULL AIR、1：AOH                     /*初值1*/
    uint8_t K_Line_LID35; /* -- 气压计          //0：2针式、1：1针式 */
    uint8_t K_Line_LID36; /* -- 低压警报压      //0：一般输出（539kPa）、1：ADR（588kPa） */
    uint8_t K_Line_LID37; /* -- 超限警报        //0：无、1：有 */

    uint8_t K_Line_LID38; /* -- 速度警报        //0：无、1：有 */
    uint8_t K_Line_LID39; /* 00 可变SLD         //0：无、1：1车速、2：2车速            /*初值1*/
    uint8_t K_Line_LID3A; /* -- OEM             //0：ISZ、1：UDT */
    uint8_t K_Line_LID3B; /* -- 预留 */

    uint8_t K_Line_LID3C; /* -- 预留 */
    uint8_t K_Line_LID3D; /* -- 预留 */
    uint8_t K_Line_LID3E; /* 01 预留            //0：胎压功能未匹配    1：匹配 */
    uint8_t K_Line_LID3F; /* -- 预留 */

    uint8_t K_Line_LID40; /* 00 发动机种类 */
    uint8_t K_Line_LID41; /* 10 变速器种类＆控制                                /*初值50*/
    uint8_t K_Line_LID42; /* 00 驻车管道                                       /*初值 0*/
    uint8_t K_Line_LID43; /* 82 车型                                           /*初值44*/

    uint8_t K_Line_LID44; /* FF 速度警报                                       /*初值FF*/
    uint8_t K_Line_LID45; /* FF 发动机转速                                     /*初值FF*/
    uint8_t K_Line_LID46; /* FF 急加速                                         /*初值FF*/
    uint8_t K_Line_LID47; /* FF 急减速                                         /*初值FF*/

    uint8_t K_Line_LID48; /* FF 长时间怠速                                     /*初值FF*/
    uint8_t K_Line_LID49; /* FF 辅助驻车                                       /*初值FF*/
    uint8_t K_Line_LID4A; /* 32 变速箱油              5000 */
    uint8_t K_Line_LID4B; /* 32 差速器油              5000 */

    uint8_t K_Line_LID4C; /* 32 离合器油 */
    uint8_t K_Line_LID4D; /* 64 动力转向油            10000 */
    uint8_t K_Line_LID4E; /* 78 轮胎                  12000 */
    uint8_t K_Line_LID4F; /* 32 机油＆滤清器          5000 */

    uint8_t K_Line_LID50; /* -- 预留 */
    uint8_t K_Line_LID51; /* 01 工作模式              0-工厂模式  1-通常模式  2-销售模式*/
    uint8_t K_Line_LID52; /* 00 电子部件设定           0-500K    1-250k*/
    uint8_t Reserved0;

    uint8_t Reserved1;
    uint8_t Reserved2;
    uint8_t Reserved3;
    uint8_t Reserved4;

    uint8_t Reserved5;
    uint8_t Reserved6;
    uint8_t Reserved7;
    uint8_t Reserved8;

    uint8_t Reserved9;
    uint8_t ReservedA;
    uint8_t ReservedB;
    uint8_t ReservedC;
} _EOL_K_LINE_SET;

extern _EOL_K_LINE_SET K_Line_Set;

extern void Common_DataInit(void);
extern void Common_Input_Para(void);

COMMON_PowerStatus_t Common_Get_IG_Sts(void);
DataValid_t Common_Get_IG_Sts_Valid(void);

void Common_Set_IG_Sts(COMMON_PowerStatus_t Val);
void Common_Set_IG_Sts_Valid(DataValid_t Val);

extern uint16_t Common_Get_Act_V_Speed(void);
extern uint16_t Common_Get_Act_E_Speed(void);
extern uint16_t Common_Get_Disp_V_Speed(void);
extern uint16_t Common_Get_Disp_E_Speed(void);
extern uint8_t Common_Get_OverSpeed_Status(void); /*获取超速报警状态*/
extern uint8_t Common_Get_OverSpeedLine_Status(void);

extern DataValid_t Common_Get_Act_V_Speed_Valid(void);
extern DataValid_t Common_Get_Act_E_Speed_Valid(void);
extern DataValid_t Common_Get_Disp_V_Speed_Valid(void);
extern DataValid_t Common_Get_Disp_E_Speed_Valid(void);

uint32_t Common_GetIgnOnTime(void);  /*ms*/
uint32_t Common_GetIgnOffTime(void); /*ms*/

void Common_RollingCounterAdd(void);
void Common_RollingCounterClear(void);
void Common_BlockDelay(uint16_t m_MS);
uint16_t Common_ReadRollingCounter(void);

void Set_Can18FF5510_FirstRecv_Event(void);
void Set_Can18FF2300_FirstRecv_Event(void);
uint8_t Get_CanFirstRecv_Event(uint8_t ID);

uint8_t Common_Get_Cruise_TimeSta(void);
uint8_t Common_Get_Cruise_SLD_TimeSta(void);

uint8_t Common_Get_VolWarning_Sta(void);
uint8_t Common_Get_HIGH_VOLTAGE (void);
uint8_t Common_Get_LOW_VOLTAGE (void);
uint8_t Common_Get_FDJYLQQ_Sta (void);
uint8_t Common_Get_RYLQQ_Sta (void);
uint8_t Common_Get_BSXY_Sta (void);
uint8_t Common_Get_CSQY_Sta (void);
uint8_t Common_Get_LHQY_Sta (void);
uint8_t Common_Get_KQGZJ_Sta (void);
uint8_t Common_Get_DLZXY_Sta (void);
uint8_t Common_Get_LT_Sta (void);

void ReadDTCEOLValue_Meter_K_LINE(void);
void K_LINE_EOL_InitVal(void);

#endif
