#ifndef _TELLTALES_H_
#define _TELLTALES_H_

#include "TYW_stdint.h"
#include "string.h"
#include "RTE_BASE_TYPE.h"

typedef enum
{
    em_LED_INTER_DIFF_LOCK_T,
    em_LED_FOUR_MUL_FOUR_T,
    em_LED_EXH_BRAKE_T,
    em_LED_QOS_GLOW_T,
    em_LED_HI_BEAM_T,
    em_LED_Rr_FOG_LAMP_T,
    em_LED_MIL_T,
    em_LED_SVS_T,
    em_LED_H_S_A__T,
    em_LED_RETARDER_T,
    em_LED_AUTO_LEVELING_T,
    em_LED_ROWS_L,
    em_LED_BSM_OFF_L,
    em_LED_AEBS_OFF_L,
    em_LED_LDWS_L,
    em_LED_SRS_L,
    em_LED_ENG_OIL_L,
    em_LED_CHARG_L,
    em_LED_SEAT_BELT_L,
    em_LED_RR_DIFF_LOCK_L,
    em_LED_TPMS_L,
    em_LED_ASR_or_EVSC_OFF_L,
    em_LED_EVSC_L,
    em_LED_eco_stop_OFF_L,
    em_LED_AMT_L,
    em_LED_WEAR_IND_L,
    em_LED_TRAILER_BRAKE_R,
    em_LED_BRAKE_AIR_or_EBS_YELLOW_R,
    em_LED_ACC_AIR_R,
    em_LED_ABS_R,
    em_LED_PARK_BRAKE_R,
    em_LED_BRAKE_AIR_or_EBS_RED_R,
    em_LED_BRAKE_LOCK_R,
    em_LED_AIR_SUS_R,
    em_LED_TRAILER_ABS_U,
    em_LED_WORKING_LAMP_U,
    em_LED_TRAILER_ABS_INFO_U,
    em_LED_TEMP,
    em_LED_FUEL,

    LED_Max,
} LED_Idx_t;

typedef uint8_t (*LED_Judgment)(void);
typedef void (*LED_Execution)(uint8_t led_status);

typedef struct
{
    LED_Idx_t LED_Index;
    SelfCheck_t isSelfCheck;
    ExtCheck_t isExCheck;
    WorkStatus_t WorkSts;

    uint32_t CheckStart;
    uint32_t CheckEnd;

    LED_Judgment LED_Judgment_Cbk;
    LED_Execution LED_Execution_Cbk;
} LED_Attribute_st;

typedef struct
{
    PowerStatus_t IG_Status;
    Checktatus_t LED_CheckFinish;
    uint32_t IG_ON_Timer;
    uint32_t IG_OFF_Timer;
} ExternalPara_st;

typedef struct
{
    uint8_t LastLeft;
    uint8_t LastRight;
    uint8_t Delay;
} TelltaleLRCtrlStruct;

extern const LED_Attribute_st LED_Attribute[LED_Max];

void Telltales_SetPara(ExternalPara_st *Para);
void Telltales_Management(void); /*50ms*/
void Telltales_Left_Right_KL30_Init(void);
void Telltales_Left_Right_Management_Service(void); /*must put into 10ms task*/
void Telltales_IG_ON_Work(void);
void Telltales_IGOFF_Work(void);
void Test_LED_AllLight(void);

void Telltales_Wakeup_Init(void);
void Telltales_KL30_Init(void);
void Telltales_KL15_Init(void);

void LED_RIGHT_G_Execution(uint8_t led_status);
void LED_LEFT_G_Execution(uint8_t led_status);
uint8_t LED_RIGHT_G_Judgement(void);
uint8_t LED_LEFT_G_Judgement(void);

void Write_LED_POSITION_G(uint8_t led_status);
uint8_t GET_LED_POSITION_G(void);

void Write_LED_READY_G_Execution(uint8_t led_status);
uint8_t GET_LED_READY_G_Execution(void);

/*ZH:*/
/*LED点灯条件判别函数*/
uint8_t LED_INTER_DIFF_LOCK_T_Judgement(void);
uint8_t LED_FOUR_MUL_FOUR_T_Judgement(void);
uint8_t LED_EXH_BRAKE_T_Judgement(void);
uint8_t LED_QOS_GLOW_T_Judgement(void);
uint8_t LED_HI_BEAM_T_Judgement(void);
uint8_t LED_Rr_FOG_LAMP_T_Judgement(void);
uint8_t LED_MIL_T_Judgement(void);
uint8_t LED_SVS_T_Judgement(void);
uint8_t LED_H_S_A_T_Judgement(void);
uint8_t LED_RETARDER_T_Judgement(void);
uint8_t LED_AUTO_LEVELING_T_Judgement(void);
uint8_t LED_ROWS_L_Judgement(void);
uint8_t LED_BSM_OFF_L_Judgement(void);
uint8_t LED_AEBS_OFF_L_Judgement(void);
uint8_t LED_LDWS_L_Judgement(void);
uint8_t LED_SRS_L_Judgement(void);
uint8_t LED_ENG_OIL_L_Judgement(void);
uint8_t LED_CHARG_L_Judgement(void);
uint8_t LED_SEAT_BELT_L_Judgement(void);
uint8_t LED_RR_DIFF_LOCK_L_Judgement(void);
uint8_t LED_TPMS_L_Judgement(void);
uint8_t LED_ASR_or_EVSC_OFF_L_Judgement(void);
uint8_t LED_EVSC_L_Judgement(void);
uint8_t LED_eco_stop_OFF_L_Judgement(void);
uint8_t LED_AMT_L_Judgement(void);
uint8_t LED_WEAR_IND_L_Judgement(void);
uint8_t LED_TRAILER_BRAKE_R_Judgement(void);
uint8_t LED_BRAKE_AIR_or_EBS_YELLOW_R_Judgement(void);
uint8_t LED_ACC_AIR_R_Judgement(void);
uint8_t LED_ABS_R_Judgement(void);
uint8_t LED_PARK_BRAKE_R_Judgement(void);
uint8_t LED_BRAKE_AIR_or_EBS_RED_R_Judgement(void);
uint8_t LED_BRAKE_LOCK_R_Judgement(void);
uint8_t LED_AIR_SUS_R_Judgement(void);
uint8_t LED_TRAILER_ABS_U_Judgement(void);
uint8_t LED_WORKING_LAMP_U_Judgement(void);
uint8_t LED_TRAILER_ABS_INFO_U_Judgement(void);
uint8_t LED_Temp_Judgement(void);
uint8_t LED_Fuel_Judgement(void);

/*LED执行函数*/
void LED_Left_Right_Execution(void);
void LED_INTER_DIFF_LOCK_T_Execution(uint8_t led_status);
void LED_FOUR_MUL_FOUR_T_Execution(uint8_t led_status);
void LED_EXH_BRAKE_T_Execution(uint8_t led_status);
void LED_QOS_GLOW_T_Execution(uint8_t led_status);
void LED_HI_BEAM_T_Execution(uint8_t led_status);
void LED_Rr_FOG_LAMP_T_Execution(uint8_t led_status);
void LED_MIL_T_Execution(uint8_t led_status);
void LED_SVS_T_Execution(uint8_t led_status);
void LED_H_S_A_T_Execution(uint8_t led_status);
void LED_RETARDER_T_Execution(uint8_t led_status);
void LED_AUTO_LEVELING_T_Execution(uint8_t led_status);
void LED_ROWS_L_Execution(uint8_t led_status);
void LED_BSM_OFF_L_Execution(uint8_t led_status);
void LED_AEBS_OFF_L_Execution(uint8_t led_status);
void LED_LDWS_L_Execution(uint8_t led_status);
void LED_SRS_L_Execution(uint8_t led_status);
void LED_ENG_OIL_L_Execution(uint8_t led_status);
void LED_CHARG_L_Execution(uint8_t led_status);
void LED_SEAT_BELT_L_Execution(uint8_t led_status);
void LED_RR_DIFF_LOCK_L_Execution(uint8_t led_status);
void LED_TPMS_L_Execution(uint8_t led_status);
void LED_ASR_or_EVSC_OFF_L_Execution(uint8_t led_status);
void LED_EVSC_L_Execution(uint8_t led_status);
void LED_eco_stop_OFF_L_Execution(uint8_t led_status);
void LED_AMT_L_Execution(uint8_t led_status);
void LED_WEAR_IND_L_Execution(uint8_t led_status);
void LED_TRAILER_BRAKE_R_Execution(uint8_t led_status);
void LED_BRAKE_AIR_or_EBS_YELLOW_R_Execution(uint8_t led_status);
void LED_ACC_AIR_R_Execution(uint8_t led_status);
void LED_ABS_R_Execution(uint8_t led_status);
void LED_PARK_BRAKE_R_Execution(uint8_t led_status);
void LED_BRAKE_AIR_or_EBS_RED_R_Execution(uint8_t led_status);
void LED_BRAKE_LOCK_R_Execution(uint8_t led_status);
void LED_AIR_SUS_R_Execution(uint8_t led_status);
void LED_TRAILER_ABS_U_Execution(uint8_t led_status);
void LED_WORKING_LAMP_U_Execution(uint8_t led_status);
void LED_TRAILER_ABS_INFO_U_Execution(uint8_t led_status);
void LED_Temp_Execution(uint8_t led_status);
void LED_Fuel_Execution(uint8_t led_status);
/*:ZH*/

#endif
