

#include "PowerManagement.h"

static Power_Status_t  g_Power_St ;          /*当前实际电源状态*/


void Power_Management_Init ( uint8_t u8InitFlag )
{
    if (u8InitFlag == 1u)
    {
        g_Power_St = Power_Wakeup_Init();
    }
    else
    {
        g_Power_St = Power_KL30_Init();
    }
}



void Power_Management_Service ( void )
{
    switch ( g_Power_St )
    {
    case m_IGN_OFF_Init:
        Power_IG_OFF_Init();
        g_Power_St = m_IGN_OFF;
        break;
    case m_IGN_OFF:
        g_Power_St = Power_Stay_OFF();
        break;
    case m_IGN_Sleep_Init:
        Power_Sleep_Init();
        g_Power_St = m_IGN_Sleep;
        break;
    case m_IGN_Sleep:
        g_Power_St = Power_Stay_Sleep();
        break;
    case m_IGN_ON_Init:
        Power_IG_ON_Init();
        g_Power_St = m_IGN_ON;
        break;
    case m_IGN_ON:
        g_Power_St = Power_Stay_ON();
        break;
    case m_IGN_LIMIT:
        g_Power_St = Power_Stay_Protect();
        break;
    default:
        g_Power_St = m_IGN_OFF_Init;
        break;
    }
}





