#include "RTE_CAN_NM.h"
#include "None_NM.h"
#include "RTE_CAN.h"
#include "Rscan.h"
static uint8_t CAN_APP_MSG_RX_ENABLE;
static uint8_t CAN_APP_MSG_TX_ENABLE;

static uint8_t CAN_NM_MSG_RX_ENABLE;
static uint8_t CAN_NM_MSG_TX_ENABLE;

static uint8_t CAN_BUS_Status;
static uint8_t CAN_NM_MODE_Status;

void RTE_CAN_NM_Init(void)
{
    CAN_APP_MSG_RX_ENABLE = 0X00U;
    CAN_APP_MSG_TX_ENABLE = 0X55U;

    CAN_NM_MSG_RX_ENABLE = 0X00U;
    CAN_NM_MSG_TX_ENABLE = 0X55U;

    CAN_NM_MODE_Status = 0X00U;

    Can_Init();
    None_NM_Init();
}

void RTE_CAN_NM_Process(void)
{
    None_NM_Service();
}

void RTE_CAN_NM_Request(uint8_t RequestReason)
{
    None_NM_Request();
}

void RTE_CAN_NM_Release(uint8_t ReleaseReason)
{
    None_NM_Release();
}

uint8_t RTE_CAN_NM_GetStatus(void)
{
    uint8_t Ret;
    Ret = None_NM_Mode();
    return Ret;
}

uint8_t RTE_CAN_NM_MODE_GetStatus(void)
{
    uint8_t Ret;

    Ret = CAN_NM_MODE_Status;

    return Ret;
}



void RTE_CAN_SetAPP_TX_Mode(uint8_t u8Status)
{
    CAN_APP_MSG_TX_ENABLE = u8Status;
}
void RTE_CAN_SetAPP_RX_Mode(uint8_t u8Status)
{
    CAN_APP_MSG_RX_ENABLE = u8Status;
}

uint8_t RTE_CAN_GetAPP_RX_Mode(void)
{
    uint8_t ret;
    ret = CAN_APP_MSG_RX_ENABLE;
    return ret;
}
uint8_t RTE_CAN_GetAPP_TX_Mode(void)
{
    uint8_t ret;
    ret = CAN_APP_MSG_TX_ENABLE;
    return ret;
}

void RTE_CAN_SetNM_TX_Mode(uint8_t u8Status)
{
    CAN_NM_MSG_TX_ENABLE = u8Status;
}
void RTE_CAN_SetNM_RX_Mode(uint8_t u8Status)
{
    CAN_NM_MSG_RX_ENABLE = u8Status;
}

uint8_t RTE_CAN_GetNM_RX_Mode(void)
{
    uint8_t ret;
    ret = CAN_NM_MSG_RX_ENABLE;
    return ret;
}
uint8_t RTE_CAN_GetNM_TX_Mode(void)
{
    uint8_t ret;
    ret = CAN_NM_MSG_TX_ENABLE;
    return ret;
}

uint8_t RTE_CAN_GetBusStatus(void)
{
    uint8_t m_condition;
    uint8_t ret;
    //m_condition = Get_CH0_RecStatus();
    m_condition = RSCAN0_CH0_Get_Rec_Status();
    if (m_condition == 1u) /*总线有报文 在接收状态*/
    {
        ret = 1u;
    }
    else /* 总线无报文 */
    {
        ret = 0u;
    }
    return ret;
}