#include "LED_Driver.h"
#include "GPIO.h"
#include <string.h>

/*注意需将u8LEDDriverRamData定义在休眠唤醒后不会被清空的RAM区域*/
LED_Driver_uint8_t u8LEDDriverRamData[LED_DRIVER_RAM_LEN];

const LED_Driver_uint8_t u8AW21036ChipAddress[LED_DRIVER_CHIP_NUM] = {

#if (LED_DRIVER_CHIP_NUM >= 1U)
	AW21036_CHIP1_ADDRESS,
#endif

#if (LED_DRIVER_CHIP_NUM >= 2U)
	AW21036_CHIP2_ADDRESS,
#endif

#if (LED_DRIVER_CHIP_NUM >= 3U)
	AW21036_CHIP3_ADDRESS,
#endif

#if (LED_DRIVER_CHIP_NUM >= 4U)
	AW21036_CHIP4_ADDRESS,
#endif

};

const LED_Driver_uint8_t u8IS31ChipAddress[LED_DRIVER_CHIP_NUM] = {

#if (LED_DRIVER_CHIP_NUM >= 1U)
	IS31_CHIP1_ADDRESS,
#endif

#if (LED_DRIVER_CHIP_NUM >= 2U)
	IS31_CHIP2_ADDRESS,
#endif

#if (LED_DRIVER_CHIP_NUM >= 3U)
	IS31_CHIP3_ADDRESS,
#endif

#if (LED_DRIVER_CHIP_NUM >= 4U)
	IS31_CHIP4_ADDRESS,
#endif

};

/*设置shutdown引脚*/
void LED_Driver_Shutdown_Pin_Set(LED_Driver_uint8_t u8Level)
{
	SDB_LED_DRIVER = u8Level;
}

GPIO_Config_st_t YZHDstGPIOConfig1;
void LED_Driver_Init(void)
{
    uint8_t i=0;
	LED_Driver_Par_st_t stLEDDriverPar;
/*
	YZHDstGPIOConfig1.enGPIOPort = GPIO_PORT_GROUP_42;
	YZHDstGPIOConfig1.enGPIOPIN = GPIO_PIN_0;
	YZHDstGPIOConfig1.enGPIODrive = GPIO_Drive_Slow;
	YZHDstGPIOConfig1.enGPIOCharacter = GPIO_Char_CMOS1;
	YZHDstGPIOConfig1.enGPIOPull = GPIO_PULL_NONE;
	YZHDstGPIOConfig1.enGPIOOutputValue = GPIO_Level_Low;
	YZHDstGPIOConfig1.enGPIOMode = GPIO_MODE_PORT;
	YZHDstGPIOConfig1.enGPIODir = GPIO_DIR_OUT;
	YZHDstGPIOConfig1.enGPIOAltFun = GPIO_ALTER_FUN_1;
	GPIO_Config(&YZHDstGPIOConfig1);
	YZHDstGPIOConfig1.enGPIOPort = GPIO_PORT_GROUP_42;
	YZHDstGPIOConfig1.enGPIOPIN = GPIO_PIN_1;
	GPIO_Config(&YZHDstGPIOConfig1);
	YZHDstGPIOConfig1.enGPIOPort = GPIO_PORT_GROUP_42;
	YZHDstGPIOConfig1.enGPIOPIN = GPIO_PIN_2;
	GPIO_Config(&YZHDstGPIOConfig1);
	*/

	stLEDDriverPar.pfnLEDDriverShutdownPinSetCallBack = LED_Driver_Shutdown_Pin_Set;
	stLEDDriverPar.u8LEDDriverChipNum = LED_DRIVER_CHIP_NUM;
	stLEDDriverPar.pu8IS31ChipAddress = u8IS31ChipAddress;
	stLEDDriverPar.pu8AW21036ChipAddress = u8AW21036ChipAddress;
	memset(u8LEDDriverRamData, 0, sizeof(u8LEDDriverRamData));
	Simulated_IIC_2_Init();
	LED_Driver_Init_KL30(u8LEDDriverRamData, &stLEDDriverPar);


}
