/****************************************************************************
 *  License : All rights reserved for TES Electronic Solutions GmbH
 *            See included /docs/license.txt for details
 *  Project : D/AVE HD
 *  Purpose : Kernel Mode representation of each User Mode client connection
 ****************************************************************************
 * Version Control Information :
 *  $Revision: 4771 $
 *  $Date: 2015-02-10 12:01:30 +0100 (Di, 10. Feb 2015) $
 *  $LastChangedBy: florian.zimmermann $
 ****************************************************************************
 * Change History (autogenerated):
 ****************************************************************************/    

#ifndef DAVEHD_KERNEL_CLIENT_H_INCLUDED
#define DAVEHD_KERNEL_CLIENT_H_INCLUDED

#include "davehd_kernel_driver.h"

/*----------------------------------------------------------------------------------------------------------*/

#define DHD_REG_COUNT_BITS (( DHD_REG_COUNT + sizeof(dhd_uint32_t) - 1 ) / sizeof(dhd_uint32_t))  /* number of uint32's for pending mask*/
#define DHD_GPU_STATE_GROUPS    9                                       /* number of register groups in a statestore*/
#define DHD_GPU_RESTORE_SIZE    4                                       /* number of commands in a restore job call*/
#define DHD_GPU_STORE_SIZE     (1 + (DHD_GPU_STATE_GROUPS * 3) + 3)     /* wait + one dump per group + one extra dump for splits*/

/*----------------------------------------------------------------------------------------------------------*/

typedef struct tagdhd_gpu_connection {
  struct tagdhd_gpu_connection     *m_next;                             /* linked list of clients*/
  dhd_uint32_t                      m_sizeof;                           /* struct id*/
  dhd_uint32_t                      m_hw_instance;                      /* associated hw instance*/
  dhd_uint32_t                      m_used_memory;                      /* currently used video memory*/
  dhd_uint32_t                      m_used_clutblocks;                  /* bitmask of used clut blocks (see instance for blocksize)*/
  dhd_uint16_t                      m_priority;                         /* schedule priority (can not be 0)*/
  dhd_uint32_t                      m_last_scheduled;                   /* iteration index this client has been scheduled last*/
  struct tagdhd_gpu_statestore     *m_statestore;                       /* saved gpu state (use for context switching)*/

#ifdef DHD_KERNEL_TLIST_SUPPORT
  dhd_tlist_t                       m_tlist;
#endif

} dhd_gpu_connection_t;

struct tagdhd_cmdlist;

/*----------------------------------------------------------------------------------------------------------*/

typedef struct tagdhd_gpu_job {  
  struct tagdhd_gpu_job   *m_next;                                      /* used for chaining jobs internally    */
  struct tagdhd_gpu_job   *m_cmdlist_next;                              /* used for chaining jobs for command list recording*/
  dhd_uint32_t             m_size;                                      /* size of job in bytes*/
  dhd_uint32_t             m_assigned_id;                               /* jobid*/
  dhd_vidmem_t             m_memory;                                    /* job memory*/
  dhd_uint8_t             *m_userdata;                                  /* job specific data not used by kernel*/
  dhd_gpu_connection_t    *m_sender;                                    /* client that committed the job */
  dhd_uint32_t             m_active_pfcs;                               /* set bit for each performance counter to be enabled*/
  dhd_uint32_t             m_generation;                                /* incremented when job is reused. initially 0*/
  dhd_bool_t               m_cmdlist_job;                               /* flag is 1 when job is a command list job, 0 is default*/
  struct tagdhd_cmdlist   *m_cmdlist;                                   /* associated cmdlist, only valid when m_cmdlist_job is true*/

} dhd_gpu_job_t;

/*----------------------------------------------------------------------------------------------------------*/
/* Control struct for command lists.*/
/**/
typedef enum taghd_cmdlist_state {
  E_DHD_CMDLIST_EMPTY = 0,                        /* Default command list state: dhd_cmdlist_create called*/
  E_DHD_CMDLIST_RECORDING,                        /* Command list state: dhd_cmdlist_begin called*/
  E_DHD_CMDLIST_READY,                            /* Command list state: dhd_cmdlist_end called*/
  E_DHD_CMDLIST_EXECUTED,                         /* Command list state: dhd_cmdlist_exec called*/

} dhd_cmdlist_state_t;

/*----------------------------------------------------------------------------------------------------------*/
/* Control struct for command lists.*/
/**/
typedef struct tagdhd_cmdlist {
  struct tagdhd_gpu_job  *m_orig_active_job;      /* backup of original active job pointer which was valid before recording a command list*/
  dhd_uint32_t           *m_orig_write_pos;       /* backup of original write pos pointer which was valid before recording a command list*/
  dhd_uint32_t            m_orig_free_words;      /* backup of original free words counter which was valid before recording a command list*/
  dhd_uint32_t            m_job_count;            /* number of jobs in the command list*/
  dhd_uint32_t            m_job_size;             /* size in bytes of all jobs in the command list*/
  struct tagdhd_gpu_job  *m_job_start;            /* pointer to first job of the command list*/
  struct tagdhd_gpu_job  *m_job_end;              /* pointer to the last job of the command list*/
  struct tagdhd_gpu_job  *m_job_current;          /* pointer to current job of the command list*/
  dhd_cmdlist_state_t     m_state;                /* current command list state*/
  dhd_uint32_t            m_last_jobgen;          /* generation of last executed job from the command list*/
  dhd_jobid_t             m_last_jobid;           /* id of last executed job from the command list*/

} dhd_cmdlist_t;

/*----------------------------------------------------------------------------------------------------------*/

typedef struct tagdhd_gpu_statestore {
  dhd_vidmem_t            m_memory;                                     /* stream memory storing the state as stream   */
  dhd_uint32_t            m_storecode[ DHD_GPU_STORE_SIZE ];            /* series of dump commands to store into m_memory*/
  dhd_uint32_t            m_restorecode[ DHD_GPU_RESTORE_SIZE ];        /* single call into m_memory to restore*/
  dhd_uint8_t             m_texu_count;                                 /* texture unit count*/
  dhd_uint8_t             m_colu_count;                                 /* color unit count*/
  dhd_uint8_t             m_ccol_count;                                 /* constant color count*/
} dhd_gpu_statestore_t;


/*----------------------------------------------------------------------------------------------------------*/

dhd_enum_t dhd_gpu_init_connection(dhd_gpu_device_data_t *a_device, dhd_gpu_connection_t *a_client);

dhd_enum_t dhd_gpu_close_connection(dhd_gpu_device_data_t *a_device, dhd_gpu_connection_t *a_client);



/*----------------------------------------------------------------------------------------------------------*/

#endif /*DAVEHD_KERNEL_CLIENT_H_INCLUDED*/
