/****************************************************************************
 *  License : All rights reserved for TES Electronic Solutions GmbH
 *            See included /docs/license.txt for details
 *  Project : D/AVE HD
 *  Purpose : Command list functions
 ****************************************************************************
 * Version Control Information :
 *  $Revision: 7861 $
 *  $Date: 2016-03-03 10:42:24 +0100 (Do, 03. Mrz 2016) $
 *  $LastChangedBy: dennis.ostermann $
 ****************************************************************************
 * Change History (autogenerated):
 ****************************************************************************/    

#ifndef DAVEHD_CMDLIST_H_INCLUDED
#define DAVEHD_CMDLIST_H_INCLUDED

#include "davehd_types.h"
#include "davehd_settings.h"
#include "davehd_kernel_client.h"

/*----------------------------------------------------------------------------------------------------------*/
/* Control struct for jobs in a flat command list*/
/**/
typedef struct taghd_cmdlist_job {
  dhd_uint32_t            m_size;                 /* Size of a job (used bytes)*/

} dhd_cmdlist_job_t;

/*----------------------------------------------------------------------------------------------------------*/
/* Control struct for serialized command lists.*/
/**/
typedef struct tagdhd_cmdlist_serial {
  dhd_uint32_t            m_job_count;            /* number of jobs in the command list*/
  struct tagdhd_gpu_job  *m_job_start;            /* relocation address*/
  dhd_uint32_t            m_job_size;             /* default job size*/

} dhd_cmdlist_serial_t;

/* Ensure that the serializied cmdlist header and the cmdlist jobs preserve correct alignment for*/
/* the following GPU commands.*/
#if defined(__ghs__)
#pragma ghs nowarning 301
#endif /*defined(__ghs__)*/
DHD_CASSERT( ((sizeof( dhd_cmdlist_serial_t )&3u) == 0), CMDLIST_SERIAL_UNALIGNED_SIZE )
DHD_CASSERT( ((sizeof( dhd_cmdlist_job_t )&3u) == 0), CMDLIST_JOB_UNALIGNED_SIZE )
#if defined(__ghs__)
#pragma ghs endnowarning
#endif /*defined(__ghs__)*/

/*----------------------------------------------------------------------------------------------------------*/

struct tagdhd_gpu_job *dhd_alloc_cmdlist_job(dhd_cmdlist_t *a_cmdlist);
void dhd_cmdlist_return_job(dhd_gpu_job_t *a_job);

/*----------------------------------------------------------------------------------------------------------*/

#endif /*DAVEHD_CMDLIST_H_INCLUDED*/
