#ifndef _COMMON_INTERFACE_H_
#define _COMMON_INTERFACE_H_

#include "TYW_stdint.h"

extern void Common_DataInit(void);
extern void Common_Input_Para(void);

COMMON_PowerStatus_t Common_Get_IG_Sts(void);
DataValid_t Common_Get_IG_Sts_Valid(void);

void Common_Set_IG_Sts(COMMON_PowerStatus_t Val);
void Common_Set_IG_Sts_Valid(DataValid_t Val);

extern uint16_t Common_Get_Act_V_Speed(void);
extern uint16_t Common_Get_Act_E_Speed(void);
extern uint16_t Common_Get_Disp_V_Speed(void);
extern uint16_t Common_Get_Disp_E_Speed(void);
extern uint8_t Common_Get_OverEpeed_Status(void);
extern uint8_t Common_Get_OverSpeed_Status(void); /*获取超速报警状态*/
extern uint8_t Common_Get_OverSpeedLine_Status(void);

extern DataValid_t Common_Get_Act_V_Speed_Valid(void);
extern DataValid_t Common_Get_Act_E_Speed_Valid(void);
extern DataValid_t Common_Get_Disp_V_Speed_Valid(void);
extern DataValid_t Common_Get_Disp_E_Speed_Valid(void);

uint32_t Common_GetIgnOnTime(void);  /*ms*/
uint32_t Common_GetIgnOffTime(void); /*ms*/

void Common_RollingCounterAdd(void);
void Common_RollingCounterClear(void);
//void Common_BlockDelay(uint16_t m_MS);
uint16_t Common_ReadRollingCounter(void);

void Set_Can18FF5510_FirstRecv_Event(void);
void Set_Can18FF2300_FirstRecv_Event(void);
uint8_t Get_CanFirstRecv_Event(uint8_t ID);

uint8_t Common_Get_Cruise_TimeSta(void);
uint8_t Common_Get_Cruise_SLD_TimeSta(void);

uint8_t Common_Get_VolWarning_Sta(void);
uint8_t Common_Get_HIGH_VOLTAGE (void);
uint8_t Common_Get_LOW_VOLTAGE (void);
uint8_t Common_Get_FDJYLQQ_Sta (void);
uint8_t Common_Get_RYLQQ_Sta (void);
uint8_t Common_Get_BSXY_Sta (void);
uint8_t Common_Get_CSQY_Sta (void);
uint8_t Common_Get_LHQY_Sta (void);
uint8_t Common_Get_KQGZJ_Sta (void);
uint8_t Common_Get_DLZXY_Sta (void);
uint8_t Common_Get_LT_Sta (void);

void Common_Set_Menu_FacDea_Time_Sta(uint32_t Value);
uint32_t Common_Get_Menu_FacDea_Time_Sta(void);
uint8_t Common_Get_TPMS_TEST_OFF_Time_Sta(void);
uint32_t Coom_Get_Menu_Off_Time(void);
void Coom_Set_Menu_Off_MenuTime(uint32_t val);
uint32_t Coom_Get_Menu_Off_MenuTime(void);

void Common_Set_18EF1718_Msg_Sta(void);
DataValid_t Common_Get_18EF1718_Msg_Sta(void);

void ReadDTCEOLValue_Meter_K_LINE(void);
void Common_Set_K_Line_Value(void);

void Common_Set_UdsCanIDSta(uint32_t Val);
uint32_t Common_Get_UdsCanIDSta(void);
uint32_t Common_Get_OIL_PRESSURE_Time(void);

void Common_Set_Can_Engine_Oil_Num(uint32_t Val);
uint32_t Common_Get_Can_Engine_Oil_Num(void);

#endif
