/****************************************************************************
 *  License : All rights reserved for TES Electronic Solutions GmbH
 *            See included /docs/license.txt for details
 *  Project : D/AVE HD
 *  Purpose : Pixel Selection (PSU) related inline functions
 ****************************************************************************
 * Version Control Information :
 *  $Revision: 4771 $
 *  $Date: 2015-02-10 12:01:30 +0100 (Di, 10. Feb 2015) $
 *  $LastChangedBy: florian.zimmermann $
 ****************************************************************************
 * Change History (autogenerated):
 ****************************************************************************/    

#ifndef DAVEHD_DRIVER_PSU_INL_H_INCLUDED
#define DAVEHD_DRIVER_PSU_INL_H_INCLUDED

/* PRQA S 3406 ++ *//* $Misra: #INLINE_FUNCTION_DEFINED_IN_HEADER $*/

/*----------------------------------------------------------------------------------------------------------*/
/* Specify bounding box. When rendering directly (using dhd_draw) the bounding box has to be set up manually*/
/* using this function. When using dhd_draw_array, the bounding box may be set automatically for each*/
/* primitive. All borders are inclusive. Note that the enumeration will start at the screenspace */
/* position (boundingbox.xmin, ystart). Edges should be set up relative to this point.*/
/**/
/* Parameters:*/
/*  a_device : Driver context handle (as returned by dhd_init)*/
/*  a_xmin : Left bounding box border in screenspace*/
/*  a_ymin : Top bounding box border in screenspace*/
/*  a_xmax : Right bounding box border in screenspace*/
/*  a_ymax : Bottom bounding box border in screenspace*/
/*  a_ystart : Ystart position in screenspace*/
/**/
DHD_API_INLINE void dhd_set_bbox(dhd_handle_t a_device, dhd_uint32_t a_xmin, dhd_uint32_t a_ymin, dhd_uint32_t a_xmax, dhd_uint32_t a_ymax, dhd_uint32_t a_ystart ) {
  dhd_device_data_t *device = dhd_get_device( a_device );

  device->m_shadow_state.m_named.m_psu_lim_bbox_min.m_fields.m_lim_bbox_xmin = a_xmin;
  device->m_shadow_state.m_named.m_psu_lim_bbox_min.m_fields.m_lim_bbox_ymin = a_ymin;
  device->m_shadow_state.m_named.m_psu_lim_bbox_max.m_fields.m_lim_bbox_xmax = a_xmax;
  device->m_shadow_state.m_named.m_psu_lim_bbox_max.m_fields.m_lim_bbox_ymax = a_ymax;
  device->m_shadow_state.m_named.m_psu_lim_start.m_fields.m_lim_start_y = a_ystart;

  device->m_pending_mask.m_named.m_psu_lim_bbox_min = 1;
  device->m_pending_mask.m_named.m_psu_lim_bbox_max = 1;
  device->m_pending_mask.m_named.m_psu_lim_start = 1;
}

/*----------------------------------------------------------------------------------------------------------*/
/* Get bounding box. Retrieve the last manually specified bounding box (see dhd_set_bbox for details).*/
/* Passing a null pointer indicates that a specific information is not requested. */
/**/
/* Parameters:*/
/*  a_device : Driver context handle (as returned by dhd_init)*/
/*  a_xmin : Pointer to dhd_uint32_t that will receive left bounding box border (can be null)*/
/*  a_ymin : Pointer to dhd_uint32_t that will receive top bounding box border (can be null)*/
/*  a_xmax : Pointer to dhd_uint32_t that will receive right bounding box border (can be null)*/
/*  a_ymax : Pointer to dhd_uint32_t that will receive bottom bounding box border (can be null)*/
/*  a_ystart : Pointer to dhd_uint32_t that will receive Ystart position (can be null)*/
/* */
/* See Also:*/
/*  dhd_set_bbox*/
DHD_API_INLINE void dhd_get_bbox(dhd_handle_t a_device, dhd_uint32_t *a_xmin, dhd_uint32_t *a_ymin, dhd_uint32_t *a_xmax, dhd_uint32_t *a_ymax, dhd_uint32_t *a_ystart) {
  dhd_device_data_t *device = dhd_get_device( a_device );

  if (a_xmin != 0) {
    *a_xmin = device->m_shadow_state.m_named.m_psu_lim_bbox_min.m_fields.m_lim_bbox_xmin;
  }
  if (a_ymin != 0) {
    *a_ymin = device->m_shadow_state.m_named.m_psu_lim_bbox_min.m_fields.m_lim_bbox_ymin;
  }
  if (a_xmax != 0) {
    *a_xmax = device->m_shadow_state.m_named.m_psu_lim_bbox_max.m_fields.m_lim_bbox_xmax;
  }
  if (a_ymax != 0) {
    *a_ymax = device->m_shadow_state.m_named.m_psu_lim_bbox_max.m_fields.m_lim_bbox_ymax;
  }
  if (a_ystart != 0) {
    *a_ystart = device->m_shadow_state.m_named.m_psu_lim_start.m_fields.m_lim_start_y;
  }
}

/*----------------------------------------------------------------------------------------------------------*/
/* Specify stripe width. Enumeration can be done in stripes instead of full horizontal lines (to increase*/
/* cache hit rates).*/
/* The stripe width is specified in pixels and begins at the ystart value of the bounding box with the*/
/* given offset. See the TRM PSU Enumeration Stepping for further details.*/
/**/
/* Parameters:*/
/*  a_device : Driver context handle (as returned by dhd_init)*/
/*  a_offset : Offset in pixels*/
/*  a_width : Stripe width in pixels */
/**/
/*  See Also:*/
/*   dhd_set_psu_stripes_optimized*/
DHD_API_INLINE void dhd_set_psu_stripes(dhd_handle_t a_device, dhd_uint32_t a_offset, dhd_uint32_t a_width) {
  dhd_device_data_t *device = dhd_get_device( a_device );

  device->m_shadow_state.m_named.m_psu_lim_stripe.m_fields.m_lim_stripe_offset = a_offset;
  device->m_shadow_state.m_named.m_psu_lim_stripe.m_fields.m_lim_stripe_width  = a_width;
  device->m_pending_mask.m_named.m_psu_lim_stripe = 1;
}

/*----------------------------------------------------------------------------------------------------------*/
/* Get stripe width. Retrieve the last manually specified enumeration stripe width (see dhd_set_psu_stripes*/
/* for details).*/
/* Passing a null pointer indicates that a specific information is not requested. */
/**/
/* Parameters:*/
/*  a_device : Driver context handle (as returned by dhd_init)*/
/*  a_offset : Pointer to dhd_uint32_t that will receive the offset in pixels (can be null)*/
/*  a_width : Pointer to dhd_uint32_t that will receive the stripe width in pixels  (can be null)*/
/* */
/* See Also:*/
/*  dhd_set_psu_stripes*/
DHD_API_INLINE void dhd_get_psu_stripes(dhd_handle_t a_device, dhd_uint32_t *a_offset, dhd_uint32_t *a_width) {
  dhd_device_data_t *device = dhd_get_device( a_device );

  if (a_offset != 0) {
    *a_offset = device->m_shadow_state.m_named.m_psu_lim_stripe.m_fields.m_lim_stripe_offset;
  }
  if (a_width != 0) {
    *a_width = device->m_shadow_state.m_named.m_psu_lim_stripe.m_fields.m_lim_stripe_width;
  }
}

/*----------------------------------------------------------------------------------------------------------*/
/* Specify buffered edge data. When rendering using dhd_draw_array or dhd_draw_bezier_array the geometry is */
/* read from buffers. The edge buffer is defined using this function.*/
/**/
/* Parameters:*/
/*  a_device : Driver context handle (as returned by dhd_init)*/
/*  a_edges : Pointer to an array of dhd_edge_data_t elements*/
/*  a_gap : Additional spacing between the dhd_edge_data_t structures (usually 0)*/
/*  a_count : number of elements in the a_edges array (used for bounds checks)*/
/**/
/* Note :*/
/* The data inside the edge buffer must remain available until all dhd_draw_array commands using it have */
/* returned.*/
/**/
/* See Also :*/
/*   dhd_draw_array, dhd_draw_bezier_array, dhd_set_uv_buffer, dhd_set_rhw_buffer, dhd_set_col_buffer, dhd_set_depth_buffer*/
DHD_API_INLINE void dhd_set_edge_buffer(dhd_handle_t a_device, dhd_edge_data_t *a_edges, dhd_uint32_t a_gap, dhd_uint32_t a_count) {
  dhd_device_data_t *device = dhd_get_device( a_device );

  device->m_edge_buffer =                a_edges;
  device->m_edge_pitch  =                a_gap;
  device->m_edge_count  = (dhd_uint16_t) a_count;
}

/*----------------------------------------------------------------------------------------------------------*/
/* Specify buffered UV data. When rendering using dhd_draw_array or dhd_draw_bezier_array the geometry is */
/* read from buffers. The uvbuffer is defined using this function.*/
/**/
/* Parameters:*/
/*  a_device : Driver context handle (as returned by dhd_init)*/
/*  a_uvs : Pointer to an array of dhd_uv_data_t elements*/
/*  a_gap : Additional spacing between the dhd_uv_data_t structures (usually 0)*/
/*  a_count : number of elements in the a_uvs array (used for bounds checks)*/
/**/
/* Note :*/
/* The data inside the uvbuffer must remain available until all dhd_draw_array commands using it have */
/* returned.*/
/**/
/* See Also :*/
/*   dhd_draw_array, dhd_draw_bezier_array, dhd_set_edge_buffer, dhd_set_rhw_buffer, dhd_set_col_buffer, dhd_set_depth_buffer*/
DHD_API_INLINE void dhd_set_uv_buffer(dhd_handle_t a_device, dhd_uv_data_t *a_uvs, dhd_uint32_t a_gap, dhd_uint32_t a_count) {
  dhd_device_data_t *device = dhd_get_device( a_device );

  device->m_uv_buffer =                a_uvs;
  device->m_uv_pitch  =                a_gap;
  device->m_uv_count  = (dhd_uint16_t) a_count;
}

/*----------------------------------------------------------------------------------------------------------*/
/* Specify buffered RHW data. When rendering using dhd_draw_array or dhd_draw_bezier_array the geometry is */
/* read from buffers. The rhwbuffer is defined using this function.*/
/**/
/* Parameters:*/
/*  a_device : Driver context handle (as returned by dhd_init)*/
/*  a_rhws : Pointer to an array of dhd_rhw_data_t elements*/
/*  a_gap : Additional spacing between the dhd_rhw_data_t structures (usually 0)*/
/*  a_count : number of elements in the a_rhws array (used for bounds checks)*/
/**/
/* Note :*/
/* The data inside the rhwbuffer must remain available until all dhd_draw_array commands using it have */
/* returned.*/
/**/
/* See Also :*/
/*   dhd_draw_array, dhd_draw_bezier_array, dhd_set_edge_buffer, dhd_set_uv_buffer, dhd_set_col_buffer, dhd_set_depth_buffer*/
DHD_API_INLINE void dhd_set_rhw_buffer(dhd_handle_t a_device, dhd_rhw_data_t *a_rhws, dhd_uint32_t a_gap, dhd_uint32_t a_count) {
  dhd_device_data_t *device = dhd_get_device( a_device );

  device->m_rhw_buffer =                a_rhws;
  device->m_rhw_pitch  =                a_gap;
  device->m_rhw_count  = (dhd_uint16_t) a_count;
}

/*----------------------------------------------------------------------------------------------------------*/
/* Specify buffered Depth data. When rendering using dhd_draw_array or dhd_draw_bezier_array the geometry is */
/* read from buffers. The depthbuffer is defined using this function.*/
/**/
/* Parameters:*/
/*  a_device : Driver context handle (as returned by dhd_init)*/
/*  a_depths : Pointer to an array of dhd_depth_data_t elements*/
/*  a_gap : Additional spacing between the dhd_depth_data_t structures (usually 0)*/
/*  a_count : number of elements in the a_depths array (used for bounds checks)*/
/**/
/* Note :*/
/* The data inside the depthbuffer must remain available until all dhd_draw_array commands using it have */
/* returned.*/
/**/
/* See Also :*/
/*   dhd_draw_array, dhd_draw_bezier_array, dhd_set_edge_buffer, dhd_set_uv_buffer, dhd_set_col_buffer, dhd_set_rhw_buffer*/
DHD_API_INLINE void dhd_set_depth_buffer(dhd_handle_t a_device, dhd_depth_data_t *a_depths, dhd_uint32_t a_gap, dhd_uint32_t a_count) {
  dhd_device_data_t *device = dhd_get_device( a_device );

  device->m_depth_buffer =                a_depths;
  device->m_depth_pitch  =                a_gap;
  device->m_depth_count  = (dhd_uint16_t) a_count;
}

/*----------------------------------------------------------------------------------------------------------*/
/* Specify buffered Color data. When rendering using dhd_draw_array or dhd_draw_bezier_array the geometry is */
/* read from buffers. The colorbuffer is defined using this function.*/
/**/
/* Parameters:*/
/*  a_device : Driver context handle (as returned by dhd_init)*/
/*  a_colors : Pointer to an array of dhd_uint32_t ARGB8888 colors*/
/*  a_gap : Additional spacing between the colors (usually 0)*/
/*  a_count : number of elements in the a_colors array (used for bounds checks)*/
/**/
/* Note :*/
/* The data inside the colorbuffer must remain available until all dhd_draw_array commands using it have */
/* returned.*/
/**/
/* See Also :*/
/*   dhd_draw_array, dhd_draw_bezier_array, dhd_set_edge_buffer, dhd_set_uv_buffer, dhd_set_rhw_buffer, dhd_set_depth_buffer*/
DHD_API_INLINE void dhd_set_col_buffer(dhd_handle_t a_device, dhd_uint32_t *a_colors, dhd_uint32_t a_gap, dhd_uint32_t a_count) {
  dhd_device_data_t *device = dhd_get_device( a_device );

  device->m_col_buffer =                a_colors;
  device->m_col_pitch  =                a_gap;
  device->m_col_count  = (dhd_uint16_t) a_count;
}

/*----------------------------------------------------------------------------------------------------------*/
/* Retrieve buffered edge data address. Returns the active client edge buffer parameters (as set by  */
/* dhd_set_edge_buffer). Both a_gap_out and a_count_out can be NULL to indicate that the information is */
/* not needed.*/
/**/
/* Parameters:*/
/*  a_device : Driver context handle (as returned by dhd_init)*/
/*  a_gap_out : Pointer to a dhd_uint32_t that will receive the additional buffer spacing*/
/*  a_count_out : Pointer to a dhd_uint32_t that will receive the additional buffer spacing*/
/**/
/* Returns:*/
/*  Address of the edge data (as specified by dhd_set_edge_buffer)*/
/**/
/* See Also:*/
/*  dhd_set_edge_buffer*/
DHD_API_INLINE dhd_edge_data_t * dhd_get_edge_buffer(dhd_handle_t a_device, dhd_uint32_t *a_gap_out, dhd_uint32_t *a_count_out) {
  dhd_device_data_t *device = dhd_get_device( a_device );

  if (a_gap_out != 0) {
    *a_gap_out = device->m_edge_pitch;
  }
  if (a_count_out != 0) {
    *a_count_out = (dhd_uint32_t) device->m_edge_count;
  }

  return device->m_edge_buffer;
}

/*----------------------------------------------------------------------------------------------------------*/
/* Retrieve buffered UV data address. Returns the active client UV buffer parameters (as set by  */
/* dhd_set_uv_buffer). Both a_gap_out and a_count_out can be NULL to indicate that the information is */
/* not needed.*/
/**/
/* Parameters:*/
/*  a_device : Driver context handle (as returned by dhd_init)*/
/*  a_gap_out : Pointer to a dhd_uint32_t that will receive the additional buffer spacing*/
/*  a_count_out : Pointer to a dhd_uint32_t that will receive the additional buffer spacing*/
/**/
/* Returns:*/
/*  Address of the uv data (as specified by dhd_set_uv_buffer)*/
/**/
/* See Also:*/
/*  dhd_set_uv_buffer*/
DHD_API_INLINE dhd_uv_data_t * dhd_get_uv_buffer(dhd_handle_t a_device, dhd_uint32_t *a_gap_out, dhd_uint32_t *a_count_out) {
  dhd_device_data_t *device = dhd_get_device( a_device );

  if (a_gap_out != 0) {
    *a_gap_out = device->m_uv_pitch;
  }
  if (a_count_out != 0) {
    *a_count_out = (dhd_uint32_t) device->m_uv_count;
  }

  return device->m_uv_buffer;
}

/*----------------------------------------------------------------------------------------------------------*/
/* Retrieve buffered rhw data address. Returns the active client rhw buffer parameters (as set by  */
/* dhd_set_rhw_buffer). Both a_gap_out and a_count_out can be NULL to indicate that the information is */
/* not needed.*/
/**/
/* Parameters:*/
/*  a_device : Driver context handle (as returned by dhd_init)*/
/*  a_gap_out : Pointer to a dhd_uint32_t that will receive the additional buffer spacing*/
/*  a_count_out : Pointer to a dhd_uint32_t that will receive the additional buffer spacing*/
/**/
/* Returns:*/
/*  Address of the rhw data (as specified by dhd_set_rhw_buffer)*/
/**/
/* See Also:*/
/*  dhd_set_rhw_buffer*/
DHD_API_INLINE dhd_rhw_data_t * dhd_get_rhw_buffer(dhd_handle_t a_device, dhd_uint32_t *a_gap_out, dhd_uint32_t *a_count_out) {
  dhd_device_data_t *device = dhd_get_device( a_device );

  if (a_gap_out != 0) {
    *a_gap_out = device->m_rhw_pitch;
  }
  if (a_count_out != 0) {
    *a_count_out = (dhd_uint32_t) device->m_rhw_count;
  }

  return device->m_rhw_buffer;
}

/*----------------------------------------------------------------------------------------------------------*/
/* Retrieve buffered color data address. Returns the active client color buffer parameters (as set by  */
/* dhd_set_col_buffer). Both a_gap_out and a_count_out can be NULL to indicate that the information is */
/* not needed.*/
/**/
/* Parameters:*/
/*  a_device : Driver context handle (as returned by dhd_init)*/
/*  a_gap_out : Pointer to a dhd_uint32_t that will receive the additional buffer spacing*/
/*  a_count_out : Pointer to a dhd_uint32_t that will receive the additional buffer spacing*/
/**/
/* Returns:*/
/*  Address of the color data (as specified by dhd_set_col_buffer)*/
/**/
/* See Also:*/
/*  dhd_set_col_buffer*/
DHD_API_INLINE dhd_uint32_t * dhd_get_col_buffer(dhd_handle_t a_device, dhd_uint32_t *a_gap_out, dhd_uint32_t *a_count_out) {
  dhd_device_data_t *device = dhd_get_device( a_device );

  if (a_gap_out != 0) {
    *a_gap_out = device->m_col_pitch;
  }
  if (a_count_out != 0) {
    *a_count_out = (dhd_uint32_t) device->m_col_count;
  }

  return device->m_col_buffer;
}

/*----------------------------------------------------------------------------------------------------------*/
/* Retrieve buffered depth data address. Returns the active client depth buffer parameters (as set by  */
/* dhd_set_depth_buffer). Both a_gap_out and a_count_out can be NULL to indicate that the information is */
/* not needed.*/
/**/
/* Parameters:*/
/*  a_device : Driver context handle (as returned by dhd_init)*/
/*  a_gap_out : Pointer to a dhd_uint32_t that will receive the additional buffer spacing*/
/*  a_count_out : Pointer to a dhd_uint32_t that will receive the additional buffer spacing*/
/**/
/* Returns:*/
/*  Address of the depth data (as specified by dhd_set_depth_buffer)*/
/**/
/* See Also:*/
/*  dhd_set_depth_buffer*/
DHD_API_INLINE dhd_depth_data_t * dhd_get_depth_buffer(dhd_handle_t a_device, dhd_uint32_t *a_gap_out, dhd_uint32_t *a_count_out) {
  dhd_device_data_t *device = dhd_get_device( a_device );

  if (a_gap_out != 0) {
    *a_gap_out = device->m_depth_pitch;
  }
  if (a_count_out != 0) {
    *a_count_out = (dhd_uint32_t) device->m_depth_count;
  }

  return device->m_depth_buffer;
}

/*----------------------------------------------------------------------------------------------------------*/
/* Specify bezier offsets. */
/**/
/* Parameters:*/
/*  a_device : Driver context handle (as returned by dhd_init)*/
/*  a_offset0 : Bezier offset 0 (fixedpoint 14.18)*/
/*  a_offset1 : Bezier offset 1 (fixedpoint 14.18)*/
DHD_API_INLINE void dhd_set_bezier_offset(dhd_handle_t a_device, dhd_int32_t a_offset0, dhd_int32_t a_offset1) {
  dhd_device_data_t *device = dhd_get_device( a_device );

  device->m_shadow_state.m_named.m_psu_bez_voff_0.m_fields.m_bez_voff_0 = a_offset0;
  device->m_shadow_state.m_named.m_psu_bez_voff_1.m_fields.m_bez_voff_1 = a_offset1;
  device->m_pending_mask.m_named.m_psu_bez_voff_0 = 1;
  device->m_pending_mask.m_named.m_psu_bez_voff_1 = 1;
}

/*----------------------------------------------------------------------------------------------------------*/
/* Get bezier offsets. Retrieve the last manually specified bezier offsets (see dhd_set_bezier_offset for*/
/* details).*/
/* Passing a null pointer indicates that a specific information is not requested. */
/**/
/* Parameters:*/
/*  a_device : Driver context handle (as returned by dhd_init)*/
/*  a_offset0 : Pointer to dhd_uint32_t that will receive bezier offset 0 (can be null)*/
/*  a_offset1 : Pointer to dhd_uint32_t that will receive bezier offset 1 (can be null)*/
/* */
/* See Also:*/
/*  dhd_set_bezier_offset*/
DHD_API_INLINE void dhd_get_bezier_offset(dhd_handle_t a_device, dhd_int32_t *a_offset0, dhd_int32_t *a_offset1) {
  dhd_device_data_t *device = dhd_get_device( a_device );

  if (a_offset0 != 0) {
    *a_offset0 = device->m_shadow_state.m_named.m_psu_bez_voff_0.m_fields.m_bez_voff_0;
  }
  if (a_offset1 != 0) {
    *a_offset1 = device->m_shadow_state.m_named.m_psu_bez_voff_1.m_fields.m_bez_voff_1;
  }
}

/*----------------------------------------------------------------------------------------------------------*/
/* Specify bezier width. */
/**/
/* Parameters:*/
/*  a_device : Driver context handle (as returned by dhd_init)*/
/*  a_width : Bezier line width (4.4 unsigned fixed point), set to 0 for full convex/concave segment*/
DHD_API_INLINE void dhd_set_bezier_width(dhd_handle_t a_device, dhd_uint32_t a_width) {
  dhd_device_data_t *device = dhd_get_device( a_device );

  device->m_shadow_state.m_named.m_psu_bez_aa_ctrl.m_fields.m_bez_width = a_width;
  device->m_pending_mask.m_named.m_psu_bez_aa_ctrl = 1;
}

/*----------------------------------------------------------------------------------------------------------*/
/* Get bezier widths. Retrieve currently active bezier width (see dhd_set_bezier_width for details). */
/**/
/* Parameters:*/
/*  a_device : Driver context handle (as returned by dhd_init)*/
/**/
/* Returns:*/
/*  Bezier width*/
/**/
/* See Also:*/
/*  dhd_set_bezier_width*/
DHD_API_INLINE dhd_uint32_t dhd_get_bezier_width(dhd_handle_t a_device) {
  dhd_device_data_t *device = dhd_get_device( a_device );

  return device->m_shadow_state.m_named.m_psu_bez_aa_ctrl.m_fields.m_bez_width;
}

/*----------------------------------------------------------------------------------------------------------*/
/* Specify bezier antialiasing. */
/**/
/* Parameters:*/
/*  a_device : Driver context handle (as returned by dhd_init)*/
/*  a_width : Bezier aa width reciproke (4.6 unsigned fixpoint)*/
/*  a_offset : Bezier aa offset to shift anti aliased region to outside (4.4 signed fixed point)*/
DHD_API_INLINE void dhd_set_bezier_aa(dhd_handle_t a_device, dhd_uint32_t a_width, dhd_int32_t a_offset) {
  dhd_device_data_t *device = dhd_get_device( a_device );

  device->m_shadow_state.m_named.m_psu_bez_aa_ctrl.m_fields.m_bez_aa        = a_width;
  device->m_shadow_state.m_named.m_psu_bez_aa_ctrl.m_fields.m_bez_aa_offset = a_offset;
  device->m_pending_mask.m_named.m_psu_bez_aa_ctrl = 1;
}

/*----------------------------------------------------------------------------------------------------------*/
/* Get bezier antialiasing. Retrieve the last manually specified bezier antialiasing (see dhd_set_bezier_aa for details).*/
/* Passing a null pointer indicates that a specific information is not requested. */
/**/
/* Parameters:*/
/*  a_device : Driver context handle (as returned by dhd_init)*/
/*  a_width : Pointer to dhd_uint32_t that will receive bezier aa width (can be null)*/
/*  a_offset : Pointer to dhd_uint32_t that will receive bezier aa offset (can be null)*/
/* */
/* See Also:*/
/*  dhd_set_bezier_aa*/
DHD_API_INLINE void dhd_get_bezier_aa(dhd_handle_t a_device, dhd_uint32_t *a_width, dhd_int32_t *a_offset) {
  dhd_device_data_t *device = dhd_get_device( a_device );

  if (a_width != 0) {
    *a_width = device->m_shadow_state.m_named.m_psu_bez_aa_ctrl.m_fields.m_bez_aa;
  }
  if (a_offset != 0) {
    *a_offset = device->m_shadow_state.m_named.m_psu_bez_aa_ctrl.m_fields.m_bez_aa_offset;
  }
}

/*----------------------------------------------------------------------------------------------------------*/

#endif /*DAVEHD_DRIVER_PSU_INL_H_INCLUDED*/
