#ifndef DISPSCH_H
#define DISPSCH_H


#include "TYW_stdint.h"
#include "stddef.h"
#include "Common_Interface.h"



typedef enum
{
    Disp_StartAnimation,
    Disp_StartAnimationFinish,
    Disp_DriveInfo,
    Disp_Menu,
    Disp_Alarm,
    Disp_LVDS,
    Disp_Navigation,
    Disp_Reverse2,
    Disp_Reverse3,
} enDisp_Type_t;




void Display_KL30_Init(void);
void Display_WakeUp_Init(void);
void Display_KL15_Init(void);
void Display_Schedule_Service( void );

void HMI_DRIVE_INFO(void);
void HMI_ALARM_EnterInit(void);
void HMI_MENU_EnterInit(void);
void HMI_ALARM_ExitInit(void);
void HMI_MENU_ExitInit(void);
void HMI_DRIVE_ExitInit(void);
void HMI_DRIVE_EnterInit(void);




void HMI_ALARM_INFO(uint8_t popupID);
void HMI_MENU_INFO(void);


enDisp_Type_t Get_Current_DispType(void);
uint8_t Get_HMI_StartAnimationFrame(void);
uint8_t Get_HMI_StartAnimationTimer(void);



#endif
